/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fabric;

import com.liferay.portal.fabric.agent.FabricAgent;
import com.liferay.portal.fabric.agent.FabricAgentRegistry;
import com.liferay.portal.fabric.agent.selectors.FabricAgentSelector;
import com.liferay.portal.fabric.worker.FabricWorker;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessConfig;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.process.ProcessExecutor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class FabricProcessExecutor
implements ProcessExecutor {
    private final FabricAgentRegistry _fabricAgentRegistry;
    private final FabricAgentSelector _fabricAgentSelector;

    public FabricProcessExecutor(FabricAgentRegistry fabricAgentRegistry, FabricAgentSelector fabricAgentSelector) {
        if (fabricAgentRegistry == null) {
            throw new NullPointerException("Fabric agent registry is null");
        }
        if (fabricAgentSelector == null) {
            throw new NullPointerException("Fabric agent selector is null");
        }
        this._fabricAgentRegistry = fabricAgentRegistry;
        this._fabricAgentSelector = fabricAgentSelector;
    }

    public <T extends Serializable> FabricWorker<T> execute(ProcessConfig processConfig, ProcessCallable<T> processCallable) throws ProcessException {
        FabricAgent fabricAgent = this.getFabricAgent(processCallable);
        return fabricAgent.execute(processConfig, processCallable);
    }

    protected FabricAgent getFabricAgent(ProcessCallable<?> processCallable) {
        Collection<FabricAgent> fabricAgents = this._fabricAgentSelector.select(this._fabricAgentRegistry.getFabricAgents(), processCallable);
        if (fabricAgents.isEmpty()) {
            return this._fabricAgentRegistry.getDefaultFabricAgent();
        }
        Iterator<FabricAgent> iterator = fabricAgents.iterator();
        return iterator.next();
    }
}

