/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolverUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Method;
import java.util.Objects;

public class JSONWebServiceActionConfig
implements Comparable<JSONWebServiceActionConfig>,
JSONWebServiceActionMapping {
    private final Class<?> _actionClass;
    private final Method _actionMethod;
    private final Object _actionObject;
    private final String _contextName;
    private final String _contextPath;
    private final boolean _deprecated;
    private final String _method;
    private final MethodParameter[] _methodParameters;
    private final String _path;
    private final Method _realActionMethod;
    private final String _signature;

    public JSONWebServiceActionConfig(String contextName, String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        this(contextName, contextPath, null, actionClass, actionMethod, path, method);
    }

    public JSONWebServiceActionConfig(String contextName, String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        this._contextName = GetterUtil.getString((String)contextName);
        this._contextPath = GetterUtil.getString((String)contextPath);
        this._actionObject = actionObject;
        this._actionClass = actionClass;
        Method newActionMethod = actionMethod;
        if (actionObject != null) {
            try {
                Class<?> actionObjectClass = actionObject.getClass();
                newActionMethod = actionObjectClass.getMethod(actionMethod.getName(), actionMethod.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException(nsme);
            }
        }
        this._actionMethod = newActionMethod;
        if (Validator.isNotNull((String)this._contextName)) {
            path = path.substring(1);
            path = "/".concat(this._contextName).concat(".").concat(path);
        }
        this._path = path;
        this._method = method;
        Deprecated deprecated = actionMethod.getAnnotation(Deprecated.class);
        this._deprecated = deprecated != null;
        this._methodParameters = MethodParametersResolverUtil.resolveMethodParameters((Method)actionMethod);
        Method realActionMethod = null;
        try {
            realActionMethod = this._actionClass.getDeclaredMethod(actionMethod.getName(), actionMethod.getParameterTypes());
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        this._realActionMethod = realActionMethod;
        StringBundler sb = new StringBundler(this._methodParameters.length * 2 + 3);
        sb.append(this._path);
        sb.append("-");
        sb.append(this._methodParameters.length);
        for (MethodParameter methodParameter : this._methodParameters) {
            sb.append("-");
            sb.append(methodParameter.getName());
        }
        this._signature = sb.toString();
    }

    @Override
    public int compareTo(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        return this._signature.compareTo(jsonWebServiceActionConfig._signature);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONWebServiceActionConfig)) {
            return false;
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = (JSONWebServiceActionConfig)object;
        return Objects.equals(this._signature, jsonWebServiceActionConfig._signature);
    }

    public Class<?> getActionClass() {
        return this._actionClass;
    }

    public Method getActionMethod() {
        return this._actionMethod;
    }

    public Object getActionObject() {
        return this._actionObject;
    }

    public String getContextName() {
        return this._contextName;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getMethod() {
        return this._method;
    }

    public MethodParameter[] getMethodParameters() {
        return this._methodParameters;
    }

    public String getPath() {
        return this._path;
    }

    public Method getRealActionMethod() {
        return this._realActionMethod;
    }

    public String getSignature() {
        return this._signature;
    }

    public int hashCode() {
        return this._signature.hashCode();
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public String toString() {
        StringBundler sb = new StringBundler(21);
        sb.append("{actionClass=");
        sb.append(this._actionClass);
        sb.append(", actionMethod=");
        sb.append((Object)this._actionMethod);
        sb.append(", contextName=");
        sb.append(this._contextName);
        sb.append(", contextPath=");
        sb.append(this._contextPath);
        sb.append(", deprecated=");
        sb.append(this._deprecated);
        sb.append(", method=");
        sb.append(this._method);
        sb.append(", methodParameters=");
        sb.append((Object)this._methodParameters);
        sb.append(", path=");
        sb.append(this._path);
        sb.append(", realActionMethod=");
        sb.append((Object)this._realActionMethod);
        sb.append(", signature=");
        sb.append(this._signature);
        sb.append("}");
        return sb.toString();
    }
}

