/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultRepositoryEventRegistry
implements RepositoryEventRegistry,
RepositoryEventTrigger {
    private final RepositoryEventTrigger _parentRepositoryEventTrigger;
    private final Map<Tuple, Collection<RepositoryEventListener<?, ?>>> _repositoryEventListeners = new HashMap();

    public DefaultRepositoryEventRegistry(RepositoryEventTrigger parentRepositoryEventTrigger) {
        this._parentRepositoryEventTrigger = parentRepositoryEventTrigger;
    }

    public <S extends RepositoryEventType, T> void registerRepositoryEventListener(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListener) {
        if (repositoryEventListener == null) {
            throw new NullPointerException("Repository event listener is null");
        }
        Tuple key = new Tuple(new Object[]{repositoryEventTypeClass, modelClass});
        Collection<RepositoryEventListener<?, ?>> repositoryEventListeners = this._repositoryEventListeners.get(key);
        if (repositoryEventListeners == null) {
            repositoryEventListeners = new ArrayList();
            this._repositoryEventListeners.put(key, repositoryEventListeners);
        }
        repositoryEventListeners.add(repositoryEventListener);
    }

    public <S extends RepositoryEventType, T> void trigger(Class<S> repositoryEventTypeClass, Class<T> modelClass, T model) throws PortalException {
        Tuple key;
        Collection<RepositoryEventListener<?, ?>> repositoryEventListeners;
        if (this._parentRepositoryEventTrigger != null) {
            this._parentRepositoryEventTrigger.trigger(repositoryEventTypeClass, modelClass, model);
        }
        if ((repositoryEventListeners = this._repositoryEventListeners.get(key = new Tuple(new Object[]{repositoryEventTypeClass, modelClass}))) != null) {
            for (RepositoryEventListener<?, ?> repositoryEventListener : repositoryEventListeners) {
                repositoryEventListener.execute(model);
            }
        }
    }
}

