/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.ResourceActionsException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.security.permission.ModelResourceActionsBag;
import com.liferay.portal.kernel.security.permission.PortletResourceActionsBag;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentType;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.security.permission.ModelResourceActionsBagImpl;
import com.liferay.portal.security.permission.PortletResourceActionsBagImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.util.JS;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.util.RequestUtils;

@DoPrivileged
public class ResourceActionsImpl
implements ResourceActions {
    @BeanReference(type=PortletLocalService.class)
    protected PortletLocalService portletLocalService;
    @BeanReference(type=ResourceActionLocalService.class)
    protected ResourceActionLocalService resourceActionLocalService;
    @BeanReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    private static final String _ACTION_NAME_PREFIX = "action.";
    private static final String _COMPOSITE_MODEL_NAME_SEPARATOR = "-";
    private static final String _MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    private static final Log _log = LogFactoryUtil.getLog(ResourceActionsImpl.class);
    private Map<String, ModelResourceActionsBag> _modelResourceActionsBags;
    private final Set<String> _organizationModelResources = new HashSet<String>();
    private final Set<String> _portalModelResources = new HashSet<String>();
    private Map<String, PortletResourceActionsBag> _portletResourceActionsBags;
    private final ServiceTrackerList<ResourceBundleLoader> _resourceBundleLoaders;
    private final Set<String> _rootModelResources = new HashSet<String>();

    public ResourceActionsImpl() {
        this._resourceBundleLoaders = ServiceTrackerCollections.openList(ResourceBundleLoader.class);
    }

    public void afterPropertiesSet() {
        this._portletResourceActionsBags = new HashMap<String, PortletResourceActionsBag>();
        this._modelResourceActionsBags = new HashMap<String, ModelResourceActionsBag>();
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            for (String config : PropsValues.RESOURCE_ACTIONS_CONFIGS) {
                this.read(null, classLoader, config);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void checkAction(String name, String actionId) throws NoSuchResourceActionException {
        List<String> resourceActions = this.getResourceActions(name);
        if (!resourceActions.contains(actionId)) {
            throw new NoSuchResourceActionException(name.concat("#").concat(actionId));
        }
    }

    public void destroy() {
        this._resourceBundleLoaders.close();
    }

    public String getAction(HttpServletRequest request, String action) {
        String key = this.getActionNamePrefix() + action;
        String value = LanguageUtil.get((HttpServletRequest)request, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this.getResourceBundlesString(request, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getAction(Locale locale, String action) {
        String key = this.getActionNamePrefix() + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this.getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getActionNamePrefix() {
        return _ACTION_NAME_PREFIX;
    }

    @Deprecated
    public List<String> getActionsNames(HttpServletRequest request, List<String> actions) {
        LinkedHashSet<String> actionNames = new LinkedHashSet<String>();
        for (String action : actions) {
            actionNames.add(this.getAction(request, action));
        }
        return new ArrayList<String>(actionNames);
    }

    @Deprecated
    public List<String> getActionsNames(HttpServletRequest request, String name, long actionIds) {
        try {
            List resourceActions = this.resourceActionLocalService.getResourceActions(name);
            ArrayList<String> actions = new ArrayList<String>();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actions.add(resourceAction.getActionId());
            }
            return this.getActionsNames(request, actions);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getCompositeModelName(String ... classNames) {
        if (ArrayUtil.isEmpty((Object[])classNames)) {
            return "";
        }
        Arrays.sort(classNames);
        StringBundler sb = new StringBundler(classNames.length * 2);
        for (String className : classNames) {
            sb.append(className);
            sb.append(this.getCompositeModelNameSeparator());
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public String getCompositeModelNameSeparator() {
        return _COMPOSITE_MODEL_NAME_SEPARATOR;
    }

    public List<String> getModelNames() {
        return ListUtil.fromMapKeys(this._modelResourceActionsBags);
    }

    public List<String> getModelPortletResources(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResources());
    }

    public String getModelResource(HttpServletRequest request, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((HttpServletRequest)request, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this.getResourceBundlesString(request, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getModelResource(Locale locale, String name) {
        String key = this.getModelResourceNamePrefix() + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = this.getResourceBundlesString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public List<String> getModelResourceActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResourceActions());
    }

    public List<String> getModelResourceGroupDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResourceGroupDefaultActions());
    }

    public List<String> getModelResourceGuestDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResourceGuestDefaultActions());
    }

    public List<String> getModelResourceGuestUnsupportedActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResourceGuestUnsupportedActions());
    }

    public String getModelResourceNamePrefix() {
        return _MODEL_RESOURCE_NAME_PREFIX;
    }

    public List<String> getModelResourceOwnerDefaultActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        return new ArrayList<String>(modelResourceActionsBag.getResourceOwnerDefaultActions());
    }

    public Double getModelResourceWeight(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        Map modelResourceWeights = modelResourceActionsBag.getResourceWeights();
        return (Double)modelResourceWeights.get(name);
    }

    public String[] getOrganizationModelResources() {
        return this._organizationModelResources.toArray(new String[this._organizationModelResources.size()]);
    }

    public String[] getPortalModelResources() {
        return this._portalModelResources.toArray(new String[this._portalModelResources.size()]);
    }

    public String getPortletBaseResource(String portletName) {
        List<String> modelNames = this.getPortletModelResources(portletName);
        for (String modelName : modelNames) {
            if (modelName.contains(".model.")) continue;
            return modelName;
        }
        return null;
    }

    public List<String> getPortletModelResources(String portletName) {
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(portletName = PortletConstants.getRootPortletId((String)portletName));
        Set resources = portletResourceActionsBag.getResources();
        if (resources == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(resources);
    }

    public List<String> getPortletNames() {
        return ListUtil.fromMapKeys(this._portletResourceActionsBags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPortletResourceActions(Portlet portlet) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>(this.getPortletResourceActions(portlet.getPortletId()));
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            this.checkPortletActions(portlet, actions);
        }
        return new ArrayList<String>(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPortletResourceActions(String name) {
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name = PortletConstants.getRootPortletId((String)name));
        Set<String> actions = portletResourceActionsBag.getResourceActions();
        if (!actions.isEmpty()) {
            return new ArrayList<String>(actions);
        }
        ResourceActionsImpl resourceActionsImpl = this;
        synchronized (resourceActionsImpl) {
            actions = this.getPortletMimeTypeActions(name);
            if (!name.equals("90")) {
                this.checkPortletActions(name, actions);
            }
            Set groupDefaultActions = portletResourceActionsBag.getResourceGroupDefaultActions();
            this.checkPortletGroupDefaultActions(groupDefaultActions);
            Set guestDefaultActions = portletResourceActionsBag.getResourceGuestDefaultActions();
            this.checkPortletGuestDefaultActions(guestDefaultActions);
            Set layoutManagerActions = portletResourceActionsBag.getResourceLayoutManagerActions();
            this.checkPortletLayoutManagerActions(layoutManagerActions);
        }
        return new ArrayList<String>(actions);
    }

    public List<String> getPortletResourceGroupDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getResourceGroupDefaultActions());
    }

    public List<String> getPortletResourceGuestDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name);
        return new ArrayList<String>(portletResourceActionsBag.getResourceGuestDefaultActions());
    }

    public List<String> getPortletResourceGuestUnsupportedActions(String name) {
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name = PortletConstants.getRootPortletId((String)name));
        Set actions = portletResourceActionsBag.getResourceGuestUnsupportedActions();
        if (actions.contains("CONFIGURATION") && actions.contains("PERMISSIONS")) {
            return new ArrayList<String>(actions);
        }
        actions.add("CONFIGURATION");
        actions.add("PERMISSIONS");
        return new ArrayList<String>(actions);
    }

    public List<String> getPortletResourceLayoutManagerActions(String name) {
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name = PortletConstants.getRootPortletId((String)name));
        LinkedHashSet<String> actions = portletResourceActionsBag.getResourceLayoutManagerActions();
        if (actions.isEmpty()) {
            actions = new LinkedHashSet<String>();
            actions.add("CONFIGURATION");
            actions.add("PREFERENCES");
            actions.add("VIEW");
        }
        return new ArrayList<String>(actions);
    }

    public String getPortletRootModelResource(String portletName) {
        portletName = PortletConstants.getRootPortletId((String)portletName);
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(portletName);
        Map portletRootModelResource = portletResourceActionsBag.getPortletRootModelResources();
        return (String)portletRootModelResource.get(portletName);
    }

    public List<String> getResourceActions(String name) {
        if (name.indexOf(46) != -1) {
            return this.getModelResourceActions(name);
        }
        return this.getPortletResourceActions(name);
    }

    public List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceActions(portletResource) : this.getModelResourceActions(modelResource);
        return actions;
    }

    public List<String> getResourceGroupDefaultActions(String name) {
        if (name.contains(".")) {
            return this.getModelResourceGroupDefaultActions(name);
        }
        return this.getPortletResourceGroupDefaultActions(name);
    }

    public List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? this.getPortletResourceGuestUnsupportedActions(portletResource) : this.getModelResourceGuestUnsupportedActions(modelResource);
        return actions;
    }

    public List<Role> getRoles(long companyId, Group group, String modelResource, int[] roleTypes) {
        if (roleTypes == null) {
            roleTypes = this.getRoleTypes(companyId, group, modelResource);
        }
        return this.roleLocalService.getRoles(companyId, roleTypes);
    }

    public String[] getRootModelResources() {
        return this._rootModelResources.toArray(new String[this._rootModelResources.size()]);
    }

    public boolean hasModelResourceActions(String name) {
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        Set actions = modelResourceActionsBag.getResourceActions();
        return actions != null && !actions.isEmpty();
    }

    public boolean isOrganizationModelResource(String modelResource) {
        return this._organizationModelResources.contains(modelResource);
    }

    public boolean isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    public boolean isRootModelResource(String modelResource) {
        return this._rootModelResources.contains(modelResource);
    }

    public void read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        Document document;
        DocumentType documentType;
        String publicId;
        InputStream inputStream = classLoader.getResourceAsStream(source);
        if (inputStream == null) {
            if (_log.isInfoEnabled() && !source.endsWith("-ext.xml") && !source.startsWith("META-INF/")) {
                _log.info((Object)("Cannot load " + source));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        if ((publicId = GetterUtil.getString((String)(documentType = (document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true)).getDocumentType()).getPublicId())).equals("-//Liferay//DTD Resource Action Mapping 6.0.0//EN") && _log.isWarnEnabled()) {
            _log.warn((Object)("Please update " + source + " to use the 6.1.0 format"));
        }
        Element rootElement = document.getRootElement();
        for (Element resourceElement : rootElement.elements("resource")) {
            String file = resourceElement.attributeValue("file").trim();
            this.read(servletContextName, classLoader, file);
            String extFile = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
            this.read(servletContextName, classLoader, extFile);
        }
        this.read(servletContextName, document);
    }

    @Deprecated
    public void read(String servletContextName, InputStream inputStream) throws Exception {
        Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream, (boolean)true);
        this.read(servletContextName, document);
    }

    protected void checkGuestUnsupportedActions(Set<String> guestUnsupportedActions, Set<String> guestDefaultActions) {
        Iterator<String> itr = guestDefaultActions.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected void checkModelActions(Set<String> actions) {
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
    }

    protected void checkPortletActions(Portlet portlet, Set<String> actions) {
        this.checkPortletLayoutManagerActions(actions);
        if (portlet != null && portlet.getControlPanelEntryCategory() != null && !actions.contains("ACCESS_IN_CONTROL_PANEL")) {
            actions.add("ACCESS_IN_CONTROL_PANEL");
        }
    }

    protected void checkPortletActions(String name, Set<String> actions) {
        Portlet portlet = this.portletLocalService.getPortletById(name);
        this.checkPortletActions(portlet, actions);
    }

    protected void checkPortletGroupDefaultActions(Set<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    protected void checkPortletGuestDefaultActions(Set<String> actions) {
        if (actions.isEmpty()) {
            actions.add("VIEW");
        }
    }

    protected void checkPortletLayoutManagerActions(Set<String> actions) {
        if (!actions.contains("ACCESS_IN_CONTROL_PANEL") && !actions.contains("ADD_TO_PAGE")) {
            actions.add("ADD_TO_PAGE");
        }
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("PERMISSIONS")) {
            actions.add("PERMISSIONS");
        }
        if (!actions.contains("PREFERENCES")) {
            actions.add("PREFERENCES");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    protected String getCompositeModelName(Element compositeModelNameElement) {
        StringBundler sb = new StringBundler();
        ArrayList elements = new ArrayList(compositeModelNameElement.elements("model-name"));
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element element1, Element element2) {
                String textTrim1 = GetterUtil.getString((String)element1.getTextTrim());
                String textTrim2 = GetterUtil.getString((String)element2.getTextTrim());
                return textTrim1.compareTo(textTrim2);
            }
        });
        Iterator itr = elements.iterator();
        while (itr.hasNext()) {
            Element modelNameElement = (Element)itr.next();
            sb.append(modelNameElement.getTextTrim());
            if (!itr.hasNext()) continue;
            sb.append(_COMPOSITE_MODEL_NAME_SEPARATOR);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelResourceActionsBag getModelResourceActionsBag(String modelName) {
        ModelResourceActionsBag modelResourceActionsBag = this._modelResourceActionsBags.get(modelName);
        if (modelResourceActionsBag != null) {
            return modelResourceActionsBag;
        }
        Map<String, ModelResourceActionsBag> map = this._modelResourceActionsBags;
        synchronized (map) {
            modelResourceActionsBag = this._modelResourceActionsBags.get(modelName);
            if (modelResourceActionsBag != null) {
                return modelResourceActionsBag;
            }
            modelResourceActionsBag = new ModelResourceActionsBagImpl();
            this._modelResourceActionsBags.put(modelName, modelResourceActionsBag);
        }
        return modelResourceActionsBag;
    }

    protected Element getPermissionsChildElement(Element parentElement, String childElementName) {
        Element permissionsElement = parentElement.element("permissions");
        if (permissionsElement != null) {
            return permissionsElement.element(childElementName);
        }
        return parentElement.element(childElementName);
    }

    protected Set<String> getPortletMimeTypeActions(String name) {
        LinkedHashSet<String> actions = new LinkedHashSet<String>();
        Portlet portlet = this.portletLocalService.getPortletById(name);
        if (portlet != null) {
            Map portletModes = portlet.getPortletModes();
            Set mimeTypePortletModes = (Set)portletModes.get("text/html");
            if (mimeTypePortletModes != null) {
                for (String actionId : mimeTypePortletModes) {
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit")) {
                        actions.add("PREFERENCES");
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((String)actionId, (String)"edit_guest")) {
                        actions.add("GUEST_PREFERENCES");
                        continue;
                    }
                    actions.add(StringUtil.toUpperCase((String)actionId));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unable to obtain resource actions for unknown portlet " + name));
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletResourceActionsBag getPortletResourceActionsBag(String portletName) {
        PortletResourceActionsBag portletResourceActionsBag = this._portletResourceActionsBags.get(portletName);
        if (portletResourceActionsBag != null) {
            return portletResourceActionsBag;
        }
        Map<String, PortletResourceActionsBag> map = this._portletResourceActionsBags;
        synchronized (map) {
            portletResourceActionsBag = this._portletResourceActionsBags.get(portletName);
            if (portletResourceActionsBag != null) {
                return portletResourceActionsBag;
            }
            portletResourceActionsBag = new PortletResourceActionsBagImpl();
            this._portletResourceActionsBags.put(portletName, portletResourceActionsBag);
        }
        return portletResourceActionsBag;
    }

    protected String getResourceBundlesString(HttpServletRequest request, String key) {
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)request, null);
        return this.getResourceBundlesString(locale, key);
    }

    protected String getResourceBundlesString(Locale locale, String key) {
        if (locale == null || key == null) {
            return null;
        }
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        for (ResourceBundleLoader resourceBundleLoader : this._resourceBundleLoaders) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(languageId);
            if (resourceBundle == null || !resourceBundle.containsKey(key)) continue;
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        }
        return null;
    }

    protected int[] getRoleTypes(long companyId, Group group, String modelResource) {
        int[] types = RoleConstants.TYPES_REGULAR_AND_SITE;
        if (this.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR : RoleConstants.TYPES_REGULAR;
        } else if (group != null) {
            if (group.isLayout()) {
                try {
                    group = GroupServiceUtil.getGroup((long)group.getParentGroupId());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (group.isOrganization()) {
                types = RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE;
            } else if (group.isUser()) {
                types = RoleConstants.TYPES_REGULAR;
            }
        }
        return types;
    }

    protected void read(String servletContextName, Document document) throws Exception {
        Element rootElement = document.getRootElement();
        if (PropsValues.RESOURCE_ACTIONS_READ_PORTLET_RESOURCES) {
            for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
                this.readPortletResource(servletContextName, portletResourceElement);
            }
        }
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            this.readModelResource(servletContextName, modelResourceElement);
        }
    }

    protected List<String> readActionKeys(Element parentElement) {
        ArrayList<String> actions = new ArrayList<String>();
        for (Element actionKeyElement : parentElement.elements("action-key")) {
            String actionKey = actionKeyElement.getTextTrim();
            if (Validator.isNull((String)actionKey)) continue;
            actions.add(actionKey);
        }
        return actions;
    }

    protected void readGroupDefaultActions(Element parentElement, Set<String> groupDefaultActions) {
        Element groupDefaultsElement = this.getPermissionsChildElement(parentElement, "site-member-defaults");
        if (groupDefaultsElement == null) {
            groupDefaultsElement = this.getPermissionsChildElement(parentElement, "community-defaults");
            if (_log.isWarnEnabled() && groupDefaultsElement != null) {
                _log.warn((Object)"The community-defaults element is deprecated. Use the site-member-defaults element instead.");
            }
        }
        groupDefaultActions.addAll(this.readActionKeys(groupDefaultsElement));
    }

    protected void readGuestDefaultActions(Element parentElement, Set<String> guestDefaultActions) {
        Element guestDefaultsElement = this.getPermissionsChildElement(parentElement, "guest-defaults");
        guestDefaultActions.addAll(this.readActionKeys(guestDefaultsElement));
    }

    protected void readGuestUnsupportedActions(Element parentElement, Set<String> guestUnsupportedActions, Set<String> guestDefaultActions) {
        Element guestUnsupportedElement = this.getPermissionsChildElement(parentElement, "guest-unsupported");
        guestUnsupportedActions.addAll(this.readActionKeys(guestUnsupportedElement));
        this.checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
    }

    protected void readLayoutManagerActions(Element parentElement, Set<String> layoutManagerActions, Set<String> supportsActions) {
        Element layoutManagerElement = this.getPermissionsChildElement(parentElement, "layout-manager");
        if (layoutManagerElement != null) {
            layoutManagerActions.addAll(this.readActionKeys(layoutManagerElement));
        } else {
            layoutManagerActions.addAll(supportsActions);
        }
    }

    protected void readModelResource(String servletContextName, Element modelResourceElement) throws Exception {
        String name = modelResourceElement.elementTextTrim("model-name");
        if (Validator.isNull((String)name)) {
            name = this.getCompositeModelName(modelResourceElement.element("composite-model-name"));
        }
        if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("organization"))) {
            this._organizationModelResources.add(name);
        }
        if (GetterUtil.getBoolean((String)modelResourceElement.attributeValue("portal"))) {
            this._portalModelResources.add(name);
        }
        ModelResourceActionsBag modelResourceActionsBag = this.getModelResourceActionsBag(name);
        Element portletRefElement = modelResourceElement.element("portlet-ref");
        for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
            String portletName = portletNameElement.getTextTrim();
            if (servletContextName != null) {
                portletName = portletName.concat("_WAR_").concat(servletContextName);
            }
            portletName = JS.getSafeName((String)portletName);
            PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(portletName);
            Set modelResources = portletResourceActionsBag.getResources();
            modelResources.add(name);
            Set portletResources = modelResourceActionsBag.getResources();
            portletResources.add(portletName);
            boolean root = GetterUtil.getBoolean((String)modelResourceElement.elementText("root"));
            if (!root) continue;
            this._rootModelResources.add(name);
            Map portletRootModelResource = portletResourceActionsBag.getPortletRootModelResources();
            portletRootModelResource.put(portletName, name);
        }
        double weight = GetterUtil.getDouble((String)modelResourceElement.elementTextTrim("weight"), (double)100.0);
        Map modelResourceWeights = modelResourceActionsBag.getResourceWeights();
        modelResourceWeights.put(name, weight);
        Set modelResourceActions = modelResourceActionsBag.getResourceActions();
        this.readSupportsActions(modelResourceElement, modelResourceActions);
        this.checkModelActions(modelResourceActions);
        if (modelResourceActions.size() > 64) {
            throw new ResourceActionsException("There are more than 64 actions for resource " + name);
        }
        Set modelResourceGroupDefaultActions = modelResourceActionsBag.getResourceGroupDefaultActions();
        this.readGroupDefaultActions(modelResourceElement, modelResourceGroupDefaultActions);
        Set modelResourceGuestDefaultActions = modelResourceActionsBag.getResourceGuestDefaultActions();
        this.readGuestDefaultActions(modelResourceElement, modelResourceGuestDefaultActions);
        Set modelResourceGuestUnsupportedActions = modelResourceActionsBag.getResourceGuestUnsupportedActions();
        this.readGuestUnsupportedActions(modelResourceElement, modelResourceGuestUnsupportedActions, modelResourceGuestDefaultActions);
        Set modelResourceOwnerDefaultActions = modelResourceActionsBag.getResourceOwnerDefaultActions();
        this.readOwnerDefaultActions(modelResourceElement, modelResourceOwnerDefaultActions);
    }

    protected void readOwnerDefaultActions(Element parentElement, Set<String> ownerDefaultActions) {
        Element ownerDefaultsElement = this.getPermissionsChildElement(parentElement, "owner-defaults");
        if (ownerDefaultsElement == null) {
            return;
        }
        ownerDefaultActions.addAll(this.readActionKeys(ownerDefaultsElement));
    }

    protected void readPortletResource(String servletContextName, Element portletResourceElement) throws Exception {
        String name = portletResourceElement.elementTextTrim("portlet-name");
        if (servletContextName != null) {
            name = name.concat("_WAR_").concat(servletContextName);
        }
        name = JS.getSafeName((String)name);
        PortletResourceActionsBag portletResourceActionsBag = this.getPortletResourceActionsBag(name);
        Set portletResourceActions = portletResourceActionsBag.getResourceActions();
        this.readSupportsActions(portletResourceElement, portletResourceActions);
        portletResourceActions.addAll(this.getPortletMimeTypeActions(name));
        if (!name.equals("90")) {
            this.checkPortletActions(name, (Set<String>)portletResourceActions);
        }
        if (portletResourceActions.size() > 64) {
            throw new ResourceActionsException("There are more than 64 actions for resource " + name);
        }
        Set portletResourceGroupDefaultActions = portletResourceActionsBag.getResourceGroupDefaultActions();
        this.readGroupDefaultActions(portletResourceElement, portletResourceGroupDefaultActions);
        Set portletResourceGuestDefaultActions = portletResourceActionsBag.getResourceGuestDefaultActions();
        this.readGuestDefaultActions(portletResourceElement, portletResourceGuestDefaultActions);
        Set portletResourceGuestUnsupportedActions = portletResourceActionsBag.getResourceGuestUnsupportedActions();
        this.readGuestUnsupportedActions(portletResourceElement, portletResourceGuestUnsupportedActions, portletResourceGuestDefaultActions);
        Set portletResourceLayoutManagerActions = portletResourceActionsBag.getResourceLayoutManagerActions();
        this.readLayoutManagerActions(portletResourceElement, portletResourceLayoutManagerActions, portletResourceActions);
    }

    protected Set<String> readSupportsActions(Element parentElement, Set<String> supportsActions) {
        Element supportsElement = this.getPermissionsChildElement(parentElement, "supports");
        supportsActions.addAll(this.readActionKeys(supportsElement));
        return supportsActions;
    }
}

