/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.util.StringUtil;
import java.nio.ByteBuffer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagUtil {
    public static boolean processETag(HttpServletRequest request, HttpServletResponse response, ByteBuffer byteBuffer) {
        if (response.isCommitted()) {
            return false;
        }
        int hashCode = ETagUtil._hashCode(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        String eTag = "\"".concat(StringUtil.toHexString((int)hashCode)).concat("\"");
        response.setHeader("ETag", eTag);
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (eTag.equals(ifNoneMatch)) {
            response.setStatus(304);
            response.setContentLength(0);
            return true;
        }
        return false;
    }

    private static int _hashCode(byte[] data, int offset, int length) {
        int hashCode = 0;
        for (int i = 0; i < length; ++i) {
            hashCode = 31 * hashCode + data[offset++];
        }
        return hashCode;
    }
}

