/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.DummyOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.util.ant.Wsdl2JavaTask;
import com.liferay.util.axis.AxisServlet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;

public class PortalClientBuilder {
    private final HttpServlet _axisHttpServlet;

    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        if (args.length != 4) {
            throw new IllegalArgumentException();
        }
        new PortalClientBuilder(args[0], args[1], args[2], args[3]);
    }

    public PortalClientBuilder(String fileName, String outputDir, String mappingFile, String url) throws Exception {
        URL.setURLStreamHandlerFactory(new DirectURLStreamHandlerFactory());
        File file = new File(fileName);
        File parentFile = file.getParentFile();
        this._axisHttpServlet = this._createAxisHttpServlet(parentFile.getParentFile());
        Document document = UnsecureSAXReaderUtil.read((File)new File(fileName));
        Element rootElement = document.getRootElement();
        List serviceElements = rootElement.elements("service");
        for (Element serviceElement : serviceElements) {
            String serviceName = serviceElement.attributeValue("name");
            if (serviceName.startsWith("Plugin_") && !FileUtil.exists((String)mappingFile)) {
                this._writePluginMappingFile(mappingFile, serviceElement);
            }
            if (!serviceName.startsWith("Plugin_") && !serviceName.startsWith("Portal_") && !serviceName.startsWith("Portlet_")) continue;
            Wsdl2JavaTask.generateJava((String)(url + "/" + serviceName + "?wsdl"), (String)outputDir, (String)mappingFile);
        }
        File testNamespace = new File(outputDir + "/com/liferay/portal");
        if (testNamespace.exists()) {
            throw new RuntimeException("Please update " + mappingFile + " from namespace " + "com.liferay.portal to com.liferay.client.soap.portal");
        }
    }

    private HttpServlet _createAxisHttpServlet(final File docRootDir) throws ServletException {
        AxisServlet axisServlet = new AxisServlet();
        MockServletConfig mockServletConfig = new MockServletConfig((ServletContext)new MockServletContext(new ResourceLoader(){

            public ClassLoader getClassLoader() {
                return AxisServlet.class.getClassLoader();
            }

            public Resource getResource(String name) {
                return new FileSystemResource(new File(docRootDir, name));
            }
        }), "Axis Servlet");
        axisServlet.init((ServletConfig)mockServletConfig);
        return axisServlet;
    }

    private byte[] _getWSDLContent(URL url) throws IOException {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        String servletPath = path.substring(0, index);
        MockHttpServletRequest mockHttpServletRequest = new MockHttpServletRequest(this._axisHttpServlet.getServletContext(), "GET", path);
        mockHttpServletRequest.setPathInfo(path.substring(index));
        mockHttpServletRequest.setQueryString(url.getQuery());
        mockHttpServletRequest.setScheme(url.getProtocol());
        mockHttpServletRequest.setServerName(url.getHost());
        mockHttpServletRequest.setServerPort(url.getPort());
        mockHttpServletRequest.setServletPath(servletPath);
        MockHttpServletResponse mockHttpServletResponse = new MockHttpServletResponse();
        try {
            this._axisHttpServlet.service((ServletRequest)mockHttpServletRequest, (ServletResponse)mockHttpServletResponse);
        }
        catch (ServletException se) {
            throw new IOException(se);
        }
        return mockHttpServletResponse.getContentAsByteArray();
    }

    private void _writePluginMappingFile(String mappingFile, Element serviceElement) throws Exception {
        String wsdlTargetNamespace = null;
        List parameterElements = serviceElement.elements("parameter");
        for (Element parameterElement : parameterElements) {
            String parameterName = parameterElement.attributeValue("name");
            if (!parameterName.equals("wsdlTargetNamespace")) continue;
            wsdlTargetNamespace = parameterElement.attributeValue("value");
            break;
        }
        int pos = wsdlTargetNamespace.indexOf(".service.");
        String soapNamespace = wsdlTargetNamespace.substring(pos + 9);
        Object[] soapNamespaceArray = StringUtil.split((String)soapNamespace, (char)'.');
        ArrayUtil.reverse((Object[])soapNamespaceArray);
        soapNamespace = StringUtil.merge((Object[])soapNamespaceArray, (String)".");
        pos = soapNamespace.lastIndexOf(".");
        soapNamespace = soapNamespace.substring(0, pos) + ".client.soap" + soapNamespace.substring(pos);
        StringBundler sb = new StringBundler(10);
        sb.append("com.liferay.client.soap.portal.kernel.util=");
        sb.append("http://util.kernel.portal.liferay.com\n");
        sb.append("com.liferay.client.soap.portal.model=");
        sb.append("http://model.portal.liferay.com\n");
        sb.append("com.liferay.client.soap.portal.service=");
        sb.append("http://service.portal.liferay.com\n");
        sb.append(soapNamespace);
        sb.append(".model=http://model.knowledgebase.liferay.com\n");
        sb.append(soapNamespace);
        sb.append(".service.http=urn:http.service.knowledgebase.liferay.com\n");
        FileUtil.write((String)mappingFile, (String)sb.toString());
    }

    private class DirectURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private DirectURLStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            return new DirectURLStreamHandler();
        }
    }

    private class DirectURLStreamHandler
    extends URLStreamHandler {
        private DirectURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new DirectURLConnection(url);
        }
    }

    private class DirectURLConnection
    extends URLConnection {
        public DirectURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new UnsyncByteArrayInputStream(PortalClientBuilder.this._getWSDLContent(this.url));
        }

        @Override
        public OutputStream getOutputStream() {
            return new DummyOutputStream();
        }
    }
}

