/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.portletrepository.PortletRepository;
import com.liferay.portal.upgrade.v7_0_0.util.DLFolderTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    protected void addClassName(long classNameId, String className) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            ps.setLong(1, 0L);
            ps.setLong(2, classNameId);
            ps.setString(3, className);
            ps.executeUpdate();
        }
    }

    protected void addDDMStructureLink(long ddmStructureLinkId, long classNameId, long classPK, long ddmStructureId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into DDMStructureLink (structureLinkId, classNameId, classPK, structureId) values (?, ?, ?, ?)");){
            ps.setLong(1, ddmStructureLinkId);
            ps.setLong(2, classNameId);
            ps.setLong(3, classPK);
            ps.setLong(4, ddmStructureId);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.error((Object)("Unable to add dynamic data mapping structure link for file entry type " + classPK));
            throw e;
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateFileEntryFileNames();
        this.updateFileEntryTypeNamesAndDescriptions();
        this.updateFileEntryTypeDDMStructureLinks();
        this.updateFileVersionFileNames();
        this.alter(DLFolderTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, "name", "VARCHAR(255) null")});
        this.updateRepositoryClassNameIds();
    }

    /*
     * Exception decompiling
     */
    protected boolean hasFileEntry(long groupId, long folderId, long fileEntryId, String title, String fileName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    protected boolean hasFileEntry(long groupId, long folderId, String fileName) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void updateFileEntryFileNames() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("alter table DLFileEntry add fileName VARCHAR(255) null");
            HashSet<String> generatedUniqueFileNames = new HashSet<String>();
            HashSet<String> generatedUniqueTitles = new HashSet<String>();
            try (PreparedStatement ps1 = this.connection.prepareStatement("select fileEntryId, groupId, folderId, extension, title, version from DLFileEntry");
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update DLFileEntry set fileName = ?, title = ? where fileEntryId = ?"));
                 PreparedStatement ps3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileVersion set title = ? where fileEntryId = ? and version = ? and status != ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long fileEntryId = rs.getLong("fileEntryId");
                    long groupId = rs.getLong("groupId");
                    long folderId = rs.getLong("folderId");
                    String extension = GetterUtil.getString((String)rs.getString("extension"));
                    String title = GetterUtil.getString((String)rs.getString("title"));
                    String version = rs.getString("version");
                    String uniqueFileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                    String titleExtension = "";
                    String titleWithoutExtension = title;
                    if (title.endsWith("." + extension)) {
                        titleExtension = extension;
                        titleWithoutExtension = FileUtil.stripExtension((String)title);
                    }
                    boolean generatedUniqueFileName = false;
                    String uniqueTitle = title;
                    int i = 1;
                    while (generatedUniqueFileNames.contains(uniqueFileName) || generatedUniqueTitles.contains(uniqueTitle) || this.hasFileEntry(groupId, folderId, fileEntryId, uniqueTitle, uniqueFileName)) {
                        generatedUniqueFileName = true;
                        uniqueTitle = titleWithoutExtension + "_" + String.valueOf(i);
                        if (Validator.isNotNull((String)titleExtension)) {
                            uniqueTitle = uniqueTitle + ".".concat(titleExtension);
                        }
                        uniqueFileName = DLUtil.getSanitizedFileName((String)uniqueTitle, (String)extension);
                        ++i;
                    }
                    if (generatedUniqueFileName) {
                        generatedUniqueFileNames.add(uniqueFileName);
                        generatedUniqueTitles.add(uniqueTitle);
                    }
                    ps2.setString(1, uniqueFileName);
                    if (Validator.isNotNull((String)uniqueTitle)) {
                        ps2.setString(2, uniqueTitle);
                    } else {
                        ps2.setString(2, title);
                    }
                    ps2.setLong(3, fileEntryId);
                    ps2.addBatch();
                    if (!Validator.isNotNull((String)uniqueTitle)) continue;
                    ps3.setString(1, uniqueTitle);
                    ps3.setLong(2, fileEntryId);
                    ps3.setString(3, version);
                    ps3.setInt(4, 8);
                    ps3.addBatch();
                }
                ps2.executeBatch();
                ps3.executeBatch();
            }
        }
    }

    protected void updateFileEntryTypeDDMStructureLinks() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from DLFileEntryTypes_DDMStructures");
             ResultSet rs = ps.executeQuery();){
            long classNameId = PortalUtil.getClassNameId(DLFileEntryType.class);
            while (rs.next()) {
                long structureId = rs.getLong("structureId");
                long fileEntryTypeId = rs.getLong("fileEntryTypeId");
                this.addDDMStructureLink(this.increment(), classNameId, fileEntryTypeId, structureId);
            }
            this.runSQL("drop table DLFileEntryTypes_DDMStructures");
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select companyId, groupId from Group_ where classNameId = ?");){
            long classNameId = PortalUtil.getClassNameId(Company.class);
            ps.setLong(1, classNameId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong(1);
                    long groupId = rs.getLong(2);
                    this.updateFileEntryTypeNamesAndDescriptions(companyId, groupId);
                }
            }
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long groupId) throws Exception {
        HashMap<String, String> nameLanguageKeys = new HashMap<String, String>();
        nameLanguageKeys.put("contract", "CONTRACT");
        nameLanguageKeys.put("marketing-banner", "MARKETING BANNER");
        nameLanguageKeys.put("online-training", "ONLINE TRAINING");
        nameLanguageKeys.put("sales-presentation", "SALES PRESENTATION");
        for (Map.Entry nameAndKey : nameLanguageKeys.entrySet()) {
            String dlFileEntryTypeKey = (String)nameAndKey.getValue();
            String nameLanguageKey = (String)nameAndKey.getKey();
            this.updateFileEntryTypeNamesAndDescriptions(companyId, groupId, dlFileEntryTypeKey, nameLanguageKey);
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long groupId, String dlFileEntryTypeKey, String nameLanguageKey) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select fileEntryTypeId, name, description from DLFileEntryType where groupId = ? and fileEntryTypeKey = ?");){
            ps.setLong(1, groupId);
            ps.setString(2, dlFileEntryTypeKey);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) {
                    return;
                }
                long fileEntryTypeId = rs.getLong(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                if (rs.next()) {
                    throw new IllegalStateException(String.format("Found more than one row in table DLFileEntryType with groupId %s and fileEntryTypeKey %s", groupId, dlFileEntryTypeKey));
                }
                this.updateFileEntryTypeNamesAndDescriptions(companyId, fileEntryTypeId, nameLanguageKey, name, description);
            }
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long companyId, long dlFileEntryTypeId, String nameLanguageKey, String nameXML, String descriptionXML) throws Exception {
        boolean update = false;
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)companyId));
        String defaultValue = LanguageUtil.get((Locale)defaultLocale, (String)nameLanguageKey);
        Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
        Map descriptionMap = LocalizationUtil.getLocalizationMap((String)descriptionXML);
        for (Locale locale : LanguageUtil.getSupportedLocales()) {
            String name;
            String value = LanguageUtil.get((Locale)locale, (String)nameLanguageKey);
            if (!locale.equals(defaultLocale) && value.equals(defaultValue)) continue;
            String description = (String)descriptionMap.get(locale);
            if (description == null) {
                descriptionMap.put(locale, value);
                update = true;
            }
            if ((name = (String)nameMap.get(locale)) != null) continue;
            nameMap.put(locale, value);
            update = true;
        }
        if (update) {
            this.updateFileEntryTypeNamesAndDescriptions(dlFileEntryTypeId, nameXML, descriptionXML, nameMap, descriptionMap, defaultLocale);
        }
    }

    protected void updateFileEntryTypeNamesAndDescriptions(long fileEntryTypeId, String nameXML, String descriptionXML, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, Locale defaultLocale) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update DLFileEntryType set name = ?, description = ? where fileEntryTypeId = ?");){
            String languageId = LanguageUtil.getLanguageId((Locale)defaultLocale);
            nameXML = LocalizationUtil.updateLocalization(nameMap, (String)nameXML, (String)"Name", (String)languageId);
            descriptionXML = LocalizationUtil.updateLocalization(descriptionMap, (String)descriptionXML, (String)"Description", (String)languageId);
            ps.setString(1, nameXML);
            ps.setString(2, descriptionXML);
            ps.setLong(3, fileEntryTypeId);
            int rowCount = ps.executeUpdate();
            if (rowCount != 1) {
                throw new IllegalStateException(String.format("Updated %s rows in table DLFileEntryType with fileEntryTypeId %s", rowCount, fileEntryTypeId));
            }
        }
    }

    protected void updateFileVersionFileName(long fileVersionId, String fileName) throws Exception {
    }

    protected void updateFileVersionFileNames() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("alter table DLFileVersion add fileName VARCHAR(255) null");
            try (PreparedStatement ps1 = this.connection.prepareStatement("select fileVersionId, extension, title from DLFileVersion");
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileVersion set fileName = ? where fileVersionId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long fileVersionId = rs.getLong("fileVersionId");
                    String extension = GetterUtil.getString((String)rs.getString("extension"));
                    String title = GetterUtil.getString((String)rs.getString("title"));
                    String fileName = DLUtil.getSanitizedFileName((String)title, (String)extension);
                    ps2.setString(1, fileName);
                    ps2.setLong(2, fileVersionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected void updateRepositoryClassNameIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long liferayRepositoryClassNameId = PortalUtil.getClassNameId(LiferayRepository.class);
            long portletRepositoryClassNameId = PortalUtil.getClassNameId(PortletRepository.class);
            if (portletRepositoryClassNameId == 0L) {
                portletRepositoryClassNameId = this.increment();
                this.addClassName(portletRepositoryClassNameId, PortletRepository.class.getName());
            }
            try (PreparedStatement ps = this.connection.prepareStatement("update Repository set classNameId = ? where classNameId = ?");){
                ps.setLong(1, portletRepositoryClassNameId);
                ps.setLong(2, liferayRepositoryClassNameId);
                ps.executeUpdate();
            }
        }
    }
}

