/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeResourcePermission
extends UpgradeProcess {
    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQLTemplateString("create index IX_D5F1E2A2 on ResourcePermission (name[$COLUMN_LENGTH:255$])", false, false);
        }
    }

    protected void doUpgrade() throws Exception {
        this.createIndex();
        this.upgradeResourcePermissions();
    }

    protected void upgradeResourcePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String selectSQL = "select resourcePermissionId, primKey, actionIds from ResourcePermission";
            String updateSQL = "update ResourcePermission set primKeyId = ?, viewActionId = ? where resourcePermissionId = ?";
            try (PreparedStatement ps1 = this.connection.prepareStatement(selectSQL);
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateSQL);){
                while (rs.next()) {
                    boolean newViewActionId;
                    long resourcePermissionId = rs.getLong("resourcePermissionId");
                    long actionIds = rs.getLong("actionIds");
                    long newPrimKeyId = GetterUtil.getLong((String)rs.getString("primKey"));
                    boolean bl = newViewActionId = actionIds % 2L == 1L;
                    if (newPrimKeyId == 0L && !newViewActionId) continue;
                    ps2.setLong(1, newPrimKeyId);
                    ps2.setBoolean(2, newViewActionId);
                    ps2.setLong(3, resourcePermissionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

