/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.net.HttpURLConnection;
import java.net.URL;

public class BrowserLauncher
implements Runnable {
    private static final String[] _BROWSERS = new String[]{"xdg-open", "firefox", "mozilla", "konqueror", "opera"};

    @Override
    public void run() {
        if (Validator.isNull((String)PropsValues.BROWSER_LAUNCHER_URL)) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                URL url = new URL(PropsValues.BROWSER_LAUNCHER_URL);
                HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
                int responseCode = urlc.getResponseCode();
                if (responseCode != 200) continue;
                try {
                    this.launchBrowser();
                }
                catch (Exception e2) {}
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void launchBrowser() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        if (OSDetector.isApple()) {
            this.launchBrowserApple(runtime);
        } else if (OSDetector.isWindows()) {
            this.launchBrowserWindows(runtime);
        } else {
            this.launchBrowserUnix(runtime);
        }
    }

    protected void launchBrowserApple(Runtime runtime) throws Exception {
        runtime.exec("open " + PropsValues.BROWSER_LAUNCHER_URL);
    }

    protected void launchBrowserUnix(Runtime runtime) throws Exception {
        if (_BROWSERS.length == 0) {
            runtime.exec(new String[]{"sh", "-c", ""});
        }
        StringBundler sb = new StringBundler(_BROWSERS.length * 5 - 1);
        for (int i = 0; i < _BROWSERS.length; ++i) {
            if (i != 0) {
                sb.append(" || ");
            }
            sb.append(_BROWSERS[i]);
            sb.append(" \"");
            sb.append(PropsValues.BROWSER_LAUNCHER_URL);
            sb.append("\" ");
        }
        runtime.exec(new String[]{"sh", "-c", sb.toString()});
    }

    protected void launchBrowserWindows(Runtime runtime) throws Exception {
        runtime.exec("cmd.exe /c start " + PropsValues.BROWSER_LAUNCHER_URL);
    }
}

