/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import java.util.Date;

public class ShutdownUtil {
    private static final ShutdownUtil _instance = new ShutdownUtil();
    private Date _date;
    private String _message;

    public static void cancel() {
        _instance._cancel();
    }

    public static long getInProcess() {
        return _instance._getInProcess();
    }

    public static String getMessage() {
        return _instance._getMessage();
    }

    public static boolean isInProcess() {
        return _instance._isInProcess();
    }

    public static boolean isShutdown() {
        return _instance._isShutdown();
    }

    public static void shutdown(long milliseconds) {
        ShutdownUtil.shutdown(milliseconds, "");
    }

    public static void shutdown(long milliseconds, String message) {
        _instance._shutdown(milliseconds, message);
    }

    private ShutdownUtil() {
    }

    private void _cancel() {
        this._date = null;
        this._message = null;
    }

    private long _getInProcess() {
        long milliseconds = 0L;
        if (this._date != null) {
            milliseconds = this._date.getTime() - System.currentTimeMillis();
        }
        return milliseconds;
    }

    private String _getMessage() {
        return this._message;
    }

    private boolean _isInProcess() {
        if (this._date == null) {
            return false;
        }
        return this._date.after(new Date());
    }

    private boolean _isShutdown() {
        if (this._date == null) {
            return false;
        }
        return this._date.before(new Date());
    }

    private void _shutdown(long milliseconds, String message) {
        this._date = new Date(System.currentTimeMillis() + milliseconds);
        this._message = message;
    }
}

