/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.ccpp.PortalProfileFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.servlet.NamespaceServletRequest;
import com.liferay.portal.servlet.SharedSessionServletRequest;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortalContextImpl;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.PortletSessionImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import com.liferay.portlet.RenderParametersPool;
import com.liferay.portlet.UserInfoFactory;
import com.liferay.portlet.portletconfiguration.util.PublicRenderParameterConfiguration;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ccpp.Profile;
import javax.portlet.PortalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.WindowState;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class PortletRequestImpl
implements LiferayPortletRequest {
    private static final Log _log = LogFactoryUtil.getLog(PortletRequestImpl.class);
    private static final Pattern _strutsPortletIgnoredParamtersPattern = Pattern.compile(PropsValues.STRUTS_PORTLET_IGNORED_PARAMETERS_REGEXP);
    private boolean _invalidSession;
    private Locale _locale;
    private HttpServletRequest _originalRequest;
    private long _plid;
    private PortalContext _portalContext;
    private Portlet _portlet;
    private PortletContext _portletContext;
    private PortletMode _portletMode;
    private String _portletName;
    private HttpServletRequest _portletRequestDispatcherRequest;
    private PortletPreferences _preferences;
    private Profile _profile;
    private Map<String, String[]> _publicRenderParameters;
    private String _remoteUser;
    private long _remoteUserId;
    private HttpServletRequest _request;
    private PortletSessionImpl _session;
    private boolean _strutsPortlet;
    private boolean _triggeredByActionURL;
    private Principal _userPrincipal;
    private WindowState _windowState;

    public static PortletRequestImpl getPortletRequestImpl(PortletRequest portletRequest) {
        while (!(portletRequest instanceof PortletRequestImpl)) {
            if (portletRequest instanceof DoPrivilegedBean) {
                DoPrivilegedBean doPrivilegedBean = (DoPrivilegedBean)portletRequest;
                portletRequest = (PortletRequest)doPrivilegedBean.getActualBean();
                continue;
            }
            if (portletRequest instanceof PortletRequestWrapper) {
                PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
                portletRequest = portletRequestWrapper.getRequest();
                continue;
            }
            throw new RuntimeException("Unable to unwrap the portlet request from " + portletRequest.getClass());
        }
        return (PortletRequestImpl)portletRequest;
    }

    public void cleanUp() {
        this._request.removeAttribute("javax.portlet.config");
        this._request.removeAttribute("javax.portlet.request");
        this._request.removeAttribute("javax.portlet.response");
        this._request.removeAttribute("javax.portlet.lifecycle_phase");
        this._request.removeAttribute("PORTLET_ID");
        this._request.removeAttribute("PORTLET_CONTENT");
    }

    public Map<String, String[]> clearRenderParameters() {
        return RenderParametersPool.clear(this._request, this._plid, this._portletName);
    }

    public void defineObjects(PortletConfig portletConfig, PortletResponse portletResponse) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this.setAttribute("PORTLET_ID", liferayPortletConfig.getPortletId());
        this.setAttribute("javax.portlet.config", portletConfig);
        this.setAttribute("javax.portlet.request", this);
        this.setAttribute("javax.portlet.response", portletResponse);
        this.setAttribute("javax.portlet.lifecycle_phase", this.getLifecycle());
    }

    public Object getAttribute(String name) {
        LinkedHashMap<String, String> value;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (name.equals("javax.portlet.ccpp")) {
            return this.getCCPPProfile();
        }
        if (name.equals("javax.portlet.userinfo") && (value = this.getUserInfo()) != null) {
            return value;
        }
        return this._request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = this._request.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (name.equals("javax.servlet.include.path_info")) continue;
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public String getAuthType() {
        return this._request.getAuthType();
    }

    public Profile getCCPPProfile() {
        if (this._profile == null) {
            this._profile = PortalProfileFactory.getCCPPProfile(this._request);
        }
        return this._profile;
    }

    public String getContextPath() {
        return this._portlet.getContextPath();
    }

    public Cookie[] getCookies() {
        return this._request.getCookies();
    }

    public String getETag() {
        return null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    public abstract String getLifecycle();

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale == null) {
            locale = this._request.getLocale();
        }
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    public Enumeration<Locale> getLocales() {
        return this._request.getLocales();
    }

    public String getMethod() {
        return this._request.getMethod();
    }

    public HttpServletRequest getOriginalHttpServletRequest() {
        return this._originalRequest;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameter(name);
        }
        return this._request.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this._portletRequestDispatcherRequest != null) {
            return Collections.unmodifiableMap(this._portletRequestDispatcherRequest.getParameterMap());
        }
        return Collections.unmodifiableMap(this._request.getParameterMap());
    }

    public Enumeration<String> getParameterNames() {
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameterNames();
        }
        return this._request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this._portletRequestDispatcherRequest != null) {
            return this._portletRequestDispatcherRequest.getParameterValues(name);
        }
        return this._request.getParameterValues(name);
    }

    public long getPlid() {
        return this._plid;
    }

    public PortalContext getPortalContext() {
        return this._portalContext;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public PortletSession getPortletSession() {
        return this._session;
    }

    public PortletSession getPortletSession(boolean create) {
        if (!create && this._invalidSession) {
            return null;
        }
        return this._session;
    }

    public PortletPreferences getPreferences() {
        String lifecycle = this.getLifecycle();
        if (lifecycle.equals("RENDER_PHASE") && PropsValues.PORTLET_PREFERENCES_STRICT_STORE) {
            return (PortletPreferences)DoPrivilegedUtil.wrap(new PortletPreferencesPrivilegedAction());
        }
        return this.getPreferencesImpl();
    }

    public PortletPreferencesImpl getPreferencesImpl() {
        return (PortletPreferencesImpl)this._preferences;
    }

    public Map<String, String[]> getPrivateParameterMap() {
        Map parameterMap = null;
        parameterMap = this._portletRequestDispatcherRequest != null ? this._portletRequestDispatcherRequest.getParameterMap() : this._request.getParameterMap();
        HashMap privateParameterMap = null;
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            if (this._portlet.getPublicRenderParameter(name) != null) continue;
            if (privateParameterMap == null) {
                privateParameterMap = new HashMap(parameterMap.size(), 1.0f);
            }
            privateParameterMap.put(name, entry.getValue());
        }
        if (privateParameterMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(privateParameterMap);
    }

    public Enumeration<String> getProperties(String name) {
        ArrayList<String> values = new ArrayList<String>();
        String value = this._portalContext.getProperty(name);
        if (value != null) {
            values.add(value);
        }
        return Collections.enumeration(values);
    }

    public String getProperty(String name) {
        return this._portalContext.getProperty(name);
    }

    public Enumeration<String> getPropertyNames() {
        return this._portalContext.getPropertyNames();
    }

    public Map<String, String[]> getPublicParameterMap() {
        Map parameterMap = null;
        parameterMap = this._portletRequestDispatcherRequest != null ? this._portletRequestDispatcherRequest.getParameterMap() : this._request.getParameterMap();
        HashMap publicParameterMap = null;
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            if (this._portlet.getPublicRenderParameter(name) == null) continue;
            if (publicParameterMap == null) {
                publicParameterMap = new HashMap(parameterMap.size(), 1.0f);
            }
            publicParameterMap.put(name, entry.getValue());
        }
        if (publicParameterMap == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(publicParameterMap);
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public String getRequestedSessionId() {
        if (this._session != null) {
            return this._session.getId();
        }
        HttpSession session = this._request.getSession(false);
        if (session == null) {
            return "";
        }
        return session.getId();
    }

    public String getResponseContentType() {
        return "text/html";
    }

    public Enumeration<String> getResponseContentTypes() {
        ArrayList<String> responseContentTypes = new ArrayList<String>();
        responseContentTypes.add(this.getResponseContentType());
        return Collections.enumeration(responseContentTypes);
    }

    public String getScheme() {
        return this._request.getScheme();
    }

    public String getServerName() {
        return this._request.getServerName();
    }

    public int getServerPort() {
        return this._request.getServerPort();
    }

    public LinkedHashMap<String, String> getUserInfo() {
        return UserInfoFactory.getUserInfo(this._remoteUserId, this._portlet);
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public String getWindowID() {
        return this._portletName.concat("_LAYOUT_").concat(String.valueOf(this._plid));
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public void invalidateSession() {
        this._invalidSession = true;
    }

    public boolean isInvalidParameter(String name) {
        Matcher matcher;
        if (Validator.isNull((String)name) || name.startsWith("p_r_p_") || name.startsWith("r_p_r_p") || PortalUtil.isReservedParameter((String)name)) {
            return true;
        }
        return this._strutsPortlet && (matcher = _strutsPortletIgnoredParamtersPattern.matcher(name)).matches();
    }

    public boolean isPortletModeAllowed(PortletMode portletMode) {
        if (portletMode == null || Validator.isNull((String)portletMode.toString())) {
            return true;
        }
        return this._portlet.hasPortletMode(this.getResponseContentType(), portletMode);
    }

    public boolean isPrivateRequestAttributes() {
        return this._portlet.isPrivateRequestAttributes();
    }

    public boolean isRequestedSessionIdValid() {
        return this._request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public boolean isTriggeredByActionURL() {
        return this._triggeredByActionURL;
    }

    public boolean isUserInRole(String role) {
        if (this._remoteUserId <= 0L) {
            return false;
        }
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)this._request);
            String roleLink = (String)this._portlet.getRoleMappers().get(role);
            if (Validator.isNotNull((String)roleLink)) {
                return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)roleLink, (boolean)true);
            }
            return RoleLocalServiceUtil.hasUserRole((long)this._remoteUserId, (long)companyId, (String)role, (boolean)true);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return this._request.isUserInRole(role);
        }
    }

    public boolean isWindowStateAllowed(WindowState windowState) {
        return PortalContextImpl.isSupportedWindowState(windowState);
    }

    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._request.removeAttribute(name);
    }

    public void setAttribute(String name, Object obj) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (obj == null) {
            this._request.removeAttribute(name);
        } else {
            this._request.setAttribute(name, obj);
        }
    }

    public void setPortletMode(PortletMode portletMode) {
        this._portletMode = portletMode;
    }

    public void setPortletRequestDispatcherRequest(HttpServletRequest request) {
        this._portletRequestDispatcherRequest = request;
    }

    public void setWindowState(WindowState windowState) {
        this._windowState = windowState;
    }

    protected void init(HttpServletRequest request, Portlet portlet, InvokerPortlet invokerPortlet, PortletContext portletContext, WindowState windowState, PortletMode portletMode, PortletPreferences preferences, long plid) {
        Map<String, String[]> renderParameters;
        String dynamicQueryString;
        String portletResource;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._portlet = portlet;
        this._portletName = portlet.getPortletId();
        PortletApp portletApp = portlet.getPortletApp();
        this._publicRenderParameters = PublicRenderParametersPool.get(request, plid, portletApp.isWARFile());
        if (invokerPortlet != null && (invokerPortlet.isStrutsPortlet() || invokerPortlet.isStrutsBridgePortlet())) {
            this._strutsPortlet = true;
        }
        String portletNamespace = PortalUtil.getPortletNamespace((String)this._portletName);
        boolean warFile = portletApp.isWARFile();
        if (!warFile && Validator.isNotNull((String)(portletResource = ParamUtil.getString((HttpServletRequest)request, (String)portletNamespace.concat("portletResource"))))) {
            PortletApp resourcePortletApp;
            Portlet resourcePortlet = null;
            try {
                resourcePortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletResource);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (resourcePortlet != null && (resourcePortletApp = resourcePortlet.getPortletApp()).isWARFile()) {
                warFile = true;
            }
        }
        if (warFile) {
            request = new SharedSessionServletRequest((HttpServletRequest)request, !portlet.isPrivateSessionAttributes());
        }
        if ((dynamicQueryString = (String)request.getAttribute("DYNAMIC_QUERY_STRING")) != null) {
            request.removeAttribute("DYNAMIC_QUERY_STRING");
            request = DynamicServletRequest.addQueryString((HttpServletRequest)request, (String)dynamicQueryString, (boolean)true);
        }
        DynamicServletRequest dynamicRequest = null;
        dynamicRequest = portlet.isPrivateRequestAttributes() ? new NamespaceServletRequest((HttpServletRequest)request, portletNamespace, portletNamespace, false) : new DynamicServletRequest(request, false);
        boolean portletFocus = false;
        String ppid = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        boolean windowStateRestoreCurrentView = ParamUtil.getBoolean((HttpServletRequest)request, (String)"p_p_state_rcv");
        if (!(!this._portletName.equals(ppid) || windowStateRestoreCurrentView && portlet.isRestoreCurrentView())) {
            if (themeDisplay.isLifecycleRender() || themeDisplay.isLifecycleResource()) {
                portletFocus = true;
            } else if (themeDisplay.isLifecycleAction()) {
                this._triggeredByActionURL = true;
                if (this.getLifecycle().equals("ACTION_PHASE")) {
                    portletFocus = true;
                }
            }
        }
        if (portletFocus) {
            renderParameters = null;
            Map parameters = request.getParameterMap();
            for (Map.Entry entry : parameters.entrySet()) {
                String name = (String)entry.getKey();
                if (this.isInvalidParameter(name)) continue;
                String[] values = (String[])entry.getValue();
                if (themeDisplay.isLifecycleRender()) {
                    if (renderParameters == null) {
                        renderParameters = new HashMap<String, String[]>();
                    }
                    renderParameters.put(name, values);
                }
                if (values == null) continue;
                if (invokerPortlet != null && invokerPortlet.isFacesPortlet()) {
                    if (!name.startsWith(portletNamespace) && portlet.isRequiresNamespacedParameters()) continue;
                    dynamicRequest.setParameterValues(name, values);
                    continue;
                }
                String realName = this.removePortletNamespace(portletNamespace, name);
                if (realName.equals(name) && portlet.isRequiresNamespacedParameters()) continue;
                dynamicRequest.setParameterValues(realName, values);
            }
            if (this.getLifecycle().equals("RENDER_PHASE") && !LiferayWindowState.isExclusive((HttpServletRequest)request) && !LiferayWindowState.isPopUp((HttpServletRequest)request) && renderParameters != null) {
                RenderParametersPool.put(request, plid, this._portletName, renderParameters);
            }
        } else {
            renderParameters = RenderParametersPool.get(request, plid, this._portletName);
            if (renderParameters != null) {
                for (Map.Entry<String, String[]> entry : renderParameters.entrySet()) {
                    String name = entry.getKey();
                    String[] values = entry.getValue();
                    if (invokerPortlet == null || !invokerPortlet.isFacesPortlet()) {
                        name = this.removePortletNamespace(portletNamespace, name);
                    }
                    dynamicRequest.setParameterValues(name, values);
                }
            }
        }
        this.mergePublicRenderParameters(dynamicRequest, preferences, plid);
        this._request = dynamicRequest;
        this._originalRequest = request;
        this._portlet = portlet;
        this._portalContext = new PortalContextImpl();
        this._portletContext = portletContext;
        this._windowState = windowState;
        this._portletMode = portletMode;
        this._preferences = preferences;
        this._session = new PortletSessionImpl(this._request.getSession(), this._portletContext, this._portletName, plid);
        String remoteUser = request.getRemoteUser();
        String userPrincipalStrategy = portlet.getUserPrincipalStrategy();
        if (userPrincipalStrategy.equals("screenName")) {
            try {
                User user = PortalUtil.getUser((HttpServletRequest)request);
                if (user != null) {
                    this._remoteUser = user.getScreenName();
                    this._remoteUserId = user.getUserId();
                    this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
                }
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        } else {
            long userId = PortalUtil.getUserId((HttpServletRequest)request);
            if (userId > 0L && remoteUser == null) {
                this._remoteUser = String.valueOf(userId);
                this._remoteUserId = userId;
                this._userPrincipal = new ProtectedPrincipal(this._remoteUser);
            } else {
                this._remoteUser = remoteUser;
                this._remoteUserId = GetterUtil.getLong((String)remoteUser);
                this._userPrincipal = request.getUserPrincipal();
            }
        }
        this._locale = themeDisplay.getLocale();
        this._plid = plid;
    }

    protected void mergePublicRenderParameters(DynamicServletRequest dynamicRequest, PortletPreferences preferences, long plid) {
        Enumeration publicRenderParameters = Collections.enumeration(this._portlet.getPublicRenderParameters());
        while (publicRenderParameters.hasMoreElements()) {
            PublicRenderParameter publicRenderParameter = (PublicRenderParameter)publicRenderParameters.nextElement();
            String ignoreKey = PublicRenderParameterConfiguration.getIgnoreKey(publicRenderParameter);
            boolean ignoreValue = GetterUtil.getBoolean((String)preferences.getValue(ignoreKey, null));
            if (ignoreValue) continue;
            String mappingKey = PublicRenderParameterConfiguration.getMappingKey(publicRenderParameter);
            String mappingValue = GetterUtil.getString((String)preferences.getValue(mappingKey, null));
            HttpServletRequest request = (HttpServletRequest)dynamicRequest.getRequest();
            Object[] newValues = request.getParameterValues(mappingValue);
            if (newValues != null && newValues.length != 0) {
                newValues = ArrayUtil.remove((String[])newValues, (String)"null");
            }
            String name = publicRenderParameter.getIdentifier();
            if (ArrayUtil.isEmpty((Object[])newValues)) {
                QName qName = publicRenderParameter.getQName();
                Object[] values = this._publicRenderParameters.get(PortletQNameUtil.getPublicRenderParameterName((QName)qName));
                if (ArrayUtil.isEmpty((Object[])values) || Validator.isNull((String)values[0]) || dynamicRequest.getParameter(name) != null) continue;
                dynamicRequest.setParameterValues(name, (String[])values);
                continue;
            }
            dynamicRequest.setParameterValues(name, (String[])newValues);
        }
    }

    protected String removePortletNamespace(String portletNamespace, String name) {
        if (name.startsWith(portletNamespace)) {
            name = name.substring(portletNamespace.length());
        }
        return name;
    }

    private class PortletPreferencesPrivilegedAction
    implements PrivilegedAction<PortletPreferences> {
        private PortletPreferencesPrivilegedAction() {
        }

        @Override
        public PortletPreferences run() {
            return new PortletPreferencesWrapper(PortletRequestImpl.this.getPreferencesImpl());
        }
    }
}

