/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.social.kernel.model.SocialActivitySetting;
import com.liferay.social.kernel.service.permission.SocialActivityPermission;

public class SocialActivityPermissionImpl
implements SocialActivityPermission {
    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this.getPortletId(), groupId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        if (permissionChecker.isGroupAdmin(groupId) || permissionChecker.isGroupOwner(groupId)) {
            return true;
        }
        return permissionChecker.hasPermission(groupId, this.getPortletId(), this.getPortletId(), actionId);
    }

    protected String getPortletId() {
        return PortletProviderUtil.getPortletId((String)SocialActivitySetting.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
    }
}

