/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializable;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.ac.AccessControlThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.struts.JSONAction;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class JSONServiceAction
extends JSONAction {
    private static final String _REROUTE_PATH = "/api/json";
    private static Log _log = LogFactoryUtil.getLog(JSONServiceAction.class);
    private static Pattern _fieldDescriptorPattern = Pattern.compile("^(.*?)((\\[\\])*)$", 32);
    private Set<String> _invalidClassNames;
    private Set<String> _invalidMethodNames;
    private Map<String, Object[]> _methodCache = new HashMap<String, Object[]>();

    public JSONServiceAction() {
        this._invalidClassNames = SetUtil.fromArray((Object[])PropsValues.JSON_SERVICE_INVALID_CLASS_NAMES);
        this._invalidMethodNames = SetUtil.fromArray((Object[])PropsValues.JSON_SERVICE_INVALID_METHOD_NAMES);
        if (_log.isDebugEnabled()) {
            for (String invalidClassName : this._invalidClassNames) {
                _log.debug((Object)("Invalid class name " + invalidClassName));
            }
            for (String invalidMethodName : this._invalidMethodNames) {
                _log.debug((Object)("Invalid method name " + invalidMethodName));
            }
        }
    }

    @Override
    public String getJSON(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        String methodName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceMethodName");
        String[] serviceParameters = this.getStringArrayFromJSON(request, "serviceParameters");
        String[] serviceParameterTypes = this.getStringArrayFromJSON(request, "serviceParameterTypes");
        if (!this.isValidRequest(request)) {
            return null;
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        Class<?> clazz = contextClassLoader.loadClass(className);
        Object[] methodAndParameterTypes = this.getMethodAndParameterTypes(clazz, methodName, serviceParameters, serviceParameterTypes);
        if (methodAndParameterTypes == null) {
            return null;
        }
        Method method = (Method)methodAndParameterTypes[0];
        Type[] parameterTypes = (Type[])methodAndParameterTypes[1];
        Object[] args = new Object[serviceParameters.length];
        int i2 = 0;
        while (i2 < serviceParameters.length) {
            args[i2] = this.getArgValue(request, clazz, methodName, serviceParameters[i2], parameterTypes[i2]);
            ++i2;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoking " + clazz + " on method " + method.getName() + " with args " + Arrays.toString(args)));
            }
            Object returnObj = null;
            boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
            try {
                AccessControlThreadLocal.setRemoteAccess((boolean)true);
                returnObj = method.invoke(clazz, args);
            }
            finally {
                AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
            }
            if (returnObj != null) {
                return this.getReturnValue(returnObj);
            }
            return JSONFactoryUtil.getNullJSON();
        }
        catch (Exception e2) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invoked " + clazz + " on method " + method.getName() + " with args " + Arrays.toString(args)), (Throwable)e2);
            }
            return JSONFactoryUtil.serializeException((Exception)e2);
        }
    }

    protected Object getArgValue(HttpServletRequest request, Class<?> clazz, String methodName, String parameter, Type parameterType) throws Exception {
        String typeNameOrClassDescriptor = this.getTypeNameOrClassDescriptor(parameterType);
        String value = ParamUtil.getString((HttpServletRequest)request, (String)parameter);
        if (Validator.isNull((String)value) && !typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return null;
        }
        if (typeNameOrClassDescriptor.equals("boolean") || typeNameOrClassDescriptor.equals(Boolean.class.getName())) {
            return ParamUtil.getBoolean((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("double") || typeNameOrClassDescriptor.equals(Double.class.getName())) {
            return new Double(ParamUtil.getDouble((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("int") || typeNameOrClassDescriptor.equals(Integer.class.getName())) {
            return new Integer(ParamUtil.getInteger((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("long") || typeNameOrClassDescriptor.equals(Long.class.getName())) {
            return new Long(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals("short") || typeNameOrClassDescriptor.equals(Short.class.getName())) {
            return new Short(ParamUtil.getShort((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals(Date.class.getName())) {
            return new Date(ParamUtil.getLong((HttpServletRequest)request, (String)parameter));
        }
        if (typeNameOrClassDescriptor.equals(ServiceContext.class.getName())) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            jsonObject.put("javaClass", ServiceContext.class.getName());
            return ServiceContextUtil.deserialize((JSONObject)jsonObject);
        }
        if (typeNameOrClassDescriptor.equals(String.class.getName())) {
            return value;
        }
        if (typeNameOrClassDescriptor.equals("[Z")) {
            return ParamUtil.getBooleanValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[D")) {
            return ParamUtil.getDoubleValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[F")) {
            return ParamUtil.getFloatValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[I")) {
            return ParamUtil.getIntegerValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[J")) {
            return ParamUtil.getLongValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[S")) {
            return ParamUtil.getShortValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[Ljava.lang.String;")) {
            return ParamUtil.getParameterValues((HttpServletRequest)request, (String)parameter);
        }
        if (typeNameOrClassDescriptor.equals("[[Z")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                boolean[][] doubleArray = new boolean[values.length][values0.length];
                int i2 = 0;
                while (i2 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i2]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i2][j] = GetterUtil.getBoolean((String)curValues[j]);
                        ++j;
                    }
                    ++i2;
                }
                return doubleArray;
            }
            return new boolean[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[D")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                double[][] doubleArray = new double[values.length][values0.length];
                int i3 = 0;
                while (i3 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i3]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i3][j] = GetterUtil.getDouble((String)curValues[j]);
                        ++j;
                    }
                    ++i3;
                }
                return doubleArray;
            }
            return new double[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[F")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                float[][] doubleArray = new float[values.length][values0.length];
                int i4 = 0;
                while (i4 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i4]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i4][j] = GetterUtil.getFloat((String)curValues[j]);
                        ++j;
                    }
                    ++i4;
                }
                return doubleArray;
            }
            return new float[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[I")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                int[][] doubleArray = new int[values.length][values0.length];
                int i5 = 0;
                while (i5 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i5]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i5][j] = GetterUtil.getInteger((String)curValues[j]);
                        ++j;
                    }
                    ++i5;
                }
                return doubleArray;
            }
            return new int[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[J")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                long[][] doubleArray = new long[values.length][values0.length];
                int i6 = 0;
                while (i6 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i6]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i6][j] = GetterUtil.getLong((String)curValues[j]);
                        ++j;
                    }
                    ++i6;
                }
                return doubleArray;
            }
            return new long[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[S")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                short[][] doubleArray = new short[values.length][values0.length];
                int i7 = 0;
                while (i7 < values.length) {
                    String[] curValues = StringUtil.split((String)values[i7]);
                    int j = 0;
                    while (j < curValues.length) {
                        doubleArray[i7][j] = GetterUtil.getShort((String)curValues[j]);
                        ++j;
                    }
                    ++i7;
                }
                return doubleArray;
            }
            return new short[0][0];
        }
        if (typeNameOrClassDescriptor.equals("[[Ljava.lang.String")) {
            Object[] values = request.getParameterValues(parameter);
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                String[] values0 = StringUtil.split((String)values[0]);
                String[][] doubleArray = new String[values.length][values0.length];
                int i8 = 0;
                while (i8 < values.length) {
                    doubleArray[i8] = StringUtil.split((String)values[i8]);
                    ++i8;
                }
                return doubleArray;
            }
            return new String[0][0];
        }
        if (typeNameOrClassDescriptor.equals("java.util.Map<java.util.Locale, java.lang.String>")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)value);
            return LocalizationUtil.deserialize((JSONObject)jsonObject);
        }
        try {
            return JSONFactoryUtil.looseDeserializeSafe((String)value);
        }
        catch (Exception exception) {
            _log.error((Object)("Unsupported parameter type for class " + clazz + ", method " + methodName + ", parameter " + parameter + ", and type " + typeNameOrClassDescriptor));
            return null;
        }
    }

    @Override
    protected String getCSRFOrigin(HttpServletRequest request) {
        StringBundler sb = new StringBundler(6);
        sb.append(ClassUtil.getClassName((Object)((Object)this)));
        sb.append(":");
        sb.append("/");
        String serviceClassName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        sb.append(serviceClassName);
        sb.append("#");
        String serviceMethodName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceMethodName");
        sb.append(serviceMethodName);
        return sb.toString();
    }

    protected Object[] getMethodAndParameterTypes(Class<?> clazz, String methodName, String[] parameters, String[] parameterTypes) throws Exception {
        Method[] methods;
        StringBundler sb = new StringBundler(5);
        sb.append(clazz.getName());
        sb.append("_METHOD_NAME_");
        sb.append(methodName);
        sb.append("_PARAMETERS_");
        String parameterTypesNames = StringUtil.merge((Object[])parameterTypes);
        if (Validator.isNull((String)parameterTypesNames)) {
            sb.append(parameters.length);
        } else {
            sb.append(parameterTypesNames);
        }
        String key = sb.toString();
        Object[] methodAndParameterTypes = this._methodCache.get(key);
        if (methodAndParameterTypes != null) {
            return methodAndParameterTypes;
        }
        Method method = null;
        Type[] methodParameterTypes = null;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Type[] curParameterTypes;
            Method curMethod = methodArray[n2];
            if (curMethod.getName().equals(methodName) && (curParameterTypes = curMethod.getGenericParameterTypes()).length == parameters.length) {
                if (parameterTypes.length > 0 && parameterTypes.length == curParameterTypes.length) {
                    boolean match = true;
                    int j = 0;
                    while (j < parameterTypes.length) {
                        String t1 = parameterTypes[j];
                        String t2 = this.getTypeNameOrClassDescriptor(curParameterTypes[j]);
                        if (!t1.equals(t2)) {
                            match = false;
                        }
                        ++j;
                    }
                    if (match) {
                        method = curMethod;
                        methodParameterTypes = curParameterTypes;
                        break;
                    }
                } else {
                    if (method != null) {
                        String parametersString = StringUtil.merge((Object[])parameters);
                        _log.error((Object)("Obscure method name for class " + clazz + ", method " + methodName + ", and parameters " + parametersString));
                        return null;
                    }
                    method = curMethod;
                    methodParameterTypes = curParameterTypes;
                }
            }
            ++n2;
        }
        if (method != null) {
            methodAndParameterTypes = new Object[]{method, methodParameterTypes};
            this._methodCache.put(key, methodAndParameterTypes);
            return methodAndParameterTypes;
        }
        String parametersString = StringUtil.merge((Object[])parameters);
        _log.error((Object)("No method found for class " + clazz + ", method " + methodName + ", and parameters " + parametersString));
        return null;
    }

    @Override
    protected String getReroutePath() {
        return _REROUTE_PATH;
    }

    protected String getReturnValue(Object returnObj) throws Exception {
        if (returnObj instanceof JSONSerializable) {
            JSONSerializable jsonSerializable = (JSONSerializable)returnObj;
            return jsonSerializable.toJSONString();
        }
        JSONSerializer jsonSerializer = JSONFactoryUtil.createJSONSerializer();
        jsonSerializer.exclude(new String[]{"*.class"});
        return jsonSerializer.serializeDeep(returnObj);
    }

    protected String[] getStringArrayFromJSON(HttpServletRequest request, String param) throws JSONException {
        String json = ParamUtil.getString((HttpServletRequest)request, (String)param, (String)"[]");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        return ArrayUtil.toStringArray((JSONArray)jsonArray);
    }

    protected String getTypeNameOrClassDescriptor(Type type) {
        String typeName = type.toString();
        if (typeName.contains("class ")) {
            return typeName.substring(6);
        }
        Matcher matcher = _fieldDescriptorPattern.matcher(typeName);
        if (matcher.find()) {
            String dimensions = matcher.group(2);
            String fieldDescriptor = matcher.group(1);
            if (Validator.isNull((String)dimensions)) {
                return fieldDescriptor;
            }
            dimensions = dimensions.replace("]", "");
            fieldDescriptor = fieldDescriptor.equals("boolean") ? "Z" : (fieldDescriptor.equals("byte") ? "B" : (fieldDescriptor.equals("char") ? "C" : (fieldDescriptor.equals("double") ? "D" : (fieldDescriptor.equals("float") ? "F" : (fieldDescriptor.equals("int") ? "I" : (fieldDescriptor.equals("long") ? "J" : (fieldDescriptor.equals("short") ? "S" : "L".concat(fieldDescriptor).concat(";"))))))));
            return dimensions.concat(fieldDescriptor);
        }
        throw new IllegalArgumentException(String.valueOf(type.toString()) + " is invalid");
    }

    protected boolean isValidRequest(HttpServletRequest request) {
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"serviceClassName");
        String methodName = ParamUtil.getString((HttpServletRequest)request, (String)"serviceMethodName");
        return className.contains(".service.") && className.endsWith("ServiceUtil") && !className.endsWith("LocalServiceUtil") && !this._invalidClassNames.contains(className) && !this._invalidMethodNames.contains(methodName);
    }
}

