/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.transactional;

import com.liferay.portal.cache.transactional.TransactionalPortalCacheHelper;
import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class TransactionalPortalCache<K extends Serializable, V>
implements PortalCache<K, V> {
    protected static Serializable NULL_HOLDER = "NULL_HOLDER";
    private PortalCache<K, V> _portalCache;

    public TransactionalPortalCache(PortalCache<K, V> portalCache) {
        this._portalCache = portalCache;
    }

    public void destroy() {
    }

    public Collection<V> get(Collection<K> keys) {
        ArrayList<V> values = new ArrayList<V>(keys.size());
        for (Serializable key : keys) {
            values.add(this.get(key));
        }
        return values;
    }

    public V get(K key) {
        Object result = null;
        if (TransactionalPortalCacheHelper.isEnabled() && (result = (Object)TransactionalPortalCacheHelper.get(this._portalCache, key)) == NULL_HOLDER) {
            return null;
        }
        if (result == null) {
            result = this._portalCache.get(key);
        }
        return (V)result;
    }

    public String getName() {
        return this._portalCache.getName();
    }

    public void put(K key, V value) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (value == null) {
                TransactionalPortalCacheHelper.put(this._portalCache, key, NULL_HOLDER);
            } else {
                TransactionalPortalCacheHelper.put(this._portalCache, key, value);
            }
        } else {
            this._portalCache.put(key, value);
        }
    }

    public void put(K key, V value, int timeToLive) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            if (value == null) {
                TransactionalPortalCacheHelper.put(this._portalCache, key, NULL_HOLDER);
            } else {
                TransactionalPortalCacheHelper.put(this._portalCache, key, value);
            }
        } else {
            this._portalCache.put(key, value, timeToLive);
        }
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener) {
        this._portalCache.registerCacheListener(cacheListener);
    }

    public void registerCacheListener(CacheListener<K, V> cacheListener, CacheListenerScope cacheListenerScope) {
        this._portalCache.registerCacheListener(cacheListener, cacheListenerScope);
    }

    public void remove(K key) {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            TransactionalPortalCacheHelper.put(this._portalCache, key, NULL_HOLDER);
        } else {
            this._portalCache.remove(key);
        }
    }

    public void removeAll() {
        if (TransactionalPortalCacheHelper.isEnabled()) {
            TransactionalPortalCacheHelper.removeAll(this._portalCache);
        } else {
            this._portalCache.removeAll();
        }
    }

    public void unregisterCacheListener(CacheListener<K, V> cacheListener) {
        this._portalCache.unregisterCacheListener(cacheListener);
    }

    public void unregisterCacheListeners() {
        this._portalCache.unregisterCacheListeners();
    }
}

