/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import org.apache.commons.io.FileUtils;

public class DeployUtil {
    private static Log _log = LogFactoryUtil.getLog(DeployUtil.class);
    private static DeployUtil _instance = new DeployUtil();

    public static void copyDependencyXml(String fileName, String targetDir, String targetFileName, Map<String, String> filterMap, boolean overwrite) throws Exception {
        File file = new File(DeployUtil.getResourcePath(fileName));
        File targetFile = new File(targetDir, targetFileName);
        if (!targetFile.exists()) {
            CopyTask.copyFile((File)file, (File)new File(targetDir), (String)targetFileName, filterMap, (boolean)overwrite, (boolean)true);
        }
    }

    public static String getAutoDeployDestDir() throws Exception {
        String destDir = PrefsPropsUtil.getString("auto.deploy.dest.dir", PropsValues.AUTO_DEPLOY_DEST_DIR);
        if (Validator.isNull((String)destDir)) {
            destDir = DeployUtil.getAutoDeployServerDestDir();
        }
        FileUtil.mkdirs((String)destDir);
        return destDir;
    }

    public static String getAutoDeployServerDestDir() throws Exception {
        String destDir = null;
        String serverId = GetterUtil.getString((String)ServerDetector.getServerId());
        if (serverId.equals("jboss") && ServerDetector.isJBoss5()) {
            String name = "auto.deploy." + serverId + ".dest.dir";
            PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences(true);
            String value = PropsUtil.get(name, new Filter("5"));
            destDir = portletPreferences.getValue(name, value);
        } else {
            destDir = serverId.equals("tomcat") ? PrefsPropsUtil.getString("auto.deploy.tomcat.dest.dir", PropsValues.AUTO_DEPLOY_TOMCAT_DEST_DIR) : PrefsPropsUtil.getString("auto.deploy." + serverId + ".dest.dir");
        }
        if (Validator.isNull((String)destDir)) {
            destDir = PrefsPropsUtil.getString("auto.deploy.default.dest.dir", PropsValues.AUTO_DEPLOY_DEFAULT_DEST_DIR);
        }
        destDir = StringUtil.replace((String)destDir, (char)'\\', (char)'/');
        return destDir;
    }

    public static String getResourcePath(String resource) throws Exception {
        return _instance._getResourcePath(resource);
    }

    public static void redeployJetty(String context) throws Exception {
        String contextsDirName = String.valueOf(System.getProperty("jetty.home")) + "/contexts";
        if (DeployUtil._isPortalContext(context)) {
            throw new UnsupportedOperationException("This method is meant for redeploying plugins, not the portal");
        }
        File contextXml = new File(contextsDirName, String.valueOf(context) + ".xml");
        if (contextXml.exists()) {
            FileUtils.touch((File)contextXml);
        } else {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("context", context);
            DeployUtil.copyDependencyXml("jetty-context-configure.xml", contextXml.getParent(), contextXml.getName(), filterMap, true);
        }
    }

    public static void redeployTomcat(String context) throws Exception {
        if (DeployUtil._isPortalContext(context)) {
            throw new UnsupportedOperationException("This method is meant for redeploying plugins, not the portal");
        }
        File webXml = new File(DeployUtil.getAutoDeployDestDir(), String.valueOf(context) + "/WEB-INF/web.xml");
        FileUtils.touch((File)webXml);
    }

    public static void undeploy(String appServerType, File deployDir) throws Exception {
        boolean undeployEnabled = PrefsPropsUtil.getBoolean("hot.undeploy.enabled", PropsValues.HOT_UNDEPLOY_ENABLED);
        if (!undeployEnabled) {
            return;
        }
        if (!(appServerType.equals("glassfish") || appServerType.equals("jboss") || appServerType.equals("jetty") || appServerType.equals("tomcat") || appServerType.equals("weblogic"))) {
            return;
        }
        if (!deployDir.exists()) {
            String deployDirPath = deployDir.getAbsolutePath();
            deployDirPath = StringUtil.endsWith((String)deployDirPath, (String)".war") ? deployDirPath.substring(0, deployDirPath.length() - 4) : deployDirPath.concat(".war");
            deployDir = new File(deployDirPath);
        }
        if (!deployDir.exists()) {
            return;
        }
        if (deployDir.isFile()) {
            FileUtil.delete((File)deployDir);
        } else {
            File webXml = new File(deployDir + "/WEB-INF/web.xml");
            if (!webXml.exists()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Undeploy " + deployDir));
            }
            FileUtil.delete((String)(deployDir + "/WEB-INF/web.xml"));
            DeleteTask.deleteDirectory((File)deployDir);
        }
        if (appServerType.equals("jetty")) {
            FileUtil.delete((String)(String.valueOf(System.getProperty("jetty.home")) + "/contexts/" + deployDir.getName() + ".xml"));
        }
        if (appServerType.equals("jboss")) {
            File deployedFile = new File(deployDir.getParent(), String.valueOf(deployDir.getName()) + ".deployed");
            FileUtil.delete((File)deployedFile);
        }
        int undeployInterval = PrefsPropsUtil.getInteger("hot.undeploy.interval", PropsValues.HOT_UNDEPLOY_INTERVAL);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Wait " + undeployInterval + " ms to allow the plugin time to fully undeploy"));
        }
        if (undeployInterval > 0) {
            Thread.sleep(undeployInterval);
        }
    }

    private static boolean _isPortalContext(String context) {
        return Validator.isNull((String)context) || context.equals("/") || context.equals(PortalContextLoaderListener.getPortalServletContextPath());
    }

    private DeployUtil() {
    }

    private String _getResourcePath(String resource) throws IOException {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("dependencies/" + resource);
        if (inputStream == null) {
            return null;
        }
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File file = new File(String.valueOf(tmpDir) + "/liferay/com/liferay/portal/deploy/dependencies/" + resource);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
        return FileUtil.getAbsolutePath((File)file);
    }
}

