/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.fckeditor.receiver.impl;

import com.liferay.portal.editor.fckeditor.command.CommandArgument;
import com.liferay.portal.editor.fckeditor.exception.FCKException;
import com.liferay.portal.editor.fckeditor.receiver.CommandReceiver;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.upload.LiferayServletRequest;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseCommandReceiver
implements CommandReceiver {
    private static Log _log = LogFactoryUtil.getLog(BaseCommandReceiver.class);

    @Override
    public void createFolder(CommandArgument commandArgument, HttpServletRequest request, HttpServletResponse response) {
        String returnValue;
        Element errorElement;
        Document document;
        block5: {
            document = this._createDocument();
            Node rootNode = this._createRoot(document, commandArgument.getCommand(), commandArgument.getType(), commandArgument.getCurrentFolder(), "");
            errorElement = document.createElement("Error");
            rootNode.appendChild(errorElement);
            returnValue = "0";
            try {
                returnValue = this.createFolder(commandArgument);
            }
            catch (FCKException fcke) {
                Throwable cause = fcke.getCause();
                returnValue = "110";
                if (cause == null) break block5;
                String causeString = GetterUtil.getString((String)cause.toString());
                if (causeString.contains("DuplicateFolderNameException")) {
                    returnValue = "101";
                }
                if (causeString.contains("FolderNameException")) {
                    returnValue = "102";
                }
                if (causeString.contains("NoSuchGroupException") || causeString.contains("PrincipalException")) {
                    returnValue = "103";
                }
                throw fcke;
            }
        }
        errorElement.setAttribute("number", returnValue);
        this._writeDocument(document, response);
    }

    @Override
    public void fileUpload(CommandArgument commandArgument, HttpServletRequest request, HttpServletResponse response) {
        String returnValue;
        block25: {
            InputStream inputStream = null;
            returnValue = null;
            try {
                try {
                    LiferayFileUpload servletFileUpload = new LiferayFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl.getTempDir()), request);
                    servletFileUpload.setFileSizeMax(PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size"));
                    LiferayServletRequest liferayServletRequest = new LiferayServletRequest(request);
                    List fileItems = servletFileUpload.parseRequest((HttpServletRequest)liferayServletRequest);
                    HashMap<String, String> fields = new HashMap<String, String>();
                    for (FileItem fileItem : fileItems) {
                        if (fileItem.isFormField()) {
                            fields.put(fileItem.getFieldName(), fileItem.getString());
                            continue;
                        }
                        fields.put(fileItem.getFieldName(), (String)fileItem);
                    }
                    DiskFileItem diskFileItem = (DiskFileItem)fields.get("NewFile");
                    String fileName = StringUtil.replace((String)diskFileItem.getName(), (char)'\\', (char)'/');
                    String[] fileNameArray = StringUtil.split((String)fileName, (char)'/');
                    fileName = fileNameArray[fileNameArray.length - 1];
                    String contentType = diskFileItem.getContentType();
                    if (Validator.isNull((String)contentType) || contentType.equals("application/octet-stream")) {
                        contentType = MimeTypesUtil.getContentType((File)diskFileItem.getStoreLocation());
                    }
                    inputStream = diskFileItem.isInMemory() ? diskFileItem.getInputStream() : new ByteArrayFileInputStream(diskFileItem.getStoreLocation(), LiferayFileItem.THRESHOLD_SIZE);
                    long size = diskFileItem.getSize();
                    returnValue = this.fileUpload(commandArgument, fileName, inputStream, contentType, size);
                }
                catch (Exception e2) {
                    FCKException fcke = null;
                    fcke = e2 instanceof FCKException ? (FCKException)e2 : new FCKException(e2);
                    Throwable cause = fcke.getCause();
                    returnValue = "203";
                    if (cause != null) {
                        String causeString = GetterUtil.getString((String)cause.toString());
                        if (causeString.contains("DuplicateFileException")) {
                            returnValue = "201";
                        } else if (causeString.contains("NoSuchFolderException") || causeString.contains("NoSuchGroupException")) {
                            returnValue = "204";
                        } else if (causeString.contains("ImageNameException")) {
                            returnValue = "205";
                        } else if (causeString.contains("FileExtensionException") || causeString.contains("FileNameException")) {
                            returnValue = "206";
                        } else if (causeString.contains("PrincipalException")) {
                            returnValue = "207";
                        } else if (causeString.contains("FileSizeException") || causeString.contains("ImageSizeException") || causeString.contains("SizeLimitExceededException")) {
                            returnValue = "208";
                        } else if (causeString.contains("SystemException")) {
                            returnValue = "209";
                        } else if (causeString.contains("AssetCategoryException")) {
                            returnValue = "212";
                        } else {
                            throw fcke;
                        }
                    }
                    this._writeUploadResponse(returnValue, response);
                    StreamUtil.cleanUp(inputStream);
                    break block25;
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(inputStream);
                throw throwable;
            }
            StreamUtil.cleanUp((InputStream)inputStream);
        }
        this._writeUploadResponse(returnValue, response);
    }

    @Override
    public void getFolders(CommandArgument commandArgument, HttpServletRequest request, HttpServletResponse response) {
        Document document = this._createDocument();
        Node rootNode = this._createRoot(document, commandArgument.getCommand(), commandArgument.getType(), commandArgument.getCurrentFolder(), this.getPath(commandArgument));
        this.getFolders(commandArgument, document, rootNode);
        this._writeDocument(document, response);
    }

    @Override
    public void getFoldersAndFiles(CommandArgument commandArgument, HttpServletRequest request, HttpServletResponse response) {
        Document document = this._createDocument();
        Node rootNode = this._createRoot(document, commandArgument.getCommand(), commandArgument.getType(), commandArgument.getCurrentFolder(), this.getPath(commandArgument));
        this.getFoldersAndFiles(commandArgument, document, rootNode);
        this._writeDocument(document, response);
    }

    protected abstract String createFolder(CommandArgument var1);

    protected abstract String fileUpload(CommandArgument var1, String var2, InputStream var3, String var4, long var5);

    protected abstract void getFolders(CommandArgument var1, Document var2, Node var3);

    protected abstract void getFoldersAndFiles(CommandArgument var1, Document var2, Node var3);

    protected String getPath(CommandArgument commandArgument) {
        return "";
    }

    protected void getRootFolders(CommandArgument commandArgument, Document document, Element foldersElement) throws Exception {
        UniqueList groups = new UniqueList();
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", new Long(commandArgument.getUserId()));
        groups.addAll(GroupLocalServiceUtil.search((long)commandArgument.getCompanyId(), null, null, groupParams, (int)-1, (int)-1));
        List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)commandArgument.getUserId());
        for (Organization organization : userOrgs) {
            groups.add(0, organization.getGroup());
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            Group userGroup = GroupLocalServiceUtil.getUserGroup((long)commandArgument.getCompanyId(), (long)commandArgument.getUserId());
            groups.add(0, userGroup);
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)commandArgument.getCompanyId());
        groups.add(0, companyGroup);
        ThemeDisplay themeDisplay = commandArgument.getThemeDisplay();
        long doAsGroupId = themeDisplay.getDoAsGroupId();
        HttpServletRequest request = commandArgument.getHttpServletRequest();
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        for (Group group : groups) {
            Group stagingGroup;
            Element folderElement = document.createElement("Folder");
            foldersElement.appendChild(folderElement);
            long groupId = group.getGroupId();
            String descriptiveName = group.getDescriptiveName();
            if (group.hasStagingGroup() && (stagingGroup = group.getStagingGroup()).getGroupId() == doAsGroupId && group.isStagedPortlet(portletId) && !group.isStagedRemotely() && this.isStagedData(group)) {
                groupId = stagingGroup.getGroupId();
                descriptiveName = stagingGroup.getDescriptiveName();
            }
            folderElement.setAttribute("name", String.valueOf(groupId) + " - " + HtmlUtil.escape((String)descriptiveName));
        }
    }

    protected String getSize() {
        return this.getSize(0L);
    }

    protected String getSize(long size) {
        return String.valueOf(Math.ceil(size / 1000L));
    }

    protected boolean isStagedData(Group group) {
        return true;
    }

    private Document _createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new FCKException(pce);
        }
    }

    private Node _createRoot(Document document, String command, String resourceType, String path, String url) {
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("command", command);
        rootElement.setAttribute("resourceType", resourceType);
        Element currentFolderElement = document.createElement("CurrentFolder");
        rootElement.appendChild(currentFolderElement);
        currentFolderElement.setAttribute("path", path);
        currentFolderElement.setAttribute("url", url);
        return rootElement;
    }

    private void _writeDocument(Document document, HttpServletResponse response) {
        try {
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            if (_log.isDebugEnabled()) {
                StreamResult streamResult = new StreamResult(System.out);
                transformer.transform(domSource, streamResult);
            }
            response.setContentType("text/xml; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter printWriter = response.getWriter();
            StreamResult streamResult = new StreamResult(printWriter);
            transformer.transform(domSource, streamResult);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }

    private void _writeUploadResponse(String returnValue, HttpServletResponse response) {
        try {
            StringBundler sb = new StringBundler(7);
            String newName = "";
            sb.append("<script type=\"text/javascript\">");
            sb.append("window.parent.frames['frmUpload'].OnUploadCompleted(");
            sb.append(returnValue);
            sb.append(",'");
            sb.append(newName);
            sb.append("');");
            sb.append("</script>");
            response.setContentType("text/html; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter printWriter = null;
            printWriter = response.getWriter();
            printWriter.print(sb.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception e2) {
            throw new FCKException(e2);
        }
    }
}

