/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.alloy.util.json.StringTransformer;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONDeserializerImpl;
import com.liferay.portal.json.JSONInit;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.json.JSONSerializerImpl;
import com.liferay.portal.json.UnmodifiableJSONObjectImpl;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONSerializer;
import com.liferay.portal.json.jabsorb.serializer.LiferaySerializer;
import com.liferay.portal.json.jabsorb.serializer.LocaleSerializer;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.json.JSONTransformer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.Serializer;
import org.json.JSONML;

@DoPrivileged
public class JSONFactoryImpl
implements JSONFactory {
    private static final String _NULL_JSON = "{}";
    private static Log _log = LogFactoryUtil.getLog(JSONFactoryImpl.class);
    private org.jabsorb.JSONSerializer _jsonSerializer;
    private JSONObject _unmodifiableJSONObject = new UnmodifiableJSONObjectImpl();

    public JSONFactoryImpl() {
        JSONInit.init();
        this._jsonSerializer = new LiferayJSONSerializer();
        try {
            this._jsonSerializer.registerDefaultSerializers();
            this._jsonSerializer.registerSerializer((Serializer)new LiferaySerializer());
            this._jsonSerializer.registerSerializer((Serializer)new LocaleSerializer());
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public String convertJSONMLArrayToXML(String jsonml) {
        try {
            org.json.JSONArray jsonArray = new org.json.JSONArray(jsonml);
            return JSONML.toString((org.json.JSONArray)jsonArray);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to convert to XML", e2);
        }
    }

    public String convertJSONMLObjectToXML(String jsonml) {
        try {
            org.json.JSONObject jsonObject = new org.json.JSONObject(jsonml);
            return JSONML.toString((org.json.JSONObject)jsonObject);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to convert to XML", e2);
        }
    }

    public String convertXMLtoJSONMLArray(String xml) {
        try {
            org.json.JSONArray jsonArray = JSONML.toJSONArray((String)xml);
            return jsonArray.toString();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to convert to JSONML", e2);
        }
    }

    public String convertXMLtoJSONMLObject(String xml) {
        try {
            org.json.JSONObject jsonObject = JSONML.toJSONObject((String)xml);
            return jsonObject.toString();
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to convert to JSONML", e2);
        }
    }

    public JSONTransformer createJavaScriptNormalizerJSONTransformer(List<String> javaScriptAttributes) {
        StringTransformer stringTransformer = new StringTransformer();
        stringTransformer.setJavaScriptAttributes(javaScriptAttributes);
        return stringTransformer;
    }

    public JSONArray createJSONArray() {
        return new JSONArrayImpl();
    }

    public JSONArray createJSONArray(String json) throws JSONException {
        return new JSONArrayImpl(json);
    }

    public <T> JSONDeserializer<T> createJSONDeserializer() {
        return new JSONDeserializerImpl();
    }

    public JSONObject createJSONObject() {
        return new JSONObjectImpl();
    }

    public JSONObject createJSONObject(String json) throws JSONException {
        return new JSONObjectImpl(json);
    }

    public JSONSerializer createJSONSerializer() {
        return new JSONSerializerImpl();
    }

    public Object deserialize(JSONObject jsonObj) {
        return this.deserialize(jsonObj.toString());
    }

    public Object deserialize(String json) {
        try {
            return this._jsonSerializer.fromJSON(json);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to deserialize object", e2);
        }
    }

    public String getNullJSON() {
        return _NULL_JSON;
    }

    public JSONObject getUnmodifiableJSONObject() {
        return this._unmodifiableJSONObject;
    }

    public Object looseDeserialize(String json) {
        try {
            JSONDeserializer jsonDeserializer = this.createJSONDeserializer();
            return jsonDeserializer.deserialize(json);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to deserialize object", e2);
        }
    }

    public <T> T looseDeserialize(String json, Class<T> clazz) {
        JSONDeserializer<T> jsonDeserializer = this.createJSONDeserializer();
        jsonDeserializer.use(null, clazz);
        return (T)jsonDeserializer.deserialize(json);
    }

    public Object looseDeserializeSafe(String json) {
        try {
            JSONDeserializer jsonDeserializer = this.createJSONDeserializer();
            jsonDeserializer.safeMode(true);
            return jsonDeserializer.deserialize(json);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            throw new IllegalStateException("Unable to deserialize object", e2);
        }
    }

    public <T> T looseDeserializeSafe(String json, Class<T> clazz) {
        JSONDeserializer<T> jsonDeserializer = this.createJSONDeserializer();
        jsonDeserializer.safeMode(true);
        jsonDeserializer.use(null, clazz);
        return (T)jsonDeserializer.deserialize(json);
    }

    public String looseSerialize(Object object) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        return jsonSerializer.serialize(object);
    }

    public String looseSerialize(Object object, JSONTransformer jsonTransformer, Class<?> clazz) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.transform(jsonTransformer, new Class[]{clazz});
        return jsonSerializer.serialize(object);
    }

    public String looseSerialize(Object object, String ... includes) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.include(includes);
        return jsonSerializer.serialize(object);
    }

    public String looseSerializeDeep(Object object) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        return jsonSerializer.serializeDeep(object);
    }

    public String looseSerializeDeep(Object object, JSONTransformer jsonTransformer, Class<?> clazz) {
        JSONSerializer jsonSerializer = this.createJSONSerializer();
        jsonSerializer.transform(jsonTransformer, new Class[]{clazz});
        return jsonSerializer.serializeDeep(object);
    }

    public String serialize(Object object) {
        try {
            return this._jsonSerializer.toJSON(object);
        }
        catch (MarshallException me) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)me, (Throwable)me);
            }
            throw new IllegalStateException("Unable to serialize oject", me);
        }
    }

    public String serializeException(Exception exception) {
        JSONObject jsonObject = this.createJSONObject();
        String message = null;
        if (exception instanceof InvocationTargetException) {
            Throwable cause = exception.getCause();
            message = cause.toString();
        } else {
            message = exception.getMessage();
        }
        if (Validator.isNull((String)message)) {
            message = exception.toString();
        }
        jsonObject.put("exception", message);
        return jsonObject.toString();
    }

    public String serializeThrowable(Throwable throwable) {
        if (throwable instanceof Exception) {
            return this.serializeException((Exception)throwable);
        }
        JSONObject jsonObject = this.createJSONObject();
        String message = throwable.getMessage();
        if (Validator.isNull((String)message)) {
            message = throwable.toString();
        }
        jsonObject.put("throwable", message);
        return jsonObject.toString();
    }
}

