/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.LARFileException;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.DefaultConfigurationPortletDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelper;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.MissingReference;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ElementHandler;
import com.liferay.portal.kernel.xml.ElementProcessor;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.AlwaysCurrentUserIdStrategy;
import com.liferay.portal.lar.CurrentUserIdStrategy;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.persistence.OrganizationUtil;
import com.liferay.portal.service.persistence.SystemEventActionableDynamicQuery;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetCategoryUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class ExportImportHelperImpl
implements ExportImportHelper {
    private static final char[] _DL_REFERENCE_LEGACY_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '\"', ' '};
    private static final char[] _DL_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    private static final char[] _LAYOUT_REFERENCE_STOP_CHARS = new char[]{'\'', ']', '}', ')', '>', '<', '|', '?', '\"', ' '};
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING = String.valueOf(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING) + "/";
    private static final String _PRIVATE_USER_SERVLET_MAPPING = String.valueOf(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING) + "/";
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING = String.valueOf(PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING) + "/";
    private static Log _log = LogFactoryUtil.getLog(ExportImportHelperImpl.class);
    private Pattern _exportLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)(@([\\d]+))?\\]");
    private Pattern _importLinksToLayoutPattern = Pattern.compile("\\[([\\d]+)@(private(-group|-user)?|public)@(\\p{XDigit}{8}\\-(?:\\p{XDigit}{4}\\-){3}\\p{XDigit}{12})@([a-z0-9./_-]*)(@([\\d]+))?\\]");

    public Calendar getCalendar(PortletRequest portletRequest, String paramPrefix, boolean timeZoneSensitive) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int dateMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Month"));
        int dateDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Day"));
        int dateYear = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Year"));
        int dateHour = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Hour"));
        int dateMinute = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "Minute"));
        int dateAmPm = ParamUtil.getInteger((PortletRequest)portletRequest, (String)(String.valueOf(paramPrefix) + "AmPm"));
        if (dateAmPm == 1) {
            dateHour += 12;
        }
        Locale locale = null;
        TimeZone timeZone = null;
        if (timeZoneSensitive) {
            locale = themeDisplay.getLocale();
            timeZone = themeDisplay.getTimeZone();
        } else {
            locale = LocaleUtil.getDefault();
            timeZone = TimeZoneUtil.getTimeZone((String)"UTC");
        }
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale);
        calendar.set(2, dateMonth);
        calendar.set(5, dateDay);
        calendar.set(1, dateYear);
        calendar.set(11, dateHour);
        calendar.set(12, dateMinute);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public DateRange getDateRange(PortletRequest portletRequest, long groupId, boolean privateLayout, long plid, String portletId, String defaultRange) throws Exception {
        Date startDate = null;
        Date endDate = null;
        String range = ParamUtil.getString((PortletRequest)portletRequest, (String)"range", (String)defaultRange);
        if (range.equals("dateRange")) {
            Calendar startCalendar = this.getCalendar(portletRequest, "startDate", true);
            startDate = startCalendar.getTime();
            Calendar endCalendar = this.getCalendar(portletRequest, "endDate", true);
            endDate = endCalendar.getTime();
        } else if (range.equals("fromLastPublishDate")) {
            long lastPublishDate = 0L;
            if (Validator.isNotNull((String)portletId) && plid > 0L) {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                PortletPreferences preferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletId);
                lastPublishDate = GetterUtil.getLong((String)preferences.getValue("last-publish-date", ""));
            } else {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                lastPublishDate = GetterUtil.getLong((String)layoutSet.getSettingsProperty("last-publish-date"));
            }
            if (lastPublishDate > 0L) {
                endDate = new Date();
                startDate = new Date(lastPublishDate);
            }
        } else if (range.equals("last")) {
            int rangeLast = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"last");
            Date now = new Date();
            startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
            endDate = now;
        }
        return new DateRange(startDate, endDate);
    }

    public Layout getExportableLayout(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        long defaultPlid;
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isLayout()) {
            layout = LayoutLocalServiceUtil.getLayout((long)scopeGroup.getClassPK());
        } else if (!scopeGroup.isCompany() && (defaultPlid = LayoutLocalServiceUtil.getDefaultPlid((long)themeDisplay.getSiteGroupId())) > 0L) {
            layout = LayoutLocalServiceUtil.getLayout((long)defaultPlid);
        }
        return layout;
    }

    public String getExportableRootPortletId(long companyId, String portletId) throws Exception {
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            return null;
        }
        return PortletConstants.getRootPortletId((String)portletId);
    }

    public Map<Long, Boolean> getLayoutIdMap(PortletRequest portletRequest) throws Exception {
        LinkedHashMap<Long, Boolean> layoutIdMap = new LinkedHashMap<Long, Boolean>();
        String layoutIdsJSON = ParamUtil.getString((PortletRequest)portletRequest, (String)"layoutIds");
        if (Validator.isNull((String)layoutIdsJSON)) {
            return layoutIdMap;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)layoutIdsJSON);
        int i2 = 0;
        while (i2 < jsonArray.length()) {
            JSONObject jsonObject = jsonArray.getJSONObject(i2);
            long plid = jsonObject.getLong("plid");
            boolean includeChildren = jsonObject.getBoolean("includeChildren");
            layoutIdMap.put(plid, includeChildren);
            ++i2;
        }
        return layoutIdMap;
    }

    public long[] getLayoutIds(List<Layout> layouts) {
        long[] layoutIds = new long[layouts.size()];
        int i2 = 0;
        while (i2 < layouts.size()) {
            Layout layout = layouts.get(i2);
            layoutIds[i2] = layout.getLayoutId();
            ++i2;
        }
        return layoutIds;
    }

    public ManifestSummary getManifestSummary(long userId, long groupId, Map<String, String[]> parameterMap, File file) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)group.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)this.getUserIdStrategy(userId, userIdStrategy), (ZipReader)zipReader);
        ManifestSummary manifestSummary = new ManifestSummary();
        SAXParser saxParser = new SAXParser();
        ElementHandler elementHandler = new ElementHandler((ElementProcessor)new ManifestSummaryElementProcessor(group, manifestSummary), new String[]{"header", "portlet", "staged-model"});
        saxParser.setContentHandler((ContentHandler)elementHandler);
        InputStream is = portletDataContext.getZipEntryAsInputStream("/manifest.xml");
        if (is == null) {
            throw new LARFileException("manifest.xml is not in the LAR");
        }
        String manifestXMLContent = StringUtil.read((InputStream)is);
        saxParser.parse(new InputSource(new StringReader(manifestXMLContent)));
        return manifestSummary;
    }

    public ManifestSummary getManifestSummary(long userId, long groupId, Map<String, String[]> parameterMap, FileEntry fileEntry) throws Exception {
        File file = FileUtil.createTempFile((String)"lar");
        InputStream inputStream = DLFileEntryLocalServiceUtil.getFileAsStream((long)userId, (long)fileEntry.getFileEntryId(), (String)fileEntry.getVersion(), (boolean)false);
        ManifestSummary manifestSummary = null;
        try {
            FileUtil.write((File)file, (InputStream)inputStream);
            manifestSummary = this.getManifestSummary(userId, groupId, parameterMap, file);
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
            FileUtil.delete((File)file);
        }
        return manifestSummary;
    }

    public long getModelDeletionCount(final PortletDataContext portletDataContext, final StagedModelType stagedModelType) throws PortalException, SystemException {
        SystemEventActionableDynamicQuery actionableDynamicQuery = new SystemEventActionableDynamicQuery(){

            protected void addCreateDateProperty(DynamicQuery dynamicQuery) {
                if (!portletDataContext.hasDateRange()) {
                    return;
                }
                Property createDateProperty = PropertyFactoryUtil.forName((String)"createDate");
                Date startDate = portletDataContext.getStartDate();
                dynamicQuery.add(createDateProperty.ge((Object)startDate));
                Date endDate = portletDataContext.getEndDate();
                dynamicQuery.add(createDateProperty.le((Object)endDate));
            }

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
                Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
                disjunction.add(groupIdProperty.eq((Object)0L));
                disjunction.add(groupIdProperty.eq((Object)portletDataContext.getScopeGroupId()));
                dynamicQuery.add((Criterion)disjunction);
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getClassNameId()));
                if (stagedModelType.getReferrerClassNameId() >= 0L) {
                    Property referrerClassNameIdProperty = PropertyFactoryUtil.forName((String)"referrerClassNameId");
                    dynamicQuery.add(referrerClassNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                }
                Property typeProperty = PropertyFactoryUtil.forName((String)"type");
                dynamicQuery.add(typeProperty.eq((Object)1));
                this.addCreateDateProperty(dynamicQuery);
            }

            protected void performAction(Object object) {
            }
        };
        actionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        return actionableDynamicQuery.performCount();
    }

    public String getSelectedLayoutsJSON(long groupId, boolean privateLayout, String selectedNodes) throws SystemException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)0L);
        for (Layout layout : layouts) {
            this.populateLayoutsJSON(jsonArray, layout, StringUtil.split((String)selectedNodes, (long)0L));
        }
        return jsonArray.toString();
    }

    public FileEntry getTempFileEntry(long groupId, long userId, String folderName) throws PortalException, SystemException {
        String[] tempFileEntryNames = LayoutServiceUtil.getTempFileEntryNames((long)groupId, (String)folderName);
        if (tempFileEntryNames.length == 0) {
            return null;
        }
        return TempFileUtil.getTempFile((long)groupId, (long)userId, (String)tempFileEntryNames[0], (String)folderName);
    }

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        content = ExportImportHelperUtil.replaceExportDLReferences((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (Element)entityElement, (String)content, (boolean)exportReferencedContent);
        content = ExportImportHelperUtil.replaceExportLayoutReferences((PortletDataContext)portletDataContext, (String)content, (boolean)exportReferencedContent);
        content = ExportImportHelperUtil.replaceExportLinksToLayouts((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (Element)entityElement, (String)content, (boolean)exportReferencedContent);
        Element groupElement = entityElement.getParent();
        String groupElementName = groupElement.getName();
        if (!groupElementName.equals(JournalArticle.class.getSimpleName())) {
            content = StringUtil.replace((String)content, (String)"&amp;", (String)"&");
        }
        return content;
    }

    public String replaceExportDLReferences(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("20")) {
            return content;
        }
        StringBuilder sb = new StringBuilder(content);
        String contextPath = PortalUtil.getPathContext();
        String[] patterns = new String[]{contextPath.concat("/c/document_library/get_file?"), contextPath.concat("/documents/"), contextPath.concat("/image/image_gallery?")};
        int beginPos = -1;
        int endPos = content.length();
        while ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) != -1) {
            block9: {
                Map<String, String[]> dlReferenceParameters = this.getDLReferenceParameters(portletDataContext, content, beginPos + contextPath.length(), endPos);
                FileEntry fileEntry = this.getFileEntry(dlReferenceParameters);
                if (fileEntry == null) {
                    endPos = beginPos - 1;
                    continue;
                }
                endPos = MapUtil.getInteger(dlReferenceParameters, (String)"endPos");
                try {
                    if (exportReferencedContent) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (StagedModel)fileEntry, (String)"dependency");
                    } else {
                        portletDataContext.addReferenceElement((ClassedModel)entityStagedModel, entityElement, (ClassedModel)fileEntry, "dependency", true);
                    }
                    String path = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
                    sb.replace(beginPos, endPos, "[$dl-reference=" + path + "$]");
                    this.deleteTimestampParameters(sb, beginPos);
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    if (!_log.isWarnEnabled()) break block9;
                    StringBundler exceptionSB = new StringBundler(6);
                    exceptionSB.append("Unable to process file entry ");
                    exceptionSB.append(fileEntry.getFileEntryId());
                    exceptionSB.append(" for ");
                    exceptionSB.append(entityStagedModel.getModelClassName());
                    exceptionSB.append(" with primary key ");
                    exceptionSB.append((Object)entityStagedModel.getPrimaryKeyObj());
                    _log.warn((Object)exceptionSB.toString());
                }
            }
            endPos = beginPos - 1;
        }
        return sb.toString();
    }

    public String replaceExportLayoutReferences(PortletDataContext portletDataContext, String content, boolean exportReferencedContent) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        StringBuilder sb = new StringBuilder(content);
        String[] patterns = new String[]{"href=", "[["};
        int beginPos = -1;
        int endPos = content.length();
        int offset = 0;
        while (true) {
            if (beginPos > -1) {
                endPos = beginPos - 1;
            }
            if ((beginPos = StringUtil.lastIndexOfAny((String)content, (String[])patterns, (int)endPos)) == -1) break;
            if (content.startsWith("href=", beginPos)) {
                offset = 5;
                char c2 = content.charAt(beginPos + offset);
                if (c2 == '\'' || c2 == '\"') {
                    ++offset;
                }
            } else if (content.charAt(beginPos) == '[') {
                offset = 2;
            }
            if ((endPos = StringUtil.indexOfAny((String)content, (char[])_LAYOUT_REFERENCE_STOP_CHARS, (int)(beginPos + offset), (int)endPos)) == -1) continue;
            String url = content.substring(beginPos + offset, endPos);
            StringBundler urlSB = new StringBundler(5);
            try {
                if (!(url = this.replaceExportHostname(portletDataContext, url, urlSB)).startsWith("/")) continue;
                String pathContext = PortalUtil.getPathContext();
                if (pathContext.length() > 1) {
                    if (!url.startsWith(pathContext)) continue;
                    urlSB.append("@data_handler_path_context@");
                    url = url.substring(pathContext.length());
                    return url;
                }
            }
            finally {
                if (urlSB.length() > 0) {
                    urlSB.append(url);
                    url = urlSB.toString();
                }
                sb.replace(beginPos + offset, endPos, url);
                continue;
            }
            break;
        }
        return sb.toString();
    }

    public String replaceExportLinksToLayouts(PortletDataContext portletDataContext, StagedModel entityStagedModel, Element entityElement, String content, boolean exportReferencedContent) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = this._exportLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            long layoutId = GetterUtil.getLong((String)matcher.group(1));
            String type = matcher.group(2);
            boolean privateLayout = type.startsWith("private");
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (long)layoutId);
                String oldLinkToLayout = matcher.group(0);
                StringBundler sb = new StringBundler(5);
                sb.append(type);
                sb.append("@");
                sb.append(layout.getUuid());
                sb.append("@");
                sb.append(layout.getFriendlyURL());
                String newLinkToLayout = StringUtil.replace((String)oldLinkToLayout, (String)type, (String)sb.toString());
                oldLinksToLayout.add(oldLinkToLayout);
                newLinksToLayout.add(newLinkToLayout);
                if (exportReferencedContent) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, (StagedModel)layout, (String)"dependency");
                    continue;
                }
                portletDataContext.addReferenceElement((ClassedModel)entityStagedModel, entityElement, (ClassedModel)layout, "dependency", true);
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) continue;
                String message = "Unable to get layout with ID " + layoutId + " in group " + portletDataContext.getScopeGroupId();
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)message);
                    continue;
                }
                _log.debug((Object)message, (Throwable)e2);
            }
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, Element entityElement, String content, boolean importReferencedContent) throws Exception {
        content = ExportImportHelperUtil.replaceImportDLReferences((PortletDataContext)portletDataContext, (Element)entityElement, (String)content, (boolean)importReferencedContent);
        content = ExportImportHelperUtil.replaceImportLayoutReferences((PortletDataContext)portletDataContext, (String)content, (boolean)importReferencedContent);
        content = ExportImportHelperUtil.replaceImportLinksToLayouts((PortletDataContext)portletDataContext, (String)content, (boolean)importReferencedContent);
        return content;
    }

    public String replaceImportDLReferences(PortletDataContext portletDataContext, Element entityElement, String content, boolean importReferencedContent) throws Exception {
        String elementPath = entityElement.attributeValue("path");
        StagedModel entityStagedModel = (StagedModel)portletDataContext.getZipEntryAsObject(entityElement, elementPath);
        List referenceElements = portletDataContext.getReferenceElements(entityStagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            long groupId;
            String path;
            block9: {
                long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
                Element referenceDataElement = portletDataContext.getReferenceDataElement(entityStagedModel, DLFileEntry.class, classPK);
                path = null;
                if (referenceDataElement != null) {
                    path = referenceDataElement.attributeValue("path");
                }
                groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                if (Validator.isNull((String)path)) {
                    String className = referenceElement.attributeValue("class-name");
                    path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (long)classPK);
                }
                if (!content.contains("[$dl-reference=" + path + "$]")) continue;
                try {
                    StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)entityStagedModel, DLFileEntry.class, (long)classPK);
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    if (!_log.isWarnEnabled()) break block9;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to process file entry ");
                    sb.append(classPK);
                    sb.append(" for ");
                    sb.append(entityStagedModel.getModelClassName());
                    sb.append(" with primary key ");
                    sb.append((Object)entityStagedModel.getPrimaryKeyObj());
                    _log.warn((Object)sb.toString());
                }
            }
            String uuid = referenceElement.attributeValue("uuid");
            long importGroupId = groupId;
            if (groupId == portletDataContext.getSourceCompanyGroupId()) {
                importGroupId = portletDataContext.getCompanyGroupId();
            } else if (groupId == portletDataContext.getSourceGroupId()) {
                importGroupId = portletDataContext.getGroupId();
            }
            FileEntry importedFileEntry = FileEntryUtil.fetchByUUID_R(uuid, importGroupId);
            if (importedFileEntry == null) continue;
            String url = DLUtil.getPreviewURL((FileEntry)importedFileEntry, (FileVersion)importedFileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)false);
            content = StringUtil.replace((String)content, (String)("[$dl-reference=" + path + "$]"), (String)url);
        }
        return content;
    }

    public String replaceImportLayoutReferences(PortletDataContext portletDataContext, String content, boolean importReferencedContent) throws Exception {
        String companyPortalURL = "";
        String privateLayoutSetPortalURL = "";
        String publicLayoutSetPortalURL = "";
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        int portalPort = PortalUtil.getPortalPort((boolean)false);
        if (portalPort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companyPortalURL = PortalUtil.getPortalURL((String)company.getVirtualHostname(), (int)portalPort, (boolean)false);
            }
            if (Validator.isNotNull((String)privateLayoutSet.getVirtualHostname())) {
                privateLayoutSetPortalURL = PortalUtil.getPortalURL((String)privateLayoutSet.getVirtualHostname(), (int)portalPort, (boolean)false);
            }
            if (Validator.isNotNull((String)publicLayoutSet.getVirtualHostname())) {
                publicLayoutSetPortalURL = PortalUtil.getPortalURL((String)publicLayoutSet.getVirtualHostname(), (int)portalPort, (boolean)false);
            }
        }
        int securePortalPort = PortalUtil.getPortalPort((boolean)true);
        String companySecurePortalURL = "";
        String privateLayoutSetSecurePortalURL = "";
        String publicLayoutSetSecurePortalURL = "";
        if (securePortalPort != -1) {
            if (Validator.isNotNull((String)company.getVirtualHostname())) {
                companySecurePortalURL = PortalUtil.getPortalURL((String)company.getVirtualHostname(), (int)securePortalPort, (boolean)true);
            }
            if (Validator.isNotNull((String)privateLayoutSet.getVirtualHostname())) {
                privateLayoutSetSecurePortalURL = PortalUtil.getPortalURL((String)privateLayoutSet.getVirtualHostname(), (int)securePortalPort, (boolean)true);
            }
            if (Validator.isNotNull((String)publicLayoutSet.getVirtualHostname())) {
                publicLayoutSetSecurePortalURL = PortalUtil.getPortalURL((String)publicLayoutSet.getVirtualHostname(), (int)securePortalPort, (boolean)true);
            }
        }
        content = StringUtil.replace((String)content, (String)"@data_handler_company_secure_url@", (String)companySecurePortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_company_url@", (String)companyPortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_group_friendly_url@", (String)group.getFriendlyURL());
        content = StringUtil.replace((String)content, (String)"@data_handler_path_context@", (String)PortalUtil.getPathContext());
        content = StringUtil.replace((String)content, (String)"@data_handler_private_group_servlet_mapping@", (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)"@data_handler_private_layout_set_secure_url@", (String)privateLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_private_layout_set_url@", (String)privateLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_private_user_servlet_mapping@", (String)PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
        content = StringUtil.replace((String)content, (String)"@data_handler_public_layout_set_secure_url@", (String)publicLayoutSetSecurePortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_public_layout_set_url@", (String)publicLayoutSetPortalURL);
        content = StringUtil.replace((String)content, (String)"@data_handler_public_servlet_mapping@", (String)PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING);
        return content;
    }

    public String replaceImportLinksToLayouts(PortletDataContext portletDataContext, String content, boolean importReferencedContent) throws Exception {
        ArrayList<String> oldLinksToLayout = new ArrayList<String>();
        ArrayList<String> newLinksToLayout = new ArrayList<String>();
        Matcher matcher = this._importLinksToLayoutPattern.matcher(content);
        while (matcher.find()) {
            StringBundler sb;
            String friendlyURL;
            String layoutUuid;
            long newLayoutId;
            long oldLayoutId;
            long newGroupId;
            long oldGroupId;
            block9: {
                newGroupId = oldGroupId = GetterUtil.getLong((String)matcher.group(7));
                newLayoutId = oldLayoutId = GetterUtil.getLong((String)matcher.group(1));
                String type = matcher.group(2);
                boolean privateLayout = type.startsWith("private");
                layoutUuid = matcher.group(4);
                friendlyURL = matcher.group(5);
                try {
                    Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)portletDataContext.getScopeGroupId(), (boolean)privateLayout);
                    if (layout == null) {
                        layout = LayoutLocalServiceUtil.fetchLayoutByFriendlyURL((long)portletDataContext.getScopeGroupId(), (boolean)privateLayout, (String)friendlyURL);
                    }
                    if (layout == null) {
                        if (_log.isWarnEnabled()) {
                            sb = new StringBundler(9);
                            sb.append("Unable to get layout with UUID ");
                            sb.append(layoutUuid);
                            sb.append(", friendly URL ");
                            sb.append(friendlyURL);
                            sb.append(", or ");
                            sb.append("layout ID ");
                            sb.append(oldLayoutId);
                            sb.append(" in group ");
                            sb.append(portletDataContext.getScopeGroupId());
                            _log.warn((Object)sb.toString());
                        }
                    } else {
                        newGroupId = layout.getGroupId();
                        newLayoutId = layout.getLayoutId();
                    }
                }
                catch (SystemException se) {
                    if (!_log.isDebugEnabled() && !_log.isWarnEnabled()) break block9;
                    String message = "Unable to get layout in group " + portletDataContext.getScopeGroupId();
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)message);
                    }
                    _log.debug((Object)message, (Throwable)se);
                }
            }
            String oldLinkToLayout = matcher.group(0);
            sb = new StringBundler(4);
            sb.append("@");
            sb.append(layoutUuid);
            sb.append("@");
            sb.append(friendlyURL);
            String newLinkToLayout = StringUtil.replaceFirst((String)oldLinkToLayout, (String[])new String[]{sb.toString(), String.valueOf(oldLayoutId)}, (String[])new String[]{"", String.valueOf(newLayoutId)});
            if (oldGroupId != 0L && oldGroupId != newGroupId) {
                newLinkToLayout = StringUtil.replaceLast((String)newLinkToLayout, (String)String.valueOf(oldGroupId), (String)String.valueOf(newGroupId));
            }
            oldLinksToLayout.add(oldLinkToLayout);
            newLinksToLayout.add(newLinkToLayout);
        }
        content = StringUtil.replace((String)content, (String[])ArrayUtil.toStringArray((Object[])oldLinksToLayout.toArray()), (String[])ArrayUtil.toStringArray((Object[])newLinksToLayout.toArray()));
        return content;
    }

    public void updateExportPortletPreferencesClassPKs(PortletDataContext portletDataContext, Portlet portlet, PortletPreferences portletPreferences, String key, String className, Element rootElement) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String[] primaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i2];
            String[] stringArray = primaryKeys = StringUtil.split((String)oldValue);
            int n = primaryKeys.length;
            int n2 = 0;
            while (n2 < n) {
                Organization organization;
                String primaryKey = stringArray[n2];
                if (!Validator.isNumber((String)primaryKey)) break;
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                String uuid = null;
                if (className.equals(AssetCategory.class.getName())) {
                    AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchCategory((long)primaryKeyLong);
                    if (assetCategory != null) {
                        uuid = assetCategory.getUuid();
                        portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)assetCategory, AssetCategory.class, "dependency", true);
                    }
                } else if (className.equals(AssetVocabulary.class.getName())) {
                    AssetVocabulary assetVocabulary = AssetVocabularyLocalServiceUtil.fetchAssetVocabulary((long)primaryKeyLong);
                    if (assetVocabulary != null) {
                        uuid = assetVocabulary.getUuid();
                        portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)assetVocabulary, AssetVocabulary.class, "dependency", true);
                    }
                } else if (className.equals(DDMStructure.class.getName())) {
                    DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)primaryKeyLong);
                    if (ddmStructure != null) {
                        uuid = ddmStructure.getUuid();
                        portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)ddmStructure, DDMStructure.class, "dependency", true);
                    }
                } else if (className.equals(DLFileEntryType.class.getName())) {
                    DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)primaryKeyLong);
                    if (dlFileEntryType != null) {
                        uuid = dlFileEntryType.getUuid();
                        portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)dlFileEntryType, DLFileEntryType.class, "dependency", true);
                    }
                } else if (className.equals(Organization.class.getName()) && (organization = OrganizationLocalServiceUtil.fetchOrganization((long)primaryKeyLong)) != null) {
                    uuid = organization.getUuid();
                    portletDataContext.addReferenceElement((ClassedModel)portlet, rootElement, (ClassedModel)organization, Organization.class, "dependency", true);
                }
                if (Validator.isNull(uuid)) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get UUID for class " + className + " with primary key " + primaryKeyLong));
                    }
                } else {
                    newValue = StringUtil.replace((String)newValue, (String)primaryKey, (String)uuid);
                }
                ++n2;
            }
            newValues[i2] = newValue;
            ++i2;
        }
        portletPreferences.setValues(key, newValues);
    }

    public void updateImportPortletPreferencesClassPKs(PortletDataContext portletDataContext, PortletPreferences portletPreferences, String key, Class<?> clazz, long companyGroupId) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(clazz);
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String[] uuids;
            String oldValue;
            String newValue = oldValue = oldValues[i2];
            String[] stringArray = uuids = StringUtil.split((String)oldValue);
            int n = uuids.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid = stringArray[n2];
                Long newPrimaryKey = null;
                if (Validator.isNumber((String)uuid)) {
                    long oldPrimaryKey = GetterUtil.getLong((String)uuid);
                    newPrimaryKey = MapUtil.getLong((Map)primaryKeys, (long)oldPrimaryKey, (long)oldPrimaryKey);
                } else {
                    Organization organization;
                    String className = clazz.getName();
                    if (className.equals(AssetCategory.class.getName())) {
                        AssetCategory assetCategory = AssetCategoryUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (assetCategory == null) {
                            assetCategory = AssetCategoryUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (assetCategory != null) {
                            newPrimaryKey = assetCategory.getCategoryId();
                        }
                    } else if (className.equals(AssetVocabulary.class.getName())) {
                        AssetVocabulary assetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (assetVocabulary == null) {
                            assetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (assetVocabulary != null) {
                            newPrimaryKey = assetVocabulary.getVocabularyId();
                        }
                    } else if (className.equals(DDMStructure.class.getName())) {
                        DDMStructure ddmStructure = DDMStructureUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (ddmStructure == null) {
                            ddmStructure = DDMStructureUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (ddmStructure != null) {
                            newPrimaryKey = ddmStructure.getStructureId();
                        }
                    } else if (className.equals(DLFileEntryType.class.getName())) {
                        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)uuid, (long)portletDataContext.getScopeGroupId());
                        if (dlFileEntryType == null) {
                            dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)uuid, (long)companyGroupId);
                        }
                        if (dlFileEntryType != null) {
                            newPrimaryKey = dlFileEntryType.getFileEntryTypeId();
                        }
                    } else if (className.equals(Organization.class.getName()) && (organization = OrganizationUtil.fetchByUuid_C_First((String)uuid, (long)portletDataContext.getCompanyId(), null)) != null) {
                        newPrimaryKey = organization.getOrganizationId();
                    }
                }
                if (Validator.isNull((Long)newPrimaryKey)) {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(8);
                        sb.append("Unable to get primary key for ");
                        sb.append(clazz);
                        sb.append(" with UUID ");
                        sb.append(uuid);
                        sb.append(" in company group ");
                        sb.append(companyGroupId);
                        sb.append(" or in group ");
                        sb.append(portletDataContext.getScopeGroupId());
                        _log.warn((Object)sb.toString());
                    }
                } else {
                    newValue = StringUtil.replace((String)newValue, (String)uuid, (String)newPrimaryKey.toString());
                }
                ++n2;
            }
            newValues[i2] = newValue;
            ++i2;
        }
        portletPreferences.setValues(key, newValues);
    }

    public MissingReferences validateMissingReferences(long userId, long groupId, Map<String, String[]> parameterMap, File file) throws Exception {
        final MissingReferences missingReferences = new MissingReferences();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        final PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createImportPortletDataContext((long)group.getCompanyId(), (long)groupId, parameterMap, (UserIdStrategy)this.getUserIdStrategy(userId, userIdStrategy), (ZipReader)zipReader);
        SAXParser saxParser = new SAXParser();
        ElementHandler elementHandler = new ElementHandler(new ElementProcessor(){

            public void processElement(Element element) {
                MissingReference missingReference = ExportImportHelperImpl.this.validateMissingReference(portletDataContext, element);
                if (missingReference != null) {
                    missingReferences.add(missingReference);
                }
            }
        }, new String[]{"missing-reference"});
        saxParser.setContentHandler((ContentHandler)elementHandler);
        saxParser.parse(new InputSource(portletDataContext.getZipEntryAsInputStream("/manifest.xml")));
        return missingReferences;
    }

    public void writeManifestSummary(Document document, ManifestSummary manifestSummary) {
        Element rootElement = document.getRootElement();
        Element manifestSummaryElement = rootElement.addElement("manifest-summary");
        for (String manifestSummaryKey : manifestSummary.getManifestSummaryKeys()) {
            long modelDeletionCount;
            Element element = manifestSummaryElement.addElement("staged-model");
            element.addAttribute("manifest-summary-key", manifestSummaryKey);
            long modelAdditionCount = manifestSummary.getModelAdditionCount(manifestSummaryKey);
            if (modelAdditionCount > 0L) {
                element.addAttribute("addition-count", String.valueOf(modelAdditionCount));
            }
            if ((modelDeletionCount = manifestSummary.getModelDeletionCount(manifestSummaryKey)) <= 0L) continue;
            element.addAttribute("deletion-count", String.valueOf(modelDeletionCount));
        }
    }

    protected void deleteTimestampParameters(StringBuilder sb, int beginPos) {
        if ((beginPos = sb.indexOf("]", beginPos)) == -1 || beginPos == sb.length() - 1 || sb.charAt(beginPos + 1) != '?') {
            return;
        }
        int endPos = StringUtil.indexOfAny((String)sb.toString(), (char[])_DL_REFERENCE_LEGACY_STOP_CHARS, (int)(beginPos + 2));
        if (endPos == -1) {
            return;
        }
        String urlParams = sb.substring(beginPos + 1, endPos);
        urlParams = HttpUtil.removeParameter((String)urlParams, (String)"t");
        sb.replace(beginPos + 1, endPos, urlParams);
    }

    protected Map<String, String[]> getDLReferenceParameters(PortletDataContext portletDataContext, String content, int beginPos, int endPos) {
        boolean legacyURL = true;
        char[] stopChars = _DL_REFERENCE_LEGACY_STOP_CHARS;
        if (content.startsWith("/documents/", beginPos)) {
            legacyURL = false;
            stopChars = _DL_REFERENCE_STOP_CHARS;
        }
        if ((endPos = StringUtil.indexOfAny((String)content, (char[])stopChars, (int)beginPos, (int)endPos)) == -1) {
            return null;
        }
        Map<String, String[]> map = new HashMap<String, String[]>();
        String dlReference = content.substring(beginPos, endPos);
        while (dlReference.contains("&amp;")) {
            dlReference = dlReference.replace("&amp;", "&");
        }
        if (!legacyURL) {
            String[] pathArray = dlReference.split("/");
            map.put("groupId", new String[]{pathArray[2]});
            if (pathArray.length == 4) {
                map.put("uuid", new String[]{pathArray[3]});
            } else if (pathArray.length == 5) {
                map.put("folderId", new String[]{pathArray[3]});
                map.put("title", new String[]{HttpUtil.decodeURL((String)pathArray[4])});
            } else if (pathArray.length > 5) {
                map.put("uuid", new String[]{pathArray[5]});
            }
        } else {
            map = HttpUtil.parameterMapFromString((String)(dlReference = dlReference.substring(dlReference.indexOf(63) + 1)));
            if (map.containsKey("img_id")) {
                map.put("image_id", (String[])map.get("img_id"));
            } else if (map.containsKey("i_id")) {
                map.put("image_id", (String[])map.get("i_id"));
            }
        }
        map.put("endPos", new String[]{String.valueOf(endPos)});
        String groupIdString = MapUtil.getString(map, (String)"groupId");
        if (groupIdString.equals("@group_id@")) {
            groupIdString = String.valueOf(portletDataContext.getScopeGroupId());
            map.put("groupId", new String[]{groupIdString});
        }
        return map;
    }

    protected FileEntry getFileEntry(Map<String, String[]> map) {
        FileEntry fileEntry;
        block12: {
            if (map == null) {
                return null;
            }
            fileEntry = null;
            try {
                DLFileEntry dlFileEntry;
                String uuid = MapUtil.getString(map, (String)"uuid");
                long groupId = MapUtil.getLong(map, (String)"groupId");
                if (Validator.isNotNull((String)uuid)) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                } else if (map.containsKey("folderId")) {
                    long folderId = MapUtil.getLong(map, (String)"folderId");
                    String name = MapUtil.getString(map, (String)"name");
                    String title = MapUtil.getString(map, (String)"title");
                    if (Validator.isNotNull((String)title)) {
                        fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
                    } else {
                        DLFileEntry dlFileEntry2 = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                        if (dlFileEntry2 != null) {
                            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry2.getFileEntryId());
                        }
                    }
                } else if (map.containsKey("image_id") && (dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)MapUtil.getLong(map, (String)"image_id"))) != null) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntry.getFileEntryId());
                }
            }
            catch (Exception e2) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e2, (Throwable)e2);
                }
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)e2.getMessage());
            }
        }
        return fileEntry;
    }

    protected UserIdStrategy getUserIdStrategy(long userId, String userIdStrategy) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        if ("ALWAYS_CURRENT_USER_ID".equals(userIdStrategy)) {
            return new AlwaysCurrentUserIdStrategy(user);
        }
        return new CurrentUserIdStrategy(user);
    }

    protected boolean populateLayoutsJSON(JSONArray layoutsJSONArray, Layout layout, long[] selectedLayoutIds) throws SystemException {
        boolean checked;
        List childLayouts = layout.getChildren();
        JSONArray childLayoutsJSONArray = null;
        boolean includeChildren = true;
        if (!childLayouts.isEmpty()) {
            childLayoutsJSONArray = JSONFactoryUtil.createJSONArray();
            for (Layout childLayout : childLayouts) {
                if (this.populateLayoutsJSON(childLayoutsJSONArray, childLayout, selectedLayoutIds)) continue;
                includeChildren = false;
            }
        }
        if (checked = ArrayUtil.contains((long[])selectedLayoutIds, (long)layout.getLayoutId())) {
            JSONObject layoutJSONObject = JSONFactoryUtil.createJSONObject();
            layoutJSONObject.put("includeChildren", includeChildren);
            layoutJSONObject.put("plid", layout.getPlid());
            layoutsJSONArray.put(layoutJSONObject);
        }
        if (checked && includeChildren) {
            return true;
        }
        if (childLayoutsJSONArray != null) {
            int i2 = 0;
            while (i2 < childLayoutsJSONArray.length()) {
                layoutsJSONArray.put(childLayoutsJSONArray.getJSONObject(i2));
                ++i2;
            }
        }
        return false;
    }

    protected String replaceExportHostname(PortletDataContext portletDataContext, String url, StringBundler urlSB) throws PortalException, SystemException {
        if (!HttpUtil.hasProtocol((String)url)) {
            return url;
        }
        boolean secure = HttpUtil.isSecure((String)url);
        int portalPort = PortalUtil.getPortalPort((boolean)secure);
        if (portalPort == -1) {
            return url;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)portletDataContext.getScopeGroupId());
        LayoutSet publicLayoutSet = group.getPublicLayoutSet();
        String publicLayoutSetVirtualHostname = publicLayoutSet.getVirtualHostname();
        String portalUrl = "";
        if (Validator.isNotNull((String)publicLayoutSetVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)publicLayoutSetVirtualHostname, (int)portalPort, (boolean)secure))) {
            if (secure) {
                urlSB.append("@data_handler_public_layout_set_secure_url@");
            } else {
                urlSB.append("@data_handler_public_layout_set_url@");
            }
            return url.substring(portalUrl.length());
        }
        LayoutSet privateLayoutSet = group.getPrivateLayoutSet();
        String privateLayoutSetVirtualHostname = privateLayoutSet.getVirtualHostname();
        if (Validator.isNotNull((String)privateLayoutSetVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)privateLayoutSetVirtualHostname, (int)portalPort, (boolean)secure))) {
            if (secure) {
                urlSB.append("@data_handler_private_layout_set_secure_url@");
            } else {
                urlSB.append("@data_handler_private_layout_set_url@");
            }
            return url.substring(portalUrl.length());
        }
        Company company = CompanyLocalServiceUtil.getCompany((long)group.getCompanyId());
        String companyVirtualHostname = company.getVirtualHostname();
        if (Validator.isNotNull((String)companyVirtualHostname) && url.startsWith(portalUrl = PortalUtil.getPortalURL((String)companyVirtualHostname, (int)portalPort, (boolean)secure))) {
            if (secure) {
                urlSB.append("@data_handler_company_secure_url@");
            } else {
                urlSB.append("@data_handler_company_url@");
            }
            return url.substring(portalUrl.length());
        }
        portalUrl = PortalUtil.getPortalURL((String)"localhost", (int)portalPort, (boolean)secure);
        if (url.startsWith(portalUrl)) {
            return url.substring(portalUrl.length());
        }
        return url;
    }

    protected MissingReference validateMissingReference(PortletDataContext portletDataContext, Element element) {
        String className = element.attributeValue("class-name");
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)className);
        if (!stagedModelDataHandler.validateReference(portletDataContext, element)) {
            MissingReference missingReference = new MissingReference(element);
            Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
            long groupId = MapUtil.getLong((Map)groupIds, (long)GetterUtil.getLong((String)element.attributeValue("group-id")));
            missingReference.setGroupId(groupId);
            return missingReference;
        }
        return null;
    }

    private class ManifestSummaryElementProcessor
    implements ElementProcessor {
        private Group _group;
        private ManifestSummary _manifestSummary;

        public ManifestSummaryElementProcessor(Group group, ManifestSummary manifestSummary) {
            this._group = group;
            this._manifestSummary = manifestSummary;
        }

        public void processElement(Element element) {
            String elementName = element.getName();
            if (elementName.equals("header")) {
                String exportDateString = element.attributeValue("export-date");
                Date exportDate = GetterUtil.getDate((String)exportDateString, (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z"));
                this._manifestSummary.setExportDate(exportDate);
            } else if (elementName.equals("portlet")) {
                String portletId = element.attributeValue("portlet-id");
                Portlet portlet = null;
                try {
                    portlet = PortletLocalServiceUtil.getPortletById((long)this._group.getCompanyId(), (String)portletId);
                }
                catch (Exception exception) {
                    return;
                }
                PortletDataHandler portletDataHandler = portlet.getPortletDataHandlerInstance();
                if (portletDataHandler == null) {
                    return;
                }
                String[] configurationPortletOptions = StringUtil.split((String)element.attributeValue("portlet-configuration"));
                Object[] portletDataHandlerControls = portletDataHandler.getImportConfigurationControls(configurationPortletOptions);
                if (ArrayUtil.isNotEmpty((Object[])portletDataHandlerControls)) {
                    this._manifestSummary.addConfigurationPortlet(portlet, configurationPortletOptions);
                }
                if (!(portletDataHandler instanceof DefaultConfigurationPortletDataHandler) && portletDataHandler.isDataSiteLevel() && GetterUtil.getBoolean((String)element.attributeValue("portlet-data"))) {
                    this._manifestSummary.addDataPortlet(portlet);
                }
            } else if (elementName.equals("staged-model")) {
                String manifestSummaryKey = element.attributeValue("manifest-summary-key");
                long modelAdditionCount = GetterUtil.getLong((String)element.attributeValue("addition-count"));
                this._manifestSummary.addModelAdditionCount(manifestSummaryKey, modelAdditionCount);
                long modelDeletionCount = GetterUtil.getLong((String)element.attributeValue("deletion-count"));
                this._manifestSummary.addModelDeletionCount(manifestSummaryKey, modelDeletionCount);
            }
        }
    }
}

