/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchTeamException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportClassedModelUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextListener;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PrimitiveLongList;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.model.AttachedModel;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletModel;
import com.liferay.portal.model.ResourcedModel;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.StagedGroupedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.impl.LockImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockLocalServiceUtil;
import com.liferay.portal.service.ResourceBlockPermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetLinkLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksEntryImpl;
import com.liferay.portlet.bookmarks.model.impl.BookmarksFolderImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.portlet.expando.service.ExpandoColumnLocalServiceUtil;
import com.liferay.portlet.journal.model.impl.JournalArticleImpl;
import com.liferay.portlet.journal.model.impl.JournalFeedImpl;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBBanImpl;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadFlagImpl;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.persistence.MBDiscussionUtil;
import com.liferay.portlet.messageboards.service.persistence.MBMessageUtil;
import com.liferay.portlet.polls.model.impl.PollsChoiceImpl;
import com.liferay.portlet.polls.model.impl.PollsQuestionImpl;
import com.liferay.portlet.polls.model.impl.PollsVoteImpl;
import com.liferay.portlet.ratings.model.RatingsEntry;
import com.liferay.portlet.ratings.model.impl.RatingsEntryImpl;
import com.liferay.portlet.ratings.service.RatingsEntryLocalServiceUtil;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;

public class PortletDataContextImpl
implements PortletDataContext {
    private static Log _log = LogFactoryUtil.getLog(PortletDataContextImpl.class);
    private Map<String, long[]> _assetCategoryIdsMap = new HashMap<String, long[]>();
    private Map<String, String[]> _assetCategoryUuidsMap = new HashMap<String, String[]>();
    private Map<String, List<AssetLink>> _assetLinksMap = new HashMap<String, List<AssetLink>>();
    private Map<String, String[]> _assetTagNamesMap = new HashMap<String, String[]>();
    private Map<String, List<MBMessage>> _commentsMap = new HashMap<String, List<MBMessage>>();
    private long _companyGroupId;
    private long _companyId;
    private String _dataStrategy;
    private Set<StagedModelType> _deletionSystemEventModelTypes = new HashSet<StagedModelType>();
    private Date _endDate;
    private Map<String, List<ExpandoColumn>> _expandoColumnsMap = new HashMap<String, List<ExpandoColumn>>();
    private Element _exportDataRootElement;
    private long _groupId;
    private Element _importDataRootElement;
    private Map<String, Lock> _locksMap = new HashMap<String, Lock>();
    private ManifestSummary _manifestSummary = new ManifestSummary();
    private Set<String> _missingReferences = new HashSet<String>();
    private Element _missingReferencesElement;
    private List<Layout> _newLayouts;
    private Map<String, Map<?, ?>> _newPrimaryKeysMaps = new HashMap();
    private Set<String> _notUniquePerLayout = new HashSet<String>();
    private long _oldPlid;
    private Map<String, String[]> _parameterMap;
    private Map<String, List<KeyValuePair>> _permissionsMap = new HashMap<String, List<KeyValuePair>>();
    private long _plid;
    private PortletDataContextListener _portletDataContextListener;
    private Set<String> _primaryKeys = new HashSet<String>();
    private boolean _privateLayout;
    private Map<String, List<RatingsEntry>> _ratingsEntriesMap = new HashMap<String, List<RatingsEntry>>();
    private Set<String> _references = new HashSet<String>();
    private Set<String> _scopedPrimaryKeys = new HashSet<String>();
    private long _scopeGroupId;
    private String _scopeLayoutUuid;
    private String _scopeType;
    private long _sourceCompanyGroupId;
    private long _sourceCompanyId;
    private long _sourceGroupId;
    private long _sourceUserPersonalSiteGroupId;
    private Date _startDate;
    private UserIdStrategy _userIdStrategy;
    private long _userPersonalSiteGroupId;
    private XStream _xStream;
    private ZipReader _zipReader;
    private ZipWriter _zipWriter;

    public PortletDataContextImpl() {
        this.initXStream();
    }

    public void addAssetCategories(Class<?> clazz, long classPK) throws SystemException {
        List assetCategories = AssetCategoryLocalServiceUtil.getCategories((String)clazz.getName(), (long)classPK);
        this._assetCategoryUuidsMap.put(this.getPrimaryKeyString(clazz, classPK), StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.UUID_ACCESSOR)));
        this._assetCategoryIdsMap.put(this.getPrimaryKeyString(clazz, classPK), StringUtil.split((String)ListUtil.toString((List)assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR), (long)0L));
    }

    public void addAssetCategories(String className, long classPK, long[] assetCategoryIds) {
        this._assetCategoryIdsMap.put(this.getPrimaryKeyString(className, classPK), assetCategoryIds);
    }

    public void addAssetLinks(Class<?> clazz, long classPK) throws SystemException {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)clazz.getName(), (long)classPK);
        if (assetEntry == null) {
            return;
        }
        List directAssetLinks = AssetLinkLocalServiceUtil.getDirectLinks((long)assetEntry.getEntryId());
        if (directAssetLinks.isEmpty()) {
            return;
        }
        HashMap<Integer, ArrayList<AssetLink>> assetLinksMap = new HashMap<Integer, ArrayList<AssetLink>>();
        for (AssetLink assetLink : directAssetLinks) {
            ArrayList<AssetLink> assetLinks = (ArrayList<AssetLink>)assetLinksMap.get(assetLink.getType());
            if (assetLinks == null) {
                assetLinks = new ArrayList<AssetLink>();
                assetLinksMap.put(assetLink.getType(), assetLinks);
            }
            assetLinks.add(assetLink);
        }
        for (Map.Entry entry : assetLinksMap.entrySet()) {
            this._assetLinksMap.put(this.getPrimaryKeyString(assetEntry.getClassUuid(), (long)((Integer)entry.getKey()).intValue()), (List)entry.getValue());
        }
    }

    public void addAssetTags(Class<?> clazz, long classPK) throws SystemException {
        String[] tagNames = AssetTagLocalServiceUtil.getTagNames((String)clazz.getName(), (long)classPK);
        this._assetTagNamesMap.put(this.getPrimaryKeyString(clazz, classPK), tagNames);
    }

    public void addAssetTags(String className, long classPK, String[] assetTagNames) {
        this._assetTagNamesMap.put(this.getPrimaryKeyString(className, classPK), assetTagNames);
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel) throws PortalException, SystemException {
        this.addClassedModel(element, path, classedModel, classedModel.getModelClass());
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel, Class<?> clazz) throws PortalException, SystemException {
        String className;
        element.addAttribute("path", path);
        if (classedModel instanceof AttachedModel) {
            AttachedModel attachedModel = (AttachedModel)classedModel;
            element.addAttribute("class-name", attachedModel.getClassName());
        } else if (BeanUtil.hasProperty((Object)classedModel, (String)"className") && (className = BeanPropertiesUtil.getStringSilent((Object)classedModel, (String)"className")) != null) {
            element.addAttribute("class-name", className);
        }
        if (this.isPathProcessed(path)) {
            return;
        }
        if (classedModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)classedModel;
            auditedModel.setUserUuid(auditedModel.getUserUuid());
        }
        if (this.isResourceMain(classedModel)) {
            long classPK = this.getClassPK(classedModel);
            this.addAssetCategories(clazz, classPK);
            this.addAssetLinks(clazz, classPK);
            this.addAssetTags(clazz, classPK);
            this.addExpando(element, path, classedModel, clazz);
            this.addLocks(clazz, String.valueOf(classPK));
            this.addPermissions(clazz, classPK);
            boolean portletDataAll = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_ALL");
            if (portletDataAll || MapUtil.getBoolean(this.getParameterMap(), (String)"COMMENTS")) {
                this.addComments(clazz, classPK);
            }
            if (portletDataAll || MapUtil.getBoolean(this.getParameterMap(), (String)"RATINGS")) {
                this.addRatingsEntries(clazz, classPK);
            }
        }
        this._references.add(this.getReferenceKey(classedModel));
        this.addZipEntry(path, classedModel);
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel, Class<?> clazz, String namespace) throws PortalException, SystemException {
        this.addClassedModel(element, path, classedModel, clazz);
    }

    public void addClassedModel(Element element, String path, ClassedModel classedModel, String namespace) throws PortalException, SystemException {
        this.addClassedModel(element, path, classedModel);
    }

    public void addComments(Class<?> clazz, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId(clazz);
        MBDiscussion discussion = MBDiscussionUtil.fetchByC_C((long)classNameId, (long)classPK);
        if (discussion == null) {
            return;
        }
        List messages = MBMessageLocalServiceUtil.getThreadMessages((long)discussion.getThreadId(), (int)0);
        if (messages.isEmpty()) {
            return;
        }
        MBMessage firstMessage = (MBMessage)messages.get(0);
        if (messages.size() == 1 && firstMessage.isRoot()) {
            return;
        }
        for (MBMessage message : messages) {
            this.addRatingsEntries(MBDiscussion.class, message.getPrimaryKey());
        }
        this._commentsMap.put(this.getPrimaryKeyString(clazz, classPK), messages);
    }

    public void addComments(String className, long classPK, List<MBMessage> messages) {
        this._commentsMap.put(this.getPrimaryKeyString(className, classPK), messages);
    }

    public void addDateRangeCriteria(DynamicQuery dynamicQuery, String modifiedDatePropertyName) {
        if (!this.hasDateRange()) {
            return;
        }
        Property modifiedDateProperty = PropertyFactoryUtil.forName((String)modifiedDatePropertyName);
        dynamicQuery.add(modifiedDateProperty.ge((Object)this._startDate));
        dynamicQuery.add(modifiedDateProperty.le((Object)this._endDate));
    }

    public void addDeletionSystemEventStagedModelTypes(StagedModelType ... stagedModelTypes) {
        StagedModelType[] stagedModelTypeArray = stagedModelTypes;
        int n = stagedModelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            StagedModelType stagedModelType = stagedModelTypeArray[n2];
            this._deletionSystemEventModelTypes.add(stagedModelType);
            ++n2;
        }
    }

    public void addExpando(Element element, String path, ClassedModel classedModel) throws PortalException, SystemException {
        this.addExpando(element, path, classedModel, classedModel.getModelClass());
    }

    public void addLocks(Class<?> clazz, String key) throws PortalException, SystemException {
        if (!this._locksMap.containsKey(this.getPrimaryKeyString(clazz, key)) && LockLocalServiceUtil.isLocked((String)clazz.getName(), (String)key)) {
            Lock lock = LockLocalServiceUtil.getLock((String)clazz.getName(), (String)key);
            this.addLocks(clazz.getName(), key, lock);
        }
    }

    public void addLocks(String className, String key, Lock lock) {
        this._locksMap.put(this.getPrimaryKeyString(className, key), lock);
    }

    public void addPermissions(Class<?> clazz, long classPK) throws PortalException, SystemException {
        this.addPermissions(clazz.getName(), classPK);
    }

    public void addPermissions(String resourceName, long resourcePK) throws PortalException, SystemException {
        if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        ArrayList<KeyValuePair> permissions = new ArrayList<KeyValuePair>();
        List roles = RoleLocalServiceUtil.getGroupRelatedRoles((long)this._groupId);
        PrimitiveLongList roleIds = new PrimitiveLongList(roles.size());
        HashMap<Long, String> roleIdsToNames = new HashMap<Long, String>();
        for (Role role : roles) {
            String roleName = role.getName();
            int roleType = role.getType();
            if (roleType == 4 && role.isTeam()) {
                Team team = TeamLocalServiceUtil.getTeam((long)role.getClassPK());
                roleName = "ROLE_TEAM_,*" + team.getName();
            }
            roleIds.add(role.getRoleId());
            roleIdsToNames.put(role.getRoleId(), roleName);
        }
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)resourceName);
        Map<Long, Set<String>> roleIdsToActionIds = this.getActionIds(this._companyId, roleIds.getArray(), resourceName, resourcePK, actionIds);
        for (Map.Entry entry : roleIdsToNames.entrySet()) {
            long roleId = (Long)entry.getKey();
            String name = (String)entry.getValue();
            Set<String> availableActionIds = roleIdsToActionIds.get(roleId);
            if (availableActionIds == null) {
                availableActionIds = Collections.emptySet();
            }
            KeyValuePair permission = new KeyValuePair(name, StringUtil.merge(availableActionIds));
            permissions.add(permission);
        }
        this._permissionsMap.put(this.getPrimaryKeyString(resourceName, resourcePK), permissions);
    }

    public void addPermissions(String resourceName, long resourcePK, List<KeyValuePair> permissions) {
        this._permissionsMap.put(this.getPrimaryKeyString(resourceName, resourcePK), permissions);
    }

    public void addPortalPermissions() throws PortalException, SystemException {
        this.addPermissions("90", this.getCompanyId());
    }

    public void addPortletPermissions(String resourceName) throws PortalException, SystemException {
        long groupId = this.getGroupId();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (group.isStagingGroup()) {
            if (group.isStagedRemotely()) {
                groupId = group.getLiveGroupId();
            } else {
                return;
            }
        }
        this.addPermissions(resourceName, groupId);
    }

    public boolean addPrimaryKey(Class<?> clazz, String primaryKey) {
        boolean value = this.hasPrimaryKey(clazz, primaryKey);
        if (!value) {
            this._primaryKeys.add(this.getPrimaryKeyString(clazz, primaryKey));
        }
        return value;
    }

    public void addRatingsEntries(Class<?> clazz, long classPK) throws SystemException {
        List ratingsEntries = RatingsEntryLocalServiceUtil.getEntries((String)clazz.getName(), (long)classPK);
        if (ratingsEntries.size() == 0) {
            return;
        }
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(clazz, classPK), ratingsEntries);
    }

    public void addRatingsEntries(String className, long classPK, List<RatingsEntry> ratingsEntries) {
        this._ratingsEntriesMap.put(this.getPrimaryKeyString(className, classPK), ratingsEntries);
    }

    @Deprecated
    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, Class<?> clazz, String referenceType, boolean missing) {
        return this.addReferenceElement(referrerClassedModel, element, classedModel, clazz.getName(), "", referenceType, missing);
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String referenceType, boolean missing) {
        return this.addReferenceElement(referrerClassedModel, element, classedModel, ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), "", referenceType, missing);
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String binPath, String referenceType, boolean missing) {
        return this.addReferenceElement(referrerClassedModel, element, classedModel, ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), binPath, referenceType, missing);
    }

    public Element addReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String className, String binPath, String referenceType, boolean missing) {
        Element referenceElement = this.doAddReferenceElement(referrerClassedModel, element, classedModel, className, binPath, referenceType, false);
        String referenceKey = this.getReferenceKey(classedModel);
        if (missing) {
            if (this._references.contains(referenceKey)) {
                return referenceElement;
            }
            referenceElement.addAttribute("missing", Boolean.TRUE.toString());
            if (!this._missingReferences.contains(referenceKey)) {
                this._missingReferences.add(referenceKey);
                this.doAddReferenceElement(referrerClassedModel, null, classedModel, className, binPath, referenceType, true);
            }
        } else {
            this._references.add(referenceKey);
            this.cleanUpMissingReferences(classedModel);
        }
        return referenceElement;
    }

    public boolean addScopedPrimaryKey(Class<?> clazz, String primaryKey) {
        boolean value = this.hasScopedPrimaryKey(clazz, primaryKey);
        if (!value) {
            this._scopedPrimaryKeys.add(this.getPrimaryKeyString(clazz, primaryKey));
        }
        return value;
    }

    public void addZipEntry(String path, byte[] bytes) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, InputStream is) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, Object object) throws SystemException {
        this.addZipEntry(path, this.toXML(object));
    }

    public void addZipEntry(String path, String s) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, s);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void addZipEntry(String path, StringBuilder sb) throws SystemException {
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onAddZipEntry(path);
        }
        try {
            ZipWriter zipWriter = this.getZipWriter();
            zipWriter.addEntry(path, sb);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public void cleanUpMissingReferences(ClassedModel classedModel) {
        String referenceKey = this.getReferenceKey(classedModel);
        if (this._missingReferences.contains(referenceKey)) {
            this._missingReferences.remove(referenceKey);
            Element missingReferenceElement = this.getMissingReferenceElement(classedModel);
            this._missingReferencesElement.remove(missingReferenceElement);
        }
    }

    public void clearScopedPrimaryKeys() {
        this._scopedPrimaryKeys.clear();
    }

    public ServiceContext createServiceContext(Element element, ClassedModel classedModel) {
        return this.createServiceContext(element, null, classedModel, classedModel.getModelClass());
    }

    public ServiceContext createServiceContext(Element element, ClassedModel classedModel, String namespace) {
        return this.createServiceContext(element, classedModel);
    }

    public ServiceContext createServiceContext(StagedModel stagedModel) {
        return this.createServiceContext(stagedModel, stagedModel.getModelClass());
    }

    public ServiceContext createServiceContext(StagedModel stagedModel, Class<?> clazz) {
        return this.createServiceContext(null, ExportImportPathUtil.getModelPath((StagedModel)stagedModel), (ClassedModel)stagedModel, clazz);
    }

    public ServiceContext createServiceContext(String path, ClassedModel classedModel) {
        return this.createServiceContext(null, path, classedModel, classedModel.getModelClass());
    }

    public ServiceContext createServiceContext(String path, ClassedModel classedModel, String namespace) {
        return this.createServiceContext(path, classedModel);
    }

    public Object fromXML(byte[] bytes) {
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return null;
        }
        return this._xStream.fromXML(new String(bytes));
    }

    public Object fromXML(String xml) {
        if (Validator.isNull((String)xml)) {
            return null;
        }
        return this._xStream.fromXML(xml);
    }

    public long[] getAssetCategoryIds(Class<?> clazz, long classPK) {
        return this._assetCategoryIdsMap.get(this.getPrimaryKeyString(clazz, classPK));
    }

    public Map<String, long[]> getAssetCategoryIdsMap() {
        return this._assetCategoryIdsMap;
    }

    public Map<String, String[]> getAssetCategoryUuidsMap() {
        return this._assetCategoryUuidsMap;
    }

    public Map<String, List<AssetLink>> getAssetLinksMap() {
        return this._assetLinksMap;
    }

    public String[] getAssetTagNames(Class<?> clazz, long classPK) {
        return this._assetTagNamesMap.get(this.getPrimaryKeyString(clazz, classPK));
    }

    public String[] getAssetTagNames(String className, long classPK) {
        return this._assetTagNamesMap.get(this.getPrimaryKeyString(className, classPK));
    }

    public Map<String, String[]> getAssetTagNamesMap() {
        return this._assetTagNamesMap;
    }

    public boolean getBooleanParameter(String namespace, String name) {
        return this.getBooleanParameter(namespace, name, true);
    }

    public boolean getBooleanParameter(String namespace, String name, boolean useDefaultValue) {
        if (!useDefaultValue) {
            return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name));
        }
        boolean defaultValue = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_CONTROL_DEFAULT", (boolean)true);
        return MapUtil.getBoolean(this.getParameterMap(), (String)PortletDataHandlerControl.getNamespacedControlName((String)namespace, (String)name), (boolean)defaultValue);
    }

    public ClassLoader getClassLoader() {
        return this._xStream.getClassLoader();
    }

    public Map<String, List<MBMessage>> getComments() {
        return this._commentsMap;
    }

    public long getCompanyGroupId() {
        return this._companyGroupId;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDataStrategy() {
        return this._dataStrategy;
    }

    public DateRange getDateRange() {
        DateRange dateRange = null;
        if (this.hasDateRange()) {
            dateRange = new DateRange(this._startDate, this._endDate);
        }
        return dateRange;
    }

    public Set<StagedModelType> getDeletionSystemEventStagedModelTypes() {
        return this._deletionSystemEventModelTypes;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Map<String, List<ExpandoColumn>> getExpandoColumns() {
        return this._expandoColumnsMap;
    }

    public Element getExportDataElement(ClassedModel classedModel) {
        return this.getExportDataElement(classedModel, ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)classedModel));
    }

    @Deprecated
    public Element getExportDataElement(ClassedModel classedModel, Class<?> modelClass) {
        return this.getExportDataElement(classedModel, modelClass.getSimpleName());
    }

    public Element getExportDataElement(ClassedModel classedModel, String modelClassSimpleName) {
        StagedModel stagedModel;
        Element groupElement = this.getExportDataGroupElement(modelClassSimpleName);
        Element element = null;
        if (classedModel instanceof StagedModel) {
            stagedModel = (StagedModel)classedModel;
            String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
            element = this.getDataElement(groupElement, "path", path);
            if (element != null) {
                return element;
            }
            element = this.getDataElement(groupElement, "uuid", stagedModel.getUuid());
            if (element != null) {
                return element;
            }
        }
        element = groupElement.addElement("staged-model");
        if (classedModel instanceof StagedGroupedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)classedModel;
            element.addAttribute("group-id", String.valueOf(stagedGroupedModel.getGroupId()));
            element.addAttribute("uuid", stagedGroupedModel.getUuid());
        } else if (classedModel instanceof StagedModel) {
            stagedModel = (StagedModel)classedModel;
            element.addAttribute("uuid", stagedModel.getUuid());
        }
        return element;
    }

    public Element getExportDataGroupElement(Class<? extends StagedModel> clazz) {
        return this.getExportDataGroupElement(clazz.getSimpleName());
    }

    public Element getExportDataRootElement() {
        return this._exportDataRootElement;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public Element getImportDataElement(StagedModel stagedModel) {
        return this.getImportDataElement(ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)stagedModel), "uuid", stagedModel.getUuid());
    }

    public Element getImportDataElement(String name, String attribute, String value) {
        Element groupElement = this.getImportDataGroupElement(name);
        return this.getDataElement(groupElement, attribute, value);
    }

    public Element getImportDataGroupElement(Class<? extends StagedModel> clazz) {
        return this.getImportDataGroupElement(clazz.getSimpleName());
    }

    public Element getImportDataRootElement() {
        return this._importDataRootElement;
    }

    public Element getImportDataStagedModelElement(StagedModel stagedModel) {
        String path = ExportImportPathUtil.getModelPath((StagedModel)stagedModel);
        return this.getImportDataElement(ExportImportClassedModelUtil.getClassSimpleName((ClassedModel)stagedModel), "path", path);
    }

    public String getLayoutPath(long plid) {
        return ExportImportPathUtil.getLayoutPath((PortletDataContext)this, (long)plid);
    }

    public Map<String, Lock> getLocks() {
        return this._locksMap;
    }

    public ManifestSummary getManifestSummary() {
        return this._manifestSummary;
    }

    public Element getMissingReferencesElement() {
        return this._missingReferencesElement;
    }

    public List<Layout> getNewLayouts() {
        return this._newLayouts;
    }

    public Map<?, ?> getNewPrimaryKeysMap(Class<?> clazz) {
        return this.getNewPrimaryKeysMap(clazz.getName());
    }

    public Map<?, ?> getNewPrimaryKeysMap(String className) {
        Map<?, ?> map = this._newPrimaryKeysMaps.get(className);
        if (map == null) {
            map = new HashMap();
            this._newPrimaryKeysMaps.put(className, map);
        }
        return map;
    }

    public long getOldPlid() {
        return this._oldPlid;
    }

    public Map<String, String[]> getParameterMap() {
        return this._parameterMap;
    }

    public Map<String, List<KeyValuePair>> getPermissions() {
        return this._permissionsMap;
    }

    public long getPlid() {
        return this._plid;
    }

    public String getPortletPath(String portletId) {
        return ExportImportPathUtil.getPortletPath((PortletDataContext)this, (String)portletId);
    }

    public Set<String> getPrimaryKeys() {
        return this._primaryKeys;
    }

    public Map<String, List<RatingsEntry>> getRatingsEntries() {
        return this._ratingsEntriesMap;
    }

    public Element getReferenceDataElement(Element parentElement, Class<?> clazz, long classPK) {
        List<Element> referenceElements = this.getReferenceElements(parentElement, clazz, 0L, null, classPK, null);
        List<Element> referenceDataElements = this.getReferenceDataElements(referenceElements, clazz);
        if (referenceDataElements.isEmpty()) {
            return null;
        }
        return referenceDataElements.get(0);
    }

    public Element getReferenceDataElement(Element parentElement, Class<?> clazz, long groupId, String uuid) {
        List<Element> referenceElements = this.getReferenceElements(parentElement, clazz, groupId, uuid, 0L, null);
        List<Element> referenceDataElements = this.getReferenceDataElements(referenceElements, clazz);
        if (referenceDataElements.isEmpty()) {
            return null;
        }
        return referenceDataElements.get(0);
    }

    public Element getReferenceDataElement(StagedModel parentStagedModel, Class<?> clazz, long classPK) {
        Element parentElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceDataElement(parentElement, clazz, classPK);
    }

    public Element getReferenceDataElement(StagedModel parentStagedModel, Class<?> clazz, long groupId, String uuid) {
        Element parentElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceDataElement(parentElement, clazz, groupId, uuid);
    }

    public List<Element> getReferenceDataElements(Element parentElement, Class<?> clazz) {
        return this.getReferenceDataElements(parentElement, clazz, null);
    }

    public List<Element> getReferenceDataElements(Element parentElement, Class<?> clazz, String referenceType) {
        List<Element> referenceElements = this.getReferenceElements(parentElement, clazz, 0L, null, 0L, referenceType);
        return this.getReferenceDataElements(referenceElements, clazz);
    }

    public List<Element> getReferenceDataElements(StagedModel parentStagedModel, Class<?> clazz) {
        return this.getReferenceDataElements(parentStagedModel, clazz, null);
    }

    public List<Element> getReferenceDataElements(StagedModel parentStagedModel, Class<?> clazz, String referenceType) {
        List<Element> referenceElements = this.getReferenceElements(parentStagedModel, clazz, 0L, referenceType);
        return this.getReferenceDataElements(referenceElements, clazz);
    }

    public Element getReferenceElement(StagedModel parentStagedModel, Class<?> clazz, long classPK) {
        List<Element> referenceElements = this.getReferenceElements(parentStagedModel, clazz, classPK, null);
        if (!referenceElements.isEmpty()) {
            return referenceElements.get(0);
        }
        return null;
    }

    public List<Element> getReferenceElements(StagedModel parentStagedModel, Class<?> clazz) {
        return this.getReferenceElements(parentStagedModel, clazz, 0L, null);
    }

    public String getRootPath() {
        return ExportImportPathUtil.getRootPath((PortletDataContext)this);
    }

    public Set<String> getScopedPrimaryKeys() {
        return this._scopedPrimaryKeys;
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public String getScopeLayoutUuid() {
        return this._scopeLayoutUuid;
    }

    public String getScopeType() {
        return this._scopeType;
    }

    public long getSourceCompanyGroupId() {
        return this._sourceCompanyGroupId;
    }

    public long getSourceCompanyId() {
        return this._sourceCompanyId;
    }

    public long getSourceGroupId() {
        return this._sourceGroupId;
    }

    public String getSourceLayoutPath(long layoutId) {
        return ExportImportPathUtil.getSourceLayoutPath((PortletDataContext)this, (long)layoutId);
    }

    public String getSourcePortletPath(String portletId) {
        return ExportImportPathUtil.getSourcePortletPath((PortletDataContext)this, (String)portletId);
    }

    public String getSourceRootPath() {
        return ExportImportPathUtil.getSourceRootPath((PortletDataContext)this);
    }

    public long getSourceUserPersonalSiteGroupId() {
        return this._sourceUserPersonalSiteGroupId;
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public long getUserId(String userUuid) {
        return this._userIdStrategy.getUserId(userUuid);
    }

    public UserIdStrategy getUserIdStrategy() {
        return this._userIdStrategy;
    }

    public long getUserPersonalSiteGroupId() {
        return this._userPersonalSiteGroupId;
    }

    public List<String> getZipEntries() {
        return this.getZipReader().getEntries();
    }

    public byte[] getZipEntryAsByteArray(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsByteArray(path);
    }

    public InputStream getZipEntryAsInputStream(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsInputStream(path);
    }

    public Object getZipEntryAsObject(Element element, String path) {
        Object object = this.fromXML(this.getZipEntryAsString(path));
        Attribute classNameAttribute = element.attribute("class-name");
        if (classNameAttribute != null) {
            BeanPropertiesUtil.setProperty((Object)object, (String)"className", (Object)classNameAttribute.getText());
        }
        return object;
    }

    public Object getZipEntryAsObject(String path) {
        return this.fromXML(this.getZipEntryAsString(path));
    }

    public String getZipEntryAsString(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        if (this._portletDataContextListener != null) {
            this._portletDataContextListener.onGetZipEntry(path);
        }
        return this.getZipReader().getEntryAsString(path);
    }

    public List<String> getZipFolderEntries() {
        return this.getZipFolderEntries("/");
    }

    public List<String> getZipFolderEntries(String path) {
        if (!Validator.isFilePath((String)path, (boolean)false)) {
            return null;
        }
        return this.getZipReader().getFolderEntries(path);
    }

    public ZipReader getZipReader() {
        return this._zipReader;
    }

    public ZipWriter getZipWriter() {
        return this._zipWriter;
    }

    public boolean hasDateRange() {
        return this._startDate != null;
    }

    public boolean hasNotUniquePerLayout(String dataKey) {
        return this._notUniquePerLayout.contains(dataKey);
    }

    public boolean hasPrimaryKey(Class<?> clazz, String primaryKey) {
        return this._primaryKeys.contains(this.getPrimaryKeyString(clazz, primaryKey));
    }

    public boolean hasScopedPrimaryKey(Class<?> clazz, String primaryKey) {
        return this._scopedPrimaryKeys.contains(this.getPrimaryKeyString(clazz, primaryKey));
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel) throws PortalException, SystemException {
        this.importClassedModel(classedModel, newClassedModel, classedModel.getModelClass());
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel, Class<?> clazz) throws PortalException, SystemException {
        if (!this.isResourceMain(classedModel)) {
            return;
        }
        long classPK = this.getClassPK(classedModel);
        long newClassPK = this.getClassPK(newClassedModel);
        Map<?, ?> newPrimaryKeysMap = this.getNewPrimaryKeysMap(clazz);
        newPrimaryKeysMap.put(classPK, newClassPK);
        this.importLocks(clazz, String.valueOf(classPK), String.valueOf(newClassPK));
        this.importPermissions(clazz, classPK, newClassPK);
        boolean portletDataAll = MapUtil.getBoolean(this.getParameterMap(), (String)"PORTLET_DATA_ALL");
        if (portletDataAll || MapUtil.getBoolean(this.getParameterMap(), (String)"COMMENTS")) {
            this.importComments(clazz, classPK, newClassPK, this.getScopeGroupId());
        }
        if (portletDataAll || MapUtil.getBoolean(this.getParameterMap(), (String)"RATINGS")) {
            this.importRatingsEntries(clazz, classPK, newClassPK);
        }
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel, Class<?> clazz, String namespace) throws PortalException, SystemException {
        this.importClassedModel(classedModel, newClassedModel, clazz);
    }

    public void importClassedModel(ClassedModel classedModel, ClassedModel newClassedModel, String namespace) throws PortalException, SystemException {
        this.importClassedModel(classedModel, newClassedModel, classedModel.getModelClass());
    }

    public void importComments(Class<?> clazz, long classPK, long newClassPK, long groupId) throws PortalException, SystemException {
        HashMap<Long, Long> messagePKs = new HashMap<Long, Long>();
        HashMap<Long, Long> threadPKs = new HashMap<Long, Long>();
        List<MBMessage> messages = this._commentsMap.get(this.getPrimaryKeyString(clazz, classPK));
        if (messages == null) {
            return;
        }
        MBMessage firstMessage = messages.get(0);
        if (messages.size() == 1 && firstMessage.isRoot()) {
            return;
        }
        long classNameId = PortalUtil.getClassNameId(clazz);
        MBDiscussion discussion = MBDiscussionUtil.fetchByC_C((long)classNameId, (long)newClassPK);
        for (MBMessage message : messages) {
            long userId = this.getUserId(message.getUserUuid());
            long parentMessageId = MapUtil.getLong(messagePKs, (long)message.getParentMessageId(), (long)message.getParentMessageId());
            long threadId = MapUtil.getLong(threadPKs, (long)message.getThreadId(), (long)message.getThreadId());
            if (message.isRoot()) {
                if (discussion != null) {
                    MBThread thread = MBThreadLocalServiceUtil.getThread((long)discussion.getThreadId());
                    long rootMessageId = thread.getRootMessageId();
                    messagePKs.put(message.getMessageId(), rootMessageId);
                    threadPKs.put(message.getThreadId(), thread.getThreadId());
                } else if (clazz == Layout.class) {
                    MBMessage importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)groupId, (String)clazz.getName(), (long)newClassPK, (int)1);
                    messagePKs.put(message.getMessageId(), importedMessage.getMessageId());
                    threadPKs.put(message.getThreadId(), importedMessage.getThreadId());
                }
            } else {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCreateDate(message.getCreateDate());
                serviceContext.setModifiedDate(message.getModifiedDate());
                serviceContext.setScopeGroupId(groupId);
                MBMessage importedMessage = null;
                if (this._dataStrategy.equals("DATA_STRATEGY_MIRROR") || this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE")) {
                    MBMessage existingMessage = MBMessageUtil.fetchByUUID_G((String)message.getUuid(), (long)groupId);
                    if (existingMessage == null) {
                        serviceContext.setUuid(message.getUuid());
                        importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)groupId, (String)clazz.getName(), (long)newClassPK, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                    } else {
                        serviceContext.setWorkflowAction(1);
                        importedMessage = MBMessageLocalServiceUtil.updateDiscussionMessage((long)userId, (long)existingMessage.getMessageId(), (String)clazz.getName(), (long)newClassPK, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                    }
                } else {
                    importedMessage = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)message.getUserName(), (long)groupId, (String)clazz.getName(), (long)newClassPK, (long)threadId, (long)parentMessageId, (String)message.getSubject(), (String)message.getBody(), (ServiceContext)serviceContext);
                }
                messagePKs.put(message.getMessageId(), importedMessage.getMessageId());
                threadPKs.put(message.getThreadId(), importedMessage.getThreadId());
            }
            this.importRatingsEntries(MBDiscussion.class, message.getPrimaryKey(), (Long)messagePKs.get(message.getPrimaryKey()));
        }
    }

    public void importLocks(Class<?> clazz, String key, String newKey) throws PortalException, SystemException {
        Lock lock = this._locksMap.get(this.getPrimaryKeyString(clazz, key));
        if (lock == null) {
            return;
        }
        long userId = this.getUserId(lock.getUserUuid());
        long expirationTime = 0L;
        if (lock.getExpirationDate() != null) {
            Date expirationDate = lock.getExpirationDate();
            expirationTime = expirationDate.getTime();
        }
        LockLocalServiceUtil.lock((long)userId, (String)clazz.getName(), (String)newKey, (String)lock.getOwner(), (boolean)lock.isInheritable(), (long)expirationTime);
    }

    public void importPermissions(Class<?> clazz, long classPK, long newClassPK) throws PortalException, SystemException {
        this.importPermissions(clazz.getName(), classPK, newClassPK);
    }

    public void importPermissions(String resourceName, long resourcePK, long newResourcePK) throws PortalException, SystemException {
        if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
            return;
        }
        List<KeyValuePair> permissions = this._permissionsMap.get(this.getPrimaryKeyString(resourceName, resourcePK));
        if (permissions == null) {
            return;
        }
        HashMap<Long, String[]> roleIdsToActionIds = new HashMap<Long, String[]>();
        for (KeyValuePair permission : permissions) {
            String roleName = permission.getKey();
            Role role = null;
            Team team = null;
            if (roleName.startsWith("ROLE_TEAM_,*")) {
                roleName = roleName.substring("ROLE_TEAM_,*".length());
                try {
                    team = TeamLocalServiceUtil.getTeam((long)this._groupId, (String)roleName);
                }
                catch (NoSuchTeamException noSuchTeamException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Team " + roleName + " does not exist"));
                    continue;
                }
            }
            try {
                role = team != null ? RoleLocalServiceUtil.getTeamRole((long)this._companyId, (long)team.getTeamId()) : RoleLocalServiceUtil.getRole((long)this._companyId, (String)roleName);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Role " + roleName + " does not exist"));
                continue;
            }
            String[] actionIds = StringUtil.split((String)permission.getValue());
            roleIdsToActionIds.put(role.getRoleId(), actionIds);
        }
        if (roleIdsToActionIds.isEmpty()) {
            return;
        }
        if (ResourceBlockLocalServiceUtil.isSupported((String)resourceName)) {
            ResourceBlockLocalServiceUtil.setIndividualScopePermissions((long)this._companyId, (long)this._groupId, (String)resourceName, (long)newResourcePK, roleIdsToActionIds);
        } else {
            ResourcePermissionLocalServiceUtil.setResourcePermissions((long)this._companyId, (String)resourceName, (int)4, (String)String.valueOf(newResourcePK), roleIdsToActionIds);
        }
    }

    public void importPortalPermissions() throws PortalException, SystemException {
        this.importPermissions("90", this.getSourceCompanyId(), this.getCompanyId());
    }

    public void importPortletPermissions(String resourceName) throws PortalException, SystemException {
        this.importPermissions(resourceName, this.getSourceGroupId(), this.getScopeGroupId());
    }

    public void importRatingsEntries(Class<?> clazz, long classPK, long newClassPK) throws PortalException, SystemException {
        List<RatingsEntry> ratingsEntries = this._ratingsEntriesMap.get(this.getPrimaryKeyString(clazz, classPK));
        if (ratingsEntries == null) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            long userId = this.getUserId(ratingsEntry.getUserUuid());
            serviceContext.setCreateDate(ratingsEntry.getCreateDate());
            serviceContext.setModifiedDate(ratingsEntry.getModifiedDate());
            RatingsEntryLocalServiceUtil.updateEntry((long)userId, (String)clazz.getName(), (long)newClassPK, (double)ratingsEntry.getScore(), (ServiceContext)serviceContext);
        }
    }

    public boolean isCompanyStagedGroupedModel(StagedGroupedModel stagedGroupedModel) {
        return stagedGroupedModel.getGroupId() == this.getCompanyGroupId() && this.getGroupId() != this.getCompanyGroupId();
    }

    public boolean isDataStrategyMirror() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR") || this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isDataStrategyMirrorWithOverwriting() {
        return this._dataStrategy.equals("DATA_STRATEGY_MIRROR_OVERWRITE");
    }

    public boolean isMissingReference(Element referenceElement) {
        Attribute missingAttribute = referenceElement.attribute("missing");
        if (missingAttribute != null && !GetterUtil.getBoolean((String)referenceElement.attributeValue("missing"))) {
            return false;
        }
        if (this._missingReferences.isEmpty()) {
            List missingReferenceElements = this._missingReferencesElement.elements();
            for (Element missingReferenceElement : missingReferenceElements) {
                String missingReferenceClassName = missingReferenceElement.attributeValue("class-name");
                String missingReferenceClassPK = missingReferenceElement.attributeValue("class-pk");
                String missingReferenceKey = this.getReferenceKey(missingReferenceClassName, missingReferenceClassPK);
                this._missingReferences.add(missingReferenceKey);
            }
        }
        String className = referenceElement.attributeValue("class-name");
        String classPK = referenceElement.attributeValue("class-pk");
        String referenceKey = this.getReferenceKey(className, classPK);
        return this._missingReferences.contains(referenceKey);
    }

    public boolean isModelCounted(String className, long classPK) {
        String modelCountedPrimaryKey = className.concat("#").concat(String.valueOf(classPK));
        return this.addPrimaryKey(String.class, modelCountedPrimaryKey);
    }

    public boolean isPathExportedInScope(String path) {
        return this.addScopedPrimaryKey(String.class, path);
    }

    public boolean isPathNotExportedInScope(String path) {
        return !this.isPathExportedInScope(path);
    }

    public boolean isPathNotProcessed(String path) {
        return !this.isPathProcessed(path);
    }

    public boolean isPathProcessed(String path) {
        this.addScopedPrimaryKey(String.class, path);
        return this.addPrimaryKey(String.class, path);
    }

    public boolean isPerformDirectBinaryImport() {
        return MapUtil.getBoolean(this._parameterMap, (String)"PERFORM_DIRECT_BINARY_IMPORT");
    }

    public boolean isPrivateLayout() {
        return this._privateLayout;
    }

    public boolean isStagedModelCounted(StagedModel stagedModel) {
        StagedModelType stagedModelType = stagedModel.getStagedModelType();
        return this.isModelCounted(stagedModelType.getClassName(), (Long)stagedModel.getPrimaryKeyObj());
    }

    public boolean isWithinDateRange(Date modifiedDate) {
        if (!this.hasDateRange()) {
            return true;
        }
        return this._startDate.compareTo(modifiedDate) <= 0 && this._endDate.after(modifiedDate);
    }

    public void putNotUniquePerLayout(String dataKey) {
        this._notUniquePerLayout.add(dataKey);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._xStream.setClassLoader(classLoader);
    }

    public void setCompanyGroupId(long companyGroupId) {
        this._companyGroupId = companyGroupId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setDataStrategy(String dataStrategy) {
        this._dataStrategy = dataStrategy;
    }

    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    public void setExportDataRootElement(Element exportDataRootElement) {
        this._exportDataRootElement = exportDataRootElement;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setImportDataRootElement(Element importDataRootElement) {
        this._importDataRootElement = importDataRootElement;
    }

    public void setManifestSummary(ManifestSummary manifestSummary) {
        this._manifestSummary = manifestSummary;
    }

    public void setMissingReferencesElement(Element missingReferencesElement) {
        this._missingReferencesElement = missingReferencesElement;
    }

    public void setNewLayouts(List<Layout> newLayouts) {
        this._newLayouts = newLayouts;
    }

    public void setOldPlid(long oldPlid) {
        this._oldPlid = oldPlid;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this._parameterMap = parameterMap;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortetDataContextListener(PortletDataContextListener portletDataContextListener) {
        this._portletDataContextListener = portletDataContextListener;
    }

    public void setPrivateLayout(boolean privateLayout) {
        this._privateLayout = privateLayout;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setScopeLayoutUuid(String scopeLayoutUuid) {
        this._scopeLayoutUuid = scopeLayoutUuid;
    }

    public void setScopeType(String scopeType) {
        this._scopeType = scopeType;
    }

    public void setSourceCompanyGroupId(long sourceCompanyGroupId) {
        this._sourceCompanyGroupId = sourceCompanyGroupId;
    }

    public void setSourceCompanyId(long sourceCompanyId) {
        this._sourceCompanyId = sourceCompanyId;
    }

    public void setSourceGroupId(long sourceGroupId) {
        this._sourceGroupId = sourceGroupId;
    }

    public void setSourceUserPersonalSiteGroupId(long sourceUserPersonalSiteGroupId) {
        this._sourceUserPersonalSiteGroupId = sourceUserPersonalSiteGroupId;
    }

    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    public void setUserIdStrategy(UserIdStrategy userIdStrategy) {
        this._userIdStrategy = userIdStrategy;
    }

    public void setUserPersonalSiteGroupId(long userPersonalSiteGroupId) {
        this._userPersonalSiteGroupId = userPersonalSiteGroupId;
    }

    public void setZipReader(ZipReader zipReader) {
        this._zipReader = zipReader;
    }

    public void setZipWriter(ZipWriter zipWriter) {
        this._zipWriter = zipWriter;
    }

    public String toXML(Object object) {
        return this._xStream.toXML(object);
    }

    protected void addExpando(Element element, String path, ClassedModel classedModel, Class<?> clazz) throws PortalException, SystemException {
        ExpandoBridge expandoBridge;
        Map expandoBridgeAttributes;
        String className = clazz.getName();
        if (!this._expandoColumnsMap.containsKey(className)) {
            List expandoColumns = ExpandoColumnLocalServiceUtil.getDefaultTableColumns((long)this._companyId, (String)className);
            for (ExpandoColumn expandoColumn : expandoColumns) {
                this.addPermissions(ExpandoColumn.class, expandoColumn.getColumnId());
            }
            this._expandoColumnsMap.put(className, expandoColumns);
        }
        if (!(expandoBridgeAttributes = (expandoBridge = classedModel.getExpandoBridge()).getAttributes()).isEmpty()) {
            String expandoPath = ExportImportPathUtil.getExpandoPath((String)path);
            element.addAttribute("expando-path", expandoPath);
            this.addZipEntry(expandoPath, expandoBridgeAttributes);
        }
    }

    protected ServiceContext createServiceContext(Element element, String path, ClassedModel classedModel, Class<?> clazz) {
        ServiceContext serviceContext;
        block7: {
            long classPK = this.getClassPK(classedModel);
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.getCompanyId());
            serviceContext.setScopeGroupId(this.getScopeGroupId());
            if (classedModel instanceof AuditedModel) {
                AuditedModel auditedModel = (AuditedModel)classedModel;
                serviceContext.setUserId(this.getUserId(auditedModel));
                serviceContext.setCreateDate(auditedModel.getCreateDate());
                serviceContext.setModifiedDate(auditedModel.getModifiedDate());
            }
            if (!MapUtil.getBoolean(this._parameterMap, (String)"PERMISSIONS")) {
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
            }
            if (this.isResourceMain(classedModel)) {
                long[] assetCategoryIds = this.getAssetCategoryIds(clazz, classPK);
                serviceContext.setAssetCategoryIds(assetCategoryIds);
                String[] assetTagNames = this.getAssetTagNames(clazz, classPK);
                serviceContext.setAssetTagNames(assetTagNames);
            }
            String expandoPath = null;
            expandoPath = element != null ? element.attributeValue("expando-path") : ExportImportPathUtil.getExpandoPath((String)path);
            if (Validator.isNotNull((String)expandoPath)) {
                try {
                    Map expandoBridgeAttributes = (Map)this.getZipEntryAsObject(expandoPath);
                    if (expandoBridgeAttributes != null) {
                        serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
                    }
                }
                catch (Exception e2) {
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)e2, (Throwable)e2);
                }
            }
        }
        return serviceContext;
    }

    protected Element doAddReferenceElement(ClassedModel referrerClassedModel, Element element, ClassedModel classedModel, String className, String binPath, String referenceType, boolean missing) {
        Element referencesElement;
        Element referenceElement = null;
        if (missing) {
            referencesElement = this._missingReferencesElement;
            referenceElement = referencesElement.addElement("missing-reference");
        } else {
            referencesElement = element.element("references");
            if (referencesElement == null) {
                referencesElement = element.addElement("references");
            }
            referenceElement = referencesElement.addElement("reference");
        }
        referenceElement.addAttribute("class-name", className);
        referenceElement.addAttribute("class-pk", String.valueOf(classedModel.getPrimaryKeyObj()));
        if (missing) {
            if (classedModel instanceof StagedModel) {
                referenceElement.addAttribute("display-name", StagedModelDataHandlerUtil.getDisplayName((StagedModel)((StagedModel)classedModel)));
            } else {
                referenceElement.addAttribute("display-name", String.valueOf(classedModel.getPrimaryKeyObj()));
            }
        }
        if (classedModel instanceof StagedGroupedModel) {
            StagedGroupedModel stagedGroupedModel = (StagedGroupedModel)classedModel;
            referenceElement.addAttribute("group-id", String.valueOf(stagedGroupedModel.getGroupId()));
        }
        if (Validator.isNotNull((String)binPath)) {
            referenceElement.addAttribute("path", binPath);
        }
        referenceElement.addAttribute("type", referenceType);
        if (missing) {
            referenceElement.addAttribute("referrer-class-name", ExportImportClassedModelUtil.getClassName((ClassedModel)referrerClassedModel));
            if (referrerClassedModel instanceof PortletModel) {
                Portlet portlet = (Portlet)referrerClassedModel;
                referenceElement.addAttribute("referrer-display-name", portlet.getRootPortletId());
            } else if (referrerClassedModel instanceof StagedModel) {
                StagedModel referrerStagedModel = (StagedModel)referrerClassedModel;
                referenceElement.addAttribute("referrer-display-name", StagedModelDataHandlerUtil.getDisplayName((StagedModel)referrerStagedModel));
            }
        }
        if (classedModel instanceof StagedModel) {
            StagedModel stagedModel = (StagedModel)classedModel;
            referenceElement.addAttribute("uuid", stagedModel.getUuid());
            referenceElement.addAttribute("company-id", String.valueOf(stagedModel.getCompanyId()));
            Map referenceAttributes = StagedModelDataHandlerUtil.getReferenceAttributes((PortletDataContext)this, (StagedModel)stagedModel);
            for (Map.Entry referenceAttribute : referenceAttributes.entrySet()) {
                referenceElement.addAttribute((String)referenceAttribute.getKey(), (String)referenceAttribute.getValue());
            }
        }
        return referenceElement;
    }

    protected Map<Long, Set<String>> getActionIds(long companyId, long[] roleIds, String className, long primKey, List<String> actionIds) throws PortalException, SystemException {
        if (ResourceBlockLocalServiceUtil.isSupported((String)className)) {
            return ResourceBlockPermissionLocalServiceUtil.getAvailableResourceBlockPermissionActionIds((long[])roleIds, (String)className, (long)primKey, actionIds);
        }
        return ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)className, (int)4, (String)String.valueOf(primKey), (long[])roleIds, actionIds);
    }

    protected long getClassPK(ClassedModel classedModel) {
        if (classedModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)classedModel;
            return resourcedModel.getResourcePrimKey();
        }
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected Element getDataElement(Element parentElement, String attribute, String value) {
        if (parentElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("staged-model");
        sb.append("[@");
        sb.append(attribute);
        sb.append("=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)value));
        sb.append("]");
        XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPath.selectSingleNode((Object)parentElement);
    }

    protected String getExpandoPath(String path) {
        return ExportImportPathUtil.getExpandoPath((String)path);
    }

    protected Element getExportDataGroupElement(String name) {
        if (this._exportDataRootElement == null) {
            throw new IllegalStateException("Root data element not initialized");
        }
        Element groupElement = this._exportDataRootElement.element(name);
        if (groupElement == null) {
            groupElement = this._exportDataRootElement.addElement(name);
        }
        return groupElement;
    }

    protected Element getImportDataGroupElement(String name) {
        if (this._importDataRootElement == null) {
            throw new IllegalStateException("Root data element not initialized");
        }
        if (Validator.isNull((String)name)) {
            return SAXReaderUtil.createElement((String)"EMPTY-ELEMENT");
        }
        Element groupElement = this._importDataRootElement.element(name);
        if (groupElement == null) {
            return SAXReaderUtil.createElement((String)"EMPTY-ELEMENT");
        }
        return groupElement;
    }

    protected Element getMissingReferenceElement(ClassedModel classedModel) {
        StringBundler sb = new StringBundler(5);
        sb.append("missing-reference[@class-name='");
        sb.append(ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel));
        sb.append("' and @class-pk='");
        sb.append(String.valueOf(classedModel.getPrimaryKeyObj()));
        sb.append("']");
        XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
        Node node = xPath.selectSingleNode((Object)this._missingReferencesElement);
        return (Element)node;
    }

    protected String getPrimaryKeyString(Class<?> clazz, long classPK) {
        return this.getPrimaryKeyString(clazz.getName(), String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(Class<?> clazz, String primaryKey) {
        return this.getPrimaryKeyString(clazz.getName(), primaryKey);
    }

    protected String getPrimaryKeyString(String className, long classPK) {
        return this.getPrimaryKeyString(className, String.valueOf(classPK));
    }

    protected String getPrimaryKeyString(String className, String primaryKey) {
        return className.concat("#").concat(primaryKey);
    }

    protected List<Element> getReferenceDataElements(List<Element> referenceElements, Class<?> clazz) {
        ArrayList<Element> referenceDataElements = new ArrayList<Element>();
        for (Element referenceElement : referenceElements) {
            Element referenceDataElement = null;
            String path = referenceElement.attributeValue("path");
            if (Validator.isNotNull((String)path)) {
                referenceDataElement = this.getImportDataElement(clazz.getSimpleName(), "path", path);
            } else {
                String groupId = referenceElement.attributeValue("group-id");
                String uuid = referenceElement.attributeValue("uuid");
                StringBuilder sb = new StringBuilder(5);
                sb.append("staged-model[@uuid=");
                sb.append(HtmlUtil.escapeXPathAttribute((String)uuid));
                if (groupId != null) {
                    sb.append(" and @group-id=");
                    sb.append(HtmlUtil.escapeXPathAttribute((String)groupId));
                }
                sb.append("]");
                XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
                Element groupElement = this.getImportDataGroupElement(clazz.getSimpleName());
                referenceDataElement = (Element)xPath.selectSingleNode((Object)groupElement);
            }
            if (referenceDataElement == null) continue;
            referenceDataElements.add(referenceDataElement);
        }
        return referenceDataElements;
    }

    protected List<Element> getReferenceElements(Element parentElement, Class<?> clazz, long groupId, String uuid, long classPK, String referenceType) {
        if (parentElement == null) {
            return Collections.emptyList();
        }
        Element referencesElement = parentElement.element("references");
        if (referencesElement == null) {
            return Collections.emptyList();
        }
        StringBundler sb = new StringBundler(13);
        sb.append("reference[@class-name=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)clazz.getName()));
        if (groupId > 0L) {
            sb.append(" and @group-id='");
            sb.append(groupId);
            sb.append("'");
        }
        if (Validator.isNotNull((String)uuid)) {
            sb.append(" and @uuid=");
            sb.append(HtmlUtil.escapeXPathAttribute((String)uuid));
        }
        if (classPK > 0L) {
            sb.append(" and @class-pk='");
            sb.append(classPK);
            sb.append("'");
        }
        if (referenceType != null) {
            sb.append(" and @type=");
            sb.append(HtmlUtil.escapeXPathAttribute((String)referenceType));
        }
        sb.append("]");
        XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
        List nodes = xPath.selectNodes((Object)referencesElement);
        return ListUtil.fromArray((Object[])nodes.toArray(new Element[nodes.size()]));
    }

    protected List<Element> getReferenceElements(StagedModel parentStagedModel, Class<?> clazz, long classPK, String referenceType) {
        Element stagedModelElement = this.getImportDataStagedModelElement(parentStagedModel);
        return this.getReferenceElements(stagedModelElement, clazz, 0L, null, classPK, referenceType);
    }

    protected String getReferenceKey(ClassedModel classedModel) {
        return this.getReferenceKey(ExportImportClassedModelUtil.getClassName((ClassedModel)classedModel), String.valueOf(classedModel.getPrimaryKeyObj()));
    }

    protected String getReferenceKey(String className, String classPK) {
        return className.concat("#").concat(classPK);
    }

    protected long getUserId(AuditedModel auditedModel) {
        try {
            String userUuid = auditedModel.getUserUuid();
            return this.getUserId(userUuid);
        }
        catch (SystemException se) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)se, (Throwable)se);
            }
            return 0L;
        }
    }

    protected void initXStream() {
        this._xStream = new XStream();
        this._xStream.alias("BlogsEntry", BlogsEntryImpl.class);
        this._xStream.alias("BookmarksFolder", BookmarksFolderImpl.class);
        this._xStream.alias("BookmarksEntry", BookmarksEntryImpl.class);
        this._xStream.alias("DLFolder", DLFolderImpl.class);
        this._xStream.alias("DLFileEntry", DLFileEntryImpl.class);
        this._xStream.alias("DLFileShortcut", DLFileShortcutImpl.class);
        this._xStream.alias("JournalArticle", JournalArticleImpl.class);
        this._xStream.alias("JournalFeed", JournalFeedImpl.class);
        this._xStream.alias("Lock", LockImpl.class);
        this._xStream.alias("MBBan", MBBanImpl.class);
        this._xStream.alias("MBCategory", MBCategoryImpl.class);
        this._xStream.alias("MBMessage", MBMessageImpl.class);
        this._xStream.alias("MBThreadFlag", MBThreadFlagImpl.class);
        this._xStream.alias("PollsQuestion", PollsQuestionImpl.class);
        this._xStream.alias("PollsChoice", PollsChoiceImpl.class);
        this._xStream.alias("PollsVote", PollsVoteImpl.class);
        this._xStream.alias("RatingsEntry", RatingsEntryImpl.class);
        this._xStream.alias("WikiNode", WikiNodeImpl.class);
        this._xStream.alias("WikiPage", WikiPageImpl.class);
        this._xStream.omitField(HashMap.class, "cache_bitmask");
    }

    protected boolean isResourceMain(ClassedModel classedModel) {
        if (classedModel instanceof ResourcedModel) {
            ResourcedModel resourcedModel = (ResourcedModel)classedModel;
            return resourcedModel.isResourceMain();
        }
        return true;
    }
}

