/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.StagingLocalServiceUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionalCallableUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class LayoutStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(LayoutStagingBackgroundTaskExecutor.class);
    private TransactionAttribute _transactionAttribute = TransactionAttributeBuilder.build(Propagation.REQUIRED, new Class[]{Exception.class}, new Class[0]);

    public LayoutStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)taskContextMap, (String)"targetGroupId");
        StagingUtil.lockGroup((long)userId, (long)targetGroupId);
        long sourceGroupId = MapUtil.getLong((Map)taskContextMap, (String)"sourceGroupId");
        this.clearBackgroundTaskStatus(backgroundTask);
        MissingReferences missingReferences = null;
        try {
            try {
                LayoutStagingCallable layoutStagingCallable = new LayoutStagingCallable(backgroundTask, sourceGroupId, targetGroupId, taskContextMap, userId);
                missingReferences = TransactionalCallableUtil.call(this._transactionAttribute, layoutStagingCallable);
            }
            catch (Throwable t) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)t, t);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to publish layout: " + t.getMessage()));
                }
                Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
                if (sourceGroup.hasStagingGroup()) {
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setUserId(userId);
                    StagingLocalServiceUtil.disableStaging((Group)sourceGroup, (ServiceContext)serviceContext);
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new SystemException(t);
            }
        }
        finally {
            StagingUtil.unlockGroup((long)targetGroupId);
        }
        return this.processMissingReferences(backgroundTask, missingReferences);
    }

    protected void initLayoutSetBranches(long userId, long sourceGroupId, long targetGroupId) throws Exception {
        Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
        if (!sourceGroup.hasStagingGroup()) {
            return;
        }
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)false, (boolean)true);
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)true, (boolean)true);
        UnicodeProperties typeSettingsProperties = sourceGroup.getTypeSettingsProperties();
        boolean branchingPrivate = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate"));
        boolean branchingPublic = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        StagingLocalServiceUtil.checkDefaultLayoutSetBranches((long)userId, (Group)sourceGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (boolean)false, (ServiceContext)serviceContext);
    }

    private class LayoutStagingCallable
    implements Callable<MissingReferences> {
        private BackgroundTask _backgroundTask;
        private long _sourceGroupId;
        private long _targetGroupId;
        private Map<String, Serializable> _taskContextMap;
        private long _userId;

        private LayoutStagingCallable(BackgroundTask backgroundTask, long sourceGroupId, long targetGroupId, Map<String, Serializable> taskContextMap, long userId) {
            this._backgroundTask = backgroundTask;
            this._sourceGroupId = sourceGroupId;
            this._targetGroupId = targetGroupId;
            this._taskContextMap = taskContextMap;
            this._userId = userId;
        }

        @Override
        public MissingReferences call() throws Exception {
            File file = null;
            MissingReferences missingReferences = null;
            try {
                boolean privateLayout = MapUtil.getBoolean(this._taskContextMap, (String)"privateLayout");
                long[] layoutIds = GetterUtil.getLongValues((Object)this._taskContextMap.get("layoutIds"));
                Map parameterMap = (Map)((Object)this._taskContextMap.get("parameterMap"));
                Date startDate = (Date)this._taskContextMap.get("startDate");
                Date endDate = (Date)this._taskContextMap.get("endDate");
                file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)this._sourceGroupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)startDate, (Date)endDate);
                this._backgroundTask = LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTask, "exported");
                missingReferences = LayoutLocalServiceUtil.validateImportLayoutsFile((long)this._userId, (long)this._targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
                this._backgroundTask = LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTask, "validated");
                LayoutLocalServiceUtil.importLayouts((long)this._userId, (long)this._targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
                LayoutStagingBackgroundTaskExecutor.this.initLayoutSetBranches(this._userId, this._sourceGroupId, this._targetGroupId);
                boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
                if (updateLastPublishDate) {
                    Group sourceGroup = GroupLocalServiceUtil.getGroup((long)this._sourceGroupId);
                    if (!sourceGroup.hasStagingGroup()) {
                        StagingUtil.updateLastPublishDate((long)this._sourceGroupId, (boolean)privateLayout, (Date)endDate);
                    } else {
                        StagingUtil.updateLastPublishDate((long)this._targetGroupId, (boolean)privateLayout, (Date)endDate);
                    }
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
            FileUtil.delete((File)file);
            return missingReferences;
        }
    }
}

