/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.PortletStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class PortletStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    public PortletStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new PortletStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long userId = MapUtil.getLong((Map)taskContextMap, (String)"userId");
        long targetPlid = MapUtil.getLong((Map)taskContextMap, (String)"targetPlid");
        long targetGroupId = MapUtil.getLong((Map)taskContextMap, (String)"targetGroupId");
        String portletId = MapUtil.getString((Map)taskContextMap, (String)"portletId");
        Map parameterMap = (Map)taskContextMap.get("parameterMap");
        long sourcePlid = MapUtil.getLong((Map)taskContextMap, (String)"sourcePlid");
        long sourceGroupId = MapUtil.getLong((Map)taskContextMap, (String)"sourceGroupId");
        Date startDate = (Date)taskContextMap.get("startDate");
        Date endDate = (Date)taskContextMap.get("endDate");
        File larFile = LayoutLocalServiceUtil.exportPortletInfoAsFile((long)sourcePlid, (long)sourceGroupId, (String)portletId, (Map)parameterMap, (Date)startDate, (Date)endDate);
        backgroundTask = this.markBackgroundTask(backgroundTask, "exported");
        MissingReferences missingReferences = null;
        try {
            missingReferences = LayoutLocalServiceUtil.validateImportPortletInfo((long)userId, (long)targetPlid, (long)targetGroupId, (String)portletId, (Map)parameterMap, (File)larFile);
            backgroundTask = this.markBackgroundTask(backgroundTask, "validated");
            LayoutLocalServiceUtil.importPortletInfo((long)userId, (long)targetPlid, (long)targetGroupId, (String)portletId, (Map)parameterMap, (File)larFile);
        }
        finally {
            larFile.delete();
        }
        return this.processMissingReferences(backgroundTask, missingReferences);
    }
}

