/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portletfilerepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepository;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryThreadLocal;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLAppHelperThreadLocal;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@DoPrivileged
public class PortletFileRepositoryImpl
implements PortletFileRepository {
    public void addPortletFileEntries(long groupId, long userId, String className, long classPK, String portletId, long folderId, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException, SystemException {
        int i2 = 0;
        while (i2 < inputStreamOVPs.size()) {
            ObjectValuePair<String, InputStream> inputStreamOVP = inputStreamOVPs.get(i2);
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            String fileName = (String)inputStreamOVP.getKey();
            this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, inputStream, fileName, "", true);
            ++i2;
        }
    }

    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, File file, String fileName, String mimeType, boolean indexingEnabled) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return null;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this.addPortletRepository(groupId, portletId, serviceContext);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        serviceContext.setIndexingEnabled(indexingEnabled);
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            mimeType = MimeTypesUtil.getContentType((File)file, (String)fileName);
        }
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        boolean fileMaxSizeCheckEnabled = PortletFileRepositoryThreadLocal.isFileMaxSizeCheckEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            if (portletId != null && portletId.equals("189")) {
                PortletFileRepositoryThreadLocal.setFileMaxSizeCheckEnabled((boolean)false);
            }
            FileEntry fileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)repository.getRepositoryId(), (long)folderId, (String)fileName, (String)mimeType, (String)fileName, (String)"", (String)"", (File)file, (ServiceContext)serviceContext);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
            PortletFileRepositoryThreadLocal.setFileMaxSizeCheckEnabled((boolean)fileMaxSizeCheckEnabled);
        }
    }

    public FileEntry addPortletFileEntry(long groupId, long userId, String className, long classPK, String portletId, long folderId, InputStream inputStream, String fileName, String mimeType, boolean indexingEnabled) throws PortalException, SystemException {
        if (inputStream == null) {
            return null;
        }
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            FileEntry fileEntry = this.addPortletFileEntry(groupId, userId, className, classPK, portletId, folderId, file, fileName, mimeType, indexingEnabled);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public Folder addPortletFolder(long userId, long repositoryId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            Folder folder = DLAppLocalServiceUtil.getFolder((long)repositoryId, (long)parentFolderId, (String)folderName);
            return folder;
        }
        catch (NoSuchFolderException noSuchFolderException) {
            Folder folder = DLAppLocalServiceUtil.addFolder((long)userId, (long)repositoryId, (long)parentFolderId, (String)folderName, (String)"", (ServiceContext)serviceContext);
            return folder;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public Repository addPortletRepository(long groupId, String portletId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
        if (repository != null) {
            return repository;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        User user = UserLocalServiceUtil.getDefaultUser((long)group.getCompanyId());
        long classNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            Repository repository2 = RepositoryLocalServiceUtil.addRepository((long)user.getUserId(), (long)groupId, (long)classNameId, (long)0L, (String)portletId, (String)"", (String)portletId, (UnicodeProperties)typeSettingsProperties, (boolean)true, (ServiceContext)serviceContext);
            return repository2;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            DLAppLocalServiceUtil.deleteFolder((long)folderId);
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public void deletePortletFileEntries(long groupId, long folderId) throws PortalException, SystemException {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((long)groupId, (long)folderId);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.deletePortletFileEntry(dlFileEntry.getFileEntryId());
        }
    }

    public void deletePortletFileEntries(long groupId, long folderId, int status) throws PortalException, SystemException {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((long)groupId, (long)folderId, (int)status, (int)-1, (int)-1, null);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.deletePortletFileEntry(dlFileEntry.getFileEntryId());
        }
    }

    public void deletePortletFileEntry(long fileEntryId) throws PortalException, SystemException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            DLAppLocalServiceUtil.deleteFileEntry((long)fileEntryId);
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public void deletePortletFileEntry(long groupId, long folderId, String fileName) throws PortalException, SystemException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        this.deletePortletFileEntry(fileEntry.getFileEntryId());
    }

    public void deletePortletRepository(long groupId, String portletId) throws PortalException, SystemException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
        if (repository != null) {
            RepositoryLocalServiceUtil.deleteRepository((long)repository.getRepositoryId());
        }
    }

    public Repository fetchPortletRepository(long groupId, String portletId) throws SystemException {
        return RepositoryLocalServiceUtil.fetchRepository((long)groupId, (String)portletId);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId) throws SystemException {
        return this.toFileEntries(DLFileEntryLocalServiceUtil.getFileEntries((long)groupId, (long)folderId));
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status) throws SystemException {
        return this.getPortletFileEntries(groupId, folderId, status, -1, -1, null);
    }

    public List<FileEntry> getPortletFileEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        return this.toFileEntries(DLFileEntryLocalServiceUtil.getFileEntries((long)groupId, (long)folderId, (int)status, (int)start, (int)end, (OrderByComparator)obc));
    }

    public int getPortletFileEntriesCount(long groupId, long folderId) throws SystemException {
        return DLFileEntryLocalServiceUtil.getFileEntriesCount((long)groupId, (long)folderId);
    }

    public int getPortletFileEntriesCount(long groupId, long folderId, int status) throws SystemException {
        return DLFileEntryLocalServiceUtil.getFileEntriesCount((long)groupId, (long)folderId, (int)status);
    }

    public FileEntry getPortletFileEntry(long fileEntryId) throws PortalException, SystemException {
        return DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
    }

    public FileEntry getPortletFileEntry(long groupId, long folderId, String fileName) throws PortalException, SystemException {
        return DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
    }

    public FileEntry getPortletFileEntry(String uuid, long groupId) throws PortalException, SystemException {
        return DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString) {
        return this.getPortletFileEntryURL(themeDisplay, fileEntry, queryString, true);
    }

    public String getPortletFileEntryURL(ThemeDisplay themeDisplay, FileEntry fileEntry, String queryString, boolean absoluteURL) {
        String portletId;
        PortletDisplay portletDisplay;
        StringBundler sb = new StringBundler(10);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(PortalUtil.getPathContext());
        sb.append("/documents/");
        sb.append("portlet_file_entry");
        sb.append("/");
        sb.append(fileEntry.getGroupId());
        sb.append("/");
        String title = fileEntry.getTitle();
        if (fileEntry.isInTrash()) {
            title = TrashUtil.getOriginalTitle((String)fileEntry.getTitle());
        }
        sb.append(HttpUtil.encodeURL((String)HtmlUtil.unescape((String)title)));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        if (themeDisplay != null && (portletDisplay = themeDisplay.getPortletDisplay()) != null && (portletId = portletDisplay.getId()).equals("182") && !queryString.contains("status=")) {
            if (Validator.isNotNull((String)queryString)) {
                queryString = String.valueOf(queryString) + "&";
            }
            queryString = String.valueOf(queryString) + "status=8";
        }
        if (Validator.isNotNull((String)queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        String portletFileEntryURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return PortalUtil.getURLWithSessionId((String)portletFileEntryURL, (String)themeDisplay.getSessionId());
        }
        return portletFileEntryURL;
    }

    public Folder getPortletFolder(long folderId) throws PortalException, SystemException {
        return DLAppLocalServiceUtil.getFolder((long)folderId);
    }

    public Folder getPortletFolder(long repositoryId, long parentFolderId, String folderName) throws PortalException, SystemException {
        return DLAppLocalServiceUtil.getFolder((long)repositoryId, (long)parentFolderId, (String)folderName);
    }

    public Repository getPortletRepository(long groupId, String portletId) throws PortalException, SystemException {
        return RepositoryLocalServiceUtil.getRepository((long)groupId, (String)portletId);
    }

    public FileEntry movePortletFileEntryToTrash(long userId, long fileEntryId) throws PortalException, SystemException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            FileEntry fileEntry = DLAppLocalServiceUtil.moveFileEntryToTrash((long)userId, (long)fileEntryId);
            return fileEntry;
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public FileEntry movePortletFileEntryToTrash(long groupId, long userId, long folderId, String fileName) throws PortalException, SystemException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        return this.movePortletFileEntryToTrash(userId, fileEntry.getFileEntryId());
    }

    public void restorePortletFileEntryFromTrash(long userId, long fileEntryId) throws PortalException, SystemException {
        boolean dlAppHelperEnabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            DLAppLocalServiceUtil.restoreFileEntryFromTrash((long)userId, (long)fileEntryId);
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)dlAppHelperEnabled);
        }
    }

    public void restorePortletFileEntryFromTrash(long groupId, long userId, long folderId, String fileName) throws PortalException, SystemException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        this.restorePortletFileEntryFromTrash(userId, fileEntry.getFileEntryId());
    }

    protected List<FileEntry> toFileEntries(List<DLFileEntry> dlFileEntries) {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>(dlFileEntries.size());
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            fileEntries.add(fileEntry);
        }
        if (dlFileEntries instanceof UnmodifiableList) {
            return new UnmodifiableList(fileEntries);
        }
        return fileEntries;
    }
}

