/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryBase;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portal.service.RepositoryService;
import com.liferay.portal.service.ResourceLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionService;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalService;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import com.liferay.portlet.documentlibrary.util.DLSearcher;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class LiferayRepository
extends LiferayRepositoryBase
implements Repository {
    private static Log _log = LogFactoryUtil.getLog(LiferayRepository.class);

    public LiferayRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long repositoryId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileEntryTypeLocalService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, resourceLocalService, repositoryId);
    }

    public LiferayRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long folderId, long fileEntryId, long fileVersionId) throws PrincipalException {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileEntryTypeLocalService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, resourceLocalService, folderId, fileEntryId, fileVersionId);
    }

    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryService.addFileEntry(this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryService.addFileEntry(this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder addFolder(long parentFolderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean mountPoint = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"mountPoint");
        DLFolder dlFolder = this.dlFolderService.addFolder(this.getGroupId(), this.getRepositoryId(), mountPoint, this.toFolderId(parentFolderId), title, description, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException, SystemException {
        DLFileVersion dlFileVersion = this.dlFileEntryService.cancelCheckOut(fileEntryId);
        if (dlFileVersion != null) {
            return new LiferayFileVersion(dlFileVersion);
        }
        return null;
    }

    public void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws PortalException, SystemException {
        this.dlFileEntryService.checkInFileEntry(fileEntryId, major, changeLog, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        this.checkInFileEntry(fileEntryId, lockUuid, new ServiceContext());
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException, SystemException {
        this.dlFileEntryService.checkInFileEntry(fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.checkOutFileEntry(fileEntryId, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry copyFileEntry(long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.copyFileEntry(groupId, this.getRepositoryId(), fileEntryId, destFolderId, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        this.dlFileEntryService.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntry(long folderId, String title) throws PortalException, SystemException {
        this.dlFileEntryService.deleteFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException, SystemException {
        this.dlFileEntryService.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        this.dlFolderService.deleteFolder(folderId);
    }

    public void deleteFolder(long parentFolderId, String title) throws PortalException, SystemException {
        this.dlFolderService.deleteFolder(this.getGroupId(), this.toFolderId(parentFolderId), title);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), fileEntryTypeId, start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryService.getFileEntries(this.getGroupId(), this.toFolderId(folderId), mimeTypes, start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException, SystemException {
        List dlFileEntriesAndFileShortcuts = this.dlFolderService.getFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, start, end);
        return this.toFileEntriesAndFolders(dlFileEntriesAndFileShortcuts);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException, SystemException {
        return this.dlFolderService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException, SystemException {
        return this.dlFolderService.getFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes);
    }

    public int getFileEntriesCount(long folderId) throws SystemException {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId));
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws SystemException {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), this.toFolderId(folderId), fileEntryTypeId);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws SystemException {
        return this.dlFileEntryService.getFileEntriesCount(this.getGroupId(), folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntry(fileEntryId);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntryByUuidAndGroupId(uuid, this.getGroupId());
        return new LiferayFileEntry(dlFileEntry);
    }

    public Lock getFileEntryLock(long fileEntryId) {
        return this.dlFileEntryService.getFileEntryLock(fileEntryId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException, SystemException {
        DLFileVersion dlFileVersion = this.dlFileVersionService.getFileVersion(fileVersionId);
        return new LiferayFileVersion(dlFileVersion);
    }

    public Folder getFolder(long folderId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderService.getFolder(this.toFolderId(folderId));
        return new LiferayFolder(dlFolder);
    }

    public Folder getFolder(long parentFolderId, String title) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderService.getFolder(this.getGroupId(), this.toFolderId(parentFolderId), title);
        return new LiferayFolder(dlFolder);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        return this.getFolders(parentFolderId, 0, includeMountfolders, start, end, obc);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFolders = this.dlFolderService.getFolders(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders, start, end, obc);
        return this.toFolders(dlFolders);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFoldersAndFileEntriesAndFileShortcuts = this.dlFolderService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders, start, end, obc);
        return this.toFileEntriesAndFolders(dlFoldersAndFileEntriesAndFileShortcuts);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFoldersAndFileEntriesAndFileShortcuts = this.dlFolderService.getFoldersAndFileEntriesAndFileShortcuts(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes, includeMountFolders, start, end, obc);
        return this.toFileEntriesAndFolders(dlFoldersAndFileEntriesAndFileShortcuts);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException, SystemException {
        return this.dlFolderService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException, SystemException {
        return this.dlFolderService.getFoldersAndFileEntriesAndFileShortcutsCount(this.getGroupId(), this.toFolderId(folderId), status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException, SystemException {
        return this.getFoldersCount(parentFolderId, 0, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException, SystemException {
        return this.dlFolderService.getFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId), status, includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws SystemException {
        return this.dlFileEntryService.getFoldersFileEntriesCount(this.getGroupId(), this.toFolderIds(folderIds), status);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFolders = this.dlFolderService.getMountFolders(this.getGroupId(), this.toFolderId(parentFolderId), start, end, obc);
        return this.toFolders(dlFolders);
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException, SystemException {
        return this.dlFolderService.getMountFoldersCount(this.getGroupId(), this.toFolderId(parentFolderId));
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryService.getGroupFileEntries(this.getGroupId(), userId, this.toFolderId(rootFolderId), start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        List dlFileEntries = this.dlFileEntryService.getGroupFileEntries(this.getGroupId(), userId, this.toFolderId(rootFolderId), mimeTypes, status, start, end, obc);
        return this.toFileEntries(dlFileEntries);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException, SystemException {
        return this.dlFileEntryService.getGroupFileEntriesCount(this.getGroupId(), userId, this.toFolderId(rootFolderId));
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException, SystemException {
        return this.dlFileEntryService.getGroupFileEntriesCount(this.getGroupId(), userId, this.toFolderId(rootFolderId), mimeTypes, status);
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException, SystemException {
        this.dlFolderService.getSubfolderIds(folderIds, this.getGroupId(), this.toFolderId(folderId));
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException, SystemException {
        return this.dlFolderService.getSubfolderIds(this.getGroupId(), this.toFolderId(folderId), recurse);
    }

    public Lock lockFileEntry(long fileEntryId) throws PortalException, SystemException {
        FileEntry fileEntry = this.checkOutFileEntry(fileEntryId, new ServiceContext());
        return fileEntry.getLock();
    }

    public Lock lockFileEntry(long fileEntryId, String owner, long expirationTime) throws PortalException, SystemException {
        FileEntry fileEntry = this.checkOutFileEntry(fileEntryId, owner, expirationTime, new ServiceContext());
        return fileEntry.getLock();
    }

    public Lock lockFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderService.lockFolder(this.toFolderId(folderId));
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        return this.dlFolderService.lockFolder(this.toFolderId(folderId), owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryService.moveFileEntry(fileEntryId, this.toFolderId(newFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderService.moveFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException, SystemException {
        return this.dlFileEntryService.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException, SystemException {
        return this.dlFolderService.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        this.dlFileEntryService.revertFileEntry(fileEntryId, version, serviceContext);
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        return this.dlFileEntryService.search(this.getGroupId(), creatorUserId, status, start, end);
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException, SystemException {
        return this.dlFileEntryService.search(this.getGroupId(), creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        Indexer indexer = DLSearcher.getInstance();
        searchContext.setSearchEngineId(indexer.getSearchEngineId());
        return indexer.search(searchContext);
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return SearchEngineUtil.search((SearchContext)searchContext, (Query)query);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException, SystemException {
        this.dlFolderService.unlockFolder(this.toFolderId(folderId), lockUuid);
    }

    public void unlockFolder(long parentFolderId, String title, String lockUuid) throws PortalException, SystemException {
        this.dlFolderService.unlockFolder(this.getGroupId(), this.toFolderId(parentFolderId), title, lockUuid);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryService.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder updateFolder(long folderId, String title, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        long defaultFileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        boolean overrideFileEntryTypes = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"overrideFileEntryTypes");
        DLFolder dlFolder = this.dlFolderService.updateFolder(this.toFolderId(folderId), title, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        return this.dlFileEntryService.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        return this.dlFileEntryService.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException, SystemException {
        return this.dlFolderService.verifyInheritableLock(this.toFolderId(folderId), lockUuid);
    }

    @Override
    protected void initByFileEntryId(long fileEntryId) throws PrincipalException {
        block4: {
            try {
                DLFileEntry dlFileEntry = this.dlFileEntryService.getFileEntry(fileEntryId);
                this.initByRepositoryId(dlFileEntry.getRepositoryId());
            }
            catch (PrincipalException pe) {
                throw pe;
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block4;
                if (e2 instanceof NoSuchFileEntryException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByFileVersionId(long fileVersionId) throws PrincipalException {
        block4: {
            try {
                DLFileVersion dlFileVersion = this.dlFileVersionService.getFileVersion(fileVersionId);
                this.initByRepositoryId(dlFileVersion.getRepositoryId());
            }
            catch (PrincipalException pe) {
                throw pe;
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block4;
                if (e2 instanceof NoSuchFileVersionException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByFolderId(long folderId) throws PrincipalException {
        block4: {
            try {
                DLFolder dlFolder = this.dlFolderService.getFolder(folderId);
                this.initByRepositoryId(dlFolder.getRepositoryId());
            }
            catch (PrincipalException pe) {
                throw pe;
            }
            catch (Exception e2) {
                if (!_log.isTraceEnabled()) break block4;
                if (e2 instanceof NoSuchFolderException) {
                    _log.trace((Object)e2.getMessage());
                }
                _log.trace((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    protected void initByRepositoryId(long repositoryId) {
        this.setGroupId(repositoryId);
        this.setRepositoryId(repositoryId);
        try {
            com.liferay.portal.model.Repository repository = this.repositoryService.getRepository(repositoryId);
            this.setDlFolderId(repository.getDlFolderId());
            this.setGroupId(repository.getGroupId());
            this.setRepositoryId(repository.getRepositoryId());
        }
        catch (Exception exception) {}
    }
}

