/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Tokenizer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Fieldable;

public class PerFieldAnalyzer
extends Analyzer
implements Tokenizer {
    private static Log _log = LogFactoryUtil.getLog(PerFieldAnalyzer.class);
    private Analyzer _analyzer;
    private Map<String, Analyzer> _analyzers = new HashMap<String, Analyzer>();

    public PerFieldAnalyzer(Analyzer defaultAnalyzer, Map<String, Analyzer> analyzerMap) {
        this._analyzer = defaultAnalyzer;
        this._analyzers = analyzerMap;
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        this._analyzers.put(fieldName, analyzer);
    }

    public Analyzer getAnalyzer(String fieldName) {
        Analyzer analyzer = this._analyzers.get(fieldName);
        if (analyzer != null) {
            return analyzer;
        }
        for (String key : this._analyzers.keySet()) {
            if (!Pattern.matches(key, fieldName)) continue;
            return this._analyzers.get(key);
        }
        return this._analyzer;
    }

    public int getOffsetGap(Fieldable field) {
        Analyzer analyzer = this.getAnalyzer(field.name());
        return analyzer.getOffsetGap(field);
    }

    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.reusableTokenStream(fieldName, reader);
    }

    public List<String> tokenize(String fieldName, String input, String languageId) throws SearchException {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream tokenStream = null;
        try {
            try {
                String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)fieldName);
                Analyzer analyzer = this.getAnalyzer(localizedFieldName);
                tokenStream = analyzer.tokenStream(localizedFieldName, (Reader)new StringReader(input));
                CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    tokens.add(charTermAttribute.toString());
                }
                tokenStream.end();
            }
            catch (IOException ioe) {
                throw new SearchException((Throwable)ioe);
            }
        }
        finally {
            block12: {
                if (tokenStream != null) {
                    try {
                        tokenStream.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)"Unable to close token stream", (Throwable)ioe);
                    }
                }
            }
        }
        return tokens;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.tokenStream(fieldName, reader);
    }
}

