/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.AuthSettingsUtil;
import com.liferay.portal.security.ldap.LDAPOperation;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.Modifications;
import com.liferay.portal.security.ldap.PortalLDAPContext;
import com.liferay.portal.security.ldap.PortalLDAPExporter;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.ldap.PortalToLDAPConverter;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.NameNotFoundException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;
import javax.naming.ldap.LdapContext;

@DoPrivileged
public class PortalLDAPExporterImpl
implements PortalLDAPExporter {
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPExporterImpl.class);
    private PortalToLDAPConverter _portalToLDAPConverter;

    public void exportToLDAP(Contact contact, Map<String, Serializable> contactExpandoAttributes) throws Exception {
        long companyId = contact.getCompanyId();
        if (!AuthSettingsUtil.isLDAPAuthEnabled(companyId) || !LDAPSettingsUtil.isExportEnabled(companyId)) {
            return;
        }
        User user = UserLocalServiceUtil.getUserByContactId((long)contact.getContactId());
        if (user.isDefaultUser() || user.getStatus() != 0) {
            return;
        }
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        try {
            if (ldapContext == null) {
                return;
            }
            Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
            Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, contact.getCompanyId(), user.getScreenName(), user.getEmailAddress());
            if (binding == null) {
                Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
                binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
            }
            CompositeName name = new CompositeName();
            name.add(PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications modifications = this._portalToLDAPConverter.getLDAPContactModifications(contact, contactExpandoAttributes, contactMappings, contactExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public void exportToLDAP(long userId, long userGroupId, LDAPOperation ldapOperation) throws Exception {
        User user = UserLocalServiceUtil.getUser((long)userId);
        long companyId = user.getCompanyId();
        if (!(AuthSettingsUtil.isLDAPAuthEnabled(companyId) && LDAPSettingsUtil.isExportEnabled(companyId) && LDAPSettingsUtil.isExportGroupEnabled(companyId))) {
            return;
        }
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupId);
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
        Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
        Binding binding = PortalLDAPUtil.getGroup(ldapServerId, companyId, userGroup.getName());
        try {
            if (binding == null) {
                if (ldapOperation == LDAPOperation.ADD) {
                    this.addGroup(ldapServerId, ldapContext, userGroup, user, groupMappings, userMappings);
                }
                return;
            }
            try {
                CompositeName name = new CompositeName();
                name.add(PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                Modifications modifications = this._portalToLDAPConverter.getLDAPGroupModifications(ldapServerId, userGroup, user, groupMappings, userMappings, ldapOperation);
                ModificationItem[] modificationItems = modifications.getItems();
                ldapContext.modifyAttributes(name, modificationItems);
            }
            catch (SchemaViolationException schemaViolationException) {
                String fullGroupDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding);
                Attributes attributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN, true);
                Attribute groupMembers = attributes.get(groupMappings.getProperty("user"));
                if (groupMembers != null && groupMembers.size() == 1) {
                    ldapContext.unbind(fullGroupDN);
                }
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public void exportToLDAP(User user, Map<String, Serializable> userExpandoAttributes) throws Exception {
        if (user.isDefaultUser() || user.getStatus() != 0) {
            return;
        }
        long companyId = user.getCompanyId();
        if (!AuthSettingsUtil.isLDAPAuthEnabled(companyId) || !LDAPSettingsUtil.isExportEnabled(companyId)) {
            return;
        }
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, user.getScreenName(), user.getEmailAddress());
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        try {
            if (ldapContext == null) {
                return;
            }
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress(), true);
            if (binding == null) {
                binding = this.addUser(ldapServerId, ldapContext, user, userMappings);
            }
            CompositeName name = new CompositeName();
            name.add(PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications modifications = this._portalToLDAPConverter.getLDAPUserModifications(user, userExpandoAttributes, userMappings, userExpandoMappings);
            if (modifications == null) {
                return;
            }
            ModificationItem[] modificationItems = modifications.getItems();
            ldapContext.modifyAttributes(name, modificationItems);
            if (!LDAPSettingsUtil.isExportGroupEnabled(companyId)) {
                return;
            }
            try {
                List userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)user.getUserId());
                for (UserGroup userGroup : userGroups) {
                    this.exportToLDAP(user.getUserId(), userGroup.getUserGroupId(), LDAPOperation.ADD);
                }
                Modifications groupModifications = this._portalToLDAPConverter.getLDAPUserGroupModifications(ldapServerId, userGroups, user, userMappings);
                ModificationItem[] groupModificationItems = groupModifications.getItems();
                if (groupModificationItems.length > 0) {
                    ldapContext.modifyAttributes(name, groupModificationItems);
                }
            }
            catch (NameNotFoundException nnfe) {
                if (PrefsPropsUtil.getBoolean(companyId, "ldap.auth.required")) {
                    throw nnfe;
                }
                _log.error((Object)nnfe, (Throwable)nnfe);
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public void setPortalToLDAPConverter(PortalToLDAPConverter portalToLDAPConverter) {
        this._portalToLDAPConverter = portalToLDAPConverter;
    }

    protected Binding addGroup(long ldapServerId, LdapContext ldapContext, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getGroupDNName(ldapServerId, userGroup, groupMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPGroupAttributes(ldapServerId, userGroup, user, groupMappings, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        Binding binding = PortalLDAPUtil.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
        return binding;
    }

    protected Binding addUser(long ldapServerId, LdapContext ldapContext, User user, Properties userMappings) throws Exception {
        CompositeName name = new CompositeName();
        name.add(this._portalToLDAPConverter.getUserDNName(ldapServerId, user, userMappings));
        Attributes attributes = this._portalToLDAPConverter.getLDAPUserAttributes(ldapServerId, user, userMappings);
        ldapContext.bind(name, (Object)new PortalLDAPContext(attributes));
        Binding binding = PortalLDAPUtil.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
        return binding;
    }
}

