/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.scheduler.CronTrigger;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portal.messaging.LayoutsRemotePublisherRequest;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, serviceContext);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, friendlyURLMap, serviceContext);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileUtil.addTempFile((long)groupId, (long)this.getUserId(), (String)fileName, (String)tempFolderName, (InputStream)inputStream, (String)mimeType);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"DELETE");
        this.layoutLocalService.deleteLayout(plid, serviceContext);
    }

    public void deleteTempFileEntry(long groupId, String fileName, String tempFolderName) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        TempFileUtil.deleteTempFile((long)groupId, (long)this.getUserId(), (String)fileName, (String)tempFolderName);
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, parameterMap, startDate, endDate);
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public long exportLayoutsAsFileInBackground(String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFileInBackground(this.getUserId(), taskName, groupId, privateLayout, layoutIds, parameterMap, startDate, endDate, fileName);
    }

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfo(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    public byte[] exportPortletInfo(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfo(companyId, portletId, parameterMap, startDate, endDate);
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    public File exportPortletInfoAsFile(String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFile(user.getCompanyId(), portletId, parameterMap, startDate, endDate);
    }

    public long exportPortletInfoAsFileInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFileInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, startDate, endDate, fileName);
    }

    public long exportPortletInfoAsFileInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFileInBackground(this.getUserId(), taskName, portletId, parameterMap, startDate, endDate, fileName);
    }

    public List<Layout> getAncestorLayouts(long plid) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        List ancestors = layout.getAncestors();
        return this.filterLayouts(ancestors);
    }

    public long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        if (groupId <= 0L) {
            return 0L;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        String scopeGroupLayoutUuid = null;
        Group scopeGroup = this.groupLocalService.getGroup(scopeGroupId);
        if (scopeGroup.isLayout()) {
            Layout scopeGroupLayout = this.layoutLocalService.getLayout(scopeGroup.getClassPK());
            scopeGroupLayoutUuid = scopeGroupLayout.getUuid();
        }
        Map jxPortletPreferencesMap = PortletPreferencesFactoryUtil.getPortletSetupMap((long)scopeGroup.getCompanyId(), (long)groupId, (long)0L, (int)3, (String)portletId, (boolean)privateLayout);
        for (Map.Entry entry : jxPortletPreferencesMap.entrySet()) {
            LayoutTypePortlet layoutTypePortlet;
            long plid = (Long)entry.getKey();
            Layout layout = null;
            try {
                layout = this.layoutLocalService.getLayout(plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                continue;
            }
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW") || !layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
            PortletPreferences jxPortletPreferences = (PortletPreferences)entry.getValue();
            String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
            if (scopeGroup.isLayout()) {
                String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                if (!Validator.isNotNull((String)scopeType) || !Validator.isNotNull((String)scopeLayoutUuid) || !scopeLayoutUuid.equals(scopeGroupLayoutUuid)) continue;
                return layout.getPlid();
            }
            if (!(scopeGroup.isCompany() ? Validator.isNotNull((String)scopeType) && scopeType.equals("company") : Validator.isNull((String)scopeType))) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    @ThreadLocalCachable
    public long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws PortalException, SystemException {
        long plid = this.getDefaultPlid(groupId, scopeGroupId, false, portletId);
        if (plid == 0L) {
            plid = this.getDefaultPlid(groupId, scopeGroupId, true, portletId);
        }
        return plid;
    }

    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout;
    }

    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        return layout.getName(languageId);
    }

    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        return this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutPersistence.filterFindByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.filterFindByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws SystemException {
        return this.layoutPersistence.filterFindByG_P_P(groupId, privateLayout, parentLayoutId, start, end);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.filterCountByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public String[] getTempFileEntryNames(long groupId, String tempFolderName) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileUtil.getTempFileEntryNames((long)groupId, (long)this.getUserId(), (String)tempFolderName);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, bytes);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, file);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, is);
    }

    public long importLayoutsInBackground(String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.importLayoutsInBackground(this.getUserId(), taskName, groupId, privateLayout, parameterMap, file);
    }

    public long importLayoutsInBackground(String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.importLayoutsInBackground(this.getUserId(), taskName, groupId, privateLayout, parameterMap, inputStream);
    }

    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, file);
    }

    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, is);
    }

    public void importPortletInfo(String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), portletId, parameterMap, file);
    }

    public void importPortletInfo(String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), portletId, parameterMap, is);
    }

    public long importPortletInfoInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, file);
    }

    public long importPortletInfoInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, is);
    }

    public void importPortletInfoInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, portletId, parameterMap, file);
    }

    public void importPortletInfoInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)companyGroup.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, portletId, parameterMap, is);
    }

    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"PUBLISH_STAGING");
        String jobName = PortalUUIDUtil.generate();
        CronTrigger trigger = new CronTrigger(jobName, groupName, schedulerStartDate, schedulerEndDate, cronText);
        String command = "";
        if (scope.equals("all-pages")) {
            command = "ALL_PAGES";
        } else if (scope.equals("selected-pages")) {
            command = "SELECTED_PAGES";
        }
        LayoutsLocalPublisherRequest publisherRequest = new LayoutsLocalPublisherRequest(command, this.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_local_publisher", (Object)publisherRequest, (int)0);
    }

    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"PUBLISH_STAGING");
        LayoutsRemotePublisherRequest publisherRequest = new LayoutsRemotePublisherRequest(this.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate);
        String jobName = PortalUUIDUtil.generate();
        CronTrigger trigger = new CronTrigger(jobName, groupName, schedulerStartDate, schedulerEndDate, cronText);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_remote_publisher", (Object)publisherRequest, (int)0);
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
    }

    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, iconImage, iconBytes, serviceContext);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        if (Validator.isNotNull((String)themeId)) {
            this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        }
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme);
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException, SystemException {
        return this.layoutLocalService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(plid, priority);
    }

    public MissingReferences validateImportLayoutsFile(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(this.getUserId(), groupId, privateLayout, parameterMap, file);
    }

    public MissingReferences validateImportLayoutsFile(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(this.getUserId(), groupId, privateLayout, parameterMap, inputStream);
    }

    public MissingReferences validateImportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, file);
    }

    public MissingReferences validateImportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException, SystemException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, inputStream);
    }

    protected List<Layout> filterLayouts(List<Layout> layouts) throws PortalException, SystemException {
        ArrayList<Layout> filteredLayouts = new ArrayList<Layout>();
        for (Layout layout : layouts) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layout.getPlid(), (String)"VIEW")) continue;
            filteredLayouts.add(layout);
        }
        return filteredLayouts;
    }
}

