/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.aggregate;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.IgnoreModuleRequestFilter;
import com.liferay.portal.servlet.filters.aggregate.AggregateContext;
import com.liferay.portal.servlet.filters.aggregate.ServletAggregateContext;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.JavaScriptBundleUtil;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AggregateFilter
extends IgnoreModuleRequestFilter {
    private static final String _CSS_COMMENT_BEGIN = "/*";
    private static final String _CSS_COMMENT_END = "*/";
    private static final String _CSS_EXTENSION = ".css";
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _CSS_MEDIA_QUERY = "@media";
    private static final String _JAVASCRIPT_EXTENSION = ".js";
    private static final String _JSP_EXTENSION = ".jsp";
    private static final String _TEMP_DIR = "aggregate";
    private static Log _log = LogFactoryUtil.getLog(AggregateFilter.class);
    private static String _BASE_URL = "@base_url@";
    private static Pattern _pattern = Pattern.compile("^(\\.ie|\\.js\\.ie)([^}]*)}", 8);
    private ServletContext _servletContext;
    private File _tempDir;

    public static String aggregateCss(AggregateContext aggregateContext, String content) throws IOException {
        StringBundler sb = new StringBundler();
        int pos = 0;
        while (true) {
            int commentX = content.indexOf(_CSS_COMMENT_BEGIN, pos);
            int commentY = content.indexOf(_CSS_COMMENT_END, commentX + _CSS_COMMENT_BEGIN.length());
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            if (commentX != -1 && commentY != -1 && commentX < importX && commentY > importX) {
                sb.append(content.substring(pos, commentY += _CSS_COMMENT_END.length()));
                pos = commentY;
                continue;
            }
            sb.append(content.substring(pos, importX));
            String mediaQuery = "";
            int mediaQueryImportX = content.indexOf(41, importX + _CSS_IMPORT_BEGIN.length());
            int mediaQueryImportY = content.indexOf(59, importX + _CSS_IMPORT_BEGIN.length());
            String importFileName = null;
            if (importY != mediaQueryImportX) {
                mediaQuery = content.substring(mediaQueryImportX + 1, mediaQueryImportY);
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), mediaQueryImportX);
            } else {
                importFileName = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            }
            String importContent = aggregateContext.getContent(importFileName);
            if (importContent == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("File " + aggregateContext.getFullPath(importFileName) + " does not exist"));
                }
                importContent = "";
            }
            String importDirName = "";
            int slashPos = importFileName.lastIndexOf(47);
            if (slashPos != -1) {
                importDirName = importFileName.substring(0, slashPos + 1);
            }
            aggregateContext.pushPath(importDirName);
            importContent = AggregateFilter.aggregateCss(aggregateContext, importContent);
            if (Validator.isNotNull((String)importDirName)) {
                aggregateContext.popPath();
            }
            String baseURL = _BASE_URL;
            if (!(baseURL = baseURL.concat(aggregateContext.getResourcePath(""))).endsWith("/")) {
                baseURL = baseURL.concat(importDirName);
            }
            importContent = AggregateUtil.updateRelativeURLs(importContent, baseURL);
            if (Validator.isNotNull((String)mediaQuery)) {
                sb.append(_CSS_MEDIA_QUERY);
                sb.append(' ');
                sb.append(mediaQuery);
                sb.append('{');
                sb.append(importContent);
                sb.append('}');
                pos = mediaQueryImportY + 1;
                continue;
            }
            sb.append(importContent);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    public static String aggregateJavaScript(AggregateContext aggregateContext, String[] fileNames) {
        StringBundler sb = new StringBundler(fileNames.length * 2);
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String content = aggregateContext.getContent(fileName);
            if (!Validator.isNull((String)content)) {
                sb.append(content);
                sb.append("\n");
            }
            ++n2;
        }
        return AggregateFilter.getJavaScriptContent(sb.toString());
    }

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._servletContext = filterConfig.getServletContext();
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        this._tempDir = new File(tempDir, _TEMP_DIR);
        this._tempDir.mkdirs();
    }

    protected static String getJavaScriptContent(String content) {
        return MinifierUtil.minifyJavaScript(content);
    }

    protected Object getBundleContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String bundleId = ParamUtil.getString((HttpServletRequest)request, (String)"bundleId", (String)ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId"));
        if (Validator.isNull((String)minifierType) || Validator.isNull((String)bundleId) || !ArrayUtil.contains((Object[])PropsValues.JAVASCRIPT_BUNDLE_IDS, (Object)bundleId)) {
            return null;
        }
        String bundleDirName = PropsUtil.get("javascript.bundle.dir", new Filter(bundleId));
        URL bundleDirURL = this._servletContext.getResource(bundleDirName);
        if (bundleDirURL == null) {
            return null;
        }
        String cacheFileName = bundleId;
        String[] fileNames = JavaScriptBundleUtil.getFileNames(bundleId);
        File cacheFile = new File(this._tempDir, cacheFileName);
        if (cacheFile.exists()) {
            boolean staleCache = false;
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                URLConnection urlConnection;
                String fileName = stringArray[n2];
                URL resourceURL = this._servletContext.getResource(bundleDirName.concat("/").concat(fileName));
                if (resourceURL != null && (urlConnection = resourceURL.openConnection()).getLastModified() > cacheFile.lastModified()) {
                    staleCache = true;
                    break;
                }
                ++n2;
            }
            if (!staleCache) {
                response.setContentType("text/javascript");
                return cacheFile;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Aggregating JavaScript bundle " + bundleId));
        }
        String content = null;
        if (fileNames.length == 0) {
            content = "";
        } else {
            ServletAggregateContext aggregateContext = new ServletAggregateContext(this._servletContext, "/");
            aggregateContext.pushPath(bundleDirName);
            content = AggregateFilter.aggregateJavaScript(aggregateContext, fileNames);
        }
        response.setContentType("text/javascript");
        FileUtil.write((File)cacheFile, (String)content);
        return content;
    }

    protected String getCacheFileName(HttpServletRequest request) {
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)AggregateFilter.class.getName());
        cacheKeyGenerator.append(HttpUtil.getProtocol((boolean)request.isSecure()));
        cacheKeyGenerator.append("_");
        cacheKeyGenerator.append(request.getRequestURI());
        String queryString = request.getQueryString();
        if (queryString != null) {
            cacheKeyGenerator.append(this.sterilizeQueryString(queryString));
        }
        return String.valueOf(cacheKeyGenerator.finish());
    }

    protected Object getContent(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        URL resourceURL;
        String requestURI;
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        String minifierBundleId = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleId");
        String minifierBundleDirName = ParamUtil.getString((HttpServletRequest)request, (String)"minifierBundleDir");
        if (Validator.isNull((String)minifierType) || Validator.isNotNull((String)minifierBundleId) || Validator.isNotNull((String)minifierBundleDirName)) {
            return null;
        }
        String resourcePath = requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (!contextPath.equals("/")) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        if ((resourceURL = this._servletContext.getResource(resourcePath)) == null) {
            return null;
        }
        URLConnection urlConnection = resourceURL.openConnection();
        String cacheCommonFileName = this.getCacheFileName(request);
        File cacheContentTypeFile = new File(this._tempDir, String.valueOf(cacheCommonFileName) + "_E_CONTENT_TYPE");
        File cacheDataFile = new File(this._tempDir, String.valueOf(cacheCommonFileName) + "_E_DATA");
        if (cacheDataFile.exists() && cacheDataFile.lastModified() >= urlConnection.getLastModified()) {
            if (cacheContentTypeFile.exists()) {
                String contentType = FileUtil.read((File)cacheContentTypeFile);
                response.setContentType(contentType);
            }
            return cacheDataFile;
        }
        String content = null;
        if (resourcePath.endsWith(_CSS_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying CSS " + resourcePath));
            }
            content = this.getCssContent(request, response, resourceURL, resourcePath);
            response.setContentType("text/css");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/css");
        } else if (resourcePath.endsWith(_JAVASCRIPT_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JavaScript " + resourcePath));
            }
            content = this.getJavaScriptContent(resourceURL);
            response.setContentType("text/javascript");
            FileUtil.write((File)cacheContentTypeFile, (String)"text/javascript");
        } else if (resourcePath.endsWith(_JSP_EXTENSION)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Minifying JSP " + resourcePath));
            }
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            this.processFilter(AggregateFilter.class, request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
            bufferCacheServletResponse.finishResponse();
            content = bufferCacheServletResponse.getString();
            if (minifierType.equals("css")) {
                content = this.getCssContent(request, response, resourcePath, content);
            } else if (minifierType.equals("js")) {
                content = AggregateFilter.getJavaScriptContent(content);
            }
            FileUtil.write((File)cacheContentTypeFile, (String)bufferCacheServletResponse.getContentType());
        } else {
            return null;
        }
        FileUtil.write((File)cacheDataFile, (String)content);
        return content;
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, String resourcePath, String content) {
        try {
            content = DynamicCSSUtil.parseSass(this._servletContext, request, resourcePath, content);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to parse SASS on CSS " + resourcePath), (Throwable)e2);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)content);
            }
            response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        }
        String browserId = ParamUtil.getString((HttpServletRequest)request, (String)"browserId");
        if (!browserId.equals("ie")) {
            Matcher matcher = _pattern.matcher(content);
            content = matcher.replaceAll("");
        }
        return MinifierUtil.minifyCss(content);
    }

    protected String getCssContent(HttpServletRequest request, HttpServletResponse response, URL resourceURL, String resourcePath) throws IOException {
        URLConnection urlConnection = resourceURL.openConnection();
        String content = StringUtil.read((InputStream)urlConnection.getInputStream());
        content = AggregateFilter.aggregateCss(new ServletAggregateContext(this._servletContext, resourcePath), content);
        return this.getCssContent(request, response, resourcePath, content);
    }

    protected String getJavaScriptContent(URL resourceURL) throws IOException {
        URLConnection urlConnection = resourceURL.openConnection();
        String content = StringUtil.read((InputStream)urlConnection.getInputStream());
        return AggregateFilter.getJavaScriptContent(content);
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        Object minifiedContent = this.getContent(request, response, filterChain);
        if (minifiedContent == null) {
            minifiedContent = this.getBundleContent(request, response);
        }
        if (minifiedContent == null) {
            this.processFilter(AggregateFilter.class, request, response, filterChain);
        } else if (minifiedContent instanceof File) {
            ServletResponseUtil.write((HttpServletResponse)response, (File)((File)minifiedContent));
        } else if (minifiedContent instanceof String) {
            ServletResponseUtil.write((HttpServletResponse)response, (String)((String)minifiedContent));
        }
    }

    protected String sterilizeQueryString(String queryString) {
        return StringUtil.replace((String)queryString, (String[])new String[]{"/", "\\"}, (String[])new String[]{"_", "_"});
    }
}

