/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Theme;
import com.liferay.portal.scripting.ruby.RubyExecutor;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSFilter;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.tools.SassToCssBuilder;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.time.StopWatch;

public class DynamicCSSUtil {
    private static final String _CSS_IMPORT_BEGIN = "@import url(";
    private static final String _CSS_IMPORT_END = ");";
    private static final String _SASS_COMMON_DIR = "/html/css/common";
    private static final String _SASS_DIR = "sass";
    private static final String _SASS_DIR_KEY = String.valueOf(DynamicCSSUtil.class.getName()) + "#sass";
    private static Log _log = LogFactoryUtil.getLog(DynamicCSSUtil.class);
    private static boolean _initialized;
    private static Pattern _pluginThemePattern;
    private static Pattern _portalThemePattern;
    private static RubyExecutor _rubyExecutor;
    private static String _rubyScript;

    static {
        _pluginThemePattern = Pattern.compile("\\/([^\\/]+)-theme\\/", 2);
        _portalThemePattern = Pattern.compile("themes\\/([^\\/]+)\\/css", 2);
        _rubyExecutor = new RubyExecutor();
    }

    public static void init() {
        try {
            if (_initialized) {
                return;
            }
            _rubyScript = StringUtil.read((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)"com/liferay/portal/servlet/filters/dynamiccss/main.rb");
            _initialized = true;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static String parseSass(ServletContext servletContext, HttpServletRequest request, String resourcePath, String content) throws Exception {
        String portalContextPath;
        if (!DynamicCSSFilter.ENABLED) {
            return content;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (request == null) {
            return content;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = null;
        if (themeDisplay == null && (theme = DynamicCSSUtil._getTheme(request)) == null) {
            String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No theme found for " + currentURL));
            }
            return content;
        }
        String parsedContent = null;
        boolean themeCssFastLoad = DynamicCSSUtil._isThemeCssFastLoad(request, themeDisplay);
        URLConnection cacheResourceURLConnection = null;
        URL cacheResourceURL = DynamicCSSUtil._getCacheResource(servletContext, resourcePath);
        if (cacheResourceURL != null) {
            URL resourceURL;
            cacheResourceURLConnection = cacheResourceURL.openConnection();
            if (!themeCssFastLoad && (resourceURL = servletContext.getResource(resourcePath)) != null) {
                URLConnection resourceURLConnection = resourceURL.openConnection();
                if (cacheResourceURLConnection.getLastModified() < resourceURLConnection.getLastModified()) {
                    cacheResourceURLConnection = null;
                }
            }
        }
        if ((themeCssFastLoad || !content.contains(_CSS_IMPORT_BEGIN)) && cacheResourceURLConnection != null) {
            parsedContent = StringUtil.read((InputStream)cacheResourceURLConnection.getInputStream());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Loading SASS cache from " + cacheResourceURL.getPath() + " takes " + stopWatch.getTime() + " ms"));
            }
        } else {
            content = SassToCssBuilder.parseStaticTokens(content);
            String queryString = request.getQueryString();
            if (!themeCssFastLoad && Validator.isNotNull((String)queryString)) {
                content = DynamicCSSUtil.propagateQueryString(content, queryString);
            }
            parsedContent = DynamicCSSUtil._parseSass(servletContext, request, themeDisplay, theme, resourcePath, content);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parsing SASS for " + resourcePath + " takes " + stopWatch.getTime() + " ms"));
            }
        }
        if (Validator.isNull((String)parsedContent)) {
            return content;
        }
        String baseURL = portalContextPath = PortalUtil.getPathContext();
        String contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        if (!contextPath.equals(portalContextPath)) {
            baseURL = "/".concat(GetterUtil.getString((String)servletContext.getServletContextName()));
        }
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        parsedContent = StringUtil.replace((String)parsedContent, (String[])new String[]{"@base_url@", "@portal_ctx@", "@theme_image_path@"}, (String[])new String[]{baseURL, portalContextPath, DynamicCSSUtil._getThemeImagesPath(request, themeDisplay, theme)});
        return parsedContent;
    }

    protected static String propagateQueryString(String content, String queryString) {
        StringBuilder sb = new StringBuilder(content.length());
        int pos = 0;
        while (true) {
            int importX = content.indexOf(_CSS_IMPORT_BEGIN, pos);
            int importY = content.indexOf(_CSS_IMPORT_END, importX + _CSS_IMPORT_BEGIN.length());
            if (importX == -1 || importY == -1) break;
            sb.append(content.substring(pos, importX));
            sb.append(_CSS_IMPORT_BEGIN);
            String url = content.substring(importX + _CSS_IMPORT_BEGIN.length(), importY);
            char firstChar = url.charAt(0);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            url = StringUtil.unquote((String)url);
            sb.append(url);
            if (url.indexOf(63) != -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(queryString);
            if (firstChar == '\'') {
                sb.append('\'');
            } else if (firstChar == '\"') {
                sb.append('\"');
            }
            sb.append(_CSS_IMPORT_END);
            pos = importY + _CSS_IMPORT_END.length();
        }
        sb.append(content.substring(pos));
        return sb.toString();
    }

    private static URL _getCacheResource(ServletContext servletContext, String resourcePath) throws Exception {
        int pos = resourcePath.lastIndexOf("/");
        String cacheFileName = String.valueOf(resourcePath.substring(0, pos + 1)) + ".sass-cache/" + resourcePath.substring(pos + 1);
        return servletContext.getResource(cacheFileName);
    }

    private static String _getCssThemePath(ServletContext servletContext, HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String cdnHost;
        if (themeDisplay != null) {
            return themeDisplay.getPathThemeCss();
        }
        if (PortalUtil.isCDNDynamicResourcesEnabled((HttpServletRequest)request) && Validator.isNotNull((String)(cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request)))) {
            return cdnHost.concat(theme.getStaticResourcePath()).concat(theme.getCssPath());
        }
        return servletContext.getRealPath(theme.getCssPath());
    }

    private static File _getSassTempDir(ServletContext servletContext) {
        File sassTempDir = (File)servletContext.getAttribute(_SASS_DIR_KEY);
        if (sassTempDir != null) {
            return sassTempDir;
        }
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        sassTempDir = new File(tempDir, _SASS_DIR);
        sassTempDir.mkdirs();
        servletContext.setAttribute(_SASS_DIR_KEY, (Object)sassTempDir);
        return sassTempDir;
    }

    private static Theme _getTheme(HttpServletRequest request) throws Exception {
        String requestURI;
        Matcher portalThemeMatcher;
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String themeId = ParamUtil.getString((HttpServletRequest)request, (String)"themeId");
        if (Validator.isNotNull((String)themeId)) {
            try {
                Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)false);
                return theme;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if ((portalThemeMatcher = _portalThemePattern.matcher(requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8"))).find()) {
            String themePathId = portalThemeMatcher.group(1);
            themePathId = StringUtil.replace((String)themePathId, (String)"_", (String)"");
            themeId = PortalUtil.getJsSafePortletId((String)themePathId);
        } else {
            Matcher pluginThemeMatcher = _pluginThemePattern.matcher(requestURI);
            if (pluginThemeMatcher.find()) {
                String themePathId = pluginThemeMatcher.group(1);
                themePathId = StringUtil.replace((String)themePathId, (String)"_", (String)"");
                StringBundler sb = new StringBundler(4);
                sb.append(themePathId);
                sb.append("_WAR_");
                sb.append(themePathId);
                sb.append("theme");
                themePathId = sb.toString();
                themeId = PortalUtil.getJsSafePortletId((String)themePathId);
            }
        }
        if (Validator.isNull((String)themeId)) {
            return null;
        }
        try {
            Theme theme = ThemeLocalServiceUtil.getTheme((long)companyId, (String)themeId, (boolean)false);
            return theme;
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
            return null;
        }
    }

    private static String _getThemeImagesPath(HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme) throws Exception {
        String themeImagesPath = null;
        if (themeDisplay != null) {
            themeImagesPath = themeDisplay.getPathThemeImages();
        } else {
            String cdnHost = PortalUtil.getCDNHost((HttpServletRequest)request);
            String themeStaticResourcePath = theme.getStaticResourcePath();
            themeImagesPath = String.valueOf(cdnHost) + themeStaticResourcePath + theme.getImagesPath();
        }
        return themeImagesPath;
    }

    private static boolean _isThemeCssFastLoad(HttpServletRequest request, ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.isThemeCssFastLoad();
        }
        return SessionParamUtil.getBoolean((HttpServletRequest)request, (String)"css_fast_load", (boolean)PropsValues.THEME_CSS_FAST_LOAD);
    }

    private static String _parseSass(ServletContext servletContext, HttpServletRequest request, ThemeDisplay themeDisplay, Theme theme, String resourcePath, String content) throws Exception {
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        String portalWebDir = PortalUtil.getPortalWebDir();
        inputObjects.put("commonSassPath", portalWebDir.concat(_SASS_COMMON_DIR));
        inputObjects.put("content", content);
        inputObjects.put("cssRealPath", resourcePath);
        inputObjects.put("cssThemePath", DynamicCSSUtil._getCssThemePath(servletContext, request, themeDisplay, theme));
        File sassTempDir = DynamicCSSUtil._getSassTempDir(servletContext);
        inputObjects.put("sassCachePath", sassTempDir.getCanonicalPath());
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        inputObjects.put("out", unsyncPrintWriter);
        _rubyExecutor.eval(null, inputObjects, null, _rubyScript, new ClassLoader[0]);
        unsyncPrintWriter.flush();
        return unsyncByteArrayOutputStream.toString();
    }
}

