/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.cache.ehcache.ClearEhcacheThreadUtil;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.deploy.DeployManagerUtil;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.servlet.DirectServletRegistryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.CharBufferPool;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.ClearTimerThreadUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.LicenseValidationTransportUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReferenceRegistry;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.spring.bean.BeanReferenceRefreshUtil;
import com.liferay.portal.spring.context.PortalContextLoaderLifecycleThreadLocal;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalContextLoaderListener
extends ContextLoaderListener {
    public static final boolean CACHE_CLEAR_ON_CONTEXT_INITIALIZATION = GetterUtil.getBoolean((String)PropsUtil.get("cache.clear.on.context.initialization"));
    private static Log _log = LogFactoryUtil.getLog(PortalContextLoaderListener.class);
    private static Field _filteredPropertyDescriptorsCacheField;
    private static String _portalServlerContextName;
    private static String _portalServletContextPath;

    static {
        _portalServlerContextName = "";
        _portalServletContextPath = "/";
        try {
            _filteredPropertyDescriptorsCacheField = ReflectionUtil.getDeclaredField(AbstractAutowireCapableBeanFactory.class, (String)"filteredPropertyDescriptorsCache");
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static String getPortalServlerContextName() {
        return _portalServlerContextName;
    }

    public static String getPortalServletContextPath() {
        return _portalServletContextPath;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        PortalContextLoaderLifecycleThreadLocal.setDestroying(true);
        ThreadLocalCacheManager.destroy();
        try {
            LicenseValidationTransportUtil.stopMulticastTransportThread();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        try {
            ClearTimerThreadUtil.clearTimerThread();
        }
        catch (Exception e4) {
            _log.error((Object)e4, (Throwable)e4);
        }
        try {
            ClearEhcacheThreadUtil.clearEhcacheReplicationThread();
        }
        catch (Exception e5) {
            _log.error((Object)e5, (Throwable)e5);
        }
        try {
            DirectServletRegistryUtil.clearServlets();
        }
        catch (Exception e6) {
            _log.error((Object)e6, (Throwable)e6);
        }
        try {
            HotDeployUtil.reset();
        }
        catch (Exception e7) {
            _log.error((Object)e7, (Throwable)e7);
        }
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e8) {
            _log.error((Object)e8, (Throwable)e8);
        }
        try {
            PortalLifecycleUtil.reset();
        }
        catch (Exception e9) {
            _log.error((Object)e9, (Throwable)e9);
        }
        try {
            super.contextDestroyed(servletContextEvent);
            try {
                ModuleFrameworkUtilAdapter.stopFramework();
            }
            catch (Exception e10) {
                _log.error((Object)e10, (Throwable)e10);
            }
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setDestroying(false);
            SecurityManagerUtil.destroy();
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        SystemProperties.reload();
        DBFactoryUtil.reset();
        DeployManagerUtil.reset();
        InstancePool.reset();
        MethodCache.reset();
        PortalBeanLocatorUtil.reset();
        PortletBagPool.reset();
        ReferenceRegistry.releaseReferences();
        InitUtil.init();
        ServletContext servletContext = servletContextEvent.getServletContext();
        _portalServlerContextName = servletContext.getServletContextName();
        if (_portalServlerContextName == null) {
            _portalServlerContextName = "";
        }
        if (ServerDetector.isJetty() && _portalServlerContextName.equals("/")) {
            _portalServlerContextName = "";
        }
        _portalServletContextPath = servletContext.getContextPath();
        if (ServerDetector.isWebSphere() && _portalServletContextPath.isEmpty()) {
            _portalServlerContextName = "";
        }
        ClassPathUtil.initializeClassPaths((ServletContext)servletContext);
        CacheRegistryUtil.clear();
        CharBufferPool.cleanUp();
        PortletContextBagPool.clear();
        WebAppPool.clear();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = tempDir.getAbsolutePath();
        try {
            ModuleFrameworkUtilAdapter.startFramework();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        PortalContextLoaderLifecycleThreadLocal.setInitializing(true);
        try {
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortalContextLoaderLifecycleThreadLocal.setInitializing(false);
        }
        WebApplicationContext applicationContext = ContextLoader.getCurrentWebApplicationContext();
        try {
            BeanReferenceRefreshUtil.refresh((BeanFactory)applicationContext);
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
        if (CACHE_CLEAR_ON_CONTEXT_INITIALIZATION) {
            FinderCacheUtil.clearCache();
            FinderCacheUtil.clearLocalCache();
            EntityCacheUtil.clearCache();
            EntityCacheUtil.clearLocalCache();
            PermissionCacheUtil.clearCache();
            PermissionCacheUtil.clearLocalCache();
            TemplateResourceLoaderUtil.clearCache();
            WikiCacheUtil.clearCache(0L);
            ServletContextPool.clear();
            CacheUtil.clearCache();
            MultiVMPoolUtil.clear();
            SingleVMPoolUtil.clear();
            WebCachePoolUtil.clear();
        }
        ClassLoader portalClassLoader = ClassLoaderUtil.getPortalClassLoader();
        ClassLoaderPool.register((String)_portalServlerContextName, (ClassLoader)portalClassLoader);
        ServletContextPool.put((String)_portalServlerContextName, (ServletContext)servletContext);
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(portalClassLoader, (ApplicationContext)applicationContext);
        PortalBeanLocatorUtil.setBeanLocator((BeanLocator)beanLocatorImpl);
        ClassLoader classLoader = portalClassLoader;
        while (classLoader != null) {
            CachedIntrospectionResults.clearClassLoader((ClassLoader)classLoader);
            classLoader = classLoader.getParent();
        }
        AutowireCapableBeanFactory autowireCapableBeanFactory = applicationContext.getAutowireCapableBeanFactory();
        this.clearFilteredPropertyDescriptorsCache(autowireCapableBeanFactory);
        try {
            ModuleFrameworkUtilAdapter.registerContext(applicationContext);
            ModuleFrameworkUtilAdapter.registerContext(servletContext);
            ModuleFrameworkUtilAdapter.startRuntime();
        }
        catch (Exception e4) {
            throw new RuntimeException(e4);
        }
    }

    protected void clearFilteredPropertyDescriptorsCache(AutowireCapableBeanFactory autowireCapableBeanFactory) {
        try {
            Map filteredPropertyDescriptorsCache = (Map)_filteredPropertyDescriptorsCacheField.get(autowireCapableBeanFactory);
            filteredPropertyDescriptorsCache.clear();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

