/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsEnvironmentBuilder {
    private static final String _BRANCH = "master";
    private static final String[] _SOURCE_DIR_NAMES = new String[]{"docroot/WEB-INF/ext-impl/src", "docroot/WEB-INF/ext-service/src", "docroot/WEB-INF/ext-util-bridges/src", "docroot/WEB-INF/ext-util-java/src", "docroot/WEB-INF/ext-util-taglib/src", "docroot/WEB-INF/service", "docroot/WEB-INF/src", "src"};
    private static final String[] _TEST_TYPES = new String[]{"integration", "unit"};
    private static FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) throws Exception {
        try {
            File dir = new File(System.getProperty("plugins.env.dir"));
            new PluginsEnvironmentBuilder(dir);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public PluginsEnvironmentBuilder(File dir) throws Exception {
        String fileName;
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dir);
        directoryScanner.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
        directoryScanner.scan();
        String dirName = dir.getCanonicalPath();
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            fileName = stringArray[n2];
            this.setupWarProject(dirName, fileName);
            ++n2;
        }
        directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(dir);
        directoryScanner.setIncludes(new String[]{"**\\build.xml"});
        directoryScanner.scan();
        stringArray = directoryScanner.getIncludedFiles();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            int x;
            fileName = stringArray[n2];
            String content = _fileUtil.read(String.valueOf(dirName) + "/" + fileName);
            boolean osgiProject = content.contains("<import file=\"../../build-common-osgi-plugin.xml\" />");
            boolean sharedProject = content.contains("<import file=\"../build-common-shared.xml\" />");
            List<String> dependencyJars = Collections.emptyList();
            if (osgiProject && (x = content.indexOf("osgi.plugin.portal.lib.jars")) != -1) {
                x = content.indexOf("value=\"", x);
                x = content.indexOf("\"", x);
                int y = content.indexOf("\"", x + 1);
                dependencyJars = Arrays.asList(StringUtil.split((String)content.substring(x + 1, y)));
            }
            if (osgiProject || sharedProject) {
                this.setupJarProject(dirName, fileName, dependencyJars, sharedProject);
            }
            ++n2;
        }
    }

    protected void addClasspathEntry(StringBundler sb, String jar) {
        this.addClasspathEntry(sb, jar, null);
    }

    protected void addClasspathEntry(StringBundler sb, String jar, Map<String, String> attributes) {
        sb.append("\t<classpathentry kind=\"lib\" path=\"");
        sb.append(jar);
        if (attributes == null || attributes.isEmpty()) {
            sb.append("\" />\n");
            return;
        }
        sb.append("\">\n\t\t<attributes>\n");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append("\t\t\t<attribute name=\"");
            sb.append(entry.getKey());
            sb.append("\" value=\"");
            sb.append(entry.getValue());
            sb.append("\" />\n");
        }
        sb.append("\t\t</attributes>\n\t</classpathentry>\n");
    }

    protected List<String> getCommonJars() {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("commons-logging.jar");
        jars.add("log4j.jar");
        jars.add("util-bridges.jar");
        jars.add("util-java.jar");
        jars.add("util-taglib.jar");
        return jars;
    }

    protected List<String> getImportSharedJars(File projectDir) throws Exception {
        File buildXmlFile = new File(projectDir, "build.xml");
        String content = _fileUtil.read(buildXmlFile);
        int x = content.indexOf("import.shared");
        if (x == -1) {
            return new ArrayList<String>();
        }
        x = content.indexOf("value=\"", x);
        x = content.indexOf("\"", x);
        int y = content.indexOf("\" />", x);
        if (x == -1 || y == -1) {
            return new ArrayList<String>();
        }
        String[] importShared = StringUtil.split((String)content.substring(x + 1, y));
        if (importShared.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = importShared;
        int n = importShared.length;
        int n2 = 0;
        while (n2 < n) {
            String currentImportShared = stringArray[n2];
            jars.add(String.valueOf(currentImportShared) + ".jar");
            File currentImportSharedLibDir = new File(projectDir, "/../../shared/" + currentImportShared + "/lib");
            if (currentImportSharedLibDir.exists()) {
                File[] fileArray = currentImportSharedLibDir.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    jars.add(file.getName());
                    ++n4;
                }
            }
            ++n2;
        }
        return jars;
    }

    protected List<String> getPortalDependencyJars(Properties properties) {
        Object[] dependencyJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
        return ListUtil.toList((Object[])dependencyJars);
    }

    protected List<String> getRequiredDeploymentContextsJars(File libDir, Properties properties) throws Exception {
        String[] requiredDeploymentContexts;
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = requiredDeploymentContexts = StringUtil.split((String)properties.getProperty("required-deployment-contexts"));
        int n = requiredDeploymentContexts.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredDeploymentContext = stringArray[n2];
            if (_fileUtil.exists(String.valueOf(libDir.getCanonicalPath()) + "/" + requiredDeploymentContext + "-service.jar")) {
                jars.add(String.valueOf(requiredDeploymentContext) + "-service.jar");
            }
            ++n2;
        }
        return jars;
    }

    protected void setupJarProject(String dirName, String fileName, List<String> dependencyJars, boolean sharedProject) throws Exception {
        File buildFile = new File(String.valueOf(dirName) + "/" + fileName);
        File projectDir = new File(buildFile.getParent());
        File libDir = new File(projectDir, "lib");
        this.writeEclipseFiles(libDir, projectDir, dependencyJars);
        List<String> importSharedJars = this.getImportSharedJars(projectDir);
        if (sharedProject && !importSharedJars.contains("portal-compat-shared.jar")) {
            importSharedJars.add("portal-compat-shared.jar");
        }
        File gitignoreFile = new File(String.valueOf(projectDir.getCanonicalPath()) + "/.gitignore");
        Object[] gitIgnores = importSharedJars.toArray(new String[importSharedJars.size()]);
        int i2 = 0;
        while (i2 < gitIgnores.length) {
            String gitIgnore = gitIgnores[i2];
            gitIgnores[i2] = gitIgnore = "/lib/" + gitIgnore;
            ++i2;
        }
        if (gitIgnores.length > 0) {
            System.out.println("Updating " + gitignoreFile);
            _fileUtil.write(gitignoreFile, StringUtil.merge((Object[])gitIgnores, (String)"\n"));
        }
    }

    protected void setupWarProject(String dirName, String fileName) throws Exception {
        File propertiesFile = new File(String.valueOf(dirName) + "/" + fileName);
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        TreeSet<String> jars = new TreeSet<String>();
        jars.addAll(this.getCommonJars());
        List<String> dependencyJars = this.getPortalDependencyJars(properties);
        jars.addAll(dependencyJars);
        File projectDir = new File(String.valueOf(propertiesFile.getParent()) + "/../..");
        jars.addAll(this.getImportSharedJars(projectDir));
        File libDir = new File(String.valueOf(propertiesFile.getParent()) + "/lib");
        jars.addAll(this.getRequiredDeploymentContextsJars(libDir, properties));
        this.writeEclipseFiles(libDir, projectDir, dependencyJars);
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (String)"\\", (String)"/");
        List ignores = ListUtil.fromFile((String)(String.valueOf(libDir.getCanonicalPath()) + "/../.gitignore"));
        if (libDirPath.contains("/ext/") || ignores.contains("/lib")) {
            return;
        }
        File gitignoreFile = new File(String.valueOf(libDir.getCanonicalPath()) + "/.gitignore");
        System.out.println("Updating " + gitignoreFile);
        Object[] gitIgnores = jars.toArray(new String[jars.size()]);
        int i2 = 0;
        while (i2 < gitIgnores.length) {
            String gitIgnore = gitIgnores[i2];
            if (Validator.isNotNull((String)gitIgnore) && !gitIgnore.startsWith("/")) {
                gitIgnores[i2] = "/" + gitIgnore;
            }
            ++i2;
        }
        _fileUtil.write(gitignoreFile, StringUtil.merge((Object[])gitIgnores, (String)"\n"));
    }

    protected void writeClasspathFile(File libDir, List<String> dependencyJars, String projectDirName, String projectName, boolean javaProject) throws Exception {
        File classpathFile = new File(String.valueOf(projectDirName) + "/.classpath");
        if (!javaProject) {
            classpathFile.delete();
            return;
        }
        UniqueList globalJars = new UniqueList();
        UniqueList portalJars = new UniqueList();
        UniqueList extGlobalJars = new UniqueList();
        UniqueList extPortalJars = new UniqueList();
        String libDirPath = StringUtil.replace((String)libDir.getPath(), (String)"\\", (String)"/");
        if (libDirPath.contains("/ext/")) {
            GlobFilenameFilter filenameFilter = new GlobFilenameFilter("*.jar");
            String[] stringArray = new String[]{"global", "portal"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] fileNames;
                File dir;
                String dirName = stringArray[n2];
                File file = new File(String.valueOf(libDirPath) + "/../ext-lib/" + dirName);
                List jars = ListUtil.toList((Object[])file.list((FilenameFilter)filenameFilter));
                if (dirName.equals("global")) {
                    extGlobalJars.addAll(ListUtil.sort((List)jars));
                    dir = new File(PropsValues.LIFERAY_LIB_GLOBAL_DIR);
                    fileNames = dir.list((FilenameFilter)filenameFilter);
                    globalJars.addAll(ListUtil.sort((List)ListUtil.toList((Object[])fileNames)));
                    globalJars.removeAll((Collection<?>)extGlobalJars);
                } else if (dirName.equals("portal")) {
                    extPortalJars.addAll(ListUtil.sort((List)jars));
                    dir = new File(PropsValues.LIFERAY_LIB_PORTAL_DIR);
                    fileNames = dir.list((FilenameFilter)filenameFilter);
                    portalJars.addAll(ListUtil.sort((List)ListUtil.toList((Object[])fileNames)));
                    portalJars.removeAll((Collection<?>)extPortalJars);
                }
                ++n2;
            }
        } else {
            globalJars.add("portlet.jar");
            portalJars.addAll(dependencyJars);
            portalJars.add("commons-logging.jar");
            portalJars.add("log4j.jar");
            Collections.sort(portalJars);
        }
        Object[] customJarsArray = libDir.list((FilenameFilter)new GlobFilenameFilter("*.jar"));
        ArrayList customJars = null;
        if (customJarsArray != null) {
            customJars = ListUtil.toList((Object[])customJarsArray);
            for (String jar : portalJars) {
                customJars.remove(jar);
            }
            customJars.remove(String.valueOf(projectName) + "-service.jar");
            customJars.remove("util-bridges.jar");
            customJars.remove("util-java.jar");
            customJars.remove("util-taglib.jar");
            Collections.sort(customJars);
        } else {
            customJars = new ArrayList();
        }
        StringBundler sb = new StringBundler();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<classpath>\n");
        String[] stringArray = _SOURCE_DIR_NAMES;
        int file = _SOURCE_DIR_NAMES.length;
        int n = 0;
        while (n < file) {
            String sourceDirName = stringArray[n];
            if (_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) {
                sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
                sb.append("kind=\"src\" path=\"");
                sb.append(sourceDirName);
                sb.append("\" />\n");
            }
            ++n;
        }
        sb.append("\t<classpathentry kind=\"src\" path=\"/portal\" />\n");
        sb.append("\t<classpathentry kind=\"con\" ");
        sb.append("path=\"org.eclipse.jdt.launching.JRE_CONTAINER\" />\n");
        boolean addJunitJars = false;
        String[] stringArray2 = _TEST_TYPES;
        int n3 = _TEST_TYPES.length;
        file = 0;
        while (file < n3) {
            String testType = stringArray2[file];
            String testFolder = "test/" + testType;
            if (_fileUtil.exists(String.valueOf(projectDirName) + "/" + testFolder)) {
                addJunitJars = true;
                sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
                sb.append("kind=\"src\" path=\"");
                sb.append(testFolder);
                sb.append("\" />\n");
            }
            ++file;
        }
        if (addJunitJars) {
            this.addClasspathEntry(sb, "/portal/lib/development/junit.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/mockito.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/powermock-mockito.jar");
            this.addClasspathEntry(sb, "/portal/lib/development/spring-test.jar");
            portalJars.add("commons-io.jar");
            portalJars.add("commons-lang.jar");
        }
        this.addClasspathEntry(sb, "/portal/lib/development/activation.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/annotations.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/jsp-api.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/mail.jar");
        this.addClasspathEntry(sb, "/portal/lib/development/servlet-api.jar");
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (libDirPath.contains("/ext/")) {
            attributes.put("optional", "true");
        }
        for (String jar : globalJars) {
            this.addClasspathEntry(sb, "/portal/lib/global/" + jar, attributes);
        }
        for (String jar : portalJars) {
            if (jar.equals("util-slf4j.jar")) continue;
            this.addClasspathEntry(sb, "/portal/lib/portal/" + jar, attributes);
        }
        this.addClasspathEntry(sb, "/portal/portal-service/portal-service.jar");
        this.addClasspathEntry(sb, "/portal/util-bridges/util-bridges.jar");
        this.addClasspathEntry(sb, "/portal/util-java/util-java.jar");
        if (portalJars.contains("util-slf4j.jar")) {
            this.addClasspathEntry(sb, "/portal/util-slf4j/util-slf4j.jar");
        }
        this.addClasspathEntry(sb, "/portal/util-taglib/util-taglib.jar");
        for (String jar : extGlobalJars) {
            this.addClasspathEntry(sb, "docroot/WEB-INF/ext-lib/global/" + jar);
        }
        for (String jar : extPortalJars) {
            this.addClasspathEntry(sb, "docroot/WEB-INF/ext-lib/portal/" + jar);
        }
        for (String jar : customJars) {
            if (libDirPath.contains("/tmp/WEB-INF/lib")) {
                this.addClasspathEntry(sb, "tmp/WEB-INF/lib/" + jar);
                continue;
            }
            if (libDirPath.contains("/docroot/WEB-INF/lib")) {
                this.addClasspathEntry(sb, "docroot/WEB-INF/lib/" + jar);
                continue;
            }
            this.addClasspathEntry(sb, "lib/" + jar);
        }
        sb.append("\t<classpathentry kind=\"output\" path=\"bin\" />\n");
        sb.append("</classpath>");
        System.out.println("Updating " + classpathFile);
        String content = StringUtil.replace((String)sb.toString(), (String)"\"/portal", (String)"\"/portal-master");
        _fileUtil.write(classpathFile, content);
    }

    protected void writeEclipseFiles(File libDir, File projectDir, List<String> dependencyJars) throws Exception {
        String sourceDirName;
        String projectDirName = projectDir.getCanonicalPath();
        String projectName = StringUtil.extractLast((String)projectDirName, (char)File.separatorChar);
        boolean javaProject = false;
        String[] stringArray = _SOURCE_DIR_NAMES;
        int n = _SOURCE_DIR_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            sourceDirName = stringArray[n2];
            if (_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) {
                javaProject = true;
                break;
            }
            ++n2;
        }
        if (!javaProject) {
            System.out.println("Eclipse Java project will not be used because a source folder does not exist");
        }
        this.writeProjectFile(projectDirName, projectName, javaProject);
        this.writeClasspathFile(libDir, dependencyJars, projectDirName, projectName, javaProject);
        stringArray = _SOURCE_DIR_NAMES;
        n = _SOURCE_DIR_NAMES.length;
        n2 = 0;
        while (n2 < n) {
            block11: {
                ArrayList<String> gitIgnores;
                block13: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    sourceDirName = stringArray[n2];
                                    if (!_fileUtil.exists(String.valueOf(projectDirName) + "/" + sourceDirName)) break block11;
                                    gitIgnores = new ArrayList<String>();
                                    if (!sourceDirName.endsWith("ext-impl/src")) break block12;
                                    gitIgnores.add("/classes");
                                    gitIgnores.add("/ext-impl.jar");
                                    break block13;
                                }
                                if (!sourceDirName.endsWith("ext-service/src")) break block14;
                                gitIgnores.add("/classes");
                                gitIgnores.add("/ext-service.jar");
                                break block13;
                            }
                            if (!sourceDirName.endsWith("ext-util-bridges/src")) break block15;
                            gitIgnores.add("/classes");
                            gitIgnores.add("/ext-util-bridges.jar");
                            break block13;
                        }
                        if (!sourceDirName.endsWith("ext-util-java/src")) break block16;
                        gitIgnores.add("/classes");
                        gitIgnores.add("/ext-util-java.jar");
                        break block13;
                    }
                    if (!sourceDirName.endsWith("ext-util-taglib/src")) break block11;
                    gitIgnores.add("/classes");
                    gitIgnores.add("/ext-util-taglib.jar");
                }
                String dirName = String.valueOf(projectDirName) + "/" + sourceDirName + "/../";
                if (gitIgnores.isEmpty()) {
                    _fileUtil.delete(String.valueOf(dirName) + ".gitignore");
                } else {
                    String gitIgnoresString = StringUtil.merge(gitIgnores, (String)"\n");
                    _fileUtil.write(String.valueOf(dirName) + ".gitignore", gitIgnoresString);
                }
            }
            ++n2;
        }
        if (_fileUtil.exists(String.valueOf(projectDirName) + "/test")) {
            _fileUtil.write(String.valueOf(projectDirName) + "/.gitignore", "/test-classes\n/test-results");
        } else {
            _fileUtil.delete(String.valueOf(projectDirName) + "/.gitignore");
        }
    }

    protected void writeProjectFile(String projectDirName, String projectName, boolean javaProject) throws Exception {
        StringBundler sb = new StringBundler(17);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<projectDescription>\n");
        sb.append("\t<name>");
        sb.append(projectName);
        sb.append("-");
        sb.append(_BRANCH);
        sb.append("</name>\n");
        sb.append("\t<comment></comment>\n");
        sb.append("\t<projects></projects>\n");
        sb.append("\t<buildSpec>\n");
        if (javaProject) {
            sb.append("\t\t<buildCommand>\n");
            sb.append("\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n");
            sb.append("\t\t\t<arguments></arguments>\n");
            sb.append("\t\t</buildCommand>\n");
        }
        sb.append("\t</buildSpec>\n");
        sb.append("\t<natures>\n");
        if (javaProject) {
            sb.append("\t\t<nature>org.eclipse.jdt.core.javanature</nature>\n");
        }
        sb.append("\t</natures>\n");
        sb.append("</projectDescription>");
        File projectFile = new File(String.valueOf(projectDirName) + "/.project");
        System.out.println("Updating " + projectFile);
        _fileUtil.write(projectFile, sb.toString());
    }
}

