/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.Deployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.PluginContextListener;
import com.liferay.portal.kernel.servlet.PortalClassLoaderServlet;
import com.liferay.portal.kernel.servlet.PortalDelegateServlet;
import com.liferay.portal.kernel.servlet.PortletServlet;
import com.liferay.portal.kernel.servlet.SecurePluginContextListener;
import com.liferay.portal.kernel.servlet.SecureServlet;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.tools.deploy.DeploymentHandler;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.DynamicResourceServlet;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.ant.ExpandTask;
import com.liferay.util.ant.UpToDateTask;
import com.liferay.util.ant.WarTask;
import com.liferay.util.xml.DocUtil;
import com.liferay.util.xml.XMLFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.oro.io.GlobFilenameFilter;

public class BaseDeployer
implements AutoDeployer,
Deployer {
    public static final boolean SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE = GetterUtil.getBoolean((String)PropsUtil.get("session.verify.serializable.attribute"));
    public static final String DEPLOY_TO_PREFIX = "DEPLOY_TO__";
    protected String appServerType;
    protected String auiTaglibDTD;
    protected String baseDir;
    protected String destDir;
    protected String filePattern;
    protected List<String> jars;
    protected String jbossPrefix;
    protected String portletExtTaglibDTD;
    protected String portletTaglibDTD;
    protected String securityTaglibDTD;
    protected String themeTaglibDTD;
    protected String tomcatLibDir;
    protected String uiTaglibDTD;
    protected boolean unpackWar;
    protected String utilTaglibDTD;
    protected List<String> wars;
    private static final String _PORTAL_CLASS_LOADER = "com.liferay.support.tomcat.loader.PortalClassLoader";
    private static Log _log = LogFactoryUtil.getLog(BaseDeployer.class);

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String fileName = StringUtil.toLowerCase((String)arg);
            if (fileName.endsWith(".war")) {
                wars.add(arg);
            } else if (fileName.endsWith(".jar")) {
                jars.add(arg);
            }
            ++n2;
        }
        new BaseDeployer(wars, jars);
    }

    public BaseDeployer() {
    }

    public BaseDeployer(List<String> wars, List<String> jars) {
        this.baseDir = System.getProperty("deployer.base.dir");
        this.destDir = System.getProperty("deployer.dest.dir");
        this.appServerType = System.getProperty("deployer.app.server.type");
        this.auiTaglibDTD = System.getProperty("deployer.aui.taglib.dtd");
        this.portletTaglibDTD = System.getProperty("deployer.portlet.taglib.dtd");
        this.portletExtTaglibDTD = System.getProperty("deployer.portlet.ext.taglib.dtd");
        this.securityTaglibDTD = System.getProperty("deployer.security.taglib.dtd");
        this.themeTaglibDTD = System.getProperty("deployer.theme.taglib.dtd");
        this.uiTaglibDTD = System.getProperty("deployer.ui.taglib.dtd");
        this.utilTaglibDTD = System.getProperty("deployer.util.taglib.dtd");
        this.unpackWar = GetterUtil.getBoolean((String)System.getProperty("deployer.unpack.war"), (boolean)true);
        this.filePattern = System.getProperty("deployer.file.pattern");
        this.jbossPrefix = GetterUtil.getString((String)System.getProperty("deployer.jboss.prefix"));
        this.tomcatLibDir = System.getProperty("deployer.tomcat.lib.dir");
        this.wars = wars;
        this.jars = jars;
        this.checkArguments();
        String context = System.getProperty("deployer.context");
        try {
            this.deploy(context);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addExtJar(List<String> jars, String resource) throws Exception {
        Set<String> servletContextNames = ExtRegistry.getServletContextNames();
        for (String servletContextName : servletContextNames) {
            String extResource = "ext-" + servletContextName + resource.substring(3);
            String path = DeployUtil.getResourcePath(extResource);
            if (_log.isDebugEnabled()) {
                if (path == null) {
                    _log.debug((Object)("Resource " + extResource + " is not available"));
                } else {
                    _log.debug((Object)("Resource " + extResource + " is available at " + path));
                }
            }
            if (path == null) continue;
            jars.add(path);
        }
    }

    public void addRequiredJar(List<String> jars, String resource) throws Exception {
        String path = DeployUtil.getResourcePath(resource);
        if (path == null) {
            throw new RuntimeException("Resource " + resource + " does not exist");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Resource " + resource + " is available at " + path));
        }
        jars.add(path);
    }

    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        ArrayList<String> wars = new ArrayList<String>();
        File file = autoDeploymentContext.getFile();
        wars.add(file.getName());
        this.wars = wars;
        try {
            return this.deployFile(autoDeploymentContext);
        }
        catch (Exception e2) {
            throw new AutoDeployException((Throwable)e2);
        }
    }

    public void checkArguments() {
        if (Validator.isNull((String)this.baseDir)) {
            throw new IllegalArgumentException("The system property deployer.base.dir is not set");
        }
        if (Validator.isNull((String)this.destDir)) {
            throw new IllegalArgumentException("The system property deployer.dest.dir is not set");
        }
        if (Validator.isNull((String)this.appServerType)) {
            throw new IllegalArgumentException("The system property deployer.app.server.type is not set");
        }
        if (!(this.appServerType.equals("geronimo") || this.appServerType.equals("glassfish") || this.appServerType.equals("jboss") || this.appServerType.equals("jonas") || this.appServerType.equals("jetty") || this.appServerType.equals("oc4j") || this.appServerType.equals("resin") || this.appServerType.equals("tomcat") || this.appServerType.equals("weblogic") || this.appServerType.equals("websphere"))) {
            throw new IllegalArgumentException(String.valueOf(this.appServerType) + " is not a valid application server type");
        }
        if (this.appServerType.equals("glassfish") || this.appServerType.equals("websphere")) {
            this.unpackWar = false;
        }
        if (Validator.isNotNull((String)this.jbossPrefix) && !Validator.isNumber((String)this.jbossPrefix)) {
            this.jbossPrefix = "1";
        }
    }

    public AutoDeployer cloneAutoDeployer() throws AutoDeployException {
        try {
            Class<?> clazz = this.getClass();
            Deployer deployer = (Deployer)clazz.newInstance();
            deployer.setAppServerType(this.appServerType);
            deployer.setAuiTaglibDTD(this.auiTaglibDTD);
            deployer.setBaseDir(this.baseDir);
            deployer.setDestDir(this.destDir);
            deployer.setFilePattern(this.filePattern);
            deployer.setJars(this.jars);
            deployer.setJbossPrefix(this.jbossPrefix);
            deployer.setPortletExtTaglibDTD(this.portletExtTaglibDTD);
            deployer.setPortletTaglibDTD(this.portletTaglibDTD);
            deployer.setSecurityTaglibDTD(this.securityTaglibDTD);
            deployer.setThemeTaglibDTD(this.themeTaglibDTD);
            deployer.setTomcatLibDir(this.tomcatLibDir);
            deployer.setUiTaglibDTD(this.uiTaglibDTD);
            deployer.setUnpackWar(this.unpackWar);
            deployer.setUtilTaglibDTD(this.utilTaglibDTD);
            deployer.setWars(this.wars);
            return (AutoDeployer)deployer;
        }
        catch (Exception e2) {
            throw new AutoDeployException((Throwable)e2);
        }
    }

    public void copyDependencyXml(String fileName, String targetDir) throws Exception {
        this.copyDependencyXml(fileName, targetDir, null);
    }

    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap) throws Exception {
        this.copyDependencyXml(fileName, targetDir, filterMap, false);
    }

    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap, boolean overwrite) throws Exception {
        DeployUtil.copyDependencyXml(fileName, targetDir, fileName, filterMap, overwrite);
    }

    public void copyDtds(File srcFile, PluginPackage pluginPackage) throws Exception {
        File portalLog4jXml = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/classes/META-INF/portal-log4j.xml");
        if (!portalLog4jXml.exists()) {
            return;
        }
        InputStream is = null;
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            is = classLoader.getResourceAsStream("META-INF/log4j.dtd");
            File file = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/classes/META-INF/log4j.dtd");
            FileUtil.write((File)file, (InputStream)is);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(is);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)is);
    }

    public void copyJars(File srcFile, PluginPackage pluginPackage) throws Exception {
        int i2 = 0;
        while (i2 < this.jars.size()) {
            String jarFullName = this.jars.get(i2);
            String jarName = jarFullName.substring(jarFullName.lastIndexOf("/") + 1);
            FileUtil.copyFile((String)jarFullName, (String)(srcFile + "/WEB-INF/lib/" + jarName), (boolean)false);
            ++i2;
        }
    }

    public void copyPortalDependencies(File srcFile) throws Exception {
        Object[] log4jJars;
        Object[] commonsLoggingJars;
        String[] portalTlds;
        String[] portalJars;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null) {
            return;
        }
        String[] stringArray = portalJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
        int n = portalJars.length;
        int n2 = 0;
        while (n2 < n) {
            String portalJar = stringArray[n2];
            portalJar = portalJar.trim();
            portalJar = this.fixPortalDependencyJar(portalJar);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal JAR " + portalJar));
            }
            try {
                String portalJarPath = String.valueOf(PortalUtil.getPortalLibDir()) + portalJar;
                FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/" + portalJar), (boolean)true);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to copy portal JAR " + portalJar), (Throwable)e2);
            }
            ++n2;
        }
        String[] stringArray2 = portalTlds = StringUtil.split((String)properties.getProperty("portal-dependency-tlds", properties.getProperty("portal.dependency.tlds")));
        int n3 = portalTlds.length;
        n = 0;
        while (n < n3) {
            String portalTld = stringArray2[n];
            portalTld = portalTld.trim();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Copy portal TLD " + portalTld));
            }
            try {
                String portalTldPath = DeployUtil.getResourcePath(portalTld);
                FileUtil.copyFile((String)portalTldPath, (String)(srcFile + "/WEB-INF/tld/" + portalTld), (boolean)true);
            }
            catch (Exception e3) {
                _log.error((Object)("Unable to copy portal TLD " + portalTld), (Throwable)e3);
            }
            ++n;
        }
        File pluginLibDir = new File(srcFile + "/WEB-INF/lib/");
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING && ArrayUtil.isEmpty((Object[])(commonsLoggingJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("commons-logging*.jar"))))) {
            String portalJarPath = String.valueOf(PortalUtil.getPortalLibDir()) + "commons-logging.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/commons-logging.jar"), (boolean)true);
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J && ArrayUtil.isEmpty((Object[])(log4jJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("log4j*.jar"))))) {
            String portalJarPath = String.valueOf(PortalUtil.getPortalLibDir()) + "log4j.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j.jar"), (boolean)true);
            portalJarPath = String.valueOf(PortalUtil.getPortalLibDir()) + "log4j-extras.jar";
            FileUtil.copyFile((String)portalJarPath, (String)(srcFile + "/WEB-INF/lib/log4j-extras.jar"), (boolean)true);
        }
    }

    public void copyProperties(File srcFile, PluginPackage pluginPackage) throws Exception {
        File servicePropertiesFile;
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING) {
            this.copyDependencyXml("logging.properties", srcFile + "/WEB-INF/classes");
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J) {
            this.copyDependencyXml("log4j.properties", srcFile + "/WEB-INF/classes");
        }
        if (!(servicePropertiesFile = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/classes/service.properties")).exists()) {
            return;
        }
        File portletPropertiesFile = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/classes/portlet.properties");
        if (portletPropertiesFile.exists()) {
            return;
        }
        String pluginPackageName = null;
        pluginPackageName = pluginPackage != null ? pluginPackage.getName() : srcFile.getName();
        FileUtil.write((File)portletPropertiesFile, (String)("plugin.package.name=" + pluginPackageName));
    }

    public void copyTlds(File srcFile, PluginPackage pluginPackage) throws Exception {
        if (Validator.isNotNull((String)this.auiTaglibDTD)) {
            FileUtil.copyFile((String)this.auiTaglibDTD, (String)(srcFile + "/WEB-INF/tld/aui.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            FileUtil.copyFile((String)this.portletTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            FileUtil.copyFile((String)this.portletExtTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-portlet-ext.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            FileUtil.copyFile((String)this.securityTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-security.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            FileUtil.copyFile((String)this.themeTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-theme.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            FileUtil.copyFile((String)this.uiTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-ui.tld"), (boolean)true);
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            FileUtil.copyFile((String)this.utilTaglibDTD, (String)(srcFile + "/WEB-INF/tld/liferay-util.tld"), (boolean)true);
        }
    }

    public void copyTomcatContextXml(File targetDir) throws Exception {
        if (!this.appServerType.equals("tomcat") || SecurityManagerUtil.ENABLED) {
            return;
        }
        File targetFile = new File(targetDir, "META-INF/context.xml");
        if (targetFile.exists()) {
            return;
        }
        String contextPath = DeployUtil.getResourcePath("context.xml");
        String content = FileUtil.read((String)contextPath);
        if (!PropsValues.AUTO_DEPLOY_UNPACK_WAR) {
            content = StringUtil.replace((String)content, (String)"antiResourceLocking=\"true\"", (String)"");
        }
        FileUtil.write((File)targetFile, (String)content);
    }

    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (this.appServerType.equals("geronimo")) {
            this.copyDependencyXml("geronimo-web.xml", srcFile + "/WEB-INF");
        } else if (this.appServerType.equals("jboss")) {
            if (ServerDetector.isJBoss5()) {
                this.copyDependencyXml("jboss-web.xml", srcFile + "/WEB-INF");
            } else {
                this.copyDependencyXml("jboss-deployment-structure.xml", srcFile + "/WEB-INF");
            }
        } else if (this.appServerType.equals("weblogic")) {
            this.copyDependencyXml("weblogic.xml", srcFile + "/WEB-INF");
        } else if (this.appServerType.equals("websphere")) {
            this.copyDependencyXml("ibm-web-ext.xmi", srcFile + "/WEB-INF");
        }
        this.copyDependencyXml("web.xml", srcFile + "/WEB-INF");
    }

    public void deploy(String context) throws Exception {
        try {
            File baseDirFile = new File(this.baseDir);
            File[] files = baseDirFile.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files = FileUtil.sortFiles((File[])files);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File srcFile = fileArray[n2];
                String fileName = StringUtil.toLowerCase((String)srcFile.getName());
                boolean deploy = false;
                if (fileName.endsWith(".war") || fileName.endsWith(".zip")) {
                    deploy = true;
                    if (this.wars.size() > 0) {
                        if (!this.wars.contains(srcFile.getName())) {
                            deploy = false;
                        }
                    } else if (Validator.isNotNull((String)this.filePattern) && !StringUtil.matchesIgnoreCase((String)fileName, (String)this.filePattern)) {
                        deploy = false;
                    }
                }
                if (deploy) {
                    AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
                    autoDeploymentContext.setContext(context);
                    autoDeploymentContext.setFile(srcFile);
                    this.deployFile(autoDeploymentContext);
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void deployDirectory(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        File extLibPortalDir;
        this.rewriteFiles(srcFile);
        this.mergeDirectory(mergeDir, srcFile);
        this.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        this.copyDtds(srcFile, pluginPackage);
        this.copyJars(srcFile, pluginPackage);
        this.copyProperties(srcFile, pluginPackage);
        this.copyTlds(srcFile, pluginPackage);
        this.copyXmls(srcFile, displayName, pluginPackage);
        this.copyPortalDependencies(srcFile);
        this.updateGeronimoWebXml(srcFile, displayName, pluginPackage);
        File webXml = new File(srcFile + "/WEB-INF/web.xml");
        this.updateWebXml(webXml, srcFile, displayName, pluginPackage);
        File extLibGlobalDir = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/ext-lib/global");
        if (extLibGlobalDir.exists()) {
            File globalLibDir = new File(PortalUtil.getGlobalLibDir());
            CopyTask.copyDirectory((File)extLibGlobalDir, (File)globalLibDir, (String)"*.jar", (String)"", (boolean)overwrite, (boolean)true);
        }
        if ((extLibPortalDir = new File(String.valueOf(srcFile.getAbsolutePath()) + "/WEB-INF/ext-lib/portal")).exists()) {
            File portalLibDir = new File(PortalUtil.getPortalLibDir());
            CopyTask.copyDirectory((File)extLibPortalDir, (File)portalLibDir, (String)"*.jar", (String)"", (boolean)overwrite, (boolean)true);
        }
        if (deployDir == null || this.baseDir.equals(this.destDir)) {
            return;
        }
        this.updateDeployDirectory(srcFile);
        String excludes = "";
        if (this.appServerType.equals("jboss")) {
            excludes = String.valueOf(excludes) + "**/WEB-INF/lib/log4j.jar,";
        } else if (this.appServerType.equals("tomcat")) {
            String content;
            String[] libs;
            String[] stringArray = libs = FileUtil.listFiles((String)this.tomcatLibDir);
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                excludes = String.valueOf(excludes) + "**/WEB-INF/lib/" + lib + ",";
                ++n2;
            }
            File contextXml = new File(srcFile + "/META-INF/context.xml");
            if (contextXml.exists() && (content = FileUtil.read((File)contextXml)).contains(_PORTAL_CLASS_LOADER)) {
                excludes = String.valueOf(excludes) + "**/WEB-INF/lib/util-bridges.jar,";
                excludes = String.valueOf(excludes) + "**/WEB-INF/lib/util-java.jar,";
                excludes = String.valueOf(excludes) + "**/WEB-INF/lib/util-taglib.jar,";
            }
            try {
                Class.forName("javax.el.ELContext");
                excludes = String.valueOf(excludes) + "**/WEB-INF/lib/el-api.jar,";
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            String deployExcludes = properties.getProperty("deploy-excludes");
            if (deployExcludes != null && !(excludes = String.valueOf(excludes) + deployExcludes.trim()).endsWith(",")) {
                excludes = String.valueOf(excludes) + ",";
            }
            if ((deployExcludes = properties.getProperty("deploy-excludes-" + this.appServerType)) != null && !(excludes = String.valueOf(excludes) + deployExcludes.trim()).endsWith(",")) {
                excludes = String.valueOf(excludes) + ",";
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Excludes " + excludes));
        }
        if (!this.unpackWar) {
            File tempDir = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + Time.getTimestamp());
            excludes = String.valueOf(excludes) + "/WEB-INF/web.xml";
            WarTask.war((File)srcFile, (File)tempDir, (String)excludes, (File)webXml);
            if (this.isJEEDeploymentEnabled()) {
                File tempWarDir = new File(tempDir.getParent(), deployDir.getName());
                if (tempWarDir.exists()) {
                    tempWarDir.delete();
                }
                if (!tempDir.renameTo(tempWarDir)) {
                    tempWarDir = tempDir;
                }
                DeploymentHandler deploymentHandler = this.getDeploymentHandler();
                deploymentHandler.deploy(tempWarDir, displayName);
                deploymentHandler.releaseDeploymentManager();
                DeleteTask.deleteDirectory((File)tempWarDir);
            } else {
                if (!tempDir.renameTo(deployDir)) {
                    WarTask.war((File)srcFile, (File)deployDir, (String)excludes, (File)webXml);
                }
                DeleteTask.deleteDirectory((File)tempDir);
            }
        } else {
            excludes = String.valueOf(excludes) + "**/WEB-INF/web.xml";
            CopyTask.copyDirectory((File)srcFile, (File)deployDir, (String)"", (String)excludes, (boolean)overwrite, (boolean)true);
            CopyTask.copyDirectory((File)srcFile, (File)deployDir, (String)"**/WEB-INF/web.xml", (String)"", (boolean)true, (boolean)false);
            if (this.appServerType.equals("tomcat")) {
                File deployWebXml = new File(deployDir + "/WEB-INF/web.xml");
                deployWebXml.setLastModified(System.currentTimeMillis() + 6000L);
            }
        }
        if (this.appServerType.equals("jetty")) {
            DeployUtil.redeployJetty(displayName);
        }
    }

    public void deployDirectory(File srcFile, String displayName, boolean override, PluginPackage pluginPackage) throws Exception {
        this.deployDirectory(srcFile, null, null, displayName, override, pluginPackage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deployFile(AutoDeploymentContext autoDeploymentContext) throws Exception {
        String specifiedContext;
        String autoDeploymentContextAppServerType;
        File srcFile = autoDeploymentContext.getFile();
        PluginPackage pluginPackage = this.readPluginPackage(srcFile);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Deploying " + srcFile.getName()));
        }
        if (Validator.isNotNull((String)(autoDeploymentContextAppServerType = autoDeploymentContext.getAppServerType()))) {
            this.appServerType = autoDeploymentContextAppServerType;
        }
        String displayName = specifiedContext = autoDeploymentContext.getContext();
        boolean overwrite = false;
        String preliminaryContext = specifiedContext;
        if (Validator.isNull((String)specifiedContext) && srcFile.getName().startsWith(DEPLOY_TO_PREFIX)) {
            displayName = srcFile.getName().substring(DEPLOY_TO_PREFIX.length(), srcFile.getName().length() - 4);
            overwrite = true;
            preliminaryContext = displayName;
        }
        if (preliminaryContext == null) {
            preliminaryContext = this.getDisplayName(srcFile);
        }
        if (pluginPackage != null) {
            if (!PluginPackageUtil.isCurrentVersionSupported(pluginPackage.getLiferayVersions())) {
                throw new AutoDeployException(String.valueOf(srcFile.getName()) + " does not support this version of Liferay");
            }
            if (displayName == null) {
                displayName = pluginPackage.getRecommendedDeploymentContext();
            }
            if (Validator.isNull((String)displayName)) {
                displayName = this.getDisplayName(srcFile);
            }
            pluginPackage.setContext(displayName);
            PluginPackageUtil.updateInstallingPluginPackage(preliminaryContext, pluginPackage);
        }
        String deployDir = null;
        if (Validator.isNotNull((String)displayName)) {
            deployDir = String.valueOf(displayName) + ".war";
        } else {
            deployDir = srcFile.getName();
            displayName = this.getDisplayName(srcFile);
        }
        if (this.appServerType.equals("jboss")) {
            deployDir = String.valueOf(this.jbossPrefix) + deployDir;
        } else if ((this.appServerType.equals("geronimo") || this.appServerType.equals("glassfish") || this.appServerType.equals("jetty") || this.appServerType.equals("jonas") || this.appServerType.equals("oc4j") || this.appServerType.equals("resin") || this.appServerType.equals("tomcat") || this.appServerType.equals("weblogic")) && this.unpackWar) {
            deployDir = deployDir.substring(0, deployDir.length() - 4);
        }
        String destDir = this.destDir;
        if (autoDeploymentContext.getDestDir() != null) {
            destDir = autoDeploymentContext.getDestDir();
        }
        File deployDirFile = new File(String.valueOf(destDir) + "/" + deployDir);
        try {
            PluginPackage previousPluginPackage = this.readPluginPackage(deployDirFile);
            if (pluginPackage != null && previousPluginPackage != null) {
                String name = pluginPackage.getName();
                String previousVersion = previousPluginPackage.getVersion();
                String version = pluginPackage.getVersion();
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Updating " + name + " from version " + previousVersion + " to version " + version));
                }
                if (pluginPackage.isPreviousVersionThan(previousPluginPackage)) {
                    if (!_log.isInfoEnabled()) return 2;
                    _log.info((Object)("Not updating " + name + " because version " + previousVersion + " is newer than version " + version));
                    return 2;
                }
                overwrite = true;
            }
            File mergeDirFile = new File(String.valueOf(srcFile.getParent()) + "/merge/" + srcFile.getName());
            if (srcFile.isDirectory()) {
                this.deployDirectory(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
                return 1;
            }
            boolean deployed = this.deployFile(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
            if (deployed) {
                this.postDeploy(destDir, deployDir);
                return 1;
            }
            String context = preliminaryContext;
            if (pluginPackage != null) {
                context = pluginPackage.getContext();
            }
            PluginPackageUtil.endPluginPackageInstallation(context);
            return 1;
        }
        catch (Exception e2) {
            if (pluginPackage == null) throw e2;
            PluginPackageUtil.endPluginPackageInstallation(pluginPackage.getContext());
            throw e2;
        }
    }

    public boolean deployFile(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        boolean undeployOnRedeploy = false;
        try {
            undeployOnRedeploy = PrefsPropsUtil.getBoolean("hot.undeploy.on.redeploy", PropsValues.HOT_UNDEPLOY_ON_REDEPLOY);
        }
        catch (Exception exception) {}
        if (undeployOnRedeploy) {
            DeployUtil.undeploy(this.appServerType, deployDir);
        }
        if (!overwrite && UpToDateTask.isUpToDate((File)srcFile, (File)deployDir)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)(deployDir + " is already up to date"));
            }
            return false;
        }
        File tempDir = new File(String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + File.separator + Time.getTimestamp());
        ExpandTask.expand((File)srcFile, (File)tempDir);
        this.deployDirectory(tempDir, mergeDir, deployDir, displayName, overwrite, pluginPackage);
        DeleteTask.deleteDirectory((File)tempDir);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadJar(String jar) throws Exception {
        String tmpDir = SystemProperties.get((String)"java.io.tmpdir");
        File file = new File(String.valueOf(tmpDir) + "/liferay/com/liferay/portal/deploy/dependencies/" + jar);
        if (!file.exists()) {
            BaseDeployer baseDeployer = this;
            synchronized (baseDeployer) {
                String url = PropsUtil.get("library.download.url." + jar);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Downloading library from " + url));
                }
                byte[] bytes = HttpUtil.URLtoByteArray((String)url);
                FileUtil.write((File)file, (byte[])bytes);
            }
        }
        return FileUtil.getAbsolutePath((File)file);
    }

    public String fixPortalDependencyJar(String portalJar) {
        if (portalJar.equals("antlr.jar")) {
            portalJar = "antlr2.jar";
        }
        return portalJar;
    }

    public DeploymentHandler getDeploymentHandler() {
        String prefix = "auto.deploy." + ServerDetector.getServerId() + ".jee.";
        String dmId = PropsUtil.get(String.valueOf(prefix) + "dm.id");
        String dmUser = PropsUtil.get(String.valueOf(prefix) + "dm.user");
        String dmPassword = PropsUtil.get(String.valueOf(prefix) + "dm.passwd");
        String dfClassName = PropsUtil.get(String.valueOf(prefix) + "df.classname");
        return new DeploymentHandler(dmId, dmUser, dmPassword, dfClassName);
    }

    public String getDisplayName(File srcFile) {
        String displayName = srcFile.getName();
        if (StringUtil.endsWith((String)displayName, (String)".war") || StringUtil.endsWith((String)displayName, (String)".xml")) {
            displayName = displayName.substring(0, displayName.length() - 4);
        }
        if (this.appServerType.equals("jboss") && Validator.isNotNull((String)this.jbossPrefix) && displayName.startsWith(this.jbossPrefix)) {
            displayName = displayName.substring(1);
        }
        return displayName;
    }

    public String getDynamicResourceServletContent() {
        StringBundler sb = new StringBundler();
        sb.append("<servlet>");
        sb.append("<servlet-name>");
        sb.append("Dynamic Resource Servlet");
        sb.append("</servlet-name>");
        sb.append("<servlet-class>");
        sb.append(PortalClassLoaderServlet.class.getName());
        sb.append("</servlet-class>");
        sb.append("<init-param>");
        sb.append("<param-name>");
        sb.append("servlet-class");
        sb.append("</param-name>");
        sb.append("<param-value>");
        sb.append(DynamicResourceServlet.class.getName());
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("<load-on-startup>1</load-on-startup>");
        sb.append("</servlet>");
        String[] stringArray = PropsValues.DYNAMIC_RESOURCE_SERVLET_ALLOWED_PATHS;
        int n = PropsValues.DYNAMIC_RESOURCE_SERVLET_ALLOWED_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedPath = stringArray[n2];
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append("Dynamic Resource Servlet");
            sb.append("</servlet-name>");
            sb.append("<url-pattern>");
            sb.append(allowedPath);
            if (!allowedPath.endsWith("/")) {
                sb.append("/");
            }
            sb.append("*");
            sb.append("</url-pattern>");
            sb.append("</servlet-mapping>");
            ++n2;
        }
        return sb.toString();
    }

    public String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        File webXml;
        String content;
        StringBundler sb = new StringBundler();
        sb.append("<display-name>");
        sb.append(displayName);
        sb.append("</display-name>");
        if (webXmlVersion < 2.4) {
            sb.append("<context-param>");
            sb.append("<param-name>liferay-invoker-enabled</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        if (SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            sb.append("<listener>");
            sb.append("<listener-class>");
            sb.append(SerializableSessionAttributeListener.class.getName());
            sb.append("</listener-class>");
            sb.append("</listener>");
        }
        sb.append(this.getDynamicResourceServletContent());
        File serverConfigWsdd = new File(srcFile + "/WEB-INF/server-config.wsdd");
        if (serverConfigWsdd.exists() && !(content = FileUtil.read((File)(webXml = new File(srcFile + "/WEB-INF/web.xml")))).contains("axis.servicesPath")) {
            String remotingContent = FileUtil.read((String)DeployUtil.getResourcePath("remoting-web.xml"));
            sb.append(remotingContent);
        }
        boolean hasTaglib = false;
        if (Validator.isNotNull((String)this.auiTaglibDTD) || Validator.isNotNull((String)this.portletTaglibDTD) || Validator.isNotNull((String)this.portletExtTaglibDTD) || Validator.isNotNull((String)this.securityTaglibDTD) || Validator.isNotNull((String)this.themeTaglibDTD) || Validator.isNotNull((String)this.uiTaglibDTD) || Validator.isNotNull((String)this.utilTaglibDTD)) {
            hasTaglib = true;
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("<jsp-config>");
        }
        if (Validator.isNotNull((String)this.auiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/aui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/aui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.portletTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://java.sun.com/portlet_2_0</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.portletExtTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/portlet");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet-ext.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.securityTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/security");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-security.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.themeTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/theme</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-theme.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.uiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/ui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-ui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull((String)this.utilTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/util</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-util.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("</jsp-config>");
        }
        return sb.toString();
    }

    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        return this.getSessionFiltersContent();
    }

    public String getIgnoreFiltersContent(File srcFile) throws Exception {
        boolean ignoreFiltersEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            ignoreFiltersEnabled = GetterUtil.getBoolean((String)properties.getProperty("ignore-filters-enabled"), (boolean)true);
        }
        if (ignoreFiltersEnabled) {
            String ignoreFiltersContent = FileUtil.read((String)DeployUtil.getResourcePath("ignore-filters-web.xml"));
            return ignoreFiltersContent;
        }
        return "";
    }

    public String getInvokerFilterContent() {
        StringBundler sb = new StringBundler(4);
        sb.append(this.getInvokerFilterContent("ERROR"));
        sb.append(this.getInvokerFilterContent("FORWARD"));
        sb.append(this.getInvokerFilterContent("INCLUDE"));
        sb.append(this.getInvokerFilterContent("REQUEST"));
        return sb.toString();
    }

    public String getInvokerFilterContent(String dispatcher) {
        StringBundler sb = new StringBundler(23);
        sb.append("<filter>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<filter-class>");
        sb.append(InvokerFilter.class.getName());
        sb.append("</filter-class>");
        sb.append("<init-param>");
        sb.append("<param-name>dispatcher</param-name>");
        sb.append("<param-value>");
        sb.append(dispatcher);
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("</filter>");
        sb.append("<filter-mapping>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<url-pattern>/*</url-pattern>");
        sb.append("<dispatcher>");
        sb.append(dispatcher);
        sb.append("</dispatcher>");
        sb.append("</filter-mapping>");
        return sb.toString();
    }

    public String getPluginPackageLicensesXml(List<License> licenses) {
        if (licenses.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(5 * licenses.size() + 2);
        int i2 = 0;
        while (i2 < licenses.size()) {
            License license = licenses.get(i2);
            if (i2 == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<license osi-approved=\"");
            sb.append(license.isOsiApproved());
            sb.append("\">");
            sb.append(license.getName());
            sb.append("</license>\r\n");
            if (i2 + 1 == licenses.size()) {
                sb.append("\t");
            }
            ++i2;
        }
        return sb.toString();
    }

    public String getPluginPackageLiferayVersionsXml(List<String> liferayVersions) {
        if (liferayVersions.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(liferayVersions.size() * 3 + 2);
        int i2 = 0;
        while (i2 < liferayVersions.size()) {
            String liferayVersion = liferayVersions.get(i2);
            if (i2 == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<liferay-version>");
            sb.append(liferayVersion);
            sb.append("</liferay-version>\r\n");
            if (i2 + 1 == liferayVersions.size()) {
                sb.append("\t");
            }
            ++i2;
        }
        return sb.toString();
    }

    public Properties getPluginPackageProperties(File srcFile) throws Exception {
        File propertiesFile = new File(srcFile + "/WEB-INF/liferay-plugin-package.properties");
        if (!propertiesFile.exists()) {
            return null;
        }
        String propertiesString = FileUtil.read((File)propertiesFile);
        return PropertiesUtil.load((String)propertiesString);
    }

    public String getPluginPackageRequiredDeploymentContextsXml(List<String> requiredDeploymentContexts) {
        if (requiredDeploymentContexts.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(requiredDeploymentContexts.size() * 3 + 2);
        int i2 = 0;
        while (i2 < requiredDeploymentContexts.size()) {
            String requiredDeploymentContext = requiredDeploymentContexts.get(i2);
            if (i2 == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<required-deployment-context>");
            sb.append(requiredDeploymentContext);
            sb.append("</required-deployment-context>\r\n");
            if (i2 + 1 == requiredDeploymentContexts.size()) {
                sb.append("\t");
            }
            ++i2;
        }
        return sb.toString();
    }

    public String getPluginPackageTagsXml(List<String> tags) {
        if (tags.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(tags.size() * 3 + 2);
        int i2 = 0;
        while (i2 < tags.size()) {
            String tag = tags.get(i2);
            if (i2 == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<tag>");
            sb.append(tag);
            sb.append("</tag>\r\n");
            if (i2 + 1 == tags.size()) {
                sb.append("\t");
            }
            ++i2;
        }
        return sb.toString();
    }

    public Map<String, String> getPluginPackageXmlFilterMap(PluginPackage pluginPackage) {
        List pluginTypes = pluginPackage.getTypes();
        String pluginType = (String)pluginTypes.get(0);
        if (!pluginType.equals(this.getPluginType())) {
            return null;
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("author", this._wrapCDATA(pluginPackage.getAuthor()));
        filterMap.put("change_log", this._wrapCDATA(pluginPackage.getChangeLog()));
        filterMap.put("licenses", this.getPluginPackageLicensesXml(pluginPackage.getLicenses()));
        filterMap.put("liferay_versions", this.getPluginPackageLiferayVersionsXml(pluginPackage.getLiferayVersions()));
        filterMap.put("long_description", this._wrapCDATA(pluginPackage.getLongDescription()));
        filterMap.put("module_artifact_id", pluginPackage.getArtifactId());
        filterMap.put("module_group_id", pluginPackage.getGroupId());
        filterMap.put("module_version", pluginPackage.getVersion());
        filterMap.put("page_url", pluginPackage.getPageURL());
        filterMap.put("plugin_name", this._wrapCDATA(pluginPackage.getName()));
        filterMap.put("plugin_type", pluginType);
        filterMap.put("plugin_type_name", TextFormatter.format((String)pluginType, (int)9));
        filterMap.put("recommended_deployment_context", pluginPackage.getRecommendedDeploymentContext());
        filterMap.put("required_deployment_contexts", this.getPluginPackageRequiredDeploymentContextsXml(pluginPackage.getRequiredDeploymentContexts()));
        filterMap.put("short_description", this._wrapCDATA(pluginPackage.getShortDescription()));
        filterMap.put("tags", this.getPluginPackageTagsXml(pluginPackage.getTags()));
        return filterMap;
    }

    public String getPluginType() {
        return null;
    }

    public String getServletContextIncludeFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        if (webXmlVersion < 2.4) {
            return "";
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null) {
            return "";
        }
        if (!GetterUtil.getBoolean((String)properties.getProperty("servlet-context-include-filters-enabled"), (boolean)true)) {
            return "";
        }
        return FileUtil.read((String)DeployUtil.getResourcePath("servlet-context-include-filters-web.xml"));
    }

    public String getSessionFiltersContent() throws Exception {
        String sessionFiltersContent = FileUtil.read((String)DeployUtil.getResourcePath("session-filters-web.xml"));
        return sessionFiltersContent;
    }

    public String getSpeedFiltersContent(File srcFile) throws Exception {
        boolean speedFiltersEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            speedFiltersEnabled = GetterUtil.getBoolean((String)properties.getProperty("speed-filters-enabled"), (boolean)true);
        }
        if (speedFiltersEnabled) {
            String speedFiltersContent = FileUtil.read((String)DeployUtil.getResourcePath("speed-filters-web.xml"));
            return speedFiltersContent;
        }
        return "";
    }

    public boolean isJEEDeploymentEnabled() {
        return GetterUtil.getBoolean((String)PropsUtil.get("auto.deploy." + ServerDetector.getServerId() + ".jee.deployment.enabled"));
    }

    public void mergeDirectory(File mergeDir, File targetDir) {
        if (mergeDir == null || !mergeDir.exists()) {
            return;
        }
        CopyTask.copyDirectory((File)mergeDir, (File)targetDir, null, null, (boolean)true, (boolean)false);
    }

    public void postDeploy(String destDir, String deployDir) throws Exception {
        if (this.appServerType.equals("glassfish")) {
            this.postDeployGlassfish(destDir, deployDir);
        } else if (this.appServerType.equals("jboss")) {
            this.postDeployJBoss(destDir, deployDir);
        } else if (this.appServerType.equals("websphere")) {
            this.postDeployWebSphere(destDir, deployDir);
        }
    }

    public void postDeployGlassfish(String destDir, String deployDir) throws Exception {
        FileUtil.delete((String)(String.valueOf(destDir) + "/.autodeploystatus/" + deployDir));
    }

    public void postDeployJBoss(String destDir, String deployDir) throws Exception {
        FileUtil.write((String)(String.valueOf(destDir) + "/" + deployDir + ".dodeploy"), (String)"");
    }

    public void postDeployWebSphere(String destDir, String deployDir) throws Exception {
        String pluginServletContextName;
        if (Validator.isNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_QUERY)) {
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler();
                sb.append("Do not install the plugin with wsadmin since the ");
                sb.append("property \"");
                sb.append("auto.deploy.websphere.wsadmin.app.manager.query");
                sb.append("\"is not configured");
                _log.info((Object)sb.toString());
            }
            return;
        }
        String wsadminContent = FileUtil.read((String)DeployUtil.getResourcePath("wsadmin.py"));
        String adminAppListOptions = PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_LIST_OPTIONS;
        if (Validator.isNotNull((String)adminAppListOptions)) {
            adminAppListOptions = "'" + adminAppListOptions + "'";
        }
        wsadminContent = StringUtil.replace((String)wsadminContent, (String[])new String[]{"${auto.deploy.websphere.wsadmin.app.manager.install.options}", "${auto.deploy.websphere.wsadmin.app.manager.list.options}", "${auto.deploy.websphere.wsadmin.app.manager.query}", "${auto.deploy.websphere.wsadmin.app.manager.update.options}"}, (String[])new String[]{PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_INSTALL_OPTIONS, adminAppListOptions, PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_QUERY, PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_MANAGER_UPDATE_OPTIONS});
        String pluginApplicationName = pluginServletContextName = deployDir.substring(0, deployDir.length() - 4);
        if (Validator.isNotNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_NAME_SUFFIX)) {
            pluginApplicationName = String.valueOf(pluginApplicationName) + PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_APP_NAME_SUFFIX;
        }
        wsadminContent = StringUtil.replace((String)wsadminContent, (String[])new String[]{"${auto.deploy.dest.dir}", "${auto.deploy.websphere.wsadmin.app.name}", "${plugin.servlet.context.name}"}, (String[])new String[]{destDir, pluginApplicationName, pluginServletContextName});
        String wsadminFileName = FileUtil.createTempFileName((String)"py");
        FileUtil.write((String)wsadminFileName, (String)wsadminContent);
        String webSphereHome = System.getenv("WAS_HOME");
        ArrayList<String> commands = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            commands.add(String.valueOf(webSphereHome) + "\\bin\\wsadmin.bat");
        } else {
            commands.add(String.valueOf(webSphereHome) + "/bin/wsadmin.sh");
        }
        if (Validator.isNotNull((String)PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_PROPERTIES_FILE)) {
            commands.add("-p");
            commands.add(PropsValues.AUTO_DEPLOY_WEBSPHERE_WSADMIN_PROPERTIES_FILE);
        }
        commands.add("-f");
        commands.add(wsadminFileName);
        if (_log.isInfoEnabled()) {
            StringBundler sb = new StringBundler(commands.size() + 1);
            sb.append("Installing plugin by executing");
            for (String command : commands) {
                sb.append(" ");
                sb.append(command);
            }
            _log.info((Object)sb.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        if (_log.isInfoEnabled()) {
            InputStream inputStream = process.getInputStream();
            String output = StringUtil.read((InputStream)inputStream);
            String[] stringArray = StringUtil.split((String)output, (char)'\n');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                _log.info((Object)("Process output: " + line));
                ++n2;
            }
            int exitValue = process.exitValue();
            if (exitValue == 0) {
                _log.info((Object)("Successfully executed command with an exit value of " + exitValue));
            } else {
                _log.info((Object)("Unsuccessfully executed command with an exit value of " + exitValue));
            }
        }
        FileUtil.delete((String)wsadminFileName);
    }

    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (pluginPackage == null) {
            return null;
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null || properties.size() == 0) {
            return null;
        }
        Map<String, String> filterMap = this.getPluginPackageXmlFilterMap(pluginPackage);
        if (filterMap == null) {
            return null;
        }
        this.copyDependencyXml("liferay-plugin-package.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }

    /*
     * Loose catch block
     */
    public PluginPackage readPluginPackage(File file) {
        PluginPackage pluginPackage;
        ZipFile zipFile;
        InputStream is;
        block52: {
            block50: {
                PluginPackage pluginPackage2;
                block51: {
                    boolean parseProps;
                    block48: {
                        block49: {
                            if (!file.exists()) {
                                return null;
                            }
                            is = null;
                            zipFile = null;
                            parseProps = false;
                            if (file.isDirectory()) {
                                String path = file.getPath();
                                File pluginPackageXmlFile = new File(String.valueOf(file.getParent()) + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.xml");
                                if (pluginPackageXmlFile.exists()) {
                                    is = new FileInputStream(pluginPackageXmlFile);
                                } else {
                                    pluginPackageXmlFile = new File(String.valueOf(path) + "/WEB-INF/liferay-plugin-package.xml");
                                    if (pluginPackageXmlFile.exists()) {
                                        is = new FileInputStream(pluginPackageXmlFile);
                                    }
                                }
                                File pluginPackagePropertiesFile = new File(String.valueOf(file.getParent()) + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.properties");
                                if (is == null && pluginPackagePropertiesFile.exists()) {
                                    is = new FileInputStream(pluginPackagePropertiesFile);
                                    parseProps = true;
                                } else {
                                    pluginPackagePropertiesFile = new File(String.valueOf(path) + "/WEB-INF/liferay-plugin-package.properties");
                                    if (is == null && pluginPackagePropertiesFile.exists()) {
                                        is = new FileInputStream(pluginPackagePropertiesFile);
                                        parseProps = true;
                                    }
                                }
                            } else {
                                zipFile = new ZipFile(file);
                                File pluginPackageXmlFile = new File(String.valueOf(file.getParent()) + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.xml");
                                if (pluginPackageXmlFile.exists()) {
                                    is = new FileInputStream(pluginPackageXmlFile);
                                } else {
                                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.xml");
                                    if (zipEntry != null) {
                                        is = zipFile.getInputStream(zipEntry);
                                    }
                                }
                                File pluginPackagePropertiesFile = new File(String.valueOf(file.getParent()) + "/merge/" + file.getName() + "/WEB-INF/liferay-plugin-package.properties");
                                if (is == null && pluginPackagePropertiesFile.exists()) {
                                    is = new FileInputStream(pluginPackagePropertiesFile);
                                    parseProps = true;
                                } else {
                                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.properties");
                                    if (is == null && zipEntry != null) {
                                        is = zipFile.getInputStream(zipEntry);
                                        parseProps = true;
                                    }
                                }
                            }
                            if (is != null) break block48;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)(String.valueOf(file.getPath()) + " does not have a " + "WEB-INF/liferay-plugin-package.xml or " + "WEB-INF/liferay-plugin-package.properties"));
                            }
                            if (is == null) break block49;
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return null;
                    }
                    if (!parseProps) break block50;
                    String displayName = this.getDisplayName(file);
                    String propertiesString = StringUtil.read((InputStream)is);
                    Properties properties = PropertiesUtil.load((String)propertiesString);
                    pluginPackage2 = PluginPackageUtil.readPluginPackageProperties(displayName, properties);
                    if (is == null) break block51;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return pluginPackage2;
            }
            String xml = StringUtil.read((InputStream)is);
            xml = XMLFormatter.fixProlog((String)xml);
            pluginPackage = PluginPackageUtil.readPluginPackageXml(xml);
            if (is == null) break block52;
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return pluginPackage;
        catch (Exception e2) {
            block53: {
                try {
                    _log.error((Object)(String.valueOf(file.getPath()) + ": " + e2.toString()));
                    if (is == null) break block53;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void rewriteFiles(File srcDir) throws Exception {
        String[] fileNames;
        String[] stringArray = fileNames = FileUtil.listFiles((String)(srcDir + "/WEB-INF/"));
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                String ext;
                String fileName = stringArray[n2];
                String shortFileName = GetterUtil.getString((String)FileUtil.getShortFileName((String)fileName));
                if (!StringUtil.equalsIgnoreCase((String)shortFileName, (String)"mule-config.xml") && StringUtil.equalsIgnoreCase((String)(ext = GetterUtil.getString((String)FileUtil.getExtension((String)fileName))), (String)"xml")) {
                    File file = new File(srcDir + "/WEB-INF/" + fileName);
                    try {
                        Document doc = SAXReaderUtil.read((File)file);
                        String content = doc.formattedString("\t", true);
                        FileUtil.write((File)file, (String)content);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block4;
                        _log.warn((Object)("Unable to format " + file + ": " + e2.getMessage()));
                    }
                }
            }
            ++n2;
        }
    }

    public String secureWebXml(String content, boolean hasCustomServletListener, boolean securityManagerEnabled) throws Exception {
        if (!hasCustomServletListener && !securityManagerEnabled) {
            return content;
        }
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        ArrayList<String> listenerClasses = new ArrayList<String>();
        List listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString((String)listenerElement.elementText("listener-class"));
            if (listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            listenerClasses.add(listenerClass);
            listenerElement.detach();
        }
        Element contextParamElement = rootElement.addElement("context-param");
        DocUtil.add((Element)contextParamElement, (String)"param-name", (String)"portalListenerClasses");
        DocUtil.add((Element)contextParamElement, (String)"param-value", (String)StringUtil.merge(listenerClasses));
        if (!securityManagerEnabled) {
            return document.compactString();
        }
        List servletElements = rootElement.elements("servlet");
        for (Element servletElement : servletElements) {
            Element servletClassElement = servletElement.element("servlet-class");
            String servletClass = GetterUtil.getString((String)servletClassElement.getText());
            if (servletClass.equals(PortalClassLoaderServlet.class.getName()) || servletClass.equals(PortalDelegateServlet.class.getName()) || servletClass.equals(PortletServlet.class.getName())) continue;
            servletClassElement.setText(SecureServlet.class.getName());
            Element initParamElement = servletElement.addElement("init-param");
            DocUtil.add((Element)initParamElement, (String)"param-name", (String)"servlet-class");
            DocUtil.add((Element)initParamElement, (String)"param-value", (String)servletClass);
        }
        return document.compactString();
    }

    public void setAppServerType(String appServerType) {
        this.appServerType = appServerType;
    }

    public void setAuiTaglibDTD(String auiTaglibDTD) {
        this.auiTaglibDTD = auiTaglibDTD;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setJars(List<String> jars) {
        this.jars = jars;
    }

    public void setJbossPrefix(String jbossPrefix) {
        this.jbossPrefix = jbossPrefix;
    }

    public void setPortletExtTaglibDTD(String portletExtTaglibDTD) {
        this.portletExtTaglibDTD = portletExtTaglibDTD;
    }

    public void setPortletTaglibDTD(String portletTaglibDTD) {
        this.portletTaglibDTD = portletTaglibDTD;
    }

    public void setSecurityTaglibDTD(String securityTaglibDTD) {
        this.securityTaglibDTD = securityTaglibDTD;
    }

    public void setThemeTaglibDTD(String themeTaglibDTD) {
        this.themeTaglibDTD = themeTaglibDTD;
    }

    public void setTomcatLibDir(String tomcatLibDir) {
        this.tomcatLibDir = tomcatLibDir;
    }

    public void setUiTaglibDTD(String uiTaglibDTD) {
        this.uiTaglibDTD = uiTaglibDTD;
    }

    public void setUnpackWar(boolean unpackWar) {
        this.unpackWar = unpackWar;
    }

    public void setUtilTaglibDTD(String utilTaglibDTD) {
        this.utilTaglibDTD = utilTaglibDTD;
    }

    public void setWars(List<String> wars) {
        this.wars = wars;
    }

    public void updateDeployDirectory(File srcFile) throws Exception {
    }

    public void updateGeronimoWebXml(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (!this.appServerType.equals("geronimo")) {
            return;
        }
        File geronimoWebXml = new File(srcFile + "/WEB-INF/geronimo-web.xml");
        Document document = SAXReaderUtil.read((File)geronimoWebXml);
        Element rootElement = document.getRootElement();
        Element environmentElement = rootElement.element("environment");
        Element moduleIdElement = environmentElement.element("moduleId");
        Element artifactIdElement = moduleIdElement.element("artifactId");
        artifactIdElement.setText(displayName);
        Element versionElement = moduleIdElement.element("version");
        versionElement.setText(pluginPackage.getVersion());
        String content = document.formattedString();
        FileUtil.write((File)geronimoWebXml, (String)content);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modifying Geronimo " + geronimoWebXml));
        }
    }

    public String updateLiferayWebXml(double webXmlVersion, File srcFile, String webXmlContent) throws Exception {
        boolean liferayWebXmlEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            liferayWebXmlEnabled = GetterUtil.getBoolean((String)properties.getProperty("liferay-web-xml-enabled"), (boolean)true);
        }
        webXmlContent = WebXMLBuilder.organizeWebXML(webXmlContent);
        int x = webXmlContent.indexOf("<filter>");
        int y = webXmlContent.lastIndexOf("</filter-mapping>");
        String webXmlFiltersContent = "";
        if (x == -1 || y == -1) {
            y = x = webXmlContent.lastIndexOf("</display-name>") + 15;
        } else if (liferayWebXmlEnabled && webXmlVersion > 2.3) {
            webXmlFiltersContent = webXmlContent.substring(x, y + 17);
            y += 17;
        } else {
            x = y + 17;
            y += 17;
        }
        if (webXmlVersion < 2.4) {
            webXmlContent = String.valueOf(webXmlContent.substring(0, x)) + this.getExtraFiltersContent(webXmlVersion, srcFile) + webXmlContent.substring(y);
            return webXmlContent;
        }
        String filtersContent = String.valueOf(webXmlFiltersContent) + this.getExtraFiltersContent(webXmlVersion, srcFile);
        String liferayWebXmlContent = FileUtil.read((String)DeployUtil.getResourcePath("web.xml"));
        int z = liferayWebXmlContent.indexOf("</web-app>");
        liferayWebXmlContent = String.valueOf(liferayWebXmlContent.substring(0, z)) + filtersContent + liferayWebXmlContent.substring(z);
        liferayWebXmlContent = WebXMLBuilder.organizeWebXML(liferayWebXmlContent);
        FileUtil.write((String)(srcFile + "/WEB-INF/liferay-web.xml"), (String)liferayWebXmlContent);
        webXmlContent = String.valueOf(webXmlContent.substring(0, x)) + this.getInvokerFilterContent() + webXmlContent.substring(y);
        return webXmlContent;
    }

    public void updateWebXml(File webXml, File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        String content = FileUtil.read((File)webXml);
        int x = (content = WebXMLBuilder.organizeWebXML(content)).indexOf("<display-name>");
        if (x != -1) {
            int y = content.indexOf("</display-name>", x);
            y = content.indexOf(">", y) + 1;
            content = String.valueOf(content.substring(0, x)) + content.substring(y);
        }
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        double webXmlVersion = GetterUtil.getDouble((String)rootElement.attributeValue("version"), (double)2.3);
        if (!PropsValues.TCK_URL && webXmlVersion <= 2.3) {
            throw new AutoDeployException(String.valueOf(webXml.getName()) + " must be updated to the Servlet 2.4 specification");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<listener>");
        sb.append("<listener-class>");
        boolean hasCustomServletListener = false;
        List listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString((String)listenerElement.elementText("listener-class"));
            if (listenerClass.equals(SerializableSessionAttributeListener.class.getName()) || listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            hasCustomServletListener = true;
            break;
        }
        boolean securityManagerEnabled = false;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            securityManagerEnabled = GetterUtil.getBoolean((String)properties.getProperty("security-manager-enabled"));
        }
        if (hasCustomServletListener || securityManagerEnabled) {
            sb.append(SecurePluginContextListener.class.getName());
        } else {
            sb.append(PluginContextListener.class.getName());
        }
        sb.append("</listener-class>");
        sb.append("</listener>");
        String pluginContextListenerContent = sb.toString();
        String extraContent = this.getExtraContent(webXmlVersion, srcFile, displayName);
        int pos = content.indexOf("<listener>");
        if (pos == -1) {
            pos = content.indexOf("</web-app>");
        }
        String newContent = String.valueOf(content.substring(0, pos)) + pluginContextListenerContent + extraContent + content.substring(pos);
        newContent = this.updateLiferayWebXml(webXmlVersion, srcFile, newContent);
        newContent = this.secureWebXml(newContent, hasCustomServletListener, securityManagerEnabled);
        newContent = WebXMLBuilder.organizeWebXML(newContent);
        FileUtil.write((File)webXml, (String)newContent, (boolean)true);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Modifying Servlet " + webXmlVersion + " " + webXml));
        }
    }

    private String _wrapCDATA(String string) {
        return "<![CDATA[" + string + "]]>";
    }
}

