/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.StagnantRowException;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.apache.commons.lang.time.StopWatch;

public class Table {
    private static final int _BATCH_SIZE = GetterUtil.getInteger((String)PropsUtil.get("hibernate.jdbc.batch_size"));
    private static final String[][] _SAFE_TABLE_CHARS = new String[][]{{",", "\n", "\r"}, {"_SAFE_TABLE_COMMA_CHARACTER_", "_SAFE_TABLE_NEWLINE_CHARACTER_", "_SAFE_TABLE_RETURN_CHARACTER_"}};
    private static final String _SAFE_TABLE_COMMA_CHARACTER = "_SAFE_TABLE_COMMA_CHARACTER_";
    private static final String _SAFE_TABLE_NEWLINE_CHARACTER = "_SAFE_TABLE_NEWLINE_CHARACTER_";
    private static final String _SAFE_TABLE_RETURN_CHARACTER = "_SAFE_TABLE_RETURN_CHARACTER_";
    private static Log _log = LogFactoryUtil.getLog(Table.class);
    private Object[][] _columns;
    private String _createSQL;
    private int[] _order;
    private String _selectSQL;
    private String _tableName;
    private long _totalRows;

    public Table(String tableName) {
        this._tableName = tableName;
    }

    public Table(String tableName, Object[][] columns) {
        this._tableName = tableName;
        this.setColumns(columns);
    }

    public void appendColumn(StringBuilder sb, Object value, boolean last) throws Exception {
        if (value == null) {
            throw new UpgradeException("Nulls should never be inserted into the database. Attempted to append column to " + sb.toString() + ".");
        }
        if (value instanceof Clob || value instanceof String) {
            value = StringUtil.replace((String)((String)value), (String[])_SAFE_TABLE_CHARS[0], (String[])_SAFE_TABLE_CHARS[1]);
            sb.append(value);
        } else if (value instanceof Date) {
            DateFormat df = DateUtil.getISOFormat();
            sb.append(df.format(value));
        } else {
            sb.append(value);
        }
        sb.append(",");
        if (last) {
            sb.append("\n");
        }
    }

    public void appendColumn(StringBuilder sb, ResultSet rs, String name, Integer type, boolean last) throws Exception {
        Object value = null;
        try {
            value = this.getValue(rs, name, type);
        }
        catch (SQLException sQLException) {
            if (name.equals("uuid_")) {
                sb.append(PortalUUIDUtil.generate());
            }
            sb.append(",");
            if (last) {
                sb.append("\n");
            }
            return;
        }
        this.appendColumn(sb, value, last);
    }

    public String generateTempFile() throws Exception {
        Connection con = DataAccess.getUpgradeOptimizedConnection();
        try {
            String string = this.generateTempFile(con);
            return string;
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    public String generateTempFile(Connection con) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean empty = true;
        String tempFileName = String.valueOf(SystemProperties.get((String)"java.io.tmpdir")) + "/temp-db-" + this._tableName + "-" + System.currentTimeMillis();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Starting backup of " + this._tableName + " to " + tempFileName));
        }
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(tempFileName));
        try {
            try {
                ps = this.getSelectPreparedStatement(con);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String data = null;
                    try {
                        data = this.getExportedData(rs);
                        unsyncBufferedWriter.write(data);
                        ++this._totalRows;
                        empty = false;
                    }
                    catch (StagnantRowException sre) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("Skipping stagnant data in " + this._tableName + ": " + sre.getMessage()));
                    }
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Finished backup of " + this._tableName + " to " + tempFileName + " in " + stopWatch.getTime() + " ms"));
                }
            }
            catch (Exception e2) {
                FileUtil.delete((String)tempFileName);
                throw e2;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(null, (Statement)ps, rs);
            unsyncBufferedWriter.close();
            throw throwable;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        unsyncBufferedWriter.close();
        if (!empty) {
            return tempFileName;
        }
        FileUtil.delete((String)tempFileName);
        return null;
    }

    public Object[][] getColumns() {
        return this._columns;
    }

    public String getCreateSQL() throws Exception {
        return this._createSQL;
    }

    public String getDeleteSQL() throws Exception {
        return "DELETE FROM " + this._tableName;
    }

    public String getExportedData(ResultSet rs) throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[][] columns = this.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            boolean last = false;
            if (i2 + 1 == columns.length) {
                last = true;
            }
            this.appendColumn(sb, rs, (String)columns[i2][0], (Integer)columns[i2][1], last);
            ++i2;
        }
        return sb.toString();
    }

    public String getInsertSQL() throws Exception {
        String sql = "INSERT INTO " + this.getInsertTableName() + " (";
        int i2 = 0;
        while (i2 < this._order.length) {
            int pos = this._order[i2];
            sql = String.valueOf(sql) + this._columns[pos][0];
            sql = i2 + 1 < this._columns.length ? String.valueOf(sql) + ", " : String.valueOf(sql) + ") VALUES (";
            ++i2;
        }
        i2 = 0;
        while (i2 < this._columns.length) {
            sql = String.valueOf(sql) + "?";
            sql = i2 + 1 < this._columns.length ? String.valueOf(sql) + ", " : String.valueOf(sql) + ")";
            ++i2;
        }
        return sql;
    }

    public String getInsertTableName() throws Exception {
        String createSQL = this.getCreateSQL();
        if (Validator.isNotNull((String)createSQL)) {
            String createSQLLowerCase = StringUtil.toLowerCase((String)createSQL);
            int x = createSQLLowerCase.indexOf("create table ");
            if (x == -1) {
                return this._tableName;
            }
            int y = createSQL.indexOf(" ", x += 13);
            return createSQL.substring(x, y).trim();
        }
        return this._tableName;
    }

    public int[] getOrder() {
        return this._order;
    }

    public PreparedStatement getSelectPreparedStatement(Connection con) throws Exception {
        return con.prepareStatement(this.getSelectSQL());
    }

    public String getSelectSQL() throws Exception {
        if (this._selectSQL == null) {
            return "select * from " + this._tableName;
        }
        return this._selectSQL;
    }

    public String getTableName() {
        return this._tableName;
    }

    public long getTotalRows() {
        return this._totalRows;
    }

    public Object getValue(ResultSet rs, String name, Integer type) throws Exception {
        Object value;
        block32: {
            value = null;
            int t = type;
            if (t == -5) {
                try {
                    value = GetterUtil.getLong((Object)rs.getLong(name));
                }
                catch (SQLException sQLException) {
                    value = GetterUtil.getLong((String)rs.getString(name));
                }
            } else if (t == -7) {
                value = GetterUtil.getBoolean((Object)rs.getBoolean(name));
            } else if (t == 16) {
                value = GetterUtil.getBoolean((Object)rs.getBoolean(name));
            } else if (t == 2005) {
                try {
                    Clob clob = rs.getClob(name);
                    if (clob == null) {
                        value = "";
                        break block32;
                    }
                    UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(clob.getCharacterStream());
                    StringBundler sb = new StringBundler();
                    String line = null;
                    while ((line = unsyncBufferedReader.readLine()) != null) {
                        if (sb.length() != 0) {
                            sb.append(_SAFE_TABLE_NEWLINE_CHARACTER);
                        }
                        sb.append(line);
                    }
                    value = sb.toString();
                }
                catch (Exception exception) {
                    value = GetterUtil.getString((String)rs.getString(name));
                }
            } else if (t == 8) {
                value = GetterUtil.getDouble((Object)rs.getDouble(name));
            } else if (t == 6) {
                value = Float.valueOf(GetterUtil.getFloat((Object)Float.valueOf(rs.getFloat(name))));
            } else if (t == 4) {
                value = GetterUtil.getInteger((Object)rs.getInt(name));
            } else if (t == 2) {
                value = GetterUtil.getLong((Object)rs.getLong(name));
            } else if (t == 5) {
                value = GetterUtil.getShort((Object)rs.getShort(name));
            } else if (t == 93) {
                try {
                    value = rs.getTimestamp(name);
                }
                catch (Exception exception) {}
                if (value == null) {
                    value = "null";
                }
            } else if (t == 12) {
                value = GetterUtil.getString((String)rs.getString(name));
            } else {
                throw new UpgradeException("Upgrade code using unsupported class type " + type);
            }
        }
        return value;
    }

    public void populateTable(String tempFileName) throws Exception {
        Connection con = DataAccess.getUpgradeOptimizedConnection();
        try {
            this.populateTable(tempFileName, con);
        }
        finally {
            DataAccess.cleanUp((Connection)con);
        }
    }

    public void populateTable(String tempFileName, Connection con) throws Exception {
        PreparedStatement ps = null;
        String insertSQL = this.getInsertSQL();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(tempFileName));
        String line = null;
        try {
            DatabaseMetaData databaseMetaData = con.getMetaData();
            if (!databaseMetaData.supportsBatchUpdates() && _log.isDebugEnabled()) {
                _log.debug((Object)"Database does not support batch updates");
            }
            int count = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Object[][] columns;
                String[] values = StringUtil.split((String)line);
                if (values.length != (columns = this.getColumns()).length) {
                    throw new UpgradeException("Column lengths differ between temp file and schema. Attempted to insert row " + line + ".");
                }
                if (count == 0) {
                    ps = con.prepareStatement(insertSQL);
                }
                int[] order = this.getOrder();
                int i2 = 0;
                while (i2 < order.length) {
                    int pos = order[i2];
                    this.setColumn(ps, i2, (Integer)columns[pos][1], values[pos]);
                    ++i2;
                }
                if (databaseMetaData.supportsBatchUpdates()) {
                    ps.addBatch();
                    if (count == _BATCH_SIZE) {
                        this.populateTableRows(ps, true);
                        count = 0;
                        continue;
                    }
                    ++count;
                    continue;
                }
                this.populateTableRows(ps, false);
            }
            if (databaseMetaData.supportsBatchUpdates() && count != 0) {
                this.populateTableRows(ps, true);
            }
        }
        finally {
            DataAccess.cleanUp(null, ps);
            unsyncBufferedReader.close();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(this.getTableName()) + " table populated with data"));
        }
    }

    public void populateTableRows(PreparedStatement ps, boolean batch) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating rows for " + this.getTableName()));
        }
        if (batch) {
            ps.executeBatch();
        } else {
            ps.executeUpdate();
        }
        ps.close();
    }

    public void setColumn(PreparedStatement ps, int index, Integer type, String value) throws Exception {
        int t = type;
        int paramIndex = index + 1;
        if (t == -5) {
            ps.setLong(paramIndex, GetterUtil.getLong((String)value));
        } else if (t == 16) {
            ps.setBoolean(paramIndex, GetterUtil.getBoolean((String)value));
        } else if (t == 2005 || t == 12) {
            value = StringUtil.replace((String)value, (String[])_SAFE_TABLE_CHARS[1], (String[])_SAFE_TABLE_CHARS[0]);
            ps.setString(paramIndex, value);
        } else if (t == 8) {
            ps.setDouble(paramIndex, GetterUtil.getDouble((String)value));
        } else if (t == 6) {
            ps.setFloat(paramIndex, GetterUtil.getFloat((String)value));
        } else if (t == 4) {
            ps.setInt(paramIndex, GetterUtil.getInteger((String)value));
        } else if (t == 5) {
            ps.setShort(paramIndex, GetterUtil.getShort((String)value));
        } else if (t == 93) {
            if ("null".equals(value)) {
                ps.setTimestamp(paramIndex, null);
            } else {
                DateFormat df = DateUtil.getISOFormat();
                ps.setTimestamp(paramIndex, new Timestamp(df.parse(value).getTime()));
            }
        } else {
            throw new UpgradeException("Upgrade code using unsupported class type " + type);
        }
    }

    public void setColumns(Object[][] columns) {
        this._columns = columns;
        this._order = new int[this._columns.length];
        int clobCount = 0;
        int i2 = 0;
        while (i2 < this._columns.length) {
            int pos;
            Integer type = (Integer)columns[i2][1];
            if (type == 2005) {
                pos = this._columns.length - ++clobCount;
                this._order[pos] = i2;
            } else {
                pos = i2 - clobCount;
                this._order[pos] = i2;
            }
            ++i2;
        }
    }

    public void setCreateSQL(String createSQL) throws Exception {
        this._createSQL = createSQL;
    }

    public void setSelectSQL(String selectSQL) throws Exception {
        this._selectSQL = selectSQL;
    }
}

