/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upgrade.v6_2_0.util.JournalFeedTable;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.util.JournalConverterImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradeJournal
extends BaseUpgradePortletPreferences {
    private static Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);
    private Map<String, Long> _ddmStructureIds = new HashMap<String, Long>();
    private Map<Long, Long> _ddmStructurePKs = new HashMap<Long, Long>();

    protected void addDDMStructure(String uuid_, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long parentDDMStructureId, long classNameId, String ddmStructureKey, String name, String description, String xsd, String storageType, int type) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                StringBundler sb = new StringBundler(6);
                sb.append("insert into DDMStructure (uuid_, structureId, ");
                sb.append("groupId, companyId, userId, userName, createDate, ");
                sb.append("modifiedDate, parentStructureId, classNameId, ");
                sb.append("structureKey, name, description, xsd, storageType, ");
                sb.append("type_) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
                sb.append("?, ?, ?)");
                String sql = sb.toString();
                ps = con.prepareStatement(sql);
                ps.setString(1, uuid_);
                ps.setLong(2, ddmStructureId);
                ps.setLong(3, groupId);
                ps.setLong(4, companyId);
                ps.setLong(5, userId);
                ps.setString(6, userName);
                ps.setTimestamp(7, createDate);
                ps.setTimestamp(8, modifiedDate);
                ps.setLong(9, parentDDMStructureId);
                ps.setLong(10, classNameId);
                ps.setString(11, ddmStructureKey);
                ps.setString(12, name);
                ps.setString(13, description);
                ps.setString(14, JournalConverterImpl.getDDMXSD(xsd, this.getDefaultLocale(name)));
                ps.setString(15, storageType);
                ps.setInt(16, type);
                ps.executeUpdate();
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to upgrade dynamic data mapping structure with UUID " + uuid_));
                throw e2;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void addDDMStructure(String uuid_, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, String parentStructureId, String ddmStructureKey, String name, String description, String xsd) throws Exception {
        long insertedDDMStructureId;
        long parentDDMStructureId = 0L;
        if (Validator.isNotNull((String)parentStructureId)) {
            parentDDMStructureId = this.updateStructure(parentStructureId);
        }
        if ((insertedDDMStructureId = this.getDDMStructureId(groupId, ddmStructureKey, false)) == 0L) {
            this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentDDMStructureId, PortalUtil.getClassNameId((String)JournalArticle.class.getName()), ddmStructureKey, name, description, xsd, PropsValues.JOURNAL_ARTICLE_STORAGE_TYPE, 0);
        }
    }

    protected void addDDMTemplate(String uuid_, long ddmTemplateId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String templateKey, String name, String description, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, long smallImageId, String smallImageURL) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                StringBundler sb = new StringBundler(6);
                sb.append("insert into DDMTemplate (uuid_, templateId, groupId, ");
                sb.append("companyId, userId, userName, createDate, modifiedDate,");
                sb.append("classNameId, classPK , templateKey, name, description,");
                sb.append("type_, mode_, language, script, cacheable, smallImage,");
                sb.append("smallImageId, smallImageURL) values (?, ?, ?, ?, ?, ?,");
                sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                String sql = sb.toString();
                ps = con.prepareStatement(sql);
                ps.setString(1, uuid_);
                ps.setLong(2, ddmTemplateId);
                ps.setLong(3, groupId);
                ps.setLong(4, companyId);
                ps.setLong(5, userId);
                ps.setString(6, userName);
                ps.setTimestamp(7, createDate);
                ps.setTimestamp(8, modifiedDate);
                ps.setLong(9, classNameId);
                ps.setLong(10, classPK);
                ps.setString(11, templateKey);
                ps.setString(12, name);
                ps.setString(13, description);
                ps.setString(14, type);
                ps.setString(15, mode);
                ps.setString(16, language);
                ps.setString(17, script);
                ps.setBoolean(18, cacheable);
                ps.setBoolean(19, smallImage);
                ps.setLong(20, smallImageId);
                ps.setString(21, smallImageURL);
                ps.executeUpdate();
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to upgrade dynamic data mapping template with UUID " + uuid_));
                throw e2;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void doUpgrade() throws Exception {
        try {
            this.runSQL("alter_column_name JournalFeed feedType feedFormat VARCHAR(75) null");
        }
        catch (SQLException sQLException) {
            this.upgradeTable("JournalFeed", JournalFeedTable.TABLE_COLUMNS, "create table JournalFeed (uuid_ VARCHAR(75) null,id_ LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,feedId VARCHAR(75) null,name VARCHAR(75) null,description STRING null,type_ VARCHAR(75) null,structureId VARCHAR(75) null,templateId VARCHAR(75) null,rendererTemplateId VARCHAR(75) null,delta INTEGER,orderByCol VARCHAR(75) null,orderByType VARCHAR(75) null,targetLayoutFriendlyUrl VARCHAR(255) null,targetPortletId VARCHAR(75) null,contentField VARCHAR(75) null,feedFormat VARCHAR(75) null,feedVersion DOUBLE)", JournalFeedTable.TABLE_SQL_ADD_INDEXES);
        }
        this.updateStructures();
        this.updateTemplates();
        super.doUpgrade();
    }

    protected long getDDMStructureId(long groupId, String structureId) {
        return this.getDDMStructureId(groupId, structureId, true);
    }

    protected long getDDMStructureId(long groupId, String structureId, boolean warn) {
        if (Validator.isNull((String)structureId)) {
            return 0L;
        }
        Long ddmStructureId = this._ddmStructureIds.get(String.valueOf(groupId) + "#" + structureId);
        if (ddmStructureId == null) {
            if (warn && _log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get the DDM structure ID for group " + groupId + " and journal structure ID " + structureId));
            }
            return 0L;
        }
        return ddmStructureId;
    }

    protected Locale getDefaultLocale(String xml) {
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)xml);
        return LocaleUtil.fromLanguageId((String)defaultLanguageId);
    }

    protected String[] getPortletIds() {
        return new String[]{"56_INSTANCE_%", "62_INSTANCE_%", "101_INSTANCE_%"};
    }

    protected void updatePreferencesClassPKs(PortletPreferences preferences, String key) throws Exception {
        String[] oldValues = preferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        int i2 = 0;
        while (i2 < oldValues.length) {
            String[] oldPrimaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i2];
            String[] stringArray = oldPrimaryKeys = StringUtil.split((String)oldValue);
            int n = oldPrimaryKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String oldPrimaryKey = stringArray[n2];
                if (!Validator.isNumber((String)oldPrimaryKey)) break;
                Long newPrimaryKey = this._ddmStructurePKs.get(GetterUtil.getLong((String)oldPrimaryKey));
                if (Validator.isNotNull((Long)newPrimaryKey)) {
                    newValue = StringUtil.replace((String)newValue, (String)oldPrimaryKey, (String)String.valueOf(newPrimaryKey));
                }
                ++n2;
            }
            newValues[i2] = newValue;
            ++i2;
        }
        preferences.setValues(key, newValues);
    }

    protected void updateResourcePermission(long companyId, String oldClassName, String newClassName, long oldPrimKey, long newPrimKey) throws Exception {
        StringBundler sb = new StringBundler(11);
        sb.append("update ResourcePermission set name = '");
        sb.append(newClassName);
        sb.append("', primKey = '");
        sb.append(newPrimKey);
        sb.append("' where companyId = ");
        sb.append(companyId);
        sb.append(" and name = '");
        sb.append(oldClassName);
        sb.append("' and primKey = '");
        sb.append(oldPrimKey);
        sb.append("'");
        this.runSQL(sb.toString());
    }

    protected long updateStructure(String structureId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            Long ddmStructureId;
            String xsd;
            String description;
            String name;
            String parentStructureId;
            Timestamp modifiedDate;
            Timestamp createDate;
            String userName;
            long userId;
            long companyId;
            long groupId;
            long id_;
            String uuid_;
            block6: {
                con = null;
                ps = null;
                rs = null;
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select * from JournalStructure where structureId = ?");
                ps.setString(1, structureId);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                uuid_ = rs.getString("uuid_");
                id_ = rs.getLong("id_");
                groupId = rs.getLong("groupId");
                companyId = rs.getLong("companyId");
                userId = rs.getLong("userId");
                userName = rs.getString("userName");
                createDate = rs.getTimestamp("createDate");
                modifiedDate = rs.getTimestamp("modifiedDate");
                parentStructureId = rs.getString("parentStructureId");
                name = rs.getString("name");
                description = rs.getString("description");
                xsd = rs.getString("xsd");
                ddmStructureId = this._ddmStructureIds.get(String.valueOf(groupId) + "#" + structureId);
                if (ddmStructureId == null) break block6;
                long l = ddmStructureId;
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return l;
            }
            try {
                ddmStructureId = this.increment();
                this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentStructureId, structureId, name, description, xsd);
                this.updateResourcePermission(companyId, JournalStructure.class.getName(), DDMStructure.class.getName(), id_, ddmStructureId);
                this._ddmStructureIds.put(String.valueOf(groupId) + "#" + structureId, ddmStructureId);
            }
            catch (Exception e2) {
                try {
                    _log.error((Object)("Unable to update journal structure with structure ID " + structureId));
                    throw e2;
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                    throw throwable;
                }
            }
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return 0L;
    }

    protected void updateStructures() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from JournalStructure");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long id_ = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String structureId = rs.getString("structureId");
                String parentStructureId = rs.getString("parentStructureId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String xsd = rs.getString("xsd");
                long ddmStructureId = this.increment();
                this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentStructureId, structureId, name, description, xsd);
                this.updateResourcePermission(companyId, JournalStructure.class.getName(), DDMStructure.class.getName(), id_, ddmStructureId);
                this._ddmStructureIds.put(String.valueOf(groupId) + "#" + structureId, ddmStructureId);
                this._ddmStructurePKs.put(id_, ddmStructureId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("drop table JournalStructure");
    }

    protected void updateTemplates() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select * from JournalTemplate");
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid_ = rs.getString("uuid_");
                long id_ = rs.getLong("id_");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String templateId = rs.getString("templateId");
                String structureId = rs.getString("structureId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                String language = rs.getString("langType");
                String script = rs.getString("xsl");
                boolean cacheable = rs.getBoolean("cacheable");
                boolean smallImage = rs.getBoolean("smallImage");
                long smallImageId = rs.getLong("smallImageId");
                String smallImageURL = rs.getString("smallImageURL");
                long ddmTemplateId = this.increment();
                long classNameId = PortalUtil.getClassNameId((String)DDMStructure.class.getName());
                long classPK = this.getDDMStructureId(groupId, structureId);
                this.addDDMTemplate(uuid_, ddmTemplateId, groupId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, templateId, name, description, "display", "create", language, script, cacheable, smallImage, smallImageId, smallImageURL);
                this.updateResourcePermission(companyId, JournalTemplate.class.getName(), DDMTemplate.class.getName(), id_, ddmTemplateId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("drop table JournalTemplate");
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String structureId;
        PortletPreferences preferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        if (portletId.startsWith("101")) {
            this.updatePreferencesClassPKs(preferences, "anyClassTypeJournalArticleAssetRendererFactory");
            this.updatePreferencesClassPKs(preferences, "classTypeIds");
            this.updatePreferencesClassPKs(preferences, "classTypeIdsJournalArticleAssetRendererFactory");
        } else if (portletId.startsWith("56")) {
            String templateId = preferences.getValue("templateId", "");
            if (Validator.isNotNull((String)templateId)) {
                preferences.reset("templateId");
                preferences.setValue("ddmTemplateKey", templateId);
            }
        } else if (portletId.startsWith("62") && Validator.isNotNull((String)(structureId = preferences.getValue("structureId", "")))) {
            preferences.reset("structureId");
            preferences.setValue("ddmStructureKey", structureId);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)preferences);
    }
}

