/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.upload.ProgressInputStream;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

@DoPrivileged
public class HttpImpl
implements Http {
    private static final String _DEFAULT_USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
    private static final int _MAX_CONNECTIONS_PER_HOST = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".max.connections.per.host"), (int)2);
    private static final int _MAX_TOTAL_CONNECTIONS = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".max.total.connections"), (int)20);
    private static final String _NON_PROXY_HOSTS = SystemProperties.get((String)"http.nonProxyHosts");
    private static final String _PROXY_AUTH_TYPE = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.auth.type"));
    private static final String _PROXY_HOST = GetterUtil.getString((String)SystemProperties.get((String)"http.proxyHost"));
    private static final String _PROXY_NTLM_DOMAIN = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.ntlm.domain"));
    private static final String _PROXY_NTLM_HOST = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.ntlm.host"));
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.password"));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)SystemProperties.get((String)"http.proxyPort"));
    private static final String _PROXY_USERNAME = GetterUtil.getString((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".proxy.username"));
    private static final String _TEMP_SLASH = "_LIFERAY_TEMP_SLASH_";
    private static final int _TIMEOUT = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".timeout"), (int)5000);
    private static Log _log = LogFactoryUtil.getLog(HttpImpl.class);
    private static ThreadLocal<javax.servlet.http.Cookie[]> _cookies = new ThreadLocal();
    private HttpClient _httpClient = new HttpClient();
    private Pattern _nonProxyHostsPattern;
    private Credentials _proxyCredentials;
    private HttpClient _proxyHttpClient = new HttpClient();

    public HttpImpl() {
        Protocol protocol = new Protocol("http", (ProtocolSocketFactory)new FastProtocolSocketFactory(), 80);
        Protocol.registerProtocol((String)"http", (Protocol)protocol);
        if (Validator.isNotNull((String)_NON_PROXY_HOSTS)) {
            String nonProxyHostsRegEx = _NON_PROXY_HOSTS;
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\.", "\\\\.");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\*", ".*?");
            nonProxyHostsRegEx = nonProxyHostsRegEx.replaceAll("\\|", ")|(");
            nonProxyHostsRegEx = "(" + nonProxyHostsRegEx + ")";
            this._nonProxyHostsPattern = Pattern.compile(nonProxyHostsRegEx);
        }
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams httpConnectionManagerParams = httpConnectionManager.getParams();
        httpConnectionManagerParams.setConnectionTimeout(_TIMEOUT);
        httpConnectionManagerParams.setDefaultMaxConnectionsPerHost(new Integer(_MAX_CONNECTIONS_PER_HOST).intValue());
        httpConnectionManagerParams.setMaxTotalConnections(new Integer(_MAX_TOTAL_CONNECTIONS).intValue());
        httpConnectionManagerParams.setSoTimeout(_TIMEOUT);
        this._httpClient.setHttpConnectionManager((HttpConnectionManager)httpConnectionManager);
        this._proxyHttpClient.setHttpConnectionManager((HttpConnectionManager)httpConnectionManager);
        if (!this.hasProxyConfig() || Validator.isNull((String)_PROXY_USERNAME)) {
            return;
        }
        ArrayList<String> authPrefs = new ArrayList<String>();
        if (_PROXY_AUTH_TYPE.equals("username-password")) {
            this._proxyCredentials = new UsernamePasswordCredentials(_PROXY_USERNAME, _PROXY_PASSWORD);
            authPrefs.add("Basic");
            authPrefs.add("Digest");
            authPrefs.add("NTLM");
        } else if (_PROXY_AUTH_TYPE.equals("ntlm")) {
            this._proxyCredentials = new NTCredentials(_PROXY_USERNAME, _PROXY_PASSWORD, _PROXY_NTLM_HOST, _PROXY_NTLM_DOMAIN);
            authPrefs.add("NTLM");
            authPrefs.add("Basic");
            authPrefs.add("Digest");
        }
        HttpClientParams httpClientParams = this._proxyHttpClient.getParams();
        httpClientParams.setParameter("http.auth.scheme-priority", authPrefs);
    }

    public String addParameter(String url, String name, boolean value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, double value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, int value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, long value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, short value) {
        return this.addParameter(url, name, String.valueOf(value));
    }

    public String addParameter(String url, String name, String value) {
        if (url == null) {
            return null;
        }
        String[] urlArray = PortalUtil.stripURLAnchor((String)url, (String)"#");
        url = urlArray[0];
        String anchor = urlArray[1];
        StringBundler sb = new StringBundler(7);
        sb.append(url);
        if (url.indexOf(63) == -1) {
            sb.append("?");
        } else if (!url.endsWith("?") && !url.endsWith("&")) {
            sb.append("&");
        }
        sb.append(name);
        sb.append("=");
        sb.append(this.encodeURL(value));
        sb.append(anchor);
        return sb.toString();
    }

    public String decodePath(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        path = StringUtil.replace((String)path, (String)"/", (String)_TEMP_SLASH);
        path = this.decodeURL(path, true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    public String decodeURL(String url) {
        return this.decodeURL(url, false);
    }

    public String decodeURL(String url, boolean unescapeSpaces) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        return URLCodec.decodeURL((String)url, (String)"UTF-8", (boolean)unescapeSpaces);
    }

    public void destroy() {
        MultiThreadedHttpConnectionManager.shutdownAll();
    }

    public String encodeParameters(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        String queryString = this.getQueryString(url);
        if (Validator.isNull((String)queryString)) {
            return url;
        }
        String encodedQueryString = this.parameterMapToString(this.parameterMapFromString(queryString), false);
        return StringUtil.replace((String)url, (String)queryString, (String)encodedQueryString);
    }

    public String encodePath(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        path = StringUtil.replace((String)path, (String)"/", (String)_TEMP_SLASH);
        path = this.encodeURL(path, true);
        path = StringUtil.replace((String)path, (String)_TEMP_SLASH, (String)"/");
        return path;
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, false);
    }

    public String encodeURL(String url, boolean escapeSpaces) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        return URLCodec.encodeURL((String)url, (String)"UTF-8", (boolean)escapeSpaces);
    }

    public String fixPath(String path) {
        return this.fixPath(path, true, true);
    }

    public String fixPath(String path, boolean leading, boolean trailing) {
        int slashCount;
        int i2;
        if (path == null) {
            return "";
        }
        int leadingSlashCount = 0;
        int trailingSlashCount = 0;
        if (leading) {
            i2 = 0;
            while (i2 < path.length()) {
                if (path.charAt(i2) != '/') break;
                ++leadingSlashCount;
                ++i2;
            }
        }
        if (trailing) {
            i2 = path.length() - 1;
            while (i2 >= 0) {
                if (path.charAt(i2) != '/') break;
                ++trailingSlashCount;
                --i2;
            }
        }
        if ((slashCount = leadingSlashCount + trailingSlashCount) > path.length()) {
            return "";
        }
        if (slashCount > 0) {
            path = path.substring(leadingSlashCount, path.length() - trailingSlashCount);
        }
        return path;
    }

    public HttpClient getClient(HostConfiguration hostConfiguration) {
        if (this.isProxyHost(hostConfiguration.getHost())) {
            return this._proxyHttpClient;
        }
        return this._httpClient;
    }

    public String getCompleteURL(HttpServletRequest request) {
        String proxyPath;
        StringBuffer sb = request.getRequestURL();
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (request.getQueryString() != null) {
            sb.append("?");
            sb.append(request.getQueryString());
        }
        if (Validator.isNotNull((String)(proxyPath = PortalUtil.getPathProxy()))) {
            int x = sb.indexOf("://") + "://".length();
            int y = sb.indexOf("/", x);
            sb.insert(y, proxyPath);
        }
        String completeURL = sb.toString();
        if (request.isRequestedSessionIdFromURL()) {
            HttpSession session = request.getSession();
            String sessionId = session.getId();
            completeURL = PortalUtil.getURLWithSessionId((String)completeURL, (String)sessionId);
        }
        if (_log.isWarnEnabled() && completeURL.contains("?&")) {
            _log.warn((Object)("Invalid url " + completeURL));
        }
        return completeURL;
    }

    public javax.servlet.http.Cookie[] getCookies() {
        return _cookies.get();
    }

    public String getDomain(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return url;
    }

    public HostConfiguration getHostConfig(String location) throws IOException {
        return this.getHostConfiguration(location);
    }

    public HostConfiguration getHostConfiguration(String location) throws IOException {
        int timeout;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Location is " + location));
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(new URI(location, false));
        if (this.isProxyHost(hostConfiguration.getHost())) {
            hostConfiguration.setProxy(_PROXY_HOST, _PROXY_PORT);
        }
        HttpConnectionManager httpConnectionManager = this._httpClient.getHttpConnectionManager();
        HttpConnectionManagerParams httpConnectionManagerParams = httpConnectionManager.getParams();
        int defaultMaxConnectionsPerHost = httpConnectionManagerParams.getMaxConnectionsPerHost(hostConfiguration);
        int maxConnectionsPerHost = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".max.connections.per.host", new Filter(hostConfiguration.getHost())));
        if (maxConnectionsPerHost > 0 && maxConnectionsPerHost != defaultMaxConnectionsPerHost) {
            httpConnectionManagerParams.setMaxConnectionsPerHost(hostConfiguration, maxConnectionsPerHost);
        }
        if ((timeout = GetterUtil.getInteger((String)PropsUtil.get(String.valueOf(HttpImpl.class.getName()) + ".timeout", new Filter(hostConfiguration.getHost())))) > 0) {
            HostParams hostParams = hostConfiguration.getParams();
            hostParams.setIntParameter("http.connection.timeout", timeout);
            hostParams.setIntParameter("http.socket.timeout", timeout);
        }
        return hostConfiguration;
    }

    public String getIpAddress(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            InetAddress address = InetAddress.getByName(urlObj.getHost());
            return address.getHostAddress();
        }
        catch (Exception exception) {
            return url;
        }
    }

    public String getParameter(String url, String name) {
        return this.getParameter(url, name, true);
    }

    public String getParameter(String url, String name, boolean escaped) {
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return "";
        }
        String[] parts = StringUtil.split((String)url, (char)'?');
        if (parts.length == 2) {
            String[] params = null;
            params = escaped ? StringUtil.split((String)parts[1], (String)"&amp;") : StringUtil.split((String)parts[1], (char)'&');
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] kvp = StringUtil.split((String)param, (char)'=');
                if (kvp.length == 2 && kvp[0].equals(name)) {
                    return kvp[1];
                }
                ++n2;
            }
        }
        return "";
    }

    public Map<String, String[]> getParameterMap(String queryString) {
        return this.parameterMapFromString(queryString);
    }

    public String getPath(String url) {
        int pos;
        if (Validator.isNull((String)url)) {
            return url;
        }
        if (url.startsWith("http")) {
            pos = url.indexOf("/", "https://".length());
            url = url.substring(pos);
        }
        if ((pos = url.indexOf(63)) == -1) {
            return url;
        }
        return url.substring(0, pos);
    }

    public String getProtocol(ActionRequest actionRequest) {
        return this.getProtocol(actionRequest.isSecure());
    }

    public String getProtocol(boolean secure) {
        if (!secure) {
            return "http";
        }
        return "https";
    }

    public String getProtocol(HttpServletRequest request) {
        return this.getProtocol(request.isSecure());
    }

    public String getProtocol(RenderRequest renderRequest) {
        return this.getProtocol(renderRequest.isSecure());
    }

    public String getProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = url.indexOf("://");
        if (pos != -1) {
            return url.substring(0, pos);
        }
        return "http";
    }

    public String getQueryString(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return "";
        }
        return url.substring(pos + 1);
    }

    public String getRequestURL(HttpServletRequest request) {
        return String.valueOf(request.getRequestURL());
    }

    public boolean hasDomain(String url) {
        if (Validator.isNull((String)url)) {
            return false;
        }
        return Validator.isNotNull((String)this.getDomain(url));
    }

    public boolean hasProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return false;
        }
        int pos = url.indexOf("://");
        return pos != -1;
    }

    public boolean hasProxyConfig() {
        return Validator.isNotNull((String)_PROXY_HOST) && _PROXY_PORT > 0;
    }

    public boolean isNonProxyHost(String host) {
        Matcher matcher;
        if (Validator.isNull((String)host)) {
            return false;
        }
        return this._nonProxyHostsPattern != null && (matcher = this._nonProxyHostsPattern.matcher(host)).matches();
    }

    public boolean isProxyHost(String host) {
        if (Validator.isNull((String)host)) {
            return false;
        }
        return this.hasProxyConfig() && !this.isNonProxyHost(host);
    }

    public boolean isSecure(String url) {
        String protocol = this.getProtocol(url);
        return StringUtil.equalsIgnoreCase((String)protocol, (String)"https");
    }

    public Map<String, String[]> parameterMapFromString(String queryString) {
        String[] parameters;
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        if (Validator.isNull((String)queryString)) {
            return parameterMap;
        }
        LinkedHashMap<String, ArrayList<String>> tempParameterMap = new LinkedHashMap<String, ArrayList<String>>();
        String[] stringArray = parameters = StringUtil.split((String)queryString, (char)'&');
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                String[] kvp;
                String parameter = stringArray[n2];
                if (parameter.length() > 0 && (kvp = StringUtil.split((String)parameter, (char)'=')).length != 0) {
                    ArrayList<String> values;
                    String key = kvp[0];
                    String value = "";
                    if (kvp.length > 1) {
                        try {
                            value = this.decodeURL(kvp[1]);
                        }
                        catch (IllegalArgumentException iae) {
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Skipping parameter with key " + key + " because of invalid value " + kvp[1]), (Throwable)iae);
                            }
                            break block9;
                        }
                    }
                    if ((values = (ArrayList<String>)tempParameterMap.get(key)) == null) {
                        values = new ArrayList<String>();
                        tempParameterMap.put(key, values);
                    }
                    values.add(value);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : tempParameterMap.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            parameterMap.put(key, values.toArray(new String[values.size()]));
        }
        return parameterMap;
    }

    public String parameterMapToString(Map<String, String[]> parameterMap) {
        return this.parameterMapToString(parameterMap, true);
    }

    public String parameterMapToString(Map<String, String[]> parameterMap, boolean addQuestion) {
        if (parameterMap.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        if (addQuestion) {
            sb.append("?");
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values;
            String name = entry.getKey();
            String[] stringArray = values = entry.getValue();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                sb.append(name);
                sb.append("=");
                sb.append(this.encodeURL(value));
                sb.append("&");
                ++n2;
            }
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String protocolize(String url, ActionRequest actionRequest) {
        return this.protocolize(url, actionRequest.isSecure());
    }

    public String protocolize(String url, boolean secure) {
        return this.protocolize(url, -1, secure);
    }

    public String protocolize(String url, HttpServletRequest request) {
        return this.protocolize(url, request.isSecure());
    }

    public String protocolize(String url, int port, boolean secure) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        try {
            URL urlObj = new URL(url);
            String protocol = "http";
            if (secure) {
                protocol = "https";
            }
            if (port == -1) {
                port = urlObj.getPort();
            }
            urlObj = new URL(protocol, urlObj.getHost(), port, urlObj.getFile());
            return urlObj.toString();
        }
        catch (Exception exception) {
            return url;
        }
    }

    public String protocolize(String url, RenderRequest renderRequest) {
        return this.protocolize(url, renderRequest.isSecure());
    }

    public void proxifyState(HttpState httpState, HostConfiguration hostConfiguration) {
        Credentials proxyCredentials = this._proxyCredentials;
        String host = hostConfiguration.getHost();
        if (this.isProxyHost(host) && proxyCredentials != null) {
            AuthScope scope = new AuthScope(_PROXY_HOST, _PROXY_PORT, null);
            httpState.setProxyCredentials(scope, proxyCredentials);
        }
    }

    public String removeDomain(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        int pos = (url = this.removeProtocol(url)).indexOf(47);
        if (pos > 0) {
            return url.substring(pos);
        }
        return url;
    }

    public String removeParameter(String url, String name) {
        String[] parameters;
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return url;
        }
        int pos = url.indexOf(63);
        if (pos == -1) {
            return url;
        }
        String[] array = PortalUtil.stripURLAnchor((String)url, (String)"#");
        url = array[0];
        String anchor = array[1];
        StringBundler sb = new StringBundler();
        sb.append(url.substring(0, pos + 1));
        String[] stringArray = parameters = StringUtil.split((String)url.substring(pos + 1, url.length()), (char)'&');
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            if (parameter.length() > 0) {
                String[] kvp = StringUtil.split((String)parameter, (char)'=');
                String key = kvp[0];
                String value = "";
                if (kvp.length > 1) {
                    value = kvp[1];
                }
                if (!key.equals(name)) {
                    sb.append(key);
                    sb.append("=");
                    sb.append(value);
                    sb.append("&");
                }
            }
            ++n2;
        }
        url = StringUtil.replace((String)sb.toString(), (String)"&&", (String)"&");
        if (url.endsWith("&")) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith("?")) {
            url = url.substring(0, url.length() - 1);
        }
        return String.valueOf(url) + anchor;
    }

    public String removeProtocol(String url) {
        if (Validator.isNull((String)url)) {
            return url;
        }
        if (url.startsWith("http://")) {
            return url.substring("http://".length());
        }
        if (url.startsWith("https://")) {
            return url.substring("https://".length());
        }
        return url;
    }

    public String sanitizeHeader(String header) {
        if (header == null) {
            return null;
        }
        StringBuilder sb = null;
        int i2 = 0;
        while (i2 < header.length()) {
            char c2 = header.charAt(i2);
            if (c2 <= '\u001f' && c2 != '\t' || c2 == '\u007f' || c2 > '\u00ff') {
                if (sb == null) {
                    sb = new StringBuilder(header);
                }
                sb.setCharAt(i2, ' ');
            }
            ++i2;
        }
        if (sb != null) {
            header = sb.toString();
        }
        return header;
    }

    public String setParameter(String url, String name, boolean value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, double value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, int value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, long value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, short value) {
        return this.setParameter(url, name, String.valueOf(value));
    }

    public String setParameter(String url, String name, String value) {
        if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
            return url;
        }
        url = this.removeParameter(url, name);
        return this.addParameter(url, name, value);
    }

    public byte[] URLtoByteArray(Http.Options options) throws IOException {
        return this.URLtoByteArray(options.getLocation(), options.getMethod(), options.getHeaders(), options.getCookies(), options.getAuth(), options.getBody(), options.getFileParts(), options.getParts(), options.getResponse(), options.isFollowRedirects(), options.getProgressId(), options.getPortletRequest());
    }

    public byte[] URLtoByteArray(String location) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        return this.URLtoByteArray(options);
    }

    public byte[] URLtoByteArray(String location, boolean post) throws IOException {
        Http.Options options = new Http.Options();
        options.setLocation(location);
        options.setPost(post);
        return this.URLtoByteArray(options);
    }

    public String URLtoString(Http.Options options) throws IOException {
        return new String(this.URLtoByteArray(options));
    }

    public String URLtoString(String location) throws IOException {
        return new String(this.URLtoByteArray(location));
    }

    public String URLtoString(String location, boolean post) throws IOException {
        return new String(this.URLtoByteArray(location, post));
    }

    public String URLtoString(URL url) throws IOException {
        String xml = null;
        if (url == null) {
            return null;
        }
        String protocol = StringUtil.toLowerCase((String)url.getProtocol());
        if (protocol.startsWith("http") || protocol.startsWith("https")) {
            return this.URLtoString(url.toString());
        }
        URLConnection urlConnection = url.openConnection();
        InputStream inputStream = urlConnection.getInputStream();
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] bytes = new byte[512];
        int i2 = inputStream.read(bytes, 0, 512);
        while (i2 != -1) {
            unsyncByteArrayOutputStream.write(bytes, 0, i2);
            i2 = inputStream.read(bytes, 0, 512);
        }
        xml = new String(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size());
        inputStream.close();
        unsyncByteArrayOutputStream.close();
        return xml;
    }

    protected boolean hasRequestHeader(HttpMethod httpMethod, String name) {
        Header[] headers = httpMethod.getRequestHeaders(name);
        return headers.length != 0;
    }

    protected void processPostMethod(PostMethod postMethod, List<Http.FilePart> fileParts, Map<String, String> parts) {
        if (fileParts == null || fileParts.isEmpty()) {
            if (parts != null) {
                for (Map.Entry<String, String> entry : parts.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    postMethod.addParameter(entry.getKey(), value);
                }
            }
        } else {
            ArrayList<Object> partsList = new ArrayList<Object>();
            if (parts != null) {
                for (Map.Entry entry : parts.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    StringPart stringPart = new StringPart((String)entry.getKey(), value);
                    partsList.add(stringPart);
                }
            }
            for (Http.FilePart filePart : fileParts) {
                partsList.add(this.toCommonsFilePart(filePart));
            }
            MultipartRequestEntity multipartRequestEntity = new MultipartRequestEntity(partsList.toArray(new Part[partsList.size()]), postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)multipartRequestEntity);
        }
    }

    protected Cookie toCommonsCookie(javax.servlet.http.Cookie cookie) {
        Cookie commonsCookie = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getMaxAge(), cookie.getSecure());
        commonsCookie.setVersion(cookie.getVersion());
        return commonsCookie;
    }

    protected Cookie[] toCommonsCookies(javax.servlet.http.Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        Cookie[] commonCookies = new Cookie[cookies.length];
        int i2 = 0;
        while (i2 < cookies.length) {
            commonCookies[i2] = this.toCommonsCookie(cookies[i2]);
            ++i2;
        }
        return commonCookies;
    }

    protected FilePart toCommonsFilePart(Http.FilePart filePart) {
        return new FilePart(filePart.getName(), (PartSource)new ByteArrayPartSource(filePart.getFileName(), filePart.getValue()), filePart.getContentType(), filePart.getCharSet());
    }

    protected javax.servlet.http.Cookie toServletCookie(Cookie commonsCookie) {
        String path;
        Date expiryDate;
        String domain;
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(commonsCookie.getName(), commonsCookie.getValue());
        if (!PropsValues.SESSION_COOKIE_USE_FULL_HOSTNAME && Validator.isNotNull((String)(domain = commonsCookie.getDomain()))) {
            cookie.setDomain(domain);
        }
        if ((expiryDate = commonsCookie.getExpiryDate()) != null) {
            int maxAge = (int)(expiryDate.getTime() - System.currentTimeMillis());
            if ((maxAge /= 1000) > -1) {
                cookie.setMaxAge(maxAge);
            }
        }
        if (Validator.isNotNull((String)(path = commonsCookie.getPath()))) {
            cookie.setPath(path);
        }
        cookie.setSecure(commonsCookie.getSecure());
        cookie.setVersion(commonsCookie.getVersion());
        return cookie;
    }

    protected javax.servlet.http.Cookie[] toServletCookies(Cookie[] commonsCookies) {
        if (commonsCookies == null) {
            return null;
        }
        javax.servlet.http.Cookie[] cookies = new javax.servlet.http.Cookie[commonsCookies.length];
        int i2 = 0;
        while (i2 < commonsCookies.length) {
            cookies[i2] = this.toServletCookie(commonsCookies[i2]);
            ++i2;
        }
        return cookies;
    }

    protected byte[] URLtoByteArray(String location, Http.Method method, Map<String, String> headers, javax.servlet.http.Cookie[] cookies, Http.Auth auth, Http.Body body, List<Http.FilePart> fileParts, Map<String, String> parts, Http.Response response, boolean followRedirects, String progressId, PortletRequest portletRequest) throws IOException {
        byte[] bytes = null;
        Object httpMethod = null;
        HttpState httpState = null;
        try {
            InputStream inputStream;
            _cookies.set(null);
            if (location == null) {
                return null;
            }
            if (!location.startsWith("http://") && !location.startsWith("https://")) {
                location = "http://" + location;
            }
            HostConfiguration hostConfiguration = this.getHostConfiguration(location);
            HttpClient httpClient = this.getClient(hostConfiguration);
            if (method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) {
                httpMethod = method.equals((Object)Http.Method.POST) ? new PostMethod(location) : new PutMethod(location);
                if (body != null) {
                    StringRequestEntity requestEntity = new StringRequestEntity(body.getContent(), body.getContentType(), body.getCharset());
                    EntityEnclosingMethod entityEnclosingMethod = (EntityEnclosingMethod)httpMethod;
                    entityEnclosingMethod.setRequestEntity((RequestEntity)requestEntity);
                } else if (method.equals((Object)Http.Method.POST)) {
                    PostMethod postMethod = httpMethod;
                    if (!this.hasRequestHeader((HttpMethod)postMethod, "Content-Type")) {
                        HttpClientParams httpClientParams = httpClient.getParams();
                        httpClientParams.setParameter("http.protocol.content-charset", (Object)"UTF-8");
                    }
                    this.processPostMethod(postMethod, fileParts, parts);
                }
            } else {
                httpMethod = method.equals((Object)Http.Method.DELETE) ? new DeleteMethod(location) : (method.equals((Object)Http.Method.HEAD) ? new HeadMethod(location) : new GetMethod(location));
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    httpMethod.addRequestHeader(header.getKey(), header.getValue());
                }
            }
            if (!((method.equals((Object)Http.Method.POST) || method.equals((Object)Http.Method.PUT)) && (body != null || fileParts != null && !fileParts.isEmpty() || parts != null && !parts.isEmpty()) || this.hasRequestHeader((HttpMethod)httpMethod, "Content-Type"))) {
                httpMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            }
            if (!this.hasRequestHeader((HttpMethod)httpMethod, "User-Agent")) {
                httpMethod.addRequestHeader("User-Agent", _DEFAULT_USER_AGENT);
            }
            httpState = new HttpState();
            if (ArrayUtil.isNotEmpty((Object[])cookies)) {
                Cookie[] commonsCookies = this.toCommonsCookies(cookies);
                httpState.addCookies(commonsCookies);
                HttpMethodParams httpMethodParams = httpMethod.getParams();
                httpMethodParams.setCookiePolicy("compatibility");
            }
            if (auth != null) {
                httpMethod.setDoAuthentication(true);
                httpState.setCredentials(new AuthScope(auth.getHost(), auth.getPort(), auth.getRealm()), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
            }
            this.proxifyState(httpState, hostConfiguration);
            int responseCode = httpClient.executeMethod(hostConfiguration, (HttpMethod)httpMethod, httpState);
            response.setResponseCode(responseCode);
            Header locationHeader = httpMethod.getResponseHeader("location");
            if (locationHeader != null && !locationHeader.equals((Object)location)) {
                String redirect = locationHeader.getValue();
                if (followRedirects) {
                    byte[] byArray = this.URLtoByteArray(redirect, Http.Method.GET, headers, cookies, auth, body, fileParts, parts, response, followRedirects, progressId, portletRequest);
                    return byArray;
                }
                response.setRedirect(redirect);
            }
            if ((inputStream = httpMethod.getResponseBodyAsStream()) != null) {
                Header contentType;
                int contentLength = 0;
                Header contentLengthHeader = httpMethod.getResponseHeader("Content-Length");
                if (contentLengthHeader != null) {
                    contentLength = GetterUtil.getInteger((String)contentLengthHeader.getValue());
                    response.setContentLength(contentLength);
                }
                if ((contentType = httpMethod.getResponseHeader("Content-Type")) != null) {
                    response.setContentType(contentType.getValue());
                }
                if (Validator.isNotNull((String)progressId) && portletRequest != null) {
                    ProgressInputStream progressInputStream = new ProgressInputStream(portletRequest, inputStream, (long)contentLength, progressId);
                    UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(contentLength);
                    try {
                        progressInputStream.readAll((OutputStream)unsyncByteArrayOutputStream);
                    }
                    finally {
                        progressInputStream.clearProgress();
                    }
                    bytes = unsyncByteArrayOutputStream.unsafeGetByteArray();
                    unsyncByteArrayOutputStream.close();
                } else {
                    bytes = FileUtil.getBytes((InputStream)inputStream);
                }
            }
            Header[] headerArray = httpMethod.getResponseHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                response.addHeader(header.getName(), header.getValue());
                ++n2;
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            try {
                if (httpState != null) {
                    _cookies.set(this.toServletCookies(httpState.getCookies()));
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            try {
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
    }

    private class FastProtocolSocketFactory
    extends DefaultProtocolSocketFactory {
        private FastProtocolSocketFactory() {
        }

        public Socket createSocket(String host, int port, InetAddress localInetAddress, int localPort, HttpConnectionParams httpConnectionParams) throws ConnectTimeoutException, IOException, UnknownHostException {
            int connectionTimeout = httpConnectionParams.getConnectionTimeout();
            if (connectionTimeout == 0) {
                return this.createSocket(host, port, localInetAddress, localPort);
            }
            SocketFactory socketFactory = SocketFactory.getDefault();
            Socket socket = socketFactory.createSocket();
            InetSocketAddress localSocketAddress = new InetSocketAddress(localInetAddress, localPort);
            InetSocketAddress remoteSocketAddress = new InetSocketAddress(host, port);
            socket.bind(localSocketAddress);
            socket.connect(remoteSocketAddress, connectionTimeout);
            return socket;
        }
    }
}

