/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalContentSearch;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.persistence.JournalArticleActionableDynamicQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

public class VerifyJournal
extends VerifyProcess {
    public static final long DEFAULT_GROUP_ID = 14L;
    public static final int NUM_OF_ARTICLES = 5;
    private static Log _log = LogFactoryUtil.getLog(VerifyJournal.class);
    private static Pattern _friendlyURLPattern = Pattern.compile("[^a-z0-9_-]");

    @Override
    protected void doVerify() throws Exception {
        this.verifyContent();
        this.updateFolderAssets();
        this.verifyOracleNewLine();
        this.verifyPermissionsAndAssets();
        this.verifySearch();
        this.verifyTree();
        this.verifyURLTitle();
    }

    protected void updateElements(List<Element> elements) throws Exception {
        for (Element element : elements) {
            DLFileEntry dlFileEntry;
            String type = element.attributeValue("type");
            if (!type.equals("document_library")) continue;
            this.updateElements(element.elements("dynamic-element"));
            Element dynamicContentElement = element.element("dynamic-content");
            String path = dynamicContentElement.getStringValue();
            String[] pathArray = StringUtil.split((String)path, (char)'/');
            if (pathArray.length != 5) continue;
            long groupId = GetterUtil.getLong((String)pathArray[2]);
            long folderId = GetterUtil.getLong((String)pathArray[3]);
            String title = HttpUtil.decodeURL((String)HtmlUtil.escape((String)pathArray[4]));
            if (title.contains("/")) {
                title = StringUtil.replace((String)title, (String)"/", (String)"");
                StringBundler sb = new StringBundler(9);
                int i2 = 0;
                while (i2 < 4) {
                    sb.append(pathArray[i2]);
                    sb.append("/");
                    ++i2;
                }
                sb.append(title);
                path = sb.toString();
            }
            if ((dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntry((long)groupId, (long)folderId, (String)title)) == null) continue;
            Node node = dynamicContentElement.node(0);
            node.setText(String.valueOf(path) + "/" + dlFileEntry.getUuid());
        }
    }

    protected void updateFolderAssets() throws Exception {
        List folders = JournalFolderLocalServiceUtil.getNoAssetFolders();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + folders.size() + " folders with no asset"));
        }
        for (JournalFolder folder : folders) {
            try {
                JournalFolderLocalServiceUtil.updateAsset((long)folder.getUserId(), (JournalFolder)folder, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for folder " + folder.getFolderId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for folders");
        }
    }

    protected void updateURLTitle(long groupId, String articleId, String urlTitle) throws Exception {
        String normalizedURLTitle = FriendlyURLNormalizerUtil.normalize((String)urlTitle, (Pattern)_friendlyURLPattern);
        if (urlTitle.equals(normalizedURLTitle)) {
            return;
        }
        normalizedURLTitle = JournalArticleLocalServiceUtil.getUniqueUrlTitle((long)groupId, (String)articleId, (String)normalizedURLTitle);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update JournalArticle set urlTitle = ? where urlTitle = ?");
            ps.setString(1, normalizedURLTitle);
            ps.setString(2, urlTitle);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void verifyContent() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select id_ from JournalArticle where content like '%document_library%' and structureId != ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("id_");
                JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)id);
                Document document = SAXReaderUtil.read((String)article.getContent());
                Element rootElement = document.getRootElement();
                this.updateElements(rootElement.elements());
                article.setContent(document.asXML());
                JournalArticleLocalServiceUtil.updateJournalArticle((JournalArticle)article);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyContentSearch(long groupId, String portletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select preferences from PortletPreferences inner join Layout on PortletPreferences.plid = Layout.plid where groupId = ? and portletId = ?");
            ps.setLong(1, groupId);
            ps.setString(2, portletId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String xml = rs.getString("preferences");
                PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
                String articleId = portletPreferences.getValue("articleId", null);
                List contentSearches = JournalContentSearchLocalServiceUtil.getArticleContentSearches((long)groupId, (String)articleId);
                if (contentSearches.isEmpty()) continue;
                JournalContentSearch contentSearch = (JournalContentSearch)contentSearches.get(0);
                JournalContentSearchLocalServiceUtil.updateContentSearch((long)contentSearch.getGroupId(), (boolean)contentSearch.isPrivateLayout(), (long)contentSearch.getLayoutId(), (String)contentSearch.getPortletId(), (String)articleId, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyOracleNewLine() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("oracle")) {
            return;
        }
        boolean checkNewLine = false;
        List articles = JournalArticleLocalServiceUtil.getArticles((long)14L, (int)0, (int)5);
        for (JournalArticle article : articles) {
            String content = article.getContent();
            if (content == null || !content.contains("\\n")) continue;
            articles = JournalArticleLocalServiceUtil.getArticles((long)14L);
            int j = 0;
            while (j < articles.size()) {
                article = (JournalArticle)articles.get(j);
                JournalArticleLocalServiceUtil.checkNewLine((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
                ++j;
            }
            checkNewLine = true;
            break;
        }
        if (!checkNewLine) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Do not fix oracle new line");
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Fix oracle new line");
        }
    }

    protected void verifyPermissionsAndAssets() throws Exception {
        JournalArticleActionableDynamicQuery actionableDynamicQuery = new JournalArticleActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException, SystemException {
                JournalArticle article = (JournalArticle)object;
                long groupId = article.getGroupId();
                String articleId = article.getArticleId();
                double version = article.getVersion();
                String structureId = article.getStructureId();
                if (article.getResourcePrimKey() <= 0L) {
                    article = JournalArticleLocalServiceUtil.checkArticleResourcePrimKey((long)groupId, (String)articleId, (double)version);
                }
                ResourceLocalServiceUtil.addResources((long)article.getCompanyId(), (long)0L, (long)0L, (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (boolean)false, (boolean)false, (boolean)false);
                AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
                if (assetEntry == null) {
                    try {
                        JournalArticleLocalServiceUtil.updateAsset((long)article.getUserId(), (JournalArticle)article, null, null, null);
                    }
                    catch (Exception e2) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Unable to update asset for article " + article.getId() + ": " + e2.getMessage()));
                        }
                    }
                } else if (article.getStatus() == 2 && article.getVersion() == 1.0) {
                    AssetEntryLocalServiceUtil.updateEntry((String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), null, (boolean)assetEntry.isVisible());
                }
                Validator.isNotNull((String)structureId);
                try {
                    JournalArticleLocalServiceUtil.checkStructure((long)groupId, (String)articleId, (double)version);
                }
                catch (NoSuchStructureException noSuchStructureException) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Removing reference to missing structure for article " + article.getId()));
                    }
                    article.setStructureId("");
                    article.setTemplateId("");
                    JournalArticleLocalServiceUtil.updateJournalArticle((JournalArticle)article);
                }
            }
        };
        actionableDynamicQuery.performActions();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Permissions and assets verified for articles");
        }
    }

    protected void verifySearch() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, portletId from JournalContentSearch group by groupId, portletId having count(groupId) > 1 and count(portletId) > 1");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String portletId = rs.getString("portletId");
                this.verifyContentSearch(groupId, portletId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void verifyTree() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            JournalArticleLocalServiceUtil.rebuildTree((long)companyId);
            JournalFolderLocalServiceUtil.rebuildTree((long)companyId);
            ++n2;
        }
    }

    protected void verifyURLTitle() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select distinct groupId, articleId, urlTitle from JournalArticle");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                String articleId = rs.getString("articleId");
                String urlTitle = GetterUtil.getString((String)rs.getString("urlTitle"));
                this.updateURLTitle(groupId, articleId, urlTitle);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

