/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.concurrent.ThrowableAwareRunnable;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.announcements.model.AnnouncementsEntry;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class VerifyResourcePermissions
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{AnnouncementsEntry.class.getName(), "AnnouncementsEntry", "entryId"}, {AssetCategory.class.getName(), "AssetCategory", "categoryId"}, {AssetTag.class.getName(), "AssetTag", "tagId"}, {AssetVocabulary.class.getName(), "AssetVocabulary", "vocabularyId"}, {BlogsEntry.class.getName(), "BlogsEntry", "entryId"}, {DDMStructure.class.getName(), "DDMStructure", "structureId"}, {DDMTemplate.class.getName(), "DDMTemplate", "templateId"}, {DLFileEntry.class.getName(), "DLFileEntry", "fileEntryId"}, {DLFileShortcut.class.getName(), "DLFileShortcut", "fileShortcutId"}, {DLFolder.class.getName(), "DLFolder", "folderId"}, {JournalArticle.class.getName(), "JournalArticle", "resourcePrimKey"}, {JournalFeed.class.getName(), "JournalFeed", "id_"}, {Layout.class.getName(), "Layout", "plid"}, {LayoutSetBranch.class.getName(), "LayoutSetBranch", "layoutSetBranchId"}, {MBCategory.class.getName(), "MBCategory", "categoryId"}, {MBMessage.class.getName(), "MBMessage", "messageId"}, {PasswordPolicy.class.getName(), "PasswordPolicy", "passwordPolicyId"}, {PollsQuestion.class.getName(), "PollsQuestion", "questionId"}, {SCFrameworkVersion.class.getName(), "SCFrameworkVersion", "frameworkVersionId"}, {SCProductEntry.class.getName(), "SCProductEntry", "productEntryId"}, {ShoppingCategory.class.getName(), "ShoppingCategory", "categoryId"}, {ShoppingItem.class.getName(), "ShoppingItem", "itemId"}, {Team.class.getName(), "Team", "teamId"}, {User.class.getName(), "User_", "userId"}, {WikiNode.class.getName(), "WikiNode", "nodeId"}, {WikiPage.class.getName(), "WikiPage", "resourcePrimKey"}};
    private static Log _log = LogFactoryUtil.getLog(VerifyResourcePermissions.class);

    @Override
    protected void doVerify() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Owner");
            ArrayList<VerifyResourcedModelRunnable> verifyResourcedModelRunnables = new ArrayList<VerifyResourcedModelRunnable>(_MODELS.length);
            String[][] stringArray = _MODELS;
            int n3 = _MODELS.length;
            int n4 = 0;
            while (n4 < n3) {
                String[] model = stringArray[n4];
                VerifyResourcedModelRunnable verifyResourcedModelRunnable = new VerifyResourcedModelRunnable(role, model[0], model[1], model[2]);
                verifyResourcedModelRunnables.add(verifyResourcedModelRunnable);
                ++n4;
            }
            this.verifyLayout(role);
            ++n2;
        }
    }

    protected void verifyLayout(Role role) throws Exception {
        List layouts = LayoutLocalServiceUtil.getNoPermissionLayouts((long)role.getRoleId());
        for (Layout layout : layouts) {
            this.verifyModel(role.getCompanyId(), Layout.class.getName(), layout.getPlid(), role, 0L);
        }
    }

    protected void verifyModel(long companyId, String name, long primKey, Role role, long ownerId) throws Exception {
        ResourcePermission resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)name, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId());
        if (resourcePermission == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No resource found for {" + companyId + ", " + name + ", " + 4 + ", " + primKey + ", " + role.getRoleId() + "}"));
            }
            ResourceLocalServiceUtil.addResources((long)companyId, (long)0L, (long)ownerId, (String)name, (String)String.valueOf(primKey), (boolean)false, (boolean)false, (boolean)false);
        }
        if (resourcePermission == null && (resourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)companyId, (String)name, (int)4, (String)String.valueOf(primKey), (long)role.getRoleId())) == null) {
            return;
        }
        if (name.equals(User.class.getName())) {
            User user = UserLocalServiceUtil.getUserById((long)ownerId);
            Contact contact = ContactLocalServiceUtil.getContact((long)user.getContactId());
            ownerId = contact.getUserId();
        }
        if (ownerId != resourcePermission.getOwnerId()) {
            resourcePermission.setOwnerId(ownerId);
            ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
        }
        if (_log.isInfoEnabled() && resourcePermission.getResourcePermissionId() % 100L == 0L) {
            _log.info((Object)("Processed 100 resource permissions for " + name));
        }
    }

    protected void verifyModel(Role role, String name, String modelName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + ", userId AS ownerId " + "from " + modelName + " where companyId = " + role.getCompanyId());
            rs = ps.executeQuery();
            while (rs.next()) {
                long primKey = rs.getLong(pkColumnName);
                long ownerId = rs.getLong("ownerId");
                this.verifyModel(role.getCompanyId(), name, primKey, role, ownerId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    private class VerifyResourcedModelRunnable
    extends ThrowableAwareRunnable {
        private final String _modelName;
        private final String _name;
        private final String _pkColumnName;
        private final Role _role;

        private VerifyResourcedModelRunnable(Role role, String name, String modelName, String pkColumnName) {
            this._modelName = modelName;
            this._name = name;
            this._pkColumnName = pkColumnName;
            this._role = role;
        }

        protected void doRun() throws Exception {
            VerifyResourcePermissions.this.verifyModel(this._role, this._name, this._modelName, this._pkColumnName);
        }
    }
}

