/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.BasePreferencesImpl;
import com.liferay.portlet.Preference;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

public class PortletPreferencesImpl
extends BasePreferencesImpl
implements Cloneable,
PortletPreferences,
Serializable {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesImpl.class);
    private long _companyId;
    private PortletPreferences _defaultPreferences;
    private long _plid;
    private String _portletId;

    public PortletPreferencesImpl() {
        this(0L, 0L, 0, 0L, null, null, Collections.emptyMap());
    }

    public PortletPreferencesImpl(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml, Map<String, Preference> preferences) {
        super(ownerId, ownerType, xml, preferences);
        this._companyId = companyId;
        this._plid = plid;
        this._portletId = portletId;
    }

    public PortletPreferencesImpl(String xml, Map<String, Preference> preferences) {
        this(0L, 0L, 0, 0L, null, xml, preferences);
    }

    public Object clone() {
        return new PortletPreferencesImpl(this._companyId, this.getOwnerId(), this.getOwnerType(), this._plid, this._portletId, this.getOriginalXML(), this.getOriginalPreferences());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PortletPreferencesImpl)) {
            return false;
        }
        PortletPreferencesImpl portletPreferences = (PortletPreferencesImpl)obj;
        return this._companyId == portletPreferences._companyId && this.getOwnerId() == portletPreferences.getOwnerId() && this.getOwnerType() == portletPreferences.getOwnerType() && this.getPlid() == portletPreferences.getPlid() && this.getPortletId().equals(portletPreferences.getPortletId()) && this.getPreferences().equals(portletPreferences.getPreferences());
    }

    public long getPlid() {
        return this._plid;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (long)this._companyId);
        hashCode = HashUtil.hash((int)hashCode, (long)this.getOwnerId());
        hashCode = HashUtil.hash((int)hashCode, (int)this.getOwnerType());
        hashCode = HashUtil.hash((int)hashCode, (long)this._plid);
        hashCode = HashUtil.hash((int)hashCode, (Object)this._portletId);
        hashCode = HashUtil.hash((int)hashCode, this.getPreferences());
        return hashCode;
    }

    @Override
    public void reset(String key) throws ReadOnlyException {
        block7: {
            if (this.isReadOnly(key)) {
                throw new ReadOnlyException(key);
            }
            if (this._defaultPreferences == null && this._portletId != null) {
                try {
                    this._defaultPreferences = PortletPreferencesLocalServiceUtil.getDefaultPreferences((long)this._companyId, (String)this._portletId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block7;
                    _log.warn((Object)e2, (Throwable)e2);
                }
            }
        }
        String[] defaultValues = null;
        if (this._defaultPreferences != null) {
            defaultValues = this._defaultPreferences.getValues(key, defaultValues);
        }
        if (defaultValues != null) {
            this.setValues(key, defaultValues);
        } else {
            Map<String, Preference> modifiedPreferences = this.getModifiedPreferences();
            modifiedPreferences.remove(key);
        }
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    @Override
    public void store() throws IOException, ValidatorException {
        if (this._portletId == null) {
            throw new UnsupportedOperationException();
        }
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)this._companyId, (String)this._portletId);
            PreferencesValidator preferencesValidator = PortalUtil.getPreferencesValidator((Portlet)portlet);
            if (preferencesValidator != null) {
                preferencesValidator.validate((PortletPreferences)this);
            }
            PortletPreferencesLocalServiceUtil.updatePreferences((long)this.getOwnerId(), (int)this.getOwnerType(), (long)this._plid, (String)this._portletId, (PortletPreferences)this);
        }
        catch (SystemException se) {
            throw new IOException(se.getMessage());
        }
    }

    protected String getPortletId() {
        return this._portletId;
    }
}

