/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.portlet.PortletModeFactory;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.TempAttributesServletRequest;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.AuthTokenUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.PortletMode;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class SecurityPortletContainerWrapper
implements PortletContainer {
    private static Log _log = LogFactoryUtil.getLog(SecurityPortletContainerWrapper.class);
    private PortletContainer _portletContainer;

    public static PortletContainer createSecurityPortletContainerWrapper(PortletContainer portletContainer) {
        if (!SPIUtil.isSPI()) {
            portletContainer = new SecurityPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public SecurityPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(request, portlet);
    }

    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutRequest = this.getOwnerLayoutRequestWrapper(request, portlet);
            this.checkAction(ownerLayoutRequest, portlet);
            return this._portletContainer.processAction(request, response, portlet);
        }
        catch (PrincipalException pe) {
            return this.processActionException(request, response, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        return this._portletContainer.processEvent(request, response, portlet, layout, event);
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(request, portlet);
            this._portletContainer.render(request, response, portlet);
        }
        catch (PrincipalException principalException) {
            this.processRenderException(request, response, portlet);
        }
        catch (PortletContainerException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new PortletContainerException((Throwable)e3);
        }
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutRequest = this.getOwnerLayoutRequestWrapper(request, portlet);
            this.checkResource(ownerLayoutRequest, portlet);
            this._portletContainer.serveResource(request, response, portlet);
        }
        catch (PrincipalException pe) {
            this.processServeResourceException(request, response, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e2) {
            throw new PortletContainerException((Throwable)e2);
        }
    }

    protected void check(HttpServletRequest request, Portlet portlet) throws Exception {
        if (portlet == null) {
            return;
        }
        if (!this.isValidPortletId(portlet.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid portlet id " + portlet.getPortletId()));
            }
            throw new PrincipalException();
        }
        if (portlet.isUndeployedPortlet()) {
            return;
        }
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        if (layout.isTypeControlPanel()) {
            this.isAccessAllowedToControlPanelPortlet(request, portlet);
            return;
        }
        if (this.isAccessAllowedToLayoutPortlet(request, portlet)) {
            PortalUtil.addPortletDefaultResource((HttpServletRequest)request, (Portlet)portlet);
            if (this.hasAccessPermission(request, portlet)) {
                return;
            }
        }
        throw new PrincipalException();
    }

    protected void checkAction(HttpServletRequest request, Portlet portlet) throws Exception {
        this.checkCSRFProtection(request, portlet);
        this.check(request, portlet);
    }

    protected void checkCSRFProtection(HttpServletRequest request, Portlet portlet) throws PortalException {
        Map initParams = portlet.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        if (checkAuthToken) {
            AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)SecurityPortletContainerWrapper.class.getName());
        }
    }

    protected void checkRender(HttpServletRequest request, Portlet portlet) throws Exception {
        this.check(request, portlet);
    }

    protected void checkResource(HttpServletRequest request, Portlet portlet) throws Exception {
        this.check(request, portlet);
    }

    protected String getOriginalURL(HttpServletRequest request) {
        LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return String.valueOf(request.getRequestURI());
        }
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        return portalURL.concat(lastPath.getContextPath()).concat(lastPath.getPath());
    }

    protected HttpServletRequest getOwnerLayoutRequestWrapper(HttpServletRequest request, Portlet portlet) throws Exception {
        if (!PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET || PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render")) {
            return request;
        }
        Layout ownerLayout = null;
        LayoutTypePortlet ownerLayoutTypePortlet = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout requestLayout = (Layout)request.getAttribute("LAYOUT");
        List layoutTypePortlets = PortletContainerUtil.getLayoutTypePortlets((Layout)requestLayout);
        for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
            if (!layoutTypePortlet.hasPortletId(portlet.getPortletId())) continue;
            ownerLayoutTypePortlet = layoutTypePortlet;
            ownerLayout = layoutTypePortlet.getLayout();
            break;
        }
        if (ownerLayout == null) {
            return request;
        }
        Layout currentLayout = themeDisplay.getLayout();
        if (currentLayout.equals(ownerLayout)) {
            return request;
        }
        ThemeDisplay themeDisplayClone = (ThemeDisplay)themeDisplay.clone();
        themeDisplayClone.setLayout(ownerLayout);
        themeDisplayClone.setLayoutTypePortlet(ownerLayoutTypePortlet);
        TempAttributesServletRequest tempAttributesServletRequest = new TempAttributesServletRequest(request);
        tempAttributesServletRequest.setTempAttribute("LAYOUT", (Object)ownerLayout);
        tempAttributesServletRequest.setTempAttribute("LIFERAY_SHARED_THEME_DISPLAY", (Object)themeDisplayClone);
        return tempAttributesServletRequest;
    }

    protected boolean hasAccessPermission(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = (Layout)request.getAttribute("LAYOUT");
        PortletMode portletMode = PortletModeFactory.getPortletMode((String)ParamUtil.getString((HttpServletRequest)request, (String)"p_p_mode"));
        return PortletPermissionUtil.hasAccessPermission((PermissionChecker)permissionChecker, (long)themeDisplay.getScopeGroupId(), (Layout)layout, (Portlet)portlet, (PortletMode)portletMode);
    }

    protected void isAccessAllowedToControlPanelPortlet(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        ThemeDisplay themeDisplay;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)(themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")).getScopeGroupId(), (Portlet)portlet)) {
            return;
        }
        if (this.isAccessGrantedByRuntimePortlet(request, portlet)) {
            return;
        }
        if (this.isAccessGrantedByPortletAuthenticationToken(request, portlet)) {
            return;
        }
        throw new PrincipalException();
    }

    protected boolean isAccessAllowedToLayoutPortlet(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        if (this.isAccessGrantedByRuntimePortlet(request, portlet)) {
            return true;
        }
        if (this.isAccessGrantedByPortletOnPage(request, portlet)) {
            return true;
        }
        if (this.isLayoutConfigurationAllowed(request, portlet)) {
            return true;
        }
        return this.isAccessGrantedByPortletAuthenticationToken(request, portlet);
    }

    protected boolean isAccessGrantedByPortletAuthenticationToken(HttpServletRequest request, Portlet portlet) {
        String requestPortletAuthenticationToken;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = portlet.getPortletId();
        if (!portlet.isAddDefaultResource()) {
            return false;
        }
        if (!PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_ENABLED) {
            return true;
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)(String.valueOf(namespace) + "struts_action"));
        if (Validator.isNull((String)strutsAction)) {
            strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        }
        if (Validator.isNull((String)(requestPortletAuthenticationToken = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_auth")))) {
            HttpServletRequest originalRequest = PortalUtil.getOriginalServletRequest((HttpServletRequest)request);
            requestPortletAuthenticationToken = ParamUtil.getString((HttpServletRequest)originalRequest, (String)"p_p_auth");
        }
        return AuthTokenUtil.isValidPortletInvocationToken((HttpServletRequest)request, (long)themeDisplay.getPlid(), (String)portletId, (String)strutsAction, (String)requestPortletAuthenticationToken);
    }

    protected boolean isAccessGrantedByPortletOnPage(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        String portletId = portlet.getPortletId();
        if (layout.isTypePanel() && this.isPanelSelectedPortlet(themeDisplay, portletId)) {
            return true;
        }
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        return layoutTypePortlet != null && layoutTypePortlet.hasPortletId(portletId);
    }

    protected boolean isAccessGrantedByRuntimePortlet(HttpServletRequest request, Portlet portlet) {
        boolean runtimePortlet;
        Boolean renderPortletResource = (Boolean)request.getAttribute("RENDER_PORTLET_RESOURCE");
        return renderPortletResource != null && (runtimePortlet = renderPortletResource.booleanValue());
    }

    protected boolean isLayoutConfigurationAllowed(HttpServletRequest request, Portlet portlet) throws PortalException, SystemException {
        long scopeGroupId;
        long organizationId;
        long layoutSetPrototypeId;
        long layoutPrototypeId;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!themeDisplay.isSignedIn()) {
            return false;
        }
        String portletId = portlet.getPortletId();
        if (!portletId.equals("88")) {
            return false;
        }
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (group.isSite() && (LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"CUSTOMIZE") || LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"UPDATE"))) {
            return true;
        }
        return group.isCompany() ? permissionChecker.isCompanyAdmin() : (group.isLayoutPrototype() ? LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)(layoutPrototypeId = group.getClassPK()), (String)"UPDATE") : (group.isLayoutSetPrototype() ? LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)(layoutSetPrototypeId = group.getClassPK()), (String)"UPDATE") : (group.isOrganization() ? OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(organizationId = group.getOrganizationId()), (String)"UPDATE") : (group.isUserGroup() ? GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)(scopeGroupId = themeDisplay.getScopeGroupId()), (String)"UPDATE") : group.isUser()))));
    }

    protected boolean isPanelSelectedPortlet(ThemeDisplay themeDisplay, String portletId) {
        Layout layout = themeDisplay.getLayout();
        String panelSelectedPortlets = layout.getTypeSettingsProperty("panelSelectedPortlets");
        if (Validator.isNotNull((String)panelSelectedPortlets)) {
            Object[] panelSelectedPortletsArray = StringUtil.split((String)panelSelectedPortlets);
            return ArrayUtil.contains((Object[])panelSelectedPortletsArray, (Object)portletId);
        }
        return false;
    }

    protected boolean isValidPortletId(String portletId) {
        int i2 = 0;
        while (i2 < portletId.length()) {
            char c2 = portletId.charAt(i2);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_')) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected ActionResult processActionException(HttpServletRequest request, HttpServletResponse response, Portlet portlet, PrincipalException e2) {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)e2);
        }
        String url = this.getOriginalURL(request);
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Reject process action for " + url + " on " + portlet.getPortletId()));
        }
        return ActionResult.EMPTY_ACTION_RESULT;
    }

    protected void processRenderException(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        String portletContent = null;
        if (portlet.isShowPortletAccessDenied()) {
            portletContent = "/html/portal/portlet_access_denied.jsp";
        }
        try {
            if (portletContent != null) {
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(portletContent);
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception ex) {
            throw new PortletContainerException((Throwable)ex);
        }
    }

    protected void processServeResourceException(HttpServletRequest request, HttpServletResponse response, Portlet portlet, PrincipalException e2) {
        if (_log.isDebugEnabled()) {
            _log.debug((Throwable)e2);
        }
        String url = this.getOriginalURL(request);
        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        response.setStatus(400);
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Reject serveResource for " + url + " on " + portlet.getPortletId()));
        }
    }
}

