/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.asset.service.persistence.AssetCategoryFinderUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryFinder;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AssetEntryFinderImpl
extends BasePersistenceImpl<AssetEntry>
implements AssetEntryFinder {
    public static final String FIND_BY_AND_CATEGORY_IDS = String.valueOf(AssetEntryFinder.class.getName()) + ".findByAndCategoryIds";
    public static final String FIND_BY_AND_TAG_IDS = String.valueOf(AssetEntryFinder.class.getName()) + ".findByAndTagIds";

    public int countEntries(AssetEntryQuery entryQuery) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            SQLQuery q = this.buildAssetQuerySQL(entryQuery, true, session);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AssetEntry> findEntries(AssetEntryQuery entryQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery q = this.buildAssetQuerySQL(entryQuery, false, session);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)entryQuery.getStart(), (int)entryQuery.getEnd());
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected void buildAllCategoriesSQL(long[] categoryIds, StringBundler sb) throws SystemException {
        String findByAndCategoryIdsSQL = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < categoryIds.length) {
            List treeCategoryIds;
            String sql = null;
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL && (treeCategoryIds = AssetCategoryFinderUtil.findByG_L((Long)categoryIds[i2])).size() > 1) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)"[$CATEGORY_ID$]", (String)StringUtil.merge((Collection)treeCategoryIds));
            }
            if (sql == null) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)" IN ([$CATEGORY_ID$])", (String)(" = " + categoryIds[i2]));
            }
            sb.append(sql);
            if (i2 + 1 < categoryIds.length) {
                sb.append(" AND ");
            }
            ++i2;
        }
        sb.append(")");
    }

    protected void buildAllTagsSQL(long[][] tagIds, StringBundler sb) {
        sb.append(" AND AssetEntry.entryId IN (");
        int i2 = 0;
        while (i2 < tagIds.length) {
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(tagIds[i2]));
            sb.append(sql);
            if (i2 + 1 < tagIds.length) {
                sb.append(" AND AssetEntry.entryId IN (");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < tagIds.length) {
            if (i2 + 1 < tagIds.length) {
                sb.append(")");
            }
            ++i2;
        }
        sb.append(")");
    }

    protected void buildAnyCategoriesSQL(long[] categoryIds, StringBundler sb) throws SystemException {
        String sql = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        String categoryIdsString = null;
        if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
            ArrayList categoryIdsList = new ArrayList();
            long[] lArray = categoryIds;
            int n = categoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long categoryId = lArray[n2];
                categoryIdsList.addAll(AssetCategoryFinderUtil.findByG_L((Long)categoryId));
                ++n2;
            }
            if (categoryIdsList.isEmpty()) {
                return;
            }
            categoryIdsString = StringUtil.merge(categoryIdsList);
        } else {
            categoryIdsString = StringUtil.merge((long[])categoryIds);
        }
        sb.append(" AND (");
        sb.append(StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)categoryIdsString));
        sb.append(")");
    }

    protected String buildAnyTagsSQL(long[] tagIds, StringBundler sb) {
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < tagIds.length) {
            sb.append("AssetTag.tagId = ");
            sb.append(tagIds[i2]);
            if (i2 + 1 != tagIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected SQLQuery buildAssetQuerySQL(AssetEntryQuery entryQuery, boolean count, Session session) throws SystemException {
        String where;
        StringBundler sb = new StringBundler();
        if (count) {
            sb.append("SELECT COUNT(DISTINCT AssetEntry.entryId) AS COUNT_VALUE ");
        } else {
            sb.append("SELECT {AssetEntry.*} ");
            boolean selectRatings = false;
            String orderByCol1 = entryQuery.getOrderByCol1();
            String orderByCol2 = entryQuery.getOrderByCol2();
            if (orderByCol1.equals("ratings") || orderByCol2.equals("ratings")) {
                selectRatings = true;
                sb.append(", TEMP_TABLE.averageScore ");
            }
            sb.append("FROM (SELECT DISTINCT AssetEntry.entryId ");
            if (selectRatings) {
                sb.append(", RatingsStats.averageScore ");
            }
        }
        sb.append("FROM AssetEntry ");
        if (entryQuery.getAnyTagIds().length > 0) {
            sb.append("INNER JOIN ");
            sb.append("AssetEntries_AssetTags ON ");
            sb.append("(AssetEntries_AssetTags.entryId = ");
            sb.append("AssetEntry.entryId) ");
            sb.append("INNER JOIN ");
            sb.append("AssetTag ON ");
            sb.append("(AssetTag.tagId = AssetEntries_AssetTags.tagId) ");
        }
        if (entryQuery.getLinkedAssetEntryId() > 0L) {
            sb.append("INNER JOIN ");
            sb.append("AssetLink ON ");
            sb.append("(AssetEntry.entryId = AssetLink.entryId1) ");
            sb.append("OR (AssetEntry.entryId = AssetLink.entryId2)");
        }
        if (entryQuery.getOrderByCol1().equals("ratings") || entryQuery.getOrderByCol2().equals("ratings")) {
            sb.append(" LEFT JOIN ");
            sb.append("RatingsStats ON ");
            sb.append("(RatingsStats.classNameId = ");
            sb.append("AssetEntry.classNameId) AND ");
            sb.append("(RatingsStats.classPK = AssetEntry.classPK)");
        }
        sb.append("WHERE ");
        int whereIndex = sb.index();
        if (entryQuery.getLinkedAssetEntryId() > 0L) {
            sb.append(" AND ((AssetLink.entryId1 = ?) OR ");
            sb.append("(AssetLink.entryId2 = ?))");
            sb.append(" AND (AssetEntry.entryId != ?)");
        }
        if (entryQuery.isVisible() != null) {
            sb.append(" AND (visible = ?)");
        }
        if (entryQuery.isExcludeZeroViewCount()) {
            sb.append(" AND (AssetEntry.viewCount > 0)");
        }
        if (Validator.isNotNull((String)entryQuery.getKeywords())) {
            sb.append(" AND ((AssetEntry.title LIKE ?) OR");
            sb.append(" (AssetEntry.description LIKE ?))");
        } else {
            if (Validator.isNotNull((String)entryQuery.getTitle())) {
                sb.append(" AND (AssetEntry.title LIKE ?)");
            }
            if (Validator.isNotNull((String)entryQuery.getDescription())) {
                sb.append(" AND (AssetEntry.description LIKE ?)");
            }
        }
        Layout layout = entryQuery.getLayout();
        if (layout != null) {
            sb.append(" AND (AssetEntry.layoutUuid = ?)");
        }
        if (entryQuery.getAllCategoryIds().length > 0) {
            this.buildAllCategoriesSQL(entryQuery.getAllCategoryIds(), sb);
        }
        if (entryQuery.getAnyCategoryIds().length > 0) {
            this.buildAnyCategoriesSQL(entryQuery.getAnyCategoryIds(), sb);
        }
        if (entryQuery.getNotAllCategoryIds().length > 0) {
            this.buildNotAllCategoriesSQL(entryQuery.getNotAllCategoryIds(), sb);
        }
        if (entryQuery.getNotAnyCategoryIds().length > 0) {
            this.buildNotAnyCategoriesSQL(entryQuery.getNotAnyCategoryIds(), sb);
        }
        if (entryQuery.getClassTypeIds().length > 0) {
            this.buildClassTypeIdsSQL(entryQuery.getClassTypeIds(), sb);
        }
        if (entryQuery.getAllTagIds().length > 0) {
            this.buildAllTagsSQL(entryQuery.getAllTagIdsArray(), sb);
        }
        if (entryQuery.getAnyTagIds().length > 0) {
            this.buildAnyTagsSQL(entryQuery.getAnyTagIds(), sb);
        }
        if (entryQuery.getNotAllTagIds().length > 0) {
            this.buildNotAllTagsSQL(entryQuery.getNotAllTagIdsArray(), sb);
        }
        if (entryQuery.getNotAnyTagIds().length > 0) {
            this.buildNotAnyTagsSQL(entryQuery.getNotAnyTagIds(), sb);
        }
        sb.append(this.getDates(entryQuery.getPublishDate(), entryQuery.getExpirationDate()));
        sb.append(this.getGroupIds(entryQuery.getGroupIds()));
        sb.append(this.getClassNameIds(entryQuery.getClassNameIds()));
        if (!count) {
            sb.append(") TEMP_TABLE ");
            sb.append("INNER JOIN ");
            sb.append("AssetEntry AssetEntry ON ");
            sb.append("TEMP_TABLE.entryId = AssetEntry.entryId");
            sb.append(" ORDER BY ");
            if (entryQuery.getOrderByCol1().equals("ratings")) {
                sb.append("TEMP_TABLE.averageScore");
            } else {
                sb.append("AssetEntry.");
                sb.append(entryQuery.getOrderByCol1());
            }
            sb.append(" ");
            sb.append(entryQuery.getOrderByType1());
            if (Validator.isNotNull((String)entryQuery.getOrderByCol2()) && !entryQuery.getOrderByCol1().equals(entryQuery.getOrderByCol2())) {
                if (entryQuery.getOrderByCol2().equals("ratings")) {
                    sb.append(", TEMP_TABLE.averageScore");
                } else {
                    sb.append(", AssetEntry.");
                    sb.append(entryQuery.getOrderByCol2());
                }
                sb.append(" ");
                sb.append(entryQuery.getOrderByType2());
            }
        }
        if (sb.index() > whereIndex && (where = sb.stringAt(whereIndex)).startsWith(" AND")) {
            sb.setStringAt(where.substring(4), whereIndex);
        }
        String sql = sb.toString();
        SQLQuery q = session.createSQLQuery(sql);
        if (count) {
            q.addScalar("COUNT_VALUE", Type.LONG);
        } else {
            q.addEntity("AssetEntry", AssetEntryImpl.class);
        }
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (entryQuery.getLinkedAssetEntryId() > 0L) {
            qPos.add(entryQuery.getLinkedAssetEntryId());
            qPos.add(entryQuery.getLinkedAssetEntryId());
            qPos.add(entryQuery.getLinkedAssetEntryId());
        }
        if (entryQuery.isVisible() != null) {
            qPos.add(entryQuery.isVisible());
        }
        if (Validator.isNotNull((String)entryQuery.getKeywords())) {
            qPos.add(String.valueOf(entryQuery.getKeywords()) + '%');
            qPos.add(String.valueOf(entryQuery.getKeywords()) + '%');
        } else {
            if (Validator.isNotNull((String)entryQuery.getTitle())) {
                qPos.add(String.valueOf(entryQuery.getTitle()) + '%');
            }
            if (Validator.isNotNull((String)entryQuery.getDescription())) {
                qPos.add(String.valueOf(entryQuery.getDescription()) + '%');
            }
        }
        if (layout != null) {
            qPos.add(layout.getUuid());
        }
        this.setDates(qPos, entryQuery.getPublishDate(), entryQuery.getExpirationDate());
        qPos.add(entryQuery.getGroupIds());
        qPos.add(entryQuery.getClassNameIds());
        return q;
    }

    protected void buildClassTypeIdsSQL(long[] classTypeIds, StringBundler sb) {
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < classTypeIds.length) {
            sb.append(" AssetEntry.classTypeId = ");
            sb.append(classTypeIds[i2]);
            if (i2 + 1 < classTypeIds.length) {
                sb.append(" OR ");
            } else {
                sb.append(")");
            }
            ++i2;
        }
    }

    protected void buildNotAllCategoriesSQL(long[] categoryIds, StringBundler sb) throws SystemException {
        String findByAndCategoryIdsSQL = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < categoryIds.length) {
            List treeCategoryIds;
            sb.append("NOT ");
            String sql = null;
            if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL && (treeCategoryIds = AssetCategoryFinderUtil.findByG_L((Long)categoryIds[i2])).size() > 1) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)"[$CATEGORY_ID$]", (String)StringUtil.merge((Collection)treeCategoryIds));
            }
            if (sql == null) {
                sql = StringUtil.replace((String)findByAndCategoryIdsSQL, (String)" IN ([$CATEGORY_ID$])", (String)(" = " + categoryIds[i2]));
            }
            sb.append(sql);
            if (i2 + 1 < categoryIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
    }

    protected void buildNotAllTagsSQL(long[][] tagIds, StringBundler sb) {
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < tagIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(tagIds[i2]));
            sb.append(sql);
            sb.append(")");
            if (i2 + 1 < tagIds.length && tagIds[i2 + 1].length > 0) {
                sb.append(" OR ");
            }
            ++i2;
        }
        sb.append(")");
    }

    protected void buildNotAnyCategoriesSQL(long[] notCategoryIds, StringBundler sb) throws SystemException {
        sb.append(" AND (NOT ");
        String sql = CustomSQLUtil.get((String)FIND_BY_AND_CATEGORY_IDS);
        String notCategoryIdsString = null;
        if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
            ArrayList notCategoryIdsList = new ArrayList();
            long[] lArray = notCategoryIds;
            int n = notCategoryIds.length;
            int n2 = 0;
            while (n2 < n) {
                long notCategoryId = lArray[n2];
                notCategoryIdsList.addAll(AssetCategoryFinderUtil.findByG_L((Long)notCategoryId));
                ++n2;
            }
            notCategoryIdsString = StringUtil.merge(notCategoryIdsList);
        } else {
            notCategoryIdsString = StringUtil.merge((long[])notCategoryIds);
        }
        sb.append(StringUtil.replace((String)sql, (String)"[$CATEGORY_ID$]", (String)notCategoryIdsString));
        sb.append(")");
    }

    protected String buildNotAnyTagsSQL(long[] notTagIds, StringBundler sb) {
        sb.append(" AND (");
        int i2 = 0;
        while (i2 < notTagIds.length) {
            sb.append("AssetEntry.entryId NOT IN (");
            String sql = CustomSQLUtil.get((String)FIND_BY_AND_TAG_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$TAG_ID$]", (String)this.getTagIds(notTagIds));
            sb.append(sql);
            sb.append(")");
            if (i2 + 1 < notTagIds.length) {
                sb.append(" AND ");
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getClassNameIds(long[] classNameIds) {
        if (classNameIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(classNameIds.length + 1);
        sb.append(" AND (AssetEntry.classNameId = ?");
        int i2 = 0;
        while (i2 < classNameIds.length - 1) {
            sb.append(" OR AssetEntry.classNameId = ?");
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getDates(Date publishDate, Date expirationDate) {
        StringBundler sb = new StringBundler(4);
        if (publishDate != null) {
            sb.append(" AND (AssetEntry.publishDate IS NULL OR ");
            sb.append("AssetEntry.publishDate < ?)");
        }
        if (expirationDate != null) {
            sb.append(" AND (AssetEntry.expirationDate IS NULL OR ");
            sb.append("AssetEntry.expirationDate > ?)");
        }
        return sb.toString();
    }

    protected String getGroupIds(long[] groupIds) {
        if (groupIds.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(groupIds.length + 1);
        sb.append(" AND (AssetEntry.groupId = ?");
        int i2 = 0;
        while (i2 < groupIds.length - 1) {
            sb.append(" OR AssetEntry.groupId = ?");
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }

    protected String getTagIds(long[] tagIds) {
        StringBundler sb = new StringBundler(tagIds.length * 3 - 1);
        int i2 = 0;
        while (i2 < tagIds.length) {
            sb.append("tagId = ");
            sb.append(tagIds[i2]);
            if (i2 + 1 != tagIds.length) {
                sb.append(" OR ");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected void setDates(QueryPos qPos, Date publishDate, Date expirationDate) {
        if (publishDate != null) {
            Timestamp publishDate_TS = CalendarUtil.getTimestamp((Date)publishDate);
            qPos.add(publishDate_TS);
        }
        if (expirationDate != null) {
            Timestamp expirationDate_TS = CalendarUtil.getTimestamp((Date)expirationDate);
            qPos.add(expirationDate_TS);
        }
    }
}

