/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerPostProcessor;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.portlet.PortletURL;

public class AssetSearcher
extends BaseIndexer {
    private AssetEntryQuery _assetEntryQuery;

    public static Indexer getInstance() {
        return new AssetSearcher();
    }

    public AssetSearcher() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String[] getClassNames() {
        long[] classNameIds = this._assetEntryQuery.getClassNameIds();
        String[] classNames = new String[classNameIds.length];
        int i2 = 0;
        while (i2 < classNames.length) {
            long classNameId = classNameIds[i2];
            classNames[i2] = PortalUtil.getClassName((long)classNameId);
            ++i2;
        }
        return classNames;
    }

    public IndexerPostProcessor[] getIndexerPostProcessors() {
        throw new UnsupportedOperationException();
    }

    public String getPortletId() {
        return null;
    }

    public void registerIndexerPostProcessor(IndexerPostProcessor indexerPostProcessor) {
        throw new UnsupportedOperationException();
    }

    public void setAssetEntryQuery(AssetEntryQuery assetEntryQuery) {
        this._assetEntryQuery = assetEntryQuery;
    }

    protected void addImpossibleTerm(BooleanQuery contextQuery, String field) throws Exception {
        contextQuery.addTerm(field, "-1", false, BooleanClauseOccur.MUST);
    }

    protected void addSearchAllCategories(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] allCategoryIds = this._assetEntryQuery.getAllCategoryIds();
        if (allCategoryIds.length == 0) {
            return;
        }
        long[] filteredAllCategoryIds = AssetUtil.filterCategoryIds(permissionChecker, allCategoryIds);
        if (allCategoryIds.length != filteredAllCategoryIds.length) {
            this.addImpossibleTerm(contextQuery, "assetCategoryIds");
            return;
        }
        BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = filteredAllCategoryIds;
        int n = filteredAllCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long allCategoryId = lArray[n2];
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)allCategoryId);
            if (assetCategory != null) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                    categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)allCategoryId));
                }
                if (categoryIds.isEmpty()) {
                    categoryIds.add(allCategoryId);
                }
                BooleanQuery categoryIdQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
                Iterator iterator = categoryIds.iterator();
                while (iterator.hasNext()) {
                    long categoryId = (Long)iterator.next();
                    categoryIdQuery.addTerm("assetCategoryIds", categoryId);
                }
                categoryIdsQuery.add((Query)categoryIdQuery, BooleanClauseOccur.MUST);
            }
            ++n2;
        }
        contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchAllTags(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] allTagIds = this._assetEntryQuery.getAllTagIds();
        if (allTagIds.length == 0) {
            return;
        }
        long[] filteredAllTagIds = AssetUtil.filterTagIds(permissionChecker, allTagIds);
        if (allTagIds.length != filteredAllTagIds.length) {
            this.addImpossibleTerm(contextQuery, "assetTagIds");
            return;
        }
        BooleanQuery tagIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = allTagIds;
        int n = allTagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            tagIdsQuery.addRequiredTerm("assetTagIds", tagId);
            ++n2;
        }
        contextQuery.add((Query)tagIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyCategories(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] anyCategoryIds = this._assetEntryQuery.getAnyCategoryIds();
        if (anyCategoryIds.length == 0) {
            return;
        }
        long[] filteredAnyCategoryIds = AssetUtil.filterCategoryIds(permissionChecker, anyCategoryIds);
        if (filteredAnyCategoryIds.length == 0) {
            this.addImpossibleTerm(contextQuery, "assetCategoryIds");
            return;
        }
        BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = filteredAnyCategoryIds;
        int n = filteredAnyCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long anyCategoryId = lArray[n2];
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)anyCategoryId);
            if (assetCategory != null) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                    categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)anyCategoryId));
                }
                if (categoryIds.isEmpty()) {
                    categoryIds.add(anyCategoryId);
                }
                Iterator iterator = categoryIds.iterator();
                while (iterator.hasNext()) {
                    long categoryId = (Long)iterator.next();
                    categoryIdsQuery.addTerm("assetCategoryIds", categoryId);
                }
            }
            ++n2;
        }
        contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchAnyTags(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long[] anyTagIds = this._assetEntryQuery.getAnyTagIds();
        if (anyTagIds.length == 0) {
            return;
        }
        long[] filteredAnyTagIds = AssetUtil.filterTagIds(permissionChecker, anyTagIds);
        if (filteredAnyTagIds.length == 0) {
            this.addImpossibleTerm(contextQuery, "assetTagIds");
            return;
        }
        BooleanQuery tagIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = anyTagIds;
        int n = anyTagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            tagIdsQuery.addTerm("assetTagIds", tagId);
            ++n2;
        }
        contextQuery.add((Query)tagIdsQuery, BooleanClauseOccur.MUST);
    }

    protected void addSearchAssetCategoryIds(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addSearchAllCategories(contextQuery, searchContext);
        this.addSearchAnyCategories(contextQuery, searchContext);
        this.addSearchNotAnyCategories(contextQuery, searchContext);
        this.addSearchNotAllCategories(contextQuery, searchContext);
    }

    protected void addSearchAssetTagNames(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addSearchAllTags(contextQuery, searchContext);
        this.addSearchAnyTags(contextQuery, searchContext);
        this.addSearchNotAllTags(contextQuery, searchContext);
        this.addSearchNotAnyTags(contextQuery, searchContext);
    }

    protected void addSearchKeywords(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            return;
        }
        super.addSearchKeywords(searchQuery, searchContext);
        String field = DocumentImpl.getLocalizedName((Locale)searchContext.getLocale(), (String)"localized_title");
        searchQuery.addTerm(field, keywords, true);
    }

    protected void addSearchLayout(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String layoutUuid = (String)((Object)searchContext.getAttribute("layoutUuid"));
        if (Validator.isNotNull((String)layoutUuid)) {
            contextQuery.addRequiredTerm("layoutUuid", layoutUuid);
        }
    }

    protected void addSearchNotAllCategories(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] notAllCategoryIds = this._assetEntryQuery.getNotAllCategoryIds();
        if (notAllCategoryIds.length == 0) {
            return;
        }
        BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = notAllCategoryIds;
        int n = notAllCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long notAllCategoryId = lArray[n2];
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAllCategoryId);
            if (assetCategory != null) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                    categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAllCategoryId));
                }
                if (categoryIds.isEmpty()) {
                    categoryIds.add(notAllCategoryId);
                }
                BooleanQuery categoryIdQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
                Iterator iterator = categoryIds.iterator();
                while (iterator.hasNext()) {
                    long categoryId = (Long)iterator.next();
                    categoryIdQuery.addTerm("assetCategoryIds", categoryId);
                }
                categoryIdsQuery.add((Query)categoryIdQuery, BooleanClauseOccur.MUST);
            }
            ++n2;
        }
        contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAllTags(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] notAllTagIds = this._assetEntryQuery.getNotAllTagIds();
        if (notAllTagIds.length == 0) {
            return;
        }
        BooleanQuery tagIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = notAllTagIds;
        int n = notAllTagIds.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            tagIdsQuery.addRequiredTerm("assetTagIds", tagId);
            ++n2;
        }
        contextQuery.add((Query)tagIdsQuery, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyCategories(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] notAnyCategoryIds = this._assetEntryQuery.getNotAnyCategoryIds();
        if (notAnyCategoryIds.length == 0) {
            return;
        }
        BooleanQuery categoryIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = notAnyCategoryIds;
        int n = notAnyCategoryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long notAnyCategoryId = lArray[n2];
            AssetCategory assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory((long)notAnyCategoryId);
            if (assetCategory != null) {
                ArrayList<Long> categoryIds = new ArrayList<Long>();
                if (PropsValues.ASSET_CATEGORIES_SEARCH_HIERARCHICAL) {
                    categoryIds.addAll(AssetCategoryLocalServiceUtil.getSubcategoryIds((long)notAnyCategoryId));
                }
                if (categoryIds.isEmpty()) {
                    categoryIds.add(notAnyCategoryId);
                }
                Iterator iterator = categoryIds.iterator();
                while (iterator.hasNext()) {
                    long categoryId = (Long)iterator.next();
                    categoryIdsQuery.addTerm("assetCategoryIds", categoryId);
                }
            }
            ++n2;
        }
        contextQuery.add((Query)categoryIdsQuery, BooleanClauseOccur.MUST_NOT);
    }

    protected void addSearchNotAnyTags(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] notAnyTagIds = this._assetEntryQuery.getNotAnyTagIds();
        if (notAnyTagIds.length == 0) {
            return;
        }
        BooleanQuery tagIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
        long[] lArray = this._assetEntryQuery.getNotAnyTagIds();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long tagId = lArray[n2];
            tagIdsQuery.addTerm("assetTagIds", tagId);
            ++n2;
        }
        contextQuery.add((Query)tagIdsQuery, BooleanClauseOccur.MUST_NOT);
    }

    protected void postProcessFullQuery(BooleanQuery fullQuery, SearchContext searchContext) throws Exception {
        fullQuery.addRequiredTerm("visible", true);
    }

    protected void doDelete(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Document doGetDocument(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(Object obj) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(String className, long classPK) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doReindex(String[] ids) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected String getPortletId(SearchContext searchContext) {
        return null;
    }
}

