/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryActionableDynamicQuery;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BlogsIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    public static final String PORTLET_ID = "33";

    public BlogsIndexer() {
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) {
        document.addKeyword("relatedEntry", true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        this.addStatus(contextQuery, searchContext);
    }

    protected void doDelete(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("content", HtmlUtil.extractText((String)entry.getContent()));
        document.addText("description", entry.getDescription());
        document.addDate("modified", entry.getModifiedDate());
        document.addText("title", entry.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", entryId);
        Summary summary = this.createSummary(document);
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId) throws PortalException, SystemException {
        BlogsEntryActionableDynamicQuery actionableDynamicQuery = new BlogsEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
                dynamicQuery.add(displayDateProperty.lt((Object)new Date()));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }

            protected void performAction(Object object) throws PortalException {
                BlogsEntry entry = (BlogsEntry)object;
                Document document = BlogsIndexer.this.getDocument(entry);
                this.addDocument(document);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }
}

