/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLImpl;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorThreadLocal;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class FileEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<FileEntry> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName(), FileEntry.class.getName(), LiferayFileEntry.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(FileEntryStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        FileEntry fileEntry = FileEntryUtil.fetchByUUID_R(uuid, groupId);
        if (fileEntry != null) {
            DLAppLocalServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public void importStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        boolean dlProcessorEnabled = DLProcessorThreadLocal.isEnabled();
        try {
            DLProcessorThreadLocal.setEnabled((boolean)false);
            super.importStagedModel(portletDataContext, (StagedModel)fileEntry);
        }
        finally {
            DLProcessorThreadLocal.setEnabled((boolean)dlProcessorEnabled);
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        Element fileEntryElement = portletDataContext.getExportDataElement((ClassedModel)fileEntry);
        String fileEntryPath = ExportImportPathUtil.getModelPath((StagedModel)fileEntry);
        if (!fileEntry.isDefaultRepository()) {
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)fileEntry.getRepositoryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)repository, (String)"strong");
            portletDataContext.addClassedModel(fileEntryElement, fileEntryPath, (ClassedModel)fileEntry);
            long liferayRepositoryClassNameId = PortalUtil.getClassNameId((String)LiferayRepository.class.getName());
            if (repository.getClassNameId() != liferayRepositoryClassNameId) {
                return;
            }
        }
        if (fileEntry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)fileEntry.getFolder(), (String)"parent");
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        liferayFileEntry.setCachedFileVersion(fileEntry.getFileVersion());
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            InputStream is = null;
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {}
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryElement.detach();
                return;
            }
            try {
                String binPath = ExportImportPathUtil.getModelPath((StagedModel)fileEntry, (String)fileEntry.getVersion());
                portletDataContext.addZipEntry(binPath, is);
                fileEntryElement.addAttribute("bin-path", binPath);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.exportGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (Element)fileEntryElement);
        }
        this.exportMetaData(portletDataContext, fileEntryElement, fileEntry);
        portletDataContext.addClassedModel(fileEntryElement, fileEntryPath, (ClassedModel)liferayFileEntry, DLFileEntry.class);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long fileEntryId) throws Exception {
        FileEntry existingFileEntry = FileEntryUtil.fetchByUUID_R(uuid, portletDataContext.getScopeGroupId());
        if (existingFileEntry == null) {
            existingFileEntry = FileEntryUtil.fetchByUUID_R(uuid, portletDataContext.getCompanyGroupId());
        }
        Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        fileEntryIds.put(fileEntryId, existingFileEntry.getFileEntryId());
    }

    /*
     * Unable to fully structure code
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        if (!fileEntry.isDefaultRepository()) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, Repository.class, (long)fileEntry.getRepositoryId());
            return;
        }
        if (fileEntry.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, DLFolder.class, (long)fileEntry.getFolderId());
        }
        folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class);
        folderId = MapUtil.getLong((Map)folderIds, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        assetCategoryIds = portletDataContext.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        assetTagNames = portletDataContext.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntry, DLFileEntry.class);
        serviceContext.setAttribute("sourceFileName", (Serializable)("A." + fileEntry.getExtension()));
        serviceContext.setUserId(userId);
        fileEntryElement = portletDataContext.getImportDataElement((StagedModel)fileEntry);
        binPath = fileEntryElement.attributeValue("bin-path");
        is = null;
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException v0) {}
        } else {
            is = portletDataContext.getZipEntryAsInputStream(binPath);
        }
        if (is == null) {
            if (FileEntryStagedModelDataHandler._log.isWarnEnabled()) {
                FileEntryStagedModelDataHandler._log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
            }
            return;
        }
        this.importMetaData(portletDataContext, fileEntryElement, fileEntry, serviceContext);
        importedFileEntry = null;
        titleWithExtension = DLUtil.getTitleWithExtension((FileEntry)fileEntry);
        extension = fileEntry.getExtension();
        periodAndExtension = ".".concat(extension);
        if (portletDataContext.isDataStrategyMirror()) {
            existingFileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
            fileVersion = fileEntry.getFileVersion();
            if (existingFileEntry == null) {
                fileEntryTitle = fileEntry.getTitle();
                existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, fileEntryTitle);
                if (existingTitleFileEntry != null) {
                    if (fileEntry.getGroupId() == portletDataContext.getSourceGroupId() && portletDataContext.isDataStrategyMirrorWithOverwriting()) {
                        DLAppLocalServiceUtil.deleteFileEntry((long)existingTitleFileEntry.getFileEntryId());
                    } else {
                        titleHasExtension = false;
                        if (fileEntryTitle.endsWith(periodAndExtension)) {
                            fileEntryTitle = FileUtil.stripExtension((String)fileEntryTitle);
                            titleHasExtension = true;
                        }
                        i = 1;
                        while (true) {
                            fileEntryTitle = String.valueOf(fileEntryTitle) + " " + i;
                            titleWithExtension = String.valueOf(fileEntryTitle) + periodAndExtension;
                            existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, titleWithExtension);
                            if (existingTitleFileEntry == null) {
                                if (!titleHasExtension) break;
                                fileEntryTitle = String.valueOf(fileEntryTitle) + periodAndExtension;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                serviceContext.setAttribute("fileVersionUuid", (Serializable)fileVersion.getUuid());
                serviceContext.setUuid(fileEntry.getUuid());
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntryTitle, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                if (fileEntry.isInTrash()) {
                    importedFileEntry = DLAppServiceUtil.moveFileEntryToTrash((long)importedFileEntry.getFileEntryId());
                }
            } else {
                latestExistingFileVersion = DLImpl.getLatestFileVersion(existingFileEntry, true);
                indexEnabled = serviceContext.isIndexingEnabled();
                try {
                    serviceContext.setIndexingEnabled(false);
                    if (!fileVersion.getUuid().equals(latestExistingFileVersion.getUuid())) {
                        alreadyExistingFileVersion = DLFileVersionLocalServiceUtil.getFileVersionByUuidAndGroupId((String)fileVersion.getUuid(), (long)existingFileEntry.getGroupId());
                        if (alreadyExistingFileVersion != null) {
                            serviceContext.setAttribute("existingDLFileVersionId", (Serializable)Long.valueOf(alreadyExistingFileVersion.getFileVersionId()));
                        }
                        serviceContext.setUuid(fileVersion.getUuid());
                        importedFileEntry = DLAppLocalServiceUtil.updateFileEntry((long)userId, (long)existingFileEntry.getFileEntryId(), (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (boolean)false, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                    } else {
                        DLAppLocalServiceUtil.updateAsset((long)userId, (FileEntry)existingFileEntry, (FileVersion)latestExistingFileVersion, (long[])assetCategoryIds, (String[])assetTagNames, null);
                        importedFileEntry = existingFileEntry;
                    }
                    if (importedFileEntry.getFolderId() != folderId) {
                        importedFileEntry = DLAppLocalServiceUtil.moveFileEntry((long)userId, (long)importedFileEntry.getFileEntryId(), (long)folderId, (ServiceContext)serviceContext);
                    }
                    if (!(importedFileEntry instanceof LiferayFileEntry)) ** GOTO lbl99
                    liferayFileEntry = (LiferayFileEntry)importedFileEntry;
                    indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                    indexer.reindex(liferayFileEntry.getModel());
                }
                finally {
                    serviceContext.setIndexingEnabled(indexEnabled);
                }
            }
        } else {
            try {
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            catch (DuplicateFileException v1) {
                title = fileEntry.getTitle();
                titleParts = title.split("\\.", 2);
                title = String.valueOf(titleParts[0]) + StringUtil.randomString();
                if (titleParts.length > 1) {
                    title = String.valueOf(title) + "." + titleParts[1];
                }
                if (!title.endsWith(periodAndExtension)) {
                    title = String.valueOf(title) + periodAndExtension;
                }
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)title, (String)fileEntry.getMimeType(), (String)title, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
        }
lbl99:
        // 5 sources

        if (portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.importGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (FileEntry)importedFileEntry, (Element)fileEntryElement);
        }
        portletDataContext.importClassedModel((ClassedModel)fileEntry, (ClassedModel)importedFileEntry, DLFileEntry.class);
        fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        fileEntryIds.put(fileEntry.getFileEntryId(), importedFileEntry.getFileEntryId());
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, FileEntry fileEntry) throws Exception {
        long userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        FileEntry existingFileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFileEntry == null || !existingFileEntry.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileEntry.class.getName());
        if (trashHandler.isRestorable(existingFileEntry.getFileEntryId())) {
            trashHandler.restoreTrashEntry(userId, existingFileEntry.getFileEntryId());
        }
    }

    protected void exportMetaData(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)fileEntryTypeId);
        if (dlFileEntryType == null || !dlFileEntryType.isExportable()) {
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, (StagedModel)dlFileEntryType, (String)"strong");
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            FileVersion fileVersion = fileEntry.getFileVersion();
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.fetchFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersion.getFileVersionId());
            if (dlFileEntryMetadata == null) continue;
            Element structureFields = fileEntryElement.addElement("structure-fields");
            String path = ExportImportPathUtil.getModelPath((StagedModel)ddmStructure, (String)String.valueOf(dlFileEntryMetadata.getDDMStorageId()));
            structureFields.addAttribute("path", path);
            structureFields.addAttribute("structureUuid", ddmStructure.getUuid());
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            portletDataContext.addZipEntry(path, (Object)fields);
        }
    }

    protected void importMetaData(PortletDataContext portletDataContext, Element fileEntryElement, FileEntry fileEntry, ServiceContext serviceContext) throws Exception {
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntry, DLFileEntryType.class, (long)dlFileEntry.getFileEntryTypeId());
        Map dlFileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
        long dlFileEntryTypeId = MapUtil.getLong((Map)dlFileEntryTypeIds, (long)dlFileEntry.getFileEntryTypeId(), (long)dlFileEntry.getFileEntryTypeId());
        DLFileEntryType existingDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)dlFileEntryTypeId);
        if (existingDLFileEntryType == null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Integer.valueOf(-1));
            return;
        }
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(existingDLFileEntryType.getFileEntryTypeId()));
        List ddmStructures = existingDLFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFieldsElement = (Element)fileEntryElement.selectSingleNode("structure-fields[@structureUuid='".concat(ddmStructure.getUuid()).concat("']"));
            if (structureFieldsElement == null) continue;
            String path = structureFieldsElement.attributeValue("path");
            Fields fields = (Fields)portletDataContext.getZipEntryAsObject(path);
            serviceContext.setAttribute(String.valueOf(Fields.class.getName()) + ddmStructure.getStructureId(), (Serializable)fields);
        }
    }

    protected void validateExport(PortletDataContext portletDataContext, FileEntry fileEntry) throws PortletDataException {
        block13: {
            block12: {
                if (fileEntry.getGroupId() != portletDataContext.getGroupId() && fileEntry.getGroupId() != portletDataContext.getScopeGroupId()) {
                    PortletDataException pde = new PortletDataException(4);
                    pde.setStagedModel((StagedModel)fileEntry);
                    throw pde;
                }
                try {
                    FileVersion fileVersion = fileEntry.getFileVersion();
                    if (!ArrayUtil.contains((int[])this.getExportableStatuses(), (int)fileVersion.getStatus())) {
                        throw new PortletDataException(9);
                    }
                }
                catch (PortletDataException pde) {
                    throw pde;
                }
                catch (Exception e2) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e2, (Throwable)e2);
                    }
                    if (!_log.isWarnEnabled()) break block12;
                    _log.warn((Object)("Unable to check workflow status for file entry " + fileEntry.getFileEntryId()));
                }
            }
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)DLFileEntry.class.getName());
            if (trashHandler != null) {
                try {
                    if (trashHandler.isInTrash(fileEntry.getFileEntryId()) || trashHandler.isInTrashContainer(fileEntry.getFileEntryId())) {
                        throw new PortletDataException(8);
                    }
                }
                catch (PortletDataException pde) {
                    throw pde;
                }
                catch (Exception e3) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)e3, (Throwable)e3);
                    }
                    if (!_log.isWarnEnabled()) break block13;
                    _log.warn((Object)("Unable to check trash status for file entry " + fileEntry.getFileEntryId()));
                }
            }
        }
    }

    protected boolean validateMissingReference(String uuid, long companyId, long groupId) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchDLFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
        return dlFileEntry != null;
    }
}

