/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.InvalidLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TreeModelFinder;
import com.liferay.portal.kernel.util.TreePathUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.RequiredFileEntryTypeException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.documentlibrary.util.comparator.FolderIdComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceImpl.class);

    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, boolean hidden, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validateFolder(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder dlFolder = this.dlFolderPersistence.create(folderId);
        dlFolder.setUuid(serviceContext.getUuid());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(user.getCompanyId());
        dlFolder.setUserId(user.getUserId());
        dlFolder.setUserName(user.getFullName());
        dlFolder.setCreateDate(serviceContext.getCreateDate(now));
        dlFolder.setModifiedDate(serviceContext.getModifiedDate(now));
        dlFolder.setRepositoryId(repositoryId);
        dlFolder.setMountPoint(mountPoint);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setTreePath(dlFolder.buildTreePath());
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        dlFolder.setLastPostDate(now);
        dlFolder.setHidden(hidden);
        dlFolder.setOverrideFileEntryTypes(false);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFolderResources(dlFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(repositoryId, DLFolderConstants.getClassName());
            }
            this.addFolderResources(dlFolder, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        if (parentFolderId != 0L) {
            DLFolder parentDLFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
            parentDLFolder.setLastPostDate(now);
            this.dlFolderPersistence.update((BaseModel)parentDLFolder);
        }
        this.dlAppHelperLocalService.addFolder(userId, (Folder)new LiferayFolder(dlFolder), serviceContext);
        return dlFolder;
    }

    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addFolder(userId, groupId, repositoryId, mountPoint, parentFolderId, name, description, false, serviceContext);
    }

    public void deleteAll(long groupId) throws PortalException, SystemException {
        block3: {
            Group group = this.groupLocalService.getGroup(groupId);
            List dlFolders = this.dlFolderPersistence.findByGroupId(groupId);
            for (DLFolder dlFolder : dlFolders) {
                this.dlFolderLocalService.deleteFolder(dlFolder);
            }
            this.dlFileEntryLocalService.deleteFileEntries(groupId, 0L);
            this.dlFileEntryTypeLocalService.deleteFileEntryTypes(groupId);
            this.dlFileShortcutLocalService.deleteFileShortcuts(groupId, 0L);
            try {
                DLStoreUtil.deleteDirectory((long)group.getCompanyId(), (long)groupId, (String)"");
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder) throws PortalException, SystemException {
        return this.deleteFolder(dlFolder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public DLFolder deleteFolder(DLFolder dlFolder, boolean includeTrashedEntries) throws PortalException, SystemException {
        ArrayList<Long> fileEntryTypeIds;
        block9: {
            List dlFolders = this.dlFolderPersistence.findByG_P(dlFolder.getGroupId(), dlFolder.getFolderId());
            for (DLFolder curDLFolder : dlFolders) {
                if (!includeTrashedEntries && curDLFolder.isInTrashExplicitly()) continue;
                this.dlFolderLocalService.deleteFolder(curDLFolder, includeTrashedEntries);
            }
            this.resourceLocalService.deleteResource(dlFolder.getCompanyId(), DLFolder.class.getName(), 4, dlFolder.getFolderId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), dlFolder.getFolderId());
            this.dlFileEntryLocalService.deleteFileEntries(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
            fileEntryTypeIds = new ArrayList<Long>();
            for (DLFileEntryType dlFileEntryType : this.dlFileEntryTypeLocalService.getDLFolderDLFileEntryTypes(dlFolder.getFolderId())) {
                fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
            }
            if (fileEntryTypeIds.isEmpty()) {
                fileEntryTypeIds.add(-1L);
            }
            this.dlFileEntryTypeLocalService.unsetFolderFileEntryTypes(dlFolder.getFolderId());
            this.dlFileShortcutLocalService.deleteFileShortcuts(dlFolder.getGroupId(), dlFolder.getFolderId(), includeTrashedEntries);
            this.expandoRowLocalService.deleteRows(dlFolder.getFolderId());
            this.dlAppHelperLocalService.deleteFolder((Folder)new LiferayFolder(dlFolder));
            this.dlFolderPersistence.remove((BaseModel)dlFolder);
            try {
                if (includeTrashedEntries) {
                    DLStoreUtil.deleteDirectory((long)dlFolder.getCompanyId(), (long)dlFolder.getFolderId(), (String)"");
                }
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block9;
                _log.debug((Object)nsde.getMessage());
            }
        }
        Iterator iterator = fileEntryTypeIds.iterator();
        while (iterator.hasNext()) {
            long fileEntryTypeId = (Long)iterator.next();
            WorkflowDefinitionLink workflowDefinitionLink = null;
            try {
                workflowDefinitionLink = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLink(dlFolder.getCompanyId(), dlFolder.getGroupId(), DLFolder.class.getName(), dlFolder.getFolderId(), fileEntryTypeId);
            }
            catch (NoSuchWorkflowDefinitionLinkException noSuchWorkflowDefinitionLinkException) {
                continue;
            }
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
        return dlFolder;
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderLocalService.deleteFolder(folderId, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        return this.dlFolderLocalService.deleteFolder(dlFolder, includeTrashedEntries);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLFolder deleteFolder(long userId, long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dLFolder = this.deleteFolder(folderId, includeTrashedEntries);
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public DLFolder fetchFolder(long folderId) throws SystemException {
        return this.dlFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public DLFolder fetchFolder(long groupId, long parentFolderId, String name) throws SystemException {
        return this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public List<DLFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.dlFolderPersistence.countByCompanyId(companyId);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.getFileEntriesAndFileShortcuts(groupId, folderId, queryDefinition);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.dlFolderFinder.findFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFileEntriesAndFileShortcutsCount(groupId, folderId, queryDefinition);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, QueryDefinition queryDefinition) throws SystemException {
        return this.dlFolderFinder.countFE_FS_ByG_F(groupId, folderId, queryDefinition);
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.getFolders(groupId, parentFolderId, true);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.findByG_M_P_H(groupId, false, parentFolderId, false, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.getFolders(groupId, parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.getFoldersAndFileEntriesAndFileShortcuts(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, null, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws SystemException {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, String[] mimeTypes, boolean includeMountFolders, QueryDefinition queryDefinition) throws SystemException {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_M_M(groupId, folderId, mimeTypes, includeMountFolders, queryDefinition);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.countByG_M_P_H(groupId, false, parentFolderId, false);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P_H_S(groupId, parentFolderId, false, status);
        }
        return this.dlFolderPersistence.countByG_M_P_H_S(groupId, false, parentFolderId, false, status);
    }

    public DLFolder getMountFolder(long repositoryId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByRepositoryId(repositoryId);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderPersistence.findByG_M_P_H(groupId, true, parentFolderId, false, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.countByG_M_P_H(groupId, true, parentFolderId, false);
    }

    public List<DLFolder> getNoAssetFolders() throws SystemException {
        return this.dlFolderFinder.findF_ByNoAssets();
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List dlFolders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        }
    }

    public boolean hasFolderLock(long userId, long folderId) throws SystemException {
        return this.lockLocalService.hasLock(userId, DLFolder.class.getName(), folderId);
    }

    public Lock lockFolder(long userId, long folderId) throws PortalException, SystemException {
        return this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
    }

    public Lock lockFolder(long userId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        if (expirationTime <= 0L || expirationTime > DLFolderImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFolderImpl.LOCK_EXPIRATION_TIME;
        }
        return this.lockLocalService.lock(userId, DLFolder.class.getName(), folderId, owner, inheritable, expirationTime);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId);
        }
        try {
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
            this.validateFolder(dlFolder.getFolderId(), dlFolder.getGroupId(), parentFolderId, dlFolder.getName());
            dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setTreePath(dlFolder.buildTreePath());
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            this.dlAppHelperLocalService.moveFolder((Folder)new LiferayFolder(dlFolder));
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public void rebuildTree(long companyId) throws SystemException {
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (TreeModelFinder)new TreeModelFinder<DLFolder>(){

            public List<DLFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) throws SystemException {
                return DLFolderLocalServiceImpl.this.dlFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator());
            }
        });
    }

    public void unlockFolder(long groupId, long parentFolderId, String name, String lockUuid) throws PortalException, SystemException {
        DLFolder dlFolder = this.getFolder(groupId, parentFolderId, name);
        this.unlockFolder(dlFolder.getFolderId(), lockUuid);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException, SystemException {
        block4: {
            if (Validator.isNotNull((String)lockUuid)) {
                try {
                    Lock lock = this.lockLocalService.getLock(DLFolder.class.getName(), folderId);
                    if (!lockUuid.equals(lock.getUuid())) {
                        throw new InvalidLockException("UUIDs do not match");
                    }
                }
                catch (PortalException pe) {
                    if (pe instanceof ExpiredLockException || pe instanceof NoSuchLockException) break block4;
                    throw pe;
                }
            }
        }
        this.lockLocalService.unlock(DLFolder.class.getName(), folderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean hasLock = this.hasFolderLock(serviceContext.getUserId(), folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(serviceContext.getUserId(), folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            DLFolder dlFolder = null;
            if (folderId > 0L) {
                dlFolder = this.dlFolderLocalService.updateFolderAndFileEntryTypes(serviceContext.getUserId(), folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
                this.dlFileEntryTypeLocalService.cascadeFileEntryTypes(serviceContext.getUserId(), dlFolder);
            }
            ArrayList<ObjectValuePair> workflowDefinitionOVPs = new ArrayList<ObjectValuePair>();
            if (fileEntryTypeIds.isEmpty()) {
                fileEntryTypeIds.add(-1L);
            } else {
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)""));
            }
            for (long fileEntryTypeId : fileEntryTypeIds) {
                String workflowDefinition = "";
                if (overrideFileEntryTypes || folderId == 0L) {
                    workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + fileEntryTypeId));
                }
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)fileEntryTypeId, (Object)workflowDefinition));
            }
            this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), DLFolder.class.getName(), folderId, workflowDefinitionOVPs);
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateFolder(folderId, folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
    }

    public DLFolder updateFolderAndFileEntryTypes(long userId, long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        if (overrideFileEntryTypes && fileEntryTypeIds.isEmpty()) {
            throw new RequiredFileEntryTypeException();
        }
        boolean hasLock = this.hasFolderLock(userId, folderId);
        Lock lock = null;
        if (!hasLock) {
            lock = this.lockFolder(userId, folderId, null, false, DLFolderImpl.LOCK_EXPIRATION_TIME);
        }
        try {
            if (!overrideFileEntryTypes) {
                fileEntryTypeIds = Collections.emptyList();
            }
            DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
            parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
            this.validateFolder(folderId, dlFolder.getGroupId(), parentFolderId, name);
            dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
            dlFolder.setParentFolderId(parentFolderId);
            dlFolder.setTreePath(dlFolder.buildTreePath());
            dlFolder.setName(name);
            dlFolder.setDescription(description);
            dlFolder.setExpandoBridgeAttributes(serviceContext);
            dlFolder.setOverrideFileEntryTypes(overrideFileEntryTypes);
            dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
            this.dlFolderPersistence.update((BaseModel)dlFolder);
            if (fileEntryTypeIds != null) {
                this.dlFileEntryTypeLocalService.updateFolderFileEntryTypes(dlFolder, fileEntryTypeIds, defaultFileEntryTypeId, serviceContext);
            }
            this.dlAppHelperLocalService.updateFolder(userId, (Folder)new LiferayFolder(dlFolder), serviceContext);
            DLFolder dLFolder = dlFolder;
            return dLFolder;
        }
        finally {
            if (!hasLock) {
                this.unlockFolder(folderId, lock.getUuid());
            }
        }
    }

    public void updateLastPostDate(long folderId, Date lastPostDate) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        dlFolder.setLastPostDate(lastPostDate);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    public DLFolder updateStatus(long userId, long folderId, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        int oldStatus = dlFolder.getStatus();
        dlFolder.setStatus(status);
        dlFolder.setStatusByUserId(user.getUserId());
        dlFolder.setStatusByUserName(user.getFullName());
        dlFolder.setStatusDate(new Date());
        this.dlFolderPersistence.update((BaseModel)dlFolder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(DLFolder.class.getName(), dlFolder.getFolderId(), false);
        }
        if (!(status != 0 && status != 8 && oldStatus != 8 || serviceContext != null && !serviceContext.isIndexingEnabled())) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)DLFolderConstants.getClassName());
            indexer.reindex((Object)dlFolder);
        }
        return dlFolder;
    }

    protected void addFolderResources(DLFolder dlFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(DLFolder dlFolder, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), groupPermissions, guestPermissions);
    }

    protected void addFolderResources(long folderId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(long folderId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, groupPermissions, guestPermissions);
    }

    protected long getParentFolderId(DLFolder dlFolder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (dlFolder.getFolderId() == parentFolderId) {
            return dlFolder.getParentFolderId();
        }
        DLFolder parentDLFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentDLFolder == null || dlFolder.getGroupId() != parentDLFolder.getGroupId()) {
            return dlFolder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return dlFolder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        DLFolder parentDLFolder;
        if (parentFolderId != 0L && ((parentDLFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentDLFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        this.validateFolderName(name);
        DLStoreUtil.validateDirectoryName((String)name);
        try {
            this.dlFileEntryLocalService.getFileEntry(groupId, parentFolderId, name);
            throw new DuplicateFileException(name);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
            if (dlFolder != null && dlFolder.getFolderId() != folderId) {
                throw new DuplicateFolderNameException(name);
            }
            return;
        }
    }

    protected void validateFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validateFolder(folderId, groupId, parentFolderId, name);
    }

    protected void validateFolderName(String folderName) throws PortalException {
        if (folderName.contains("/")) {
            throw new FolderNameException(folderName);
        }
    }
}

