/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.trash;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.trash.DLBaseTrashHandler;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.trash.DuplicateEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class DLFileEntryTrashHandler
extends DLBaseTrashHandler {
    public void checkDuplicateEntry(long classPK, long containerModelId, String newName) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        this.checkDuplicateEntry(classPK, 0L, containerModelId, dlFileEntry.getTitle(), newName);
    }

    public void checkDuplicateTrashEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException, SystemException {
        this.checkDuplicateEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        DLAppLocalServiceUtil.deleteFileEntry((long)classPK);
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        long parentFolderId = dlFileEntry.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = (DLFileEntry)trashedModel;
        return this.getContainerModel(dlFileEntry.getFolderId());
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        return DLUtil.getDLFileEntryControlPanelLink((PortletRequest)portletRequest, (long)dlFileEntry.getFileEntryId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)dlFileEntry.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        DLFolder dlFolder = dlFileEntry.getFolder();
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)dlFolder.getFolderId());
    }

    public String getSystemEventClassName() {
        return DLFileEntryConstants.getClassName();
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        return dlFileEntry.getTrashEntry();
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return DLFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_DOCUMENT");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        try {
            DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
            return dlFileEntry.isInTrash();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return false;
        }
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        try {
            DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
            return dlFileEntry.isInTrashContainer();
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            return false;
        }
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.fetchDLFileEntry(classPK);
        if (dlFileEntry == null || dlFileEntry.getFolderId() > 0L && DLFolderLocalServiceUtil.fetchFolder((long)dlFileEntry.getFolderId()) == null) {
            return false;
        }
        return !dlFileEntry.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLAppLocalServiceUtil.moveFileEntry((long)userId, (long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        Repository repository = this.getRepository(classPK);
        DLAppHelperLocalServiceUtil.moveFileEntryFromTrash((long)userId, (FileEntry)repository.getFileEntry(classPK), (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (dlFileEntry.getClassNameId() > 0L && dlFileEntry.getClassPK() > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)dlFileEntry.getClassName());
            trashHandler.restoreRelatedTrashEntry(this.getClassName(), classPK);
            return;
        }
        DLAppLocalServiceUtil.restoreFileEntryFromTrash((long)userId, (long)classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        dlFileEntry.setTitle(name);
        DLFileEntryLocalServiceUtil.updateDLFileEntry((DLFileEntry)dlFileEntry);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        dlFileVersion.setTitle(name);
        DLFileVersionLocalServiceUtil.updateDLFileVersion((DLFileVersion)dlFileVersion);
    }

    protected void checkDuplicateEntry(long classPK, long entryId, long containerModelId, String originalTitle, String newName) throws PortalException, SystemException {
        DLFileEntry duplicateDLFileEntry;
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (containerModelId == -1L) {
            containerModelId = dlFileEntry.getFolderId();
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateDLFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntry((long)dlFileEntry.getGroupId(), (long)containerModelId, (String)originalTitle)) != null) {
            DuplicateEntryException dee = new DuplicateEntryException();
            dee.setDuplicateEntryId(duplicateDLFileEntry.getFileEntryId());
            dee.setOldName(duplicateDLFileEntry.getTitle());
            dee.setTrashEntryId(entryId);
            throw dee;
        }
    }

    protected DLFileEntry fetchDLFileEntry(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)0L, (long)classPK, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            return null;
        }
        FileEntry fileEntry = repository.getFileEntry(classPK);
        return (DLFileEntry)fileEntry.getModel();
    }

    protected DLFileEntry getDLFileEntry(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)0L, (long)classPK, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        FileEntry fileEntry = repository.getFileEntry(classPK);
        return (DLFileEntry)fileEntry.getModel();
    }

    @Override
    protected Repository getRepository(long classPK) throws PortalException, SystemException {
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)0L, (long)classPK, (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        return repository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(classPK);
        if (dlFileEntry.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
    }
}

