/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.persistence.GroupActionableDynamicQuery;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryActionableDynamicQuery;
import com.liferay.portlet.documentlibrary.service.persistence.DLFolderActionableDynamicQuery;
import com.liferay.portlet.dynamicdatamapping.StructureFieldException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;

public class DLFileEntryIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntry.class.getName()};
    public static final String PORTLET_ID = "20";
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryIndexer.class);

    public DLFileEntryIndexer() {
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        MBMessage message = (MBMessage)obj;
        FileEntry fileEntry = null;
        try {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)message.getClassPK());
        }
        catch (Exception exception) {
            return;
        }
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("relatedEntry", true);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        Object[] mimeTypes;
        this.addStatus(contextQuery, searchContext);
        if (searchContext.isIncludeAttachments()) {
            this.addRelatedClassNames(contextQuery, searchContext);
        }
        contextQuery.addRequiredTerm("hidden", searchContext.isIncludeAttachments());
        this.addSearchClassTypeIds(contextQuery, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"/");
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((String)ddmStructureFieldNameParts[1]));
            String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[2], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
            try {
                ddmStructureFieldValue = DDMUtil.getIndexedFieldValue((Serializable)ddmStructureFieldValue, (String)structure.getFieldType(fieldName));
            }
            catch (StructureFieldException structureFieldException) {}
            contextQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
        }
        if (ArrayUtil.isNotEmpty((Object[])(mimeTypes = (String[])searchContext.getAttribute("mimeTypes")))) {
            BooleanQuery mimeTypesQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            Object[] objectArray = mimeTypes;
            int n = mimeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object mimeType = objectArray[n2];
                mimeTypesQuery.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
                ++n2;
            }
            contextQuery.add((Query)mimeTypesQuery, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        String keywords = searchContext.getKeywords();
        if (Validator.isNull((String)keywords)) {
            this.addSearchTerm(searchQuery, searchContext, "description", false);
            this.addSearchTerm(searchQuery, searchContext, "title", false);
            this.addSearchTerm(searchQuery, searchContext, "userName", false);
        }
        this.addSearchTerm(searchQuery, searchContext, "ddmContent", false);
        this.addSearchTerm(searchQuery, searchContext, "extension", false);
        this.addSearchTerm(searchQuery, searchContext, "fileEntryTypeId", false);
        this.addSearchTerm(searchQuery, searchContext, "path", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) throws PortalException, SystemException {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            Fields fields = null;
            try {
                fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception exception) {}
            if (fields == null) continue;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)dlFileEntryMetadata.getDDMStructureId());
            DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, (Fields)fields);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, dlFileEntry.getFileEntryId());
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)dlFileEntry.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        Document document;
        block23: {
            DLFileEntry dlFileEntry = (DLFileEntry)obj;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document " + dlFileEntry));
            }
            boolean indexContent = true;
            InputStream is = null;
            try {
                Object[] ignoreExtensions = PrefsPropsUtil.getStringArray("dl.file.indexing.ignore.extensions", ",");
                if (ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()))) {
                    indexContent = false;
                }
                if (indexContent) {
                    is = dlFileEntry.getFileVersion().getContentStream(false);
                }
            }
            catch (Exception exception) {}
            DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
            try {
                Document document2 = this.getBaseModelDocument(PORTLET_ID, (BaseModel)dlFileEntry, (BaseModel)dlFileVersion);
                if (indexContent) {
                    if (is != null) {
                        int dlFileIndexingMaxSize = GetterUtil.getInteger((Object)PropsValues.DL_FILE_INDEXING_MAX_SIZE);
                        try {
                            document2.addFile("content", is, dlFileEntry.getTitle(), dlFileIndexingMaxSize);
                        }
                        catch (IOException iOException) {
                            throw new SearchException("Cannot extract text from file" + dlFileEntry);
                        }
                    } else if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                    }
                }
                document2.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
                document2.addText("description", dlFileEntry.getDescription());
                document2.addKeyword("folderId", dlFileEntry.getFolderId());
                document2.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
                document2.addText("properties", dlFileEntry.getLuceneProperties());
                document2.addText("title", dlFileEntry.getTitle());
                document2.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
                document2.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
                document2.addText("ddmContent", this.extractDDMContent(dlFileVersion, LocaleUtil.getSiteDefault()));
                document2.addKeyword("extension", dlFileEntry.getExtension());
                document2.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
                document2.addKeyword("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
                document2.addKeyword("path", dlFileEntry.getTitle());
                document2.addKeyword("readCount", dlFileEntry.getReadCount());
                document2.addKeyword("size", dlFileEntry.getSize());
                ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)dlFileEntry.getCompanyId(), (String)DLFileEntry.class.getName(), (long)dlFileVersion.getFileVersionId());
                ExpandoBridgeIndexerUtil.addAttributes((Document)document2, (ExpandoBridge)expandoBridge);
                this.addFileEntryTypeAttributes(document2, dlFileVersion);
                if (dlFileEntry.isInHiddenFolder()) {
                    try {
                        Repository repository = RepositoryLocalServiceUtil.getRepository((long)dlFileEntry.getRepositoryId());
                        String portletId = repository.getPortletId();
                        for (Indexer indexer : IndexerRegistryUtil.getIndexers()) {
                            if (!portletId.equals(indexer.getPortletId())) continue;
                            indexer.addRelatedEntryFields(document2, obj);
                        }
                    }
                    catch (Exception exception) {}
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
                }
                document = document2;
                if (is == null) break block23;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        liferayPortletURL.setLifecycle("ACTION_PHASE");
        try {
            liferayPortletURL.setWindowState(LiferayWindowState.EXCLUSIVE);
        }
        catch (WindowStateException windowStateException) {}
        String fileEntryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/document_library/get_file");
        portletURL.setParameter("fileEntryId", fileEntryId);
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        summary.setPortletURL(portletURL);
        return summary;
    }

    protected void doReindex(Object obj) throws Exception {
        DLFileEntry dlFileEntry = (DLFileEntry)obj;
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        if (!dlFileVersion.isApproved() && !dlFileEntry.isInTrash()) {
            return;
        }
        Document document = this.getDocument(dlFileEntry);
        if (document != null) {
            SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)dlFileEntry.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
        this.doReindex(dlFileEntry);
    }

    protected void doReindex(String[] ids) throws Exception {
        if (ids.length == 1) {
            long companyId = GetterUtil.getLong((String)ids[0]);
            this.reindexFolders(companyId);
            this.reindexRoot(companyId);
        } else {
            long companyId = GetterUtil.getLong((String)ids[0]);
            long groupId = GetterUtil.getLong((String)ids[2]);
            long dataRepositoryId = GetterUtil.getLong((String)ids[3]);
            this.reindexFileEntries(companyId, groupId, dataRepositoryId);
        }
    }

    protected void doReindexDDMStructures(List<Long> ddmStructureIds) throws Exception {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getDDMStructureFileEntries((long[])ArrayUtil.toLongArray(ddmStructureIds));
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            this.doReindex(dlFileEntry);
        }
    }

    protected String extractDDMContent(DLFileVersion dlFileVersion, Locale locale) throws Exception {
        List dlFileEntryMetadatas = DLFileEntryMetadataLocalServiceUtil.getFileVersionFileEntryMetadatas((long)dlFileVersion.getFileVersionId());
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            Fields fields = null;
            try {
                fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            }
            catch (Exception exception) {}
            if (fields == null) continue;
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)dlFileEntryMetadata.getDDMStructureId());
            sb.append(DDMIndexerUtil.extractAttributes((DDMStructure)ddmStructure, (Fields)fields, (Locale)locale));
        }
        return sb.toString();
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFileEntries(long companyId, final long groupId, final long dataRepositoryId) throws PortalException, SystemException {
        DLFileEntryActionableDynamicQuery actionableDynamicQuery = new DLFileEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"folderId");
                long folderId = DLFolderConstants.getFolderId((long)groupId, (long)dataRepositoryId);
                dynamicQuery.add(property.eq((Object)folderId));
            }

            protected void performAction(Object object) throws PortalException {
                DLFileEntry dlFileEntry = (DLFileEntry)object;
                Document document = DLFileEntryIndexer.this.getDocument(dlFileEntry);
                if (document != null) {
                    this.addDocument(document);
                }
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setGroupId(groupId);
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexFolders(final long companyId) throws PortalException, SystemException {
        DLFolderActionableDynamicQuery actionableDynamicQuery = new DLFolderActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                DLFolder dlFolder = (DLFolder)object;
                String portletId = DLFileEntryIndexer.PORTLET_ID;
                long groupId = dlFolder.getGroupId();
                long folderId = dlFolder.getFolderId();
                String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException, SystemException {
        GroupActionableDynamicQuery actionableDynamicQuery = new GroupActionableDynamicQuery(){

            protected void performAction(Object object) throws PortalException {
                long groupId;
                Group group = (Group)object;
                String portletId = DLFileEntryIndexer.PORTLET_ID;
                long folderId = groupId = group.getGroupId();
                String[] newIds = new String[]{String.valueOf(companyId), portletId, String.valueOf(groupId), String.valueOf(folderId)};
                DLFileEntryIndexer.this.reindex(newIds);
            }
        };
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.performActions();
    }
}

