/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.util;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetServiceUtil;
import com.liferay.portlet.dynamicdatalists.util.BaseDDLExporter;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDLXMLExporter
extends BaseDDLExporter {
    protected void addFieldElement(Element fieldsElement, String label, Serializable value) {
        Element fieldElement = fieldsElement.addElement("field");
        Element labelElement = fieldElement.addElement("label");
        labelElement.addText(label);
        Element valueElement = fieldElement.addElement("value");
        valueElement.addText(String.valueOf(value));
    }

    protected byte[] doExport(long recordSetId, int status, int start, int end, OrderByComparator orderByComparator) throws Exception {
        DDLRecordSet recordSet = DDLRecordSetServiceUtil.getRecordSet((long)recordSetId);
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        Map fieldsMap = ddmStructure.getFieldsMap(LocaleUtil.toLanguageId((Locale)this.getLocale()));
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        List records = DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, (OrderByComparator)orderByComparator);
        for (DDLRecord record : records) {
            Element fieldsElement = rootElement.addElement("fields");
            DDLRecordVersion recordVersion = record.getRecordVersion();
            Fields fields = StorageEngineUtil.getFields((long)recordVersion.getDDMStorageId());
            for (Map fieldMap : fieldsMap.values()) {
                String label = (String)fieldMap.get("label");
                String name = (String)fieldMap.get("name");
                String value = "";
                if (fields.contains(name)) {
                    Field field = fields.get(name);
                    value = field.getRenderedValue(this.getLocale());
                }
                this.addFieldElement(fieldsElement, label, (Serializable)((Object)value));
            }
        }
        String xml = document.asXML();
        return xml.getBytes();
    }
}

