/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.RequiredTemplateException;
import com.liferay.portlet.dynamicdatamapping.TemplateNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateScriptException;
import com.liferay.portlet.dynamicdatamapping.TemplateSmallImageNameException;
import com.liferay.portlet.dynamicdatamapping.TemplateSmallImageSizeException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import java.io.File;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditTemplateAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        DDMTemplate template = null;
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                template = this.updateTemplate(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteTemplates(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                boolean saveAndContinue;
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
                if (Validator.isNotNull((String)closeRedirect)) {
                    redirect = HttpUtil.setParameter((String)redirect, (String)"closeRedirect", (String)closeRedirect);
                    SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".closeRedirect"), (Object)closeRedirect);
                }
                if (template != null && (saveAndContinue = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"saveAndContinue"))) {
                    redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, template, redirect);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchTemplateException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e2 instanceof RequiredTemplateException || e2 instanceof TemplateNameException || e2 instanceof TemplateScriptException || e2 instanceof TemplateSmallImageNameException || e2 instanceof TemplateSmallImageSizeException) {
                String redirect;
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                if (e2 instanceof RequiredTemplateException && Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getStructure((PortletRequest)renderRequest);
            ActionUtil.getTemplate((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchTemplateException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.edit_template"));
    }

    protected void deleteTemplates(ActionRequest actionRequest) throws Exception {
        long[] deleteTemplateIds = null;
        long templateId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"templateId");
        deleteTemplateIds = templateId > 0L ? new long[]{templateId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteTemplateIds"), (long)0L);
        long[] lArray = deleteTemplateIds;
        int n = deleteTemplateIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deleteTemplateId = lArray[n2];
            DDMTemplateServiceUtil.deleteTemplate((long)deleteTemplateId);
            ++n2;
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMTemplate template, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long classNameId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        String structureAvailableFields = ParamUtil.getString((PortletRequest)actionRequest, (String)"structureAvailableFields");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/edit_template");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("templateId", String.valueOf(template.getTemplateId()), false);
        portletURL.setParameter("groupId", String.valueOf(template.getGroupId()), false);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(classPK), false);
        portletURL.setParameter("type", template.getType(), false);
        portletURL.setParameter("structureAvailableFields", structureAvailableFields, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected String getScript(UploadPortletRequest uploadPortletRequest) throws Exception {
        String scriptContent = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"scriptContent");
        File file = uploadPortletRequest.getFile("script");
        if (file == null) {
            return scriptContent;
        }
        String script = FileUtil.read((File)file);
        if (Validator.isNotNull((String)script) && !this.isValidFile(file)) {
            throw new TemplateScriptException();
        }
        return GetterUtil.getString((String)script, (String)scriptContent);
    }

    protected boolean isValidFile(File file) {
        String contentType = MimeTypesUtil.getContentType((File)file);
        return contentType.equals("application/xslt+xml") || contentType.startsWith("text");
    }

    protected DDMTemplate updateTemplate(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        long templateId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        String templateKey = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateKey");
        Map nameMap = LocalizationUtil.getLocalizationMap((HttpServletRequest)uploadPortletRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((HttpServletRequest)uploadPortletRequest, (String)"description");
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String mode = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"mode");
        String language = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"language", (String)"vm");
        String script = this.getScript(uploadPortletRequest);
        boolean cacheable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"cacheable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallImageFile = uploadPortletRequest.getFile("smallImageFile");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        DDMTemplate template = null;
        template = templateId <= 0L ? DDMTemplateServiceUtil.addTemplate((long)groupId, (long)classNameId, (long)classPK, (String)templateKey, (Map)nameMap, (Map)descriptionMap, (String)type, (String)mode, (String)language, (String)script, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallImageFile, (ServiceContext)serviceContext) : DDMTemplateServiceUtil.updateTemplate((long)templateId, (long)classPK, (Map)nameMap, (Map)descriptionMap, (String)type, (String)mode, (String)language, (String)script, (boolean)cacheable, (boolean)smallImage, (String)smallImageURL, (File)smallImageFile, (ServiceContext)serviceContext);
        PortletPreferences portletPreferences = this.getStrictPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences != null) {
            if (type.equals("display")) {
                portletPreferences.setValue("displayDDMTemplateId", String.valueOf(template.getTemplateId()));
            } else {
                portletPreferences.setValue("formDDMTemplateId", String.valueOf(template.getTemplateId()));
            }
            portletPreferences.store();
        }
        return template;
    }
}

