/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DDMStructureStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMStructure> {
    public static final String[] CLASS_NAMES = new String[]{DDMStructure.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)uuid, (long)groupId);
        if (ddmStructure != null) {
            DDMStructureLocalServiceUtil.deleteStructure((DDMStructure)ddmStructure);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMStructure structure) {
        return structure.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DDMStructure structure) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("referenced-class-name", structure.getClassName());
        referenceAttributes.put("structure-key", structure.getStructureKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId());
        }
        catch (Exception exception) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == structure.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importCompanyStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        String uuid = element.attributeValue("uuid");
        long classNameId = PortalUtil.getClassNameId((String)element.attributeValue("referenced-class-name"));
        String structureKey = element.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
        DDMStructure existingStructure = null;
        try {
            existingStructure = this.getExistingStructure(uuid, portletDataContext.getCompanyGroupId(), classNameId, structureKey, preloaded);
        }
        catch (Exception e2) {
            throw new PortletDataException((Throwable)e2);
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long structureId = GetterUtil.getLong((String)element.attributeValue("class-pk"));
        structureIds.put(structureId, existingStructure.getStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        structureKeys.put(structureKey, existingStructure.getStructureKey());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        String uuid = referenceElement.attributeValue("uuid");
        long classNameId = PortalUtil.getClassNameId((String)referenceElement.attributeValue("referenced-class-name"));
        String structureKey = referenceElement.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        try {
            DDMStructure existingStructure = this.getExistingStructure(uuid, portletDataContext.getScopeGroupId(), classNameId, structureKey, preloaded);
            if (existingStructure == null) {
                existingStructure = this.getExistingStructure(uuid, portletDataContext.getCompanyGroupId(), classNameId, structureKey, preloaded);
            }
            return existingStructure != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long defaultUserId;
        Element structureElement = portletDataContext.getExportDataElement((ClassedModel)structure);
        if (structure.getParentStructureId() != 0L) {
            DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)structure.getParentStructureId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, (StagedModel)parentStructure, (String)"parent");
        }
        if ((defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId())) == structure.getUserId()) {
            structureElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(structureElement, ExportImportPathUtil.getModelPath((StagedModel)structure), (ClassedModel)structure);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        this.prepareLanguagesForImport(structure);
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        if (structure.getParentStructureId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, DDMStructure.class, (long)structure.getParentStructureId());
        }
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long parentStructureId = MapUtil.getLong((Map)structureIds, (long)structure.getParentStructureId(), (long)structure.getParentStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)structure);
        DDMStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)structure);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            DDMStructure existingStructure = this.getExistingStructure(structure.getUuid(), portletDataContext.getScopeGroupId(), structure.getClassNameId(), structure.getStructureKey(), preloaded);
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
            } else {
                importedStructure = DDMStructureLocalServiceUtil.updateStructure((long)existingStructure.getStructureId(), (long)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getXsd(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure);
        structureKeys.put(structure.getStructureKey(), importedStructure.getStructureKey());
    }

    protected DDMStructure getExistingStructure(String uuid, long groupId, long classNameId, String structureKey, boolean preloaded) throws Exception {
        DDMStructure existingStructure = null;
        existingStructure = !preloaded ? DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)uuid, (long)groupId) : DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)structureKey);
        return existingStructure;
    }

    protected void prepareLanguagesForImport(DDMStructure structure) throws PortalException {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)structure.getDefaultLanguageId());
        Locale[] availableLocales = LocaleUtil.fromLanguageIds((String[])structure.getAvailableLanguageIds());
        Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale((String)DDMStructure.class.getName(), (long)structure.getPrimaryKey(), (Locale)defaultLocale, (Locale[])availableLocales);
        structure.prepareLocalizedFieldsForImport(defaultImportLocale);
    }
}

