/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexer;
import java.io.Serializable;
import java.text.Format;
import java.util.Date;
import java.util.Locale;

public class DDMIndexerImpl
implements DDMIndexer {
    private static Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);

    public void addAttributes(Document document, DDMStructure ddmStructure, Fields fields) {
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                String structureKey = ddmStructure.getStructureKey();
                if (structureKey.equals("TIKARAWMETADATA")) {
                    indexType = "text";
                }
                if (Validator.isNull((String)indexType)) continue;
                Locale[] localeArray = LanguageUtil.getAvailableLocales();
                int n = localeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Locale locale = localeArray[n2];
                    String name = this.encodeName(ddmStructure.getStructureId(), field.getName(), locale);
                    Serializable value = field.getValue(locale);
                    if (value instanceof Boolean) {
                        document.addKeyword(name, (Boolean)value);
                    } else if (value instanceof Boolean[]) {
                        document.addKeyword(name, (Boolean[])value);
                    } else if (value instanceof Date) {
                        document.addDate(name, (Date)value);
                    } else if (value instanceof Date[]) {
                        document.addDate(name, (Date[])value);
                    } else if (value instanceof Double) {
                        document.addNumber(name, (Double)value);
                    } else if (value instanceof Double[]) {
                        document.addNumber(name, (Double[])value);
                    } else if (value instanceof Integer) {
                        document.addNumber(name, (Integer)value);
                    } else if (value instanceof Integer[]) {
                        document.addNumber(name, (Integer[])value);
                    } else if (value instanceof Long) {
                        document.addNumber(name, (Long)value);
                    } else if (value instanceof Long[]) {
                        document.addNumber(name, (Long[])value);
                    } else if (value instanceof Float) {
                        document.addNumber(name, (Float)value);
                    } else if (value instanceof Float[]) {
                        document.addNumber(name, (Float[])value);
                    } else if (value instanceof Object[]) {
                        String[] valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                        if (indexType.equals("keyword")) {
                            document.addKeyword(name, valuesString);
                        } else {
                            document.addText(name, valuesString);
                        }
                    } else {
                        String valueString = String.valueOf(value);
                        String type = field.getType();
                        if (type.equals("radio") || type.equals("select")) {
                            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                            if (indexType.equals("keyword")) {
                                document.addKeyword(name, stringArray);
                            } else {
                                document.addText(name, stringArray);
                            }
                        } else {
                            if (type.equals("ddm-text-html")) {
                                valueString = HtmlUtil.extractText((String)valueString);
                            }
                            if (indexType.equals("keyword")) {
                                document.addKeyword(name, valueString);
                            } else {
                                document.addText(name, valueString);
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        return this.encodeName(ddmStructureId, fieldName, null);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        StringBundler sb = new StringBundler(7);
        sb.append("ddm");
        sb.append("/");
        sb.append(ddmStructureId);
        sb.append("/");
        sb.append(fieldName);
        if (Validator.isNotNull((Object)locale)) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        }
        return sb.toString();
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, Fields fields, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        StringBundler sb = new StringBundler();
        for (Field field : fields) {
            try {
                Object[] objectArray;
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                String structureKey = ddmStructure.getStructureKey();
                if (structureKey.equals("TIKARAWMETADATA")) {
                    indexType = "text";
                }
                if (Validator.isNull((String)indexType)) continue;
                Serializable value = field.getValue(locale);
                if (value instanceof Boolean || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof Float) {
                    sb.append((Object)value);
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date) {
                    sb.append(dateFormat.format(value));
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date[]) {
                    Date[] dates = (Date[])value;
                    objectArray = dates;
                    int n = dates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object date = objectArray[n2];
                        sb.append(dateFormat.format(date));
                        sb.append(" ");
                        ++n2;
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    objectArray = values;
                    int n = values.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object object = objectArray[n3];
                        sb.append(object);
                        sb.append(" ");
                        ++n3;
                    }
                    continue;
                }
                String valueString = String.valueOf(value);
                String type = field.getType();
                if (type.equals("radio") || type.equals("select")) {
                    JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                    String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                    sb.append(stringArray);
                    sb.append(" ");
                    continue;
                }
                if (type.equals("ddm-text-html")) {
                    valueString = HtmlUtil.extractText((String)valueString);
                }
                sb.append(valueString);
                sb.append(" ");
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return sb.toString();
    }
}

