/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JournalArticleAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    public static final String TYPE = "journal_article";
    private JournalArticle _article;

    public static long getClassPK(JournalArticle article) {
        if ((article.isDraft() || article.isPending()) && article.getVersion() != 1.0) {
            return article.getPrimaryKey();
        }
        return article.getResourcePrimKey();
    }

    public JournalArticleAssetRenderer(JournalArticle article) {
        this._article = article;
    }

    public String getAddToPagePortletId() throws Exception {
        return "56";
    }

    public JournalArticle getArticle() {
        return this._article;
    }

    public String[] getAvailableLanguageIds() {
        return this._article.getAvailableLanguageIds();
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public long getClassPK() {
        return JournalArticleAssetRenderer.getClassPK(this._article);
    }

    public String getDiscussionPath() {
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            return "edit_article_discussion";
        }
        return null;
    }

    public Date getDisplayDate() {
        return this._article.getDisplayDate();
    }

    public long getGroupId() {
        return this._article.getGroupId();
    }

    public String getPortletId() {
        return "15";
    }

    public String getSummary(Locale locale) {
        String summary = this._article.getDescription(locale);
        if (Validator.isNull((String)summary)) {
            try {
                JournalArticleDisplay articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)this._article, null, null, (String)LanguageUtil.getLanguageId((Locale)locale), (int)1, null, null);
                summary = StringUtil.shorten((String)HtmlUtil.stripHtml((String)articleDisplay.getContent()), (int)200);
            }
            catch (Exception exception) {}
        }
        return summary;
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String thumbnailSrc = this._article.getArticleImageURL(themeDisplay);
        if (Validator.isNotNull((String)thumbnailSrc)) {
            return thumbnailSrc;
        }
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/file_system/large/article.png";
    }

    public String getTitle(Locale locale) {
        return this._article.getTitle(locale);
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "15", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        portletURL.setParameter("version", String.valueOf(this._article.getVersion()));
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("struts_action", "/asset_publisher/export_journal_article");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        return portletURL;
    }

    public String getUrlTitle() {
        return this._article.getUrlTitle();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (Validator.isNotNull((String)this._article.getLayoutUuid())) {
            layout = LayoutLocalServiceUtil.getLayoutByUuidAndCompanyId((String)this._article.getLayoutUuid(), (long)this._article.getCompanyId());
        }
        String portletId = (String)liferayPortletRequest.getAttribute("PORTLET_ID");
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        String linkToLayoutUuid = GetterUtil.getString((String)portletSetup.getValue("portletSetupLinkToLayoutUuid", null));
        if (Validator.isNotNull((String)this._article.getLayoutUuid()) && Validator.isNull((String)linkToLayoutUuid)) {
            Group group = themeDisplay.getScopeGroup();
            if (group.getGroupId() != this._article.getGroupId()) {
                group = GroupLocalServiceUtil.getGroup((long)this._article.getGroupId());
            }
            String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((Group)group, (boolean)layout.isPrivateLayout(), (ThemeDisplay)themeDisplay);
            return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)groupFriendlyURL.concat("/-/").concat(this._article.getUrlTitle()));
        }
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)this._article.getGroupId(), (boolean)layout.isPrivateLayout(), (String)this._article.getArticleId());
        if (!hitLayoutIds.isEmpty()) {
            Long hitLayoutId = (Long)hitLayoutIds.get(0);
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)this._article.getGroupId(), (boolean)layout.isPrivateLayout(), (long)hitLayoutId);
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        return noSuchEntryRedirect;
    }

    public long getUserId() {
        return this._article.getUserId();
    }

    public String getUserName() {
        return this._article.getUserName();
    }

    public String getUuid() {
        return this._article.getUuid();
    }

    public String getViewInContextMessage() {
        return "view";
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return JournalArticlePermission.contains(permissionChecker, this._article, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException, SystemException {
        return JournalArticlePermission.contains(permissionChecker, this._article, "VIEW");
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isDisplayable() {
        Date now = new Date();
        Date displayDate = this._article.getDisplayDate();
        if (displayDate != null && displayDate.after(now)) {
            return false;
        }
        Date expirationDate = this._article.getExpirationDate();
        return expirationDate == null || !expirationDate.before(now);
    }

    public boolean isLocalizable() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("JOURNAL_ARTICLE", (Object)this._article);
            return "/html/portlet/journal/asset/" + template + ".jsp";
        }
        return null;
    }

    public void setAddToPagePreferences(PortletPreferences preferences, String portletId, ThemeDisplay themeDisplay) throws Exception {
        preferences.setValue("articleId", this._article.getArticleId());
        preferences.setValue("groupId", String.valueOf(this._article.getGroupId()));
        Layout layout = themeDisplay.getLayout();
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletId, (String)this._article.getArticleId(), (boolean)true);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/history.png";
    }
}

